/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration information for the S3 location being used to hold label data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LabelsInputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LabelsInputConfiguration.Builder, LabelsInputConfiguration> {
    private static final SdkField<LabelsS3InputConfiguration> S3_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsS3InputConfiguration> builder(MarshallingType.SDK_POJO).memberName("S3InputConfiguration")
            .getter(getter(LabelsInputConfiguration::s3InputConfiguration)).setter(setter(Builder::s3InputConfiguration))
            .constructor(LabelsS3InputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3InputConfiguration").build())
            .build();

    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(LabelsInputConfiguration::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_CONFIGURATION_FIELD,
            LABEL_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LabelsS3InputConfiguration s3InputConfiguration;

    private final String labelGroupName;

    private LabelsInputConfiguration(BuilderImpl builder) {
        this.s3InputConfiguration = builder.s3InputConfiguration;
        this.labelGroupName = builder.labelGroupName;
    }

    /**
     * <p>
     * Contains location information for the S3 location being used for label data.
     * </p>
     * 
     * @return Contains location information for the S3 location being used for label data.
     */
    public final LabelsS3InputConfiguration s3InputConfiguration() {
        return s3InputConfiguration;
    }

    /**
     * <p>
     * The name of the label group to be used for label data.
     * </p>
     * 
     * @return The name of the label group to be used for label data.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelsInputConfiguration)) {
            return false;
        }
        LabelsInputConfiguration other = (LabelsInputConfiguration) obj;
        return Objects.equals(s3InputConfiguration(), other.s3InputConfiguration())
                && Objects.equals(labelGroupName(), other.labelGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LabelsInputConfiguration").add("S3InputConfiguration", s3InputConfiguration())
                .add("LabelGroupName", labelGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3InputConfiguration":
            return Optional.ofNullable(clazz.cast(s3InputConfiguration()));
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3InputConfiguration", S3_INPUT_CONFIGURATION_FIELD);
        map.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LabelsInputConfiguration, T> g) {
        return obj -> g.apply((LabelsInputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LabelsInputConfiguration> {
        /**
         * <p>
         * Contains location information for the S3 location being used for label data.
         * </p>
         * 
         * @param s3InputConfiguration
         *        Contains location information for the S3 location being used for label data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3InputConfiguration(LabelsS3InputConfiguration s3InputConfiguration);

        /**
         * <p>
         * Contains location information for the S3 location being used for label data.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelsS3InputConfiguration.Builder}
         * avoiding the need to create one manually via {@link LabelsS3InputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelsS3InputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #s3InputConfiguration(LabelsS3InputConfiguration)}.
         * 
         * @param s3InputConfiguration
         *        a consumer that will call methods on {@link LabelsS3InputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3InputConfiguration(LabelsS3InputConfiguration)
         */
        default Builder s3InputConfiguration(Consumer<LabelsS3InputConfiguration.Builder> s3InputConfiguration) {
            return s3InputConfiguration(LabelsS3InputConfiguration.builder().applyMutation(s3InputConfiguration).build());
        }

        /**
         * <p>
         * The name of the label group to be used for label data.
         * </p>
         * 
         * @param labelGroupName
         *        The name of the label group to be used for label data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);
    }

    static final class BuilderImpl implements Builder {
        private LabelsS3InputConfiguration s3InputConfiguration;

        private String labelGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelsInputConfiguration model) {
            s3InputConfiguration(model.s3InputConfiguration);
            labelGroupName(model.labelGroupName);
        }

        public final LabelsS3InputConfiguration.Builder getS3InputConfiguration() {
            return s3InputConfiguration != null ? s3InputConfiguration.toBuilder() : null;
        }

        public final void setS3InputConfiguration(LabelsS3InputConfiguration.BuilderImpl s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration != null ? s3InputConfiguration.build() : null;
        }

        @Override
        public final Builder s3InputConfiguration(LabelsS3InputConfiguration s3InputConfiguration) {
            this.s3InputConfiguration = s3InputConfiguration;
            return this;
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        @Override
        public LabelsInputConfiguration build() {
            return new LabelsInputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
