/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceEventsRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListInferenceEventsRequest.Builder, ListInferenceEventsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceEventsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListInferenceEventsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(ListInferenceEventsRequest::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<Instant> INTERVAL_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IntervalStartTime").getter(getter(ListInferenceEventsRequest::intervalStartTime))
            .setter(setter(Builder::intervalStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalStartTime").build()).build();

    private static final SdkField<Instant> INTERVAL_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("IntervalEndTime").getter(getter(ListInferenceEventsRequest::intervalEndTime))
            .setter(setter(Builder::intervalEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntervalEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INTERVAL_START_TIME_FIELD, INTERVAL_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final String inferenceSchedulerName;

    private final Instant intervalStartTime;

    private final Instant intervalEndTime;

    private ListInferenceEventsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.intervalStartTime = builder.intervalStartTime;
        this.intervalEndTime = builder.intervalEndTime;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of inference events.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of inference events.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of inference events to list.
     * </p>
     * 
     * @return Specifies the maximum number of inference events to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The name of the inference scheduler for the inference events listed.
     * </p>
     * 
     * @return The name of the inference scheduler for the inference events listed.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * Lookout for Equipment will return all the inference events with an end time equal to or greater than the start
     * time given.
     * </p>
     * 
     * @return Lookout for Equipment will return all the inference events with an end time equal to or greater than the
     *         start time given.
     */
    public final Instant intervalStartTime() {
        return intervalStartTime;
    }

    /**
     * <p>
     * Returns all the inference events with an end start time equal to or greater than less than the end time given.
     * </p>
     * 
     * @return Returns all the inference events with an end start time equal to or greater than less than the end time
     *         given.
     */
    public final Instant intervalEndTime() {
        return intervalEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(intervalStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(intervalEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceEventsRequest)) {
            return false;
        }
        ListInferenceEventsRequest other = (ListInferenceEventsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(intervalStartTime(), other.intervalStartTime())
                && Objects.equals(intervalEndTime(), other.intervalEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceEventsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("IntervalStartTime", intervalStartTime())
                .add("IntervalEndTime", intervalEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "IntervalStartTime":
            return Optional.ofNullable(clazz.cast(intervalStartTime()));
        case "IntervalEndTime":
            return Optional.ofNullable(clazz.cast(intervalEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("IntervalStartTime", INTERVAL_START_TIME_FIELD);
        map.put("IntervalEndTime", INTERVAL_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceEventsRequest, T> g) {
        return obj -> g.apply((ListInferenceEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceEventsRequest> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of inference events.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of inference events.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of inference events to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of inference events to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The name of the inference scheduler for the inference events listed.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler for the inference events listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * Lookout for Equipment will return all the inference events with an end time equal to or greater than the
         * start time given.
         * </p>
         * 
         * @param intervalStartTime
         *        Lookout for Equipment will return all the inference events with an end time equal to or greater than
         *        the start time given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalStartTime(Instant intervalStartTime);

        /**
         * <p>
         * Returns all the inference events with an end start time equal to or greater than less than the end time
         * given.
         * </p>
         * 
         * @param intervalEndTime
         *        Returns all the inference events with an end start time equal to or greater than less than the end
         *        time given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intervalEndTime(Instant intervalEndTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String inferenceSchedulerName;

        private Instant intervalStartTime;

        private Instant intervalEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceEventsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            inferenceSchedulerName(model.inferenceSchedulerName);
            intervalStartTime(model.intervalStartTime);
            intervalEndTime(model.intervalEndTime);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Instant getIntervalStartTime() {
            return intervalStartTime;
        }

        public final void setIntervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
        }

        @Override
        public final Builder intervalStartTime(Instant intervalStartTime) {
            this.intervalStartTime = intervalStartTime;
            return this;
        }

        public final Instant getIntervalEndTime() {
            return intervalEndTime;
        }

        public final void setIntervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
        }

        @Override
        public final Builder intervalEndTime(Instant intervalEndTime) {
            this.intervalEndTime = intervalEndTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInferenceEventsRequest build() {
            return new ListInferenceEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
