/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInferenceExecutionsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListInferenceExecutionsResponse.Builder, ListInferenceExecutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInferenceExecutionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<InferenceExecutionSummary>> INFERENCE_EXECUTION_SUMMARIES_FIELD = SdkField
            .<List<InferenceExecutionSummary>> builder(MarshallingType.LIST)
            .memberName("InferenceExecutionSummaries")
            .getter(getter(ListInferenceExecutionsResponse::inferenceExecutionSummaries))
            .setter(setter(Builder::inferenceExecutionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceExecutionSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InferenceExecutionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(InferenceExecutionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            INFERENCE_EXECUTION_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<InferenceExecutionSummary> inferenceExecutionSummaries;

    private ListInferenceExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.inferenceExecutionSummaries = builder.inferenceExecutionSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of inference executions.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of inference executions.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InferenceExecutionSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInferenceExecutionSummaries() {
        return inferenceExecutionSummaries != null && !(inferenceExecutionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides an array of information about the individual inference executions returned from the
     * <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data configuration,
     * and so on.
     * </p>
     * <note>
     * <p>
     * If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name of an
     * inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an empty array in
     * <code>InferenceExecutionSummaries</code>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInferenceExecutionSummaries} method.
     * </p>
     * 
     * @return Provides an array of information about the individual inference executions returned from the
     *         <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
     *         configuration, and so on. </p> <note>
     *         <p>
     *         If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name
     *         of an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an empty array
     *         in <code>InferenceExecutionSummaries</code>.
     *         </p>
     */
    public final List<InferenceExecutionSummary> inferenceExecutionSummaries() {
        return inferenceExecutionSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasInferenceExecutionSummaries() ? inferenceExecutionSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceExecutionsResponse)) {
            return false;
        }
        ListInferenceExecutionsResponse other = (ListInferenceExecutionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasInferenceExecutionSummaries() == other.hasInferenceExecutionSummaries()
                && Objects.equals(inferenceExecutionSummaries(), other.inferenceExecutionSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInferenceExecutionsResponse").add("NextToken", nextToken())
                .add("InferenceExecutionSummaries", hasInferenceExecutionSummaries() ? inferenceExecutionSummaries() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "InferenceExecutionSummaries":
            return Optional.ofNullable(clazz.cast(inferenceExecutionSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("InferenceExecutionSummaries", INFERENCE_EXECUTION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceExecutionsResponse, T> g) {
        return obj -> g.apply((ListInferenceExecutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInferenceExecutionsResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of inference executions.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of inference executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Provides an array of information about the individual inference executions returned from the
         * <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
         * configuration, and so on.
         * </p>
         * <note>
         * <p>
         * If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name of
         * an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an empty array in
         * <code>InferenceExecutionSummaries</code>.
         * </p>
         * </note>
         * 
         * @param inferenceExecutionSummaries
         *        Provides an array of information about the individual inference executions returned from the
         *        <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
         *        configuration, and so on. </p> <note>
         *        <p>
         *        If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the
         *        name of an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an
         *        empty array in <code>InferenceExecutionSummaries</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExecutionSummaries(Collection<InferenceExecutionSummary> inferenceExecutionSummaries);

        /**
         * <p>
         * Provides an array of information about the individual inference executions returned from the
         * <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
         * configuration, and so on.
         * </p>
         * <note>
         * <p>
         * If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name of
         * an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an empty array in
         * <code>InferenceExecutionSummaries</code>.
         * </p>
         * </note>
         * 
         * @param inferenceExecutionSummaries
         *        Provides an array of information about the individual inference executions returned from the
         *        <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
         *        configuration, and so on. </p> <note>
         *        <p>
         *        If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the
         *        name of an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an
         *        empty array in <code>InferenceExecutionSummaries</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceExecutionSummaries(InferenceExecutionSummary... inferenceExecutionSummaries);

        /**
         * <p>
         * Provides an array of information about the individual inference executions returned from the
         * <code>ListInferenceExecutions</code> operation, including model used, inference scheduler, data
         * configuration, and so on.
         * </p>
         * <note>
         * <p>
         * If you don't supply the <code>InferenceSchedulerName</code> request parameter, or if you supply the name of
         * an inference scheduler that doesn't exist, <code>ListInferenceExecutions</code> returns an empty array in
         * <code>InferenceExecutionSummaries</code>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #inferenceExecutionSummaries(List<InferenceExecutionSummary>)}.
         * 
         * @param inferenceExecutionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.InferenceExecutionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceExecutionSummaries(java.util.Collection<InferenceExecutionSummary>)
         */
        Builder inferenceExecutionSummaries(Consumer<InferenceExecutionSummary.Builder>... inferenceExecutionSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<InferenceExecutionSummary> inferenceExecutionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceExecutionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            inferenceExecutionSummaries(model.inferenceExecutionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<InferenceExecutionSummary.Builder> getInferenceExecutionSummaries() {
            List<InferenceExecutionSummary.Builder> result = InferenceExecutionSummariesCopier
                    .copyToBuilder(this.inferenceExecutionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceExecutionSummaries(
                Collection<InferenceExecutionSummary.BuilderImpl> inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries = InferenceExecutionSummariesCopier.copyFromBuilder(inferenceExecutionSummaries);
        }

        @Override
        public final Builder inferenceExecutionSummaries(Collection<InferenceExecutionSummary> inferenceExecutionSummaries) {
            this.inferenceExecutionSummaries = InferenceExecutionSummariesCopier.copy(inferenceExecutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExecutionSummaries(InferenceExecutionSummary... inferenceExecutionSummaries) {
            inferenceExecutionSummaries(Arrays.asList(inferenceExecutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceExecutionSummaries(
                Consumer<InferenceExecutionSummary.Builder>... inferenceExecutionSummaries) {
            inferenceExecutionSummaries(Stream.of(inferenceExecutionSummaries)
                    .map(c -> InferenceExecutionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListInferenceExecutionsResponse build() {
            return new ListInferenceExecutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
