/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the specified machine learning model, including dataset and model names and ARNs, as well
 * as status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelSummary implements SdkPojo, Serializable, ToCopyableBuilder<ModelSummary.Builder, ModelSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ModelSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(ModelSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(ModelSummary::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(ModelSummary::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ModelSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Long> ACTIVE_MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ActiveModelVersion").getter(getter(ModelSummary::activeModelVersion))
            .setter(setter(Builder::activeModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersion").build())
            .build();

    private static final SdkField<String> ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelVersionArn").getter(getter(ModelSummary::activeModelVersionArn))
            .setter(setter(Builder::activeModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersionArn").build())
            .build();

    private static final SdkField<String> LATEST_SCHEDULED_RETRAINING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestScheduledRetrainingStatus")
            .getter(getter(ModelSummary::latestScheduledRetrainingStatusAsString))
            .setter(setter(Builder::latestScheduledRetrainingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStatus")
                    .build()).build();

    private static final SdkField<Long> LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LatestScheduledRetrainingModelVersion")
            .getter(getter(ModelSummary::latestScheduledRetrainingModelVersion))
            .setter(setter(Builder::latestScheduledRetrainingModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestScheduledRetrainingModelVersion").build()).build();

    private static final SdkField<Instant> LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestScheduledRetrainingStartTime")
            .getter(getter(ModelSummary::latestScheduledRetrainingStartTime))
            .setter(setter(Builder::latestScheduledRetrainingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStartTime")
                    .build()).build();

    private static final SdkField<Instant> NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextScheduledRetrainingStartDate")
            .getter(getter(ModelSummary::nextScheduledRetrainingStartDate))
            .setter(setter(Builder::nextScheduledRetrainingStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextScheduledRetrainingStartDate")
                    .build()).build();

    private static final SdkField<String> RETRAINING_SCHEDULER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrainingSchedulerStatus").getter(getter(ModelSummary::retrainingSchedulerStatusAsString))
            .setter(setter(Builder::retrainingSchedulerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingSchedulerStatus").build())
            .build();

    private static final SdkField<ModelDiagnosticsOutputConfiguration> MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ModelDiagnosticsOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ModelDiagnosticsOutputConfiguration")
            .getter(getter(ModelSummary::modelDiagnosticsOutputConfiguration))
            .setter(setter(Builder::modelDiagnosticsOutputConfiguration))
            .constructor(ModelDiagnosticsOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ModelDiagnosticsOutputConfiguration").build()).build();

    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelQuality").getter(getter(ModelSummary::modelQualityAsString)).setter(setter(Builder::modelQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, STATUS_FIELD, CREATED_AT_FIELD, ACTIVE_MODEL_VERSION_FIELD,
            ACTIVE_MODEL_VERSION_ARN_FIELD, LATEST_SCHEDULED_RETRAINING_STATUS_FIELD,
            LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD, LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD,
            NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD, RETRAINING_SCHEDULER_STATUS_FIELD,
            MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD, MODEL_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final String datasetName;

    private final String datasetArn;

    private final String status;

    private final Instant createdAt;

    private final Long activeModelVersion;

    private final String activeModelVersionArn;

    private final String latestScheduledRetrainingStatus;

    private final Long latestScheduledRetrainingModelVersion;

    private final Instant latestScheduledRetrainingStartTime;

    private final Instant nextScheduledRetrainingStartDate;

    private final String retrainingSchedulerStatus;

    private final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

    private final String modelQuality;

    private ModelSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.activeModelVersion = builder.activeModelVersion;
        this.activeModelVersionArn = builder.activeModelVersionArn;
        this.latestScheduledRetrainingStatus = builder.latestScheduledRetrainingStatus;
        this.latestScheduledRetrainingModelVersion = builder.latestScheduledRetrainingModelVersion;
        this.latestScheduledRetrainingStartTime = builder.latestScheduledRetrainingStartTime;
        this.nextScheduledRetrainingStartDate = builder.nextScheduledRetrainingStartDate;
        this.retrainingSchedulerStatus = builder.retrainingSchedulerStatus;
        this.modelDiagnosticsOutputConfiguration = builder.modelDiagnosticsOutputConfiguration;
        this.modelQuality = builder.modelQuality;
    }

    /**
     * <p>
     * The name of the machine learning model.
     * </p>
     * 
     * @return The name of the machine learning model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the dataset being used for the machine learning model.
     * </p>
     * 
     * @return The name of the dataset being used for the machine learning model.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset used to create the model.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset used to create the model.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * Indicates the status of the machine learning model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the machine learning model.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the machine learning model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the machine learning model.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the specific model was created.
     * </p>
     * 
     * @return The time at which the specific model was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The model version that the inference scheduler uses to run an inference execution.
     * </p>
     * 
     * @return The model version that the inference scheduler uses to run an inference execution.
     */
    public final Long activeModelVersion() {
        return activeModelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version that is set as active. The active model version is the model
     * version that the inference scheduler uses to run an inference execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version that is set as active. The active model version is
     *         the model version that the inference scheduler uses to run an inference execution.
     */
    public final String activeModelVersionArn() {
        return activeModelVersionArn;
    }

    /**
     * <p>
     * Indicates the status of the most recent scheduled retraining run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestScheduledRetrainingStatus} will return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestScheduledRetrainingStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the most recent scheduled retraining run.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus latestScheduledRetrainingStatus() {
        return ModelVersionStatus.fromValue(latestScheduledRetrainingStatus);
    }

    /**
     * <p>
     * Indicates the status of the most recent scheduled retraining run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestScheduledRetrainingStatus} will return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestScheduledRetrainingStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the most recent scheduled retraining run.
     * @see ModelVersionStatus
     */
    public final String latestScheduledRetrainingStatusAsString() {
        return latestScheduledRetrainingStatus;
    }

    /**
     * <p>
     * Indicates the most recent model version that was generated by retraining.
     * </p>
     * 
     * @return Indicates the most recent model version that was generated by retraining.
     */
    public final Long latestScheduledRetrainingModelVersion() {
        return latestScheduledRetrainingModelVersion;
    }

    /**
     * <p>
     * Indicates the start time of the most recent scheduled retraining run.
     * </p>
     * 
     * @return Indicates the start time of the most recent scheduled retraining run.
     */
    public final Instant latestScheduledRetrainingStartTime() {
        return latestScheduledRetrainingStartTime;
    }

    /**
     * <p>
     * Indicates the date that the next scheduled retraining run will start on. Lookout for Equipment truncates the time
     * you provide to <a href=
     * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     * >the nearest UTC day</a>.
     * </p>
     * 
     * @return Indicates the date that the next scheduled retraining run will start on. Lookout for Equipment truncates
     *         the time you provide to <a href=
     *         "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
     *         >the nearest UTC day</a>.
     */
    public final Instant nextScheduledRetrainingStartDate() {
        return nextScheduledRetrainingStartDate;
    }

    /**
     * <p>
     * Indicates the status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retrainingSchedulerStatus} will return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #retrainingSchedulerStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final RetrainingSchedulerStatus retrainingSchedulerStatus() {
        return RetrainingSchedulerStatus.fromValue(retrainingSchedulerStatus);
    }

    /**
     * <p>
     * Indicates the status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retrainingSchedulerStatus} will return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #retrainingSchedulerStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final String retrainingSchedulerStatusAsString() {
        return retrainingSchedulerStatus;
    }

    /**
     * Returns the value of the ModelDiagnosticsOutputConfiguration property for this object.
     * 
     * @return The value of the ModelDiagnosticsOutputConfiguration property for this object.
     */
    public final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration() {
        return modelDiagnosticsOutputConfiguration;
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(modelQuality);
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final String modelQualityAsString() {
        return modelQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextScheduledRetrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingSchedulerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelDiagnosticsOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelSummary)) {
            return false;
        }
        ModelSummary other = (ModelSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(activeModelVersion(), other.activeModelVersion())
                && Objects.equals(activeModelVersionArn(), other.activeModelVersionArn())
                && Objects.equals(latestScheduledRetrainingStatusAsString(), other.latestScheduledRetrainingStatusAsString())
                && Objects.equals(latestScheduledRetrainingModelVersion(), other.latestScheduledRetrainingModelVersion())
                && Objects.equals(latestScheduledRetrainingStartTime(), other.latestScheduledRetrainingStartTime())
                && Objects.equals(nextScheduledRetrainingStartDate(), other.nextScheduledRetrainingStartDate())
                && Objects.equals(retrainingSchedulerStatusAsString(), other.retrainingSchedulerStatusAsString())
                && Objects.equals(modelDiagnosticsOutputConfiguration(), other.modelDiagnosticsOutputConfiguration())
                && Objects.equals(modelQualityAsString(), other.modelQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("DatasetName", datasetName()).add("DatasetArn", datasetArn()).add("Status", statusAsString())
                .add("CreatedAt", createdAt()).add("ActiveModelVersion", activeModelVersion())
                .add("ActiveModelVersionArn", activeModelVersionArn())
                .add("LatestScheduledRetrainingStatus", latestScheduledRetrainingStatusAsString())
                .add("LatestScheduledRetrainingModelVersion", latestScheduledRetrainingModelVersion())
                .add("LatestScheduledRetrainingStartTime", latestScheduledRetrainingStartTime())
                .add("NextScheduledRetrainingStartDate", nextScheduledRetrainingStartDate())
                .add("RetrainingSchedulerStatus", retrainingSchedulerStatusAsString())
                .add("ModelDiagnosticsOutputConfiguration", modelDiagnosticsOutputConfiguration())
                .add("ModelQuality", modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ActiveModelVersion":
            return Optional.ofNullable(clazz.cast(activeModelVersion()));
        case "ActiveModelVersionArn":
            return Optional.ofNullable(clazz.cast(activeModelVersionArn()));
        case "LatestScheduledRetrainingStatus":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingStatusAsString()));
        case "LatestScheduledRetrainingModelVersion":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingModelVersion()));
        case "LatestScheduledRetrainingStartTime":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingStartTime()));
        case "NextScheduledRetrainingStartDate":
            return Optional.ofNullable(clazz.cast(nextScheduledRetrainingStartDate()));
        case "RetrainingSchedulerStatus":
            return Optional.ofNullable(clazz.cast(retrainingSchedulerStatusAsString()));
        case "ModelDiagnosticsOutputConfiguration":
            return Optional.ofNullable(clazz.cast(modelDiagnosticsOutputConfiguration()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ActiveModelVersion", ACTIVE_MODEL_VERSION_FIELD);
        map.put("ActiveModelVersionArn", ACTIVE_MODEL_VERSION_ARN_FIELD);
        map.put("LatestScheduledRetrainingStatus", LATEST_SCHEDULED_RETRAINING_STATUS_FIELD);
        map.put("LatestScheduledRetrainingModelVersion", LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD);
        map.put("LatestScheduledRetrainingStartTime", LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD);
        map.put("NextScheduledRetrainingStartDate", NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD);
        map.put("RetrainingSchedulerStatus", RETRAINING_SCHEDULER_STATUS_FIELD);
        map.put("ModelDiagnosticsOutputConfiguration", MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelSummary, T> g) {
        return obj -> g.apply((ModelSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelSummary> {
        /**
         * <p>
         * The name of the machine learning model.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the dataset being used for the machine learning model.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being used for the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset used to create the model.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset used to create the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * Indicates the status of the machine learning model.
         * </p>
         * 
         * @param status
         *        Indicates the status of the machine learning model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the machine learning model.
         * </p>
         * 
         * @param status
         *        Indicates the status of the machine learning model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * The time at which the specific model was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the specific model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The model version that the inference scheduler uses to run an inference execution.
         * </p>
         * 
         * @param activeModelVersion
         *        The model version that the inference scheduler uses to run an inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelVersion(Long activeModelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version that is set as active. The active model version is the
         * model version that the inference scheduler uses to run an inference execution.
         * </p>
         * 
         * @param activeModelVersionArn
         *        The Amazon Resource Name (ARN) of the model version that is set as active. The active model version is
         *        the model version that the inference scheduler uses to run an inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelVersionArn(String activeModelVersionArn);

        /**
         * <p>
         * Indicates the status of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStatus
         *        Indicates the status of the most recent scheduled retraining run.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder latestScheduledRetrainingStatus(String latestScheduledRetrainingStatus);

        /**
         * <p>
         * Indicates the status of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStatus
         *        Indicates the status of the most recent scheduled retraining run.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder latestScheduledRetrainingStatus(ModelVersionStatus latestScheduledRetrainingStatus);

        /**
         * <p>
         * Indicates the most recent model version that was generated by retraining.
         * </p>
         * 
         * @param latestScheduledRetrainingModelVersion
         *        Indicates the most recent model version that was generated by retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion);

        /**
         * <p>
         * Indicates the start time of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStartTime
         *        Indicates the start time of the most recent scheduled retraining run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime);

        /**
         * <p>
         * Indicates the date that the next scheduled retraining run will start on. Lookout for Equipment truncates the
         * time you provide to <a href=
         * "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         * >the nearest UTC day</a>.
         * </p>
         * 
         * @param nextScheduledRetrainingStartDate
         *        Indicates the date that the next scheduled retraining run will start on. Lookout for Equipment
         *        truncates the time you provide to <a href=
         *        "https://docs.aws.amazon.com/https:/docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp"
         *        >the nearest UTC day</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate);

        /**
         * <p>
         * Indicates the status of the retraining scheduler.
         * </p>
         * 
         * @param retrainingSchedulerStatus
         *        Indicates the status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder retrainingSchedulerStatus(String retrainingSchedulerStatus);

        /**
         * <p>
         * Indicates the status of the retraining scheduler.
         * </p>
         * 
         * @param retrainingSchedulerStatus
         *        Indicates the status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder retrainingSchedulerStatus(RetrainingSchedulerStatus retrainingSchedulerStatus);

        /**
         * Sets the value of the ModelDiagnosticsOutputConfiguration property for this object.
         *
         * @param modelDiagnosticsOutputConfiguration
         *        The new value for the ModelDiagnosticsOutputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration);

        /**
         * Sets the value of the ModelDiagnosticsOutputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link ModelDiagnosticsOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link ModelDiagnosticsOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDiagnosticsOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)}.
         * 
         * @param modelDiagnosticsOutputConfiguration
         *        a consumer that will call methods on {@link ModelDiagnosticsOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)
         */
        default Builder modelDiagnosticsOutputConfiguration(
                Consumer<ModelDiagnosticsOutputConfiguration.Builder> modelDiagnosticsOutputConfiguration) {
            return modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration.builder()
                    .applyMutation(modelDiagnosticsOutputConfiguration).build());
        }

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(String modelQuality);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(ModelQuality modelQuality);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String datasetName;

        private String datasetArn;

        private String status;

        private Instant createdAt;

        private Long activeModelVersion;

        private String activeModelVersionArn;

        private String latestScheduledRetrainingStatus;

        private Long latestScheduledRetrainingModelVersion;

        private Instant latestScheduledRetrainingStartTime;

        private Instant nextScheduledRetrainingStartDate;

        private String retrainingSchedulerStatus;

        private ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            status(model.status);
            createdAt(model.createdAt);
            activeModelVersion(model.activeModelVersion);
            activeModelVersionArn(model.activeModelVersionArn);
            latestScheduledRetrainingStatus(model.latestScheduledRetrainingStatus);
            latestScheduledRetrainingModelVersion(model.latestScheduledRetrainingModelVersion);
            latestScheduledRetrainingStartTime(model.latestScheduledRetrainingStartTime);
            nextScheduledRetrainingStartDate(model.nextScheduledRetrainingStartDate);
            retrainingSchedulerStatus(model.retrainingSchedulerStatus);
            modelDiagnosticsOutputConfiguration(model.modelDiagnosticsOutputConfiguration);
            modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Long getActiveModelVersion() {
            return activeModelVersion;
        }

        public final void setActiveModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
        }

        @Override
        public final Builder activeModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
            return this;
        }

        public final String getActiveModelVersionArn() {
            return activeModelVersionArn;
        }

        public final void setActiveModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
        }

        @Override
        public final Builder activeModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
            return this;
        }

        public final String getLatestScheduledRetrainingStatus() {
            return latestScheduledRetrainingStatus;
        }

        public final void setLatestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
            return this;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(ModelVersionStatus latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus(latestScheduledRetrainingStatus == null ? null : latestScheduledRetrainingStatus
                    .toString());
            return this;
        }

        public final Long getLatestScheduledRetrainingModelVersion() {
            return latestScheduledRetrainingModelVersion;
        }

        public final void setLatestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
        }

        @Override
        public final Builder latestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
            return this;
        }

        public final Instant getLatestScheduledRetrainingStartTime() {
            return latestScheduledRetrainingStartTime;
        }

        public final void setLatestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
        }

        @Override
        public final Builder latestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
            return this;
        }

        public final Instant getNextScheduledRetrainingStartDate() {
            return nextScheduledRetrainingStartDate;
        }

        public final void setNextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
        }

        @Override
        public final Builder nextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
            return this;
        }

        public final String getRetrainingSchedulerStatus() {
            return retrainingSchedulerStatus;
        }

        public final void setRetrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
        }

        @Override
        public final Builder retrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
            return this;
        }

        @Override
        public final Builder retrainingSchedulerStatus(RetrainingSchedulerStatus retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus(retrainingSchedulerStatus == null ? null : retrainingSchedulerStatus.toString());
            return this;
        }

        public final ModelDiagnosticsOutputConfiguration.Builder getModelDiagnosticsOutputConfiguration() {
            return modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration.toBuilder() : null;
        }

        public final void setModelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration.BuilderImpl modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration
                    .build() : null;
        }

        @Override
        public final Builder modelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration;
            return this;
        }

        public final String getModelQuality() {
            return modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public ModelSummary build() {
            return new ModelSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
