/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the specific model version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelVersionSummary.Builder, ModelVersionSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ModelVersionSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(ModelVersionSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ModelVersion").getter(getter(ModelVersionSummary::modelVersion)).setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersionArn").getter(getter(ModelVersionSummary::modelVersionArn))
            .setter(setter(Builder::modelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(ModelVersionSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ModelVersionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(ModelVersionSummary::sourceTypeAsString)).setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelQuality").getter(getter(ModelVersionSummary::modelQualityAsString))
            .setter(setter(Builder::modelQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, MODEL_VERSION_FIELD, MODEL_VERSION_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD,
            MODEL_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final Long modelVersion;

    private final String modelVersionArn;

    private final Instant createdAt;

    private final String status;

    private final String sourceType;

    private final String modelQuality;

    private ModelVersionSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersion = builder.modelVersion;
        this.modelVersionArn = builder.modelVersionArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.modelQuality = builder.modelQuality;
    }

    /**
     * <p>
     * The name of the model that this model version is a version of.
     * </p>
     * 
     * @return The name of the model that this model version is a version of.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model that this model version is a version of.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model that this model version is a version of.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The version of the model.
     * </p>
     * 
     * @return The version of the model.
     */
    public final Long modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version.
     */
    public final String modelVersionArn() {
        return modelVersionArn;
    }

    /**
     * <p>
     * The time when this model version was created.
     * </p>
     * 
     * @return The time when this model version was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates how this model version was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Indicates how this model version was generated.
     * @see ModelVersionSourceType
     */
    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Indicates how this model version was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Indicates how this model version was generated.
     * @see ModelVersionSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(modelQuality);
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final String modelQualityAsString() {
        return modelQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelVersionSummary)) {
            return false;
        }
        ModelVersionSummary other = (ModelVersionSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(modelVersionArn(), other.modelVersionArn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(modelQualityAsString(), other.modelQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelVersionSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("ModelVersion", modelVersion()).add("ModelVersionArn", modelVersionArn()).add("CreatedAt", createdAt())
                .add("Status", statusAsString()).add("SourceType", sourceTypeAsString())
                .add("ModelQuality", modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "ModelVersionArn":
            return Optional.ofNullable(clazz.cast(modelVersionArn()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("ModelVersionArn", MODEL_VERSION_ARN_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelVersionSummary, T> g) {
        return obj -> g.apply((ModelVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelVersionSummary> {
        /**
         * <p>
         * The name of the model that this model version is a version of.
         * </p>
         * 
         * @param modelName
         *        The name of the model that this model version is a version of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model that this model version is a version of.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the model that this model version is a version of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The version of the model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(Long modelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version.
         * </p>
         * 
         * @param modelVersionArn
         *        The Amazon Resource Name (ARN) of the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionArn(String modelVersionArn);

        /**
         * <p>
         * The time when this model version was created.
         * </p>
         * 
         * @param createdAt
         *        The time when this model version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(ModelVersionStatus status);

        /**
         * <p>
         * Indicates how this model version was generated.
         * </p>
         * 
         * @param sourceType
         *        Indicates how this model version was generated.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Indicates how this model version was generated.
         * </p>
         * 
         * @param sourceType
         *        Indicates how this model version was generated.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(ModelVersionSourceType sourceType);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(String modelQuality);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(ModelQuality modelQuality);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private Long modelVersion;

        private String modelVersionArn;

        private Instant createdAt;

        private String status;

        private String sourceType;

        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelVersionSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            modelVersion(model.modelVersion);
            modelVersionArn(model.modelVersionArn);
            createdAt(model.createdAt);
            status(model.status);
            sourceType(model.sourceType);
            modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Long getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelVersionArn() {
            return modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getModelQuality() {
            return modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public ModelVersionSummary build() {
            return new ModelVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
