/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionSourceType;
import software.amazon.awssdk.services.lookoutequipment.model.ModelVersionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelVersionsRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, ListModelVersionsRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::modelName)).setter(ListModelVersionsRequest.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::nextToken)).setter(ListModelVersionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::maxResults)).setter(ListModelVersionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::statusAsString)).setter(ListModelVersionsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceType").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::sourceTypeAsString)).setter(ListModelVersionsRequest.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAtEndTime").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::createdAtEndTime)).setter(ListModelVersionsRequest.setter(Builder::createdAtEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAtEndTime").build()}).build();
    private static final SdkField<Instant> CREATED_AT_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAtStartTime").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::createdAtStartTime)).setter(ListModelVersionsRequest.setter(Builder::createdAtStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAtStartTime").build()}).build();
    private static final SdkField<Long> MAX_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxModelVersion").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::maxModelVersion)).setter(ListModelVersionsRequest.setter(Builder::maxModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxModelVersion").build()}).build();
    private static final SdkField<Long> MIN_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinModelVersion").getter(ListModelVersionsRequest.getter(ListModelVersionsRequest::minModelVersion)).setter(ListModelVersionsRequest.setter(Builder::minModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinModelVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD, CREATED_AT_END_TIME_FIELD, CREATED_AT_START_TIME_FIELD, MAX_MODEL_VERSION_FIELD, MIN_MODEL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelVersionsRequest.memberNameToFieldInitializer();
    private final String modelName;
    private final String nextToken;
    private final Integer maxResults;
    private final String status;
    private final String sourceType;
    private final Instant createdAtEndTime;
    private final Instant createdAtStartTime;
    private final Long maxModelVersion;
    private final Long minModelVersion;

    private ListModelVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.createdAtEndTime = builder.createdAtEndTime;
        this.createdAtStartTime = builder.createdAtStartTime;
        this.maxModelVersion = builder.maxModelVersion;
        this.minModelVersion = builder.minModelVersion;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public final Instant createdAtEndTime() {
        return this.createdAtEndTime;
    }

    public final Instant createdAtStartTime() {
        return this.createdAtStartTime;
    }

    public final Long maxModelVersion() {
        return this.maxModelVersion;
    }

    public final Long minModelVersion() {
        return this.minModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAtStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.minModelVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelVersionsRequest)) {
            return false;
        }
        ListModelVersionsRequest other = (ListModelVersionsRequest)((Object)obj);
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString()) && Objects.equals(this.createdAtEndTime(), other.createdAtEndTime()) && Objects.equals(this.createdAtStartTime(), other.createdAtStartTime()) && Objects.equals(this.maxModelVersion(), other.maxModelVersion()) && Objects.equals(this.minModelVersion(), other.minModelVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelVersionsRequest").add("ModelName", (Object)this.modelName()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.statusAsString()).add("SourceType", (Object)this.sourceTypeAsString()).add("CreatedAtEndTime", (Object)this.createdAtEndTime()).add("CreatedAtStartTime", (Object)this.createdAtStartTime()).add("MaxModelVersion", (Object)this.maxModelVersion()).add("MinModelVersion", (Object)this.minModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
            case "CreatedAtEndTime": {
                return Optional.ofNullable(clazz.cast(this.createdAtEndTime()));
            }
            case "CreatedAtStartTime": {
                return Optional.ofNullable(clazz.cast(this.createdAtStartTime()));
            }
            case "MaxModelVersion": {
                return Optional.ofNullable(clazz.cast(this.maxModelVersion()));
            }
            case "MinModelVersion": {
                return Optional.ofNullable(clazz.cast(this.minModelVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("CreatedAtEndTime", CREATED_AT_END_TIME_FIELD);
        map.put("CreatedAtStartTime", CREATED_AT_START_TIME_FIELD);
        map.put("MaxModelVersion", MAX_MODEL_VERSION_FIELD);
        map.put("MinModelVersion", MIN_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelVersionsRequest, T> g) {
        return obj -> g.apply((ListModelVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String modelName;
        private String nextToken;
        private Integer maxResults;
        private String status;
        private String sourceType;
        private Instant createdAtEndTime;
        private Instant createdAtStartTime;
        private Long maxModelVersion;
        private Long minModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelVersionsRequest model) {
            super(model);
            this.modelName(model.modelName);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.status(model.status);
            this.sourceType(model.sourceType);
            this.createdAtEndTime(model.createdAtEndTime);
            this.createdAtStartTime(model.createdAtStartTime);
            this.maxModelVersion(model.maxModelVersion);
            this.minModelVersion(model.minModelVersion);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Instant getCreatedAtEndTime() {
            return this.createdAtEndTime;
        }

        public final void setCreatedAtEndTime(Instant createdAtEndTime) {
            this.createdAtEndTime = createdAtEndTime;
        }

        @Override
        public final Builder createdAtEndTime(Instant createdAtEndTime) {
            this.createdAtEndTime = createdAtEndTime;
            return this;
        }

        public final Instant getCreatedAtStartTime() {
            return this.createdAtStartTime;
        }

        public final void setCreatedAtStartTime(Instant createdAtStartTime) {
            this.createdAtStartTime = createdAtStartTime;
        }

        @Override
        public final Builder createdAtStartTime(Instant createdAtStartTime) {
            this.createdAtStartTime = createdAtStartTime;
            return this;
        }

        public final Long getMaxModelVersion() {
            return this.maxModelVersion;
        }

        public final void setMaxModelVersion(Long maxModelVersion) {
            this.maxModelVersion = maxModelVersion;
        }

        @Override
        public final Builder maxModelVersion(Long maxModelVersion) {
            this.maxModelVersion = maxModelVersion;
            return this;
        }

        public final Long getMinModelVersion() {
            return this.minModelVersion;
        }

        public final void setMinModelVersion(Long minModelVersion) {
            this.minModelVersion = minModelVersion;
        }

        @Override
        public final Builder minModelVersion(Long minModelVersion) {
            this.minModelVersion = minModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelVersionsRequest build() {
            return new ListModelVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelVersionsRequest> {
        public Builder modelName(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder status(String var1);

        public Builder status(ModelVersionStatus var1);

        public Builder sourceType(String var1);

        public Builder sourceType(ModelVersionSourceType var1);

        public Builder createdAtEndTime(Instant var1);

        public Builder createdAtStartTime(Instant var1);

        public Builder maxModelVersion(Long var1);

        public Builder minModelVersion(Long var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

