/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataUploadFrequency;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceInputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceOutputConfiguration;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateInferenceSchedulerRequest
extends LookoutEquipmentRequest
implements ToCopyableBuilder<Builder, UpdateInferenceSchedulerRequest> {
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::inferenceSchedulerName)).setter(UpdateInferenceSchedulerRequest.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataDelayOffsetInMinutes").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::dataDelayOffsetInMinutes)).setter(UpdateInferenceSchedulerRequest.setter(Builder::dataDelayOffsetInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build()}).build();
    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataUploadFrequency").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::dataUploadFrequencyAsString)).setter(UpdateInferenceSchedulerRequest.setter(Builder::dataUploadFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build()}).build();
    private static final SdkField<InferenceInputConfiguration> DATA_INPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataInputConfiguration").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::dataInputConfiguration)).setter(UpdateInferenceSchedulerRequest.setter(Builder::dataInputConfiguration)).constructor(InferenceInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataInputConfiguration").build()}).build();
    private static final SdkField<InferenceOutputConfiguration> DATA_OUTPUT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataOutputConfiguration").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::dataOutputConfiguration)).setter(UpdateInferenceSchedulerRequest.setter(Builder::dataOutputConfiguration)).constructor(InferenceOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataOutputConfiguration").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(UpdateInferenceSchedulerRequest.getter(UpdateInferenceSchedulerRequest::roleArn)).setter(UpdateInferenceSchedulerRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SCHEDULER_NAME_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, DATA_INPUT_CONFIGURATION_FIELD, DATA_OUTPUT_CONFIGURATION_FIELD, ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateInferenceSchedulerRequest.memberNameToFieldInitializer();
    private final String inferenceSchedulerName;
    private final Long dataDelayOffsetInMinutes;
    private final String dataUploadFrequency;
    private final InferenceInputConfiguration dataInputConfiguration;
    private final InferenceOutputConfiguration dataOutputConfiguration;
    private final String roleArn;

    private UpdateInferenceSchedulerRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.dataInputConfiguration = builder.dataInputConfiguration;
        this.dataOutputConfiguration = builder.dataOutputConfiguration;
        this.roleArn = builder.roleArn;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final Long dataDelayOffsetInMinutes() {
        return this.dataDelayOffsetInMinutes;
    }

    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(this.dataUploadFrequency);
    }

    public final String dataUploadFrequencyAsString() {
        return this.dataUploadFrequency;
    }

    public final InferenceInputConfiguration dataInputConfiguration() {
        return this.dataInputConfiguration;
    }

    public final InferenceOutputConfiguration dataOutputConfiguration() {
        return this.dataOutputConfiguration;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInferenceSchedulerRequest)) {
            return false;
        }
        UpdateInferenceSchedulerRequest other = (UpdateInferenceSchedulerRequest)((Object)obj);
        return Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes()) && Objects.equals(this.dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString()) && Objects.equals(this.dataInputConfiguration(), other.dataInputConfiguration()) && Objects.equals(this.dataOutputConfiguration(), other.dataOutputConfiguration()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateInferenceSchedulerRequest").add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("DataDelayOffsetInMinutes", (Object)this.dataDelayOffsetInMinutes()).add("DataUploadFrequency", (Object)this.dataUploadFrequencyAsString()).add("DataInputConfiguration", (Object)this.dataInputConfiguration()).add("DataOutputConfiguration", (Object)this.dataOutputConfiguration()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "DataDelayOffsetInMinutes": {
                return Optional.ofNullable(clazz.cast(this.dataDelayOffsetInMinutes()));
            }
            case "DataUploadFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataUploadFrequencyAsString()));
            }
            case "DataInputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataInputConfiguration()));
            }
            case "DataOutputConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataOutputConfiguration()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("DataDelayOffsetInMinutes", DATA_DELAY_OFFSET_IN_MINUTES_FIELD);
        map.put("DataUploadFrequency", DATA_UPLOAD_FREQUENCY_FIELD);
        map.put("DataInputConfiguration", DATA_INPUT_CONFIGURATION_FIELD);
        map.put("DataOutputConfiguration", DATA_OUTPUT_CONFIGURATION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateInferenceSchedulerRequest, T> g) {
        return obj -> g.apply((UpdateInferenceSchedulerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutEquipmentRequest.BuilderImpl
    implements Builder {
        private String inferenceSchedulerName;
        private Long dataDelayOffsetInMinutes;
        private String dataUploadFrequency;
        private InferenceInputConfiguration dataInputConfiguration;
        private InferenceOutputConfiguration dataOutputConfiguration;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInferenceSchedulerRequest model) {
            super(model);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            this.dataUploadFrequency(model.dataUploadFrequency);
            this.dataInputConfiguration(model.dataInputConfiguration);
            this.dataOutputConfiguration(model.dataOutputConfiguration);
            this.roleArn(model.roleArn);
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return this.dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return this.dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final InferenceInputConfiguration.Builder getDataInputConfiguration() {
            return this.dataInputConfiguration != null ? this.dataInputConfiguration.toBuilder() : null;
        }

        public final void setDataInputConfiguration(InferenceInputConfiguration.BuilderImpl dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration != null ? dataInputConfiguration.build() : null;
        }

        @Override
        public final Builder dataInputConfiguration(InferenceInputConfiguration dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        public final InferenceOutputConfiguration.Builder getDataOutputConfiguration() {
            return this.dataOutputConfiguration != null ? this.dataOutputConfiguration.toBuilder() : null;
        }

        public final void setDataOutputConfiguration(InferenceOutputConfiguration.BuilderImpl dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration != null ? dataOutputConfiguration.build() : null;
        }

        @Override
        public final Builder dataOutputConfiguration(InferenceOutputConfiguration dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateInferenceSchedulerRequest build() {
            return new UpdateInferenceSchedulerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LookoutEquipmentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateInferenceSchedulerRequest> {
        public Builder inferenceSchedulerName(String var1);

        public Builder dataDelayOffsetInMinutes(Long var1);

        public Builder dataUploadFrequency(String var1);

        public Builder dataUploadFrequency(DataUploadFrequency var1);

        public Builder dataInputConfiguration(InferenceInputConfiguration var1);

        default public Builder dataInputConfiguration(Consumer<InferenceInputConfiguration.Builder> dataInputConfiguration) {
            return this.dataInputConfiguration((InferenceInputConfiguration)((InferenceInputConfiguration.Builder)InferenceInputConfiguration.builder().applyMutation(dataInputConfiguration)).build());
        }

        public Builder dataOutputConfiguration(InferenceOutputConfiguration var1);

        default public Builder dataOutputConfiguration(Consumer<InferenceOutputConfiguration.Builder> dataOutputConfiguration) {
            return this.dataOutputConfiguration((InferenceOutputConfiguration)((InferenceOutputConfiguration.Builder)InferenceOutputConfiguration.builder().applyMutation(dataOutputConfiguration)).build());
        }

        public Builder roleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

