/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionS3InputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionS3InputConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Bucket").getter(IngestionS3InputConfiguration.getter(IngestionS3InputConfiguration::bucket)).setter(IngestionS3InputConfiguration.setter(Builder::bucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()}).build();
    private static final SdkField<String> PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Prefix").getter(IngestionS3InputConfiguration.getter(IngestionS3InputConfiguration::prefix)).setter(IngestionS3InputConfiguration.setter(Builder::prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()}).build();
    private static final SdkField<String> KEY_PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KeyPattern").getter(IngestionS3InputConfiguration.getter(IngestionS3InputConfiguration::keyPattern)).setter(IngestionS3InputConfiguration.setter(Builder::keyPattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPattern").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PREFIX_FIELD, KEY_PATTERN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = IngestionS3InputConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String bucket;
    private final String prefix;
    private final String keyPattern;

    private IngestionS3InputConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.keyPattern = builder.keyPattern;
    }

    public final String bucket() {
        return this.bucket;
    }

    public final String prefix() {
        return this.prefix;
    }

    public final String keyPattern() {
        return this.keyPattern;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPattern());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionS3InputConfiguration)) {
            return false;
        }
        IngestionS3InputConfiguration other = (IngestionS3InputConfiguration)obj;
        return Objects.equals(this.bucket(), other.bucket()) && Objects.equals(this.prefix(), other.prefix()) && Objects.equals(this.keyPattern(), other.keyPattern());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionS3InputConfiguration").add("Bucket", (Object)this.bucket()).add("Prefix", (Object)this.prefix()).add("KeyPattern", (Object)this.keyPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Bucket": {
                return Optional.ofNullable(clazz.cast(this.bucket()));
            }
            case "Prefix": {
                return Optional.ofNullable(clazz.cast(this.prefix()));
            }
            case "KeyPattern": {
                return Optional.ofNullable(clazz.cast(this.keyPattern()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("KeyPattern", KEY_PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionS3InputConfiguration, T> g) {
        return obj -> g.apply((IngestionS3InputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String bucket;
        private String prefix;
        private String keyPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionS3InputConfiguration model) {
            this.bucket(model.bucket);
            this.prefix(model.prefix);
            this.keyPattern(model.keyPattern);
        }

        public final String getBucket() {
            return this.bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getPrefix() {
            return this.prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getKeyPattern() {
            return this.keyPattern;
        }

        public final void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }

        @Override
        public final Builder keyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        public IngestionS3InputConfiguration build() {
            return new IngestionS3InputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionS3InputConfiguration> {
        public Builder bucket(String var1);

        public Builder prefix(String var1);

        public Builder keyPattern(String var1);
    }
}

