/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentAsyncClient;
import software.amazon.awssdk.services.lookoutequipment.LookoutEquipmentServiceClientConfiguration;
import software.amazon.awssdk.services.lookoutequipment.internal.LookoutEquipmentServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.lookoutequipment.model.AccessDeniedException;
import software.amazon.awssdk.services.lookoutequipment.model.ConflictException;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.CreateRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DeleteRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeLabelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.DescribeRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportDatasetResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ImportModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.InternalServerException;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDataIngestionJobsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListDatasetsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceEventsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceExecutionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListInferenceSchedulersResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelGroupsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListLabelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelVersionsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListModelsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListRetrainingSchedulersResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListSensorStatisticsResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.LookoutEquipmentException;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.lookoutequipment.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ResourceNotFoundException;
import software.amazon.awssdk.services.lookoutequipment.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartDataIngestionJobResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StartRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StopInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.StopRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.TagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ThrottlingException;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UntagResourceResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateActiveModelVersionResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateInferenceSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateLabelGroupResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateModelRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateModelResponse;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerRequest;
import software.amazon.awssdk.services.lookoutequipment.model.UpdateRetrainingSchedulerResponse;
import software.amazon.awssdk.services.lookoutequipment.model.ValidationException;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateDatasetRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateLabelGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateLabelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateModelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.CreateRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteDatasetRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteLabelGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteLabelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteModelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DeleteRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeDataIngestionJobRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeDatasetRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeLabelGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeLabelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeModelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeModelVersionRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.DescribeRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ImportDatasetRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ImportModelVersionRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListDataIngestionJobsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListDatasetsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListInferenceEventsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListInferenceExecutionsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListInferenceSchedulersRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListLabelGroupsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListLabelsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListModelVersionsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListModelsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListRetrainingSchedulersRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListSensorStatisticsRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.StartDataIngestionJobRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.StartInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.StartRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.StopInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.StopRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UpdateActiveModelVersionRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UpdateInferenceSchedulerRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UpdateLabelGroupRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UpdateModelRequestMarshaller;
import software.amazon.awssdk.services.lookoutequipment.transform.UpdateRetrainingSchedulerRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultLookoutEquipmentAsyncClient
implements LookoutEquipmentAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultLookoutEquipmentAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultLookoutEquipmentAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateDatasetResponse> createDataset(CreateDatasetRequest createDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createDataset$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createDataset$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateInferenceSchedulerResponse> createInferenceScheduler(CreateInferenceSchedulerRequest createInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createInferenceScheduler$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createInferenceScheduler$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLabelResponse> createLabel(CreateLabelRequest createLabelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLabelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLabelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createLabel$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createLabel$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateLabelGroupResponse> createLabelGroup(CreateLabelGroupRequest createLabelGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createLabelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createLabelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateLabelGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateLabelGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateLabelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateLabelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createLabelGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createLabelGroup$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createLabelGroup$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateModelResponse> createModel(CreateModelRequest createModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createModel$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createModel$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateRetrainingSchedulerResponse> createRetrainingScheduler(CreateRetrainingSchedulerRequest createRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, createRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$createRetrainingScheduler$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$createRetrainingScheduler$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDatasetResponse> deleteDataset(DeleteDatasetRequest deleteDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteDataset$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteDataset$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInferenceSchedulerResponse> deleteInferenceScheduler(DeleteInferenceSchedulerRequest deleteInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteInferenceScheduler$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteInferenceScheduler$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLabelResponse> deleteLabel(DeleteLabelRequest deleteLabelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLabelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLabelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteLabel$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteLabel$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteLabelGroupResponse> deleteLabelGroup(DeleteLabelGroupRequest deleteLabelGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteLabelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteLabelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteLabelGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteLabelGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteLabelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteLabelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteLabelGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteLabelGroup$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteLabelGroup$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteModelResponse> deleteModel(DeleteModelRequest deleteModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteModel$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteModel$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteResourcePolicyResponse> deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteResourcePolicy$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteResourcePolicy$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteRetrainingSchedulerResponse> deleteRetrainingScheduler(DeleteRetrainingSchedulerRequest deleteRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, deleteRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$deleteRetrainingScheduler$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$deleteRetrainingScheduler$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDataIngestionJobResponse> describeDataIngestionJob(DescribeDataIngestionJobRequest describeDataIngestionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDataIngestionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeDataIngestionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataIngestionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDataIngestionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataIngestionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDataIngestionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDataIngestionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeDataIngestionJob$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeDataIngestionJob$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeDatasetResponse> describeDataset(DescribeDatasetRequest describeDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeDataset$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeDataset$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeInferenceSchedulerResponse> describeInferenceScheduler(DescribeInferenceSchedulerRequest describeInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeInferenceScheduler$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeInferenceScheduler$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLabelResponse> describeLabel(DescribeLabelRequest describeLabelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLabelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeLabelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLabel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLabelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLabel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLabelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLabelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeLabel$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeLabel$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeLabelGroupResponse> describeLabelGroup(DescribeLabelGroupRequest describeLabelGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeLabelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeLabelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeLabelGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeLabelGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeLabelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeLabelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeLabelGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeLabelGroup$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeLabelGroup$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeModelResponse> describeModel(DescribeModelRequest describeModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeModel$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeModel$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeModelVersionResponse> describeModelVersion(DescribeModelVersionRequest describeModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeModelVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeModelVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeModelVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeModelVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeModelVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeModelVersion$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeModelVersion$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeResourcePolicyResponse> describeResourcePolicy(DescribeResourcePolicyRequest describeResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeResourcePolicy$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeResourcePolicy$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeRetrainingSchedulerResponse> describeRetrainingScheduler(DescribeRetrainingSchedulerRequest describeRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, describeRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$describeRetrainingScheduler$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$describeRetrainingScheduler$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportDatasetResponse> importDataset(ImportDatasetRequest importDatasetRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, importDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportDataset");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportDatasetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importDatasetRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$importDataset$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$importDataset$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ImportModelVersionResponse> importModelVersion(ImportModelVersionRequest importModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)importModelVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, importModelVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportModelVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportModelVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ImportModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)importModelVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$importModelVersion$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$importModelVersion$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDataIngestionJobsResponse> listDataIngestionJobs(ListDataIngestionJobsRequest listDataIngestionJobsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDataIngestionJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listDataIngestionJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDataIngestionJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDataIngestionJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDataIngestionJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDataIngestionJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDataIngestionJobsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listDataIngestionJobs$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listDataIngestionJobs$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDatasetsResponse> listDatasets(ListDatasetsRequest listDatasetsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDatasets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDatasetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDatasetsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listDatasets$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listDatasets$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInferenceEventsResponse> listInferenceEvents(ListInferenceEventsRequest listInferenceEventsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInferenceEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listInferenceEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInferenceEvents");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInferenceEventsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInferenceEvents").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListInferenceEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInferenceEventsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceEvents$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceEvents$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInferenceExecutionsResponse> listInferenceExecutions(ListInferenceExecutionsRequest listInferenceExecutionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInferenceExecutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listInferenceExecutionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInferenceExecutions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInferenceExecutionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInferenceExecutions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListInferenceExecutionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInferenceExecutionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceExecutions$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceExecutions$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListInferenceSchedulersResponse> listInferenceSchedulers(ListInferenceSchedulersRequest listInferenceSchedulersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInferenceSchedulersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listInferenceSchedulersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInferenceSchedulers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInferenceSchedulersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInferenceSchedulers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListInferenceSchedulersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listInferenceSchedulersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceSchedulers$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listInferenceSchedulers$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLabelGroupsResponse> listLabelGroups(ListLabelGroupsRequest listLabelGroupsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLabelGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listLabelGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLabelGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLabelGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLabelGroups").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLabelGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLabelGroupsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listLabelGroups$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listLabelGroups$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListLabelsResponse> listLabels(ListLabelsRequest listLabelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listLabelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listLabelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListLabels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListLabelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListLabels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListLabelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listLabelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listLabels$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listLabels$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListModelVersionsResponse> listModelVersions(ListModelVersionsRequest listModelVersionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listModelVersionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listModelVersionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListModelVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListModelVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListModelVersions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListModelVersionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listModelVersionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listModelVersions$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listModelVersions$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListModelsResponse> listModels(ListModelsRequest listModelsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListModels");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListModelsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listModelsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listModels$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listModels$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListRetrainingSchedulersResponse> listRetrainingSchedulers(ListRetrainingSchedulersRequest listRetrainingSchedulersRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listRetrainingSchedulersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listRetrainingSchedulersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRetrainingSchedulers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRetrainingSchedulersResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRetrainingSchedulers").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListRetrainingSchedulersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listRetrainingSchedulersRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listRetrainingSchedulers$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listRetrainingSchedulers$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSensorStatisticsResponse> listSensorStatistics(ListSensorStatisticsRequest listSensorStatisticsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSensorStatisticsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listSensorStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSensorStatistics");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSensorStatisticsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSensorStatistics").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSensorStatisticsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSensorStatisticsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listSensorStatistics$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listSensorStatistics$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$listTagsForResource$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$listTagsForResource$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutResourcePolicyResponse> putResourcePolicy(PutResourcePolicyRequest putResourcePolicyRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, putResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutResourcePolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutResourcePolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new PutResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putResourcePolicyRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$putResourcePolicy$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$putResourcePolicy$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartDataIngestionJobResponse> startDataIngestionJob(StartDataIngestionJobRequest startDataIngestionJobRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startDataIngestionJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, startDataIngestionJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartDataIngestionJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartDataIngestionJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartDataIngestionJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartDataIngestionJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startDataIngestionJobRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$startDataIngestionJob$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$startDataIngestionJob$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartInferenceSchedulerResponse> startInferenceScheduler(StartInferenceSchedulerRequest startInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, startInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$startInferenceScheduler$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$startInferenceScheduler$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartRetrainingSchedulerResponse> startRetrainingScheduler(StartRetrainingSchedulerRequest startRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, startRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$startRetrainingScheduler$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$startRetrainingScheduler$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopInferenceSchedulerResponse> stopInferenceScheduler(StopInferenceSchedulerRequest stopInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, stopInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$stopInferenceScheduler$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$stopInferenceScheduler$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopRetrainingSchedulerResponse> stopRetrainingScheduler(StopRetrainingSchedulerRequest stopRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)stopRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, stopRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StopRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StopRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$stopRetrainingScheduler$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$stopRetrainingScheduler$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$tagResource$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$tagResource$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$untagResource$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$untagResource$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateActiveModelVersionResponse> updateActiveModelVersion(UpdateActiveModelVersionRequest updateActiveModelVersionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateActiveModelVersionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, updateActiveModelVersionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateActiveModelVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateActiveModelVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateActiveModelVersion").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateActiveModelVersionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateActiveModelVersionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$updateActiveModelVersion$178(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$updateActiveModelVersion$179((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateInferenceSchedulerResponse> updateInferenceScheduler(UpdateInferenceSchedulerRequest updateInferenceSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateInferenceSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, updateInferenceSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateInferenceScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInferenceSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInferenceScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateInferenceSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateInferenceSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$updateInferenceScheduler$182(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$updateInferenceScheduler$183((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateLabelGroupResponse> updateLabelGroup(UpdateLabelGroupRequest updateLabelGroupRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateLabelGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, updateLabelGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateLabelGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateLabelGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateLabelGroup").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateLabelGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateLabelGroupRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$updateLabelGroup$186(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$updateLabelGroup$187((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateModelResponse> updateModel(UpdateModelRequest updateModelRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, updateModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateModel");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateModelResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateModelRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$updateModel$190(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$updateModel$191((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateRetrainingSchedulerResponse> updateRetrainingScheduler(UpdateRetrainingSchedulerRequest updateRetrainingSchedulerRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateRetrainingSchedulerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultLookoutEquipmentAsyncClient.resolveMetricPublishers(clientConfiguration, updateRetrainingSchedulerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"LookoutEquipment");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRetrainingScheduler");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRetrainingSchedulerResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "ThrottlingException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "InternalServerException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(Integer.valueOf(500)).exceptionBuilderSupplier(InternalServerException::builder).build());
                    }
                    case "AccessDeniedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                    }
                    case "ConflictException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "ValidationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ValidationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRetrainingScheduler").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateRetrainingSchedulerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateRetrainingSchedulerRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultLookoutEquipmentAsyncClient.lambda$updateRetrainingScheduler$194(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultLookoutEquipmentAsyncClient.lambda$updateRetrainingScheduler$195((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final LookoutEquipmentServiceClientConfiguration serviceClientConfiguration() {
        return new LookoutEquipmentServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "lookoutequipment";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(LookoutEquipmentException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        LookoutEquipmentServiceClientConfigurationBuilder serviceConfigBuilder = new LookoutEquipmentServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateRetrainingScheduler$195(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRetrainingScheduler$194(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateModel$191(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateModel$190(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateLabelGroup$187(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateLabelGroup$186(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateLabelGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateInferenceScheduler$183(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateInferenceScheduler$182(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateActiveModelVersion$179(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateActiveModelVersion$178(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateActiveModelVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$174(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$170(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopRetrainingScheduler$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopRetrainingScheduler$166(List metricPublishers, MetricCollector apiCallMetricCollector, StopRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopInferenceScheduler$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopInferenceScheduler$162(List metricPublishers, MetricCollector apiCallMetricCollector, StopInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startRetrainingScheduler$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRetrainingScheduler$158(List metricPublishers, MetricCollector apiCallMetricCollector, StartRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startInferenceScheduler$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startInferenceScheduler$154(List metricPublishers, MetricCollector apiCallMetricCollector, StartInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startDataIngestionJob$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startDataIngestionJob$150(List metricPublishers, MetricCollector apiCallMetricCollector, StartDataIngestionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putResourcePolicy$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putResourcePolicy$146(List metricPublishers, MetricCollector apiCallMetricCollector, PutResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$142(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSensorStatistics$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSensorStatistics$138(List metricPublishers, MetricCollector apiCallMetricCollector, ListSensorStatisticsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listRetrainingSchedulers$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRetrainingSchedulers$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListRetrainingSchedulersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listModels$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listModels$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListModelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listModelVersions$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listModelVersions$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListModelVersionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLabels$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLabels$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListLabelsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listLabelGroups$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listLabelGroups$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListLabelGroupsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInferenceSchedulers$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInferenceSchedulers$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListInferenceSchedulersResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInferenceExecutions$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInferenceExecutions$110(List metricPublishers, MetricCollector apiCallMetricCollector, ListInferenceExecutionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listInferenceEvents$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listInferenceEvents$106(List metricPublishers, MetricCollector apiCallMetricCollector, ListInferenceEventsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDatasets$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDatasets$102(List metricPublishers, MetricCollector apiCallMetricCollector, ListDatasetsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDataIngestionJobs$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDataIngestionJobs$98(List metricPublishers, MetricCollector apiCallMetricCollector, ListDataIngestionJobsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importModelVersion$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importModelVersion$94(List metricPublishers, MetricCollector apiCallMetricCollector, ImportModelVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$importDataset$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importDataset$90(List metricPublishers, MetricCollector apiCallMetricCollector, ImportDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeRetrainingScheduler$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeRetrainingScheduler$86(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeResourcePolicy$82(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeModelVersion$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeModelVersion$78(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeModelVersionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeModel$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeModel$74(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLabelGroup$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLabelGroup$70(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLabelGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeLabel$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeLabel$66(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeLabelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeInferenceScheduler$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInferenceScheduler$62(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataset$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataset$58(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeDataIngestionJob$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDataIngestionJob$54(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeDataIngestionJobResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteRetrainingScheduler$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRetrainingScheduler$50(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteResourcePolicy$46(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteResourcePolicyResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteModel$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteModel$42(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLabelGroup$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLabelGroup$38(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLabelGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteLabel$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteLabel$34(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteLabelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInferenceScheduler$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInferenceScheduler$30(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDataset$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDataset$26(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createRetrainingScheduler$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRetrainingScheduler$22(List metricPublishers, MetricCollector apiCallMetricCollector, CreateRetrainingSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createModel$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createModel$18(List metricPublishers, MetricCollector apiCallMetricCollector, CreateModelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLabelGroup$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLabelGroup$14(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLabelGroupResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createLabel$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createLabel$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateLabelResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createInferenceScheduler$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createInferenceScheduler$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateInferenceSchedulerResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createDataset$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDataset$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateDatasetResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

