/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lookoutequipment.model.DataUploadFrequency;
import software.amazon.awssdk.services.lookoutequipment.model.InferenceSchedulerStatus;
import software.amazon.awssdk.services.lookoutequipment.model.LatestInferenceResult;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceSchedulerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceSchedulerSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelName").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::modelName)).setter(InferenceSchedulerSummary.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModelArn").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::modelArn)).setter(InferenceSchedulerSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerName").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::inferenceSchedulerName)).setter(InferenceSchedulerSummary.setter(Builder::inferenceSchedulerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build()}).build();
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InferenceSchedulerArn").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::inferenceSchedulerArn)).setter(InferenceSchedulerSummary.setter(Builder::inferenceSchedulerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::statusAsString)).setter(InferenceSchedulerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DataDelayOffsetInMinutes").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::dataDelayOffsetInMinutes)).setter(InferenceSchedulerSummary.setter(Builder::dataDelayOffsetInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build()}).build();
    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataUploadFrequency").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::dataUploadFrequencyAsString)).setter(InferenceSchedulerSummary.setter(Builder::dataUploadFrequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build()}).build();
    private static final SdkField<String> LATEST_INFERENCE_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LatestInferenceResult").getter(InferenceSchedulerSummary.getter(InferenceSchedulerSummary::latestInferenceResultAsString)).setter(InferenceSchedulerSummary.setter(Builder::latestInferenceResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInferenceResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD, MODEL_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, STATUS_FIELD, DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, LATEST_INFERENCE_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InferenceSchedulerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String modelName;
    private final String modelArn;
    private final String inferenceSchedulerName;
    private final String inferenceSchedulerArn;
    private final String status;
    private final Long dataDelayOffsetInMinutes;
    private final String dataUploadFrequency;
    private final String latestInferenceResult;

    private InferenceSchedulerSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.status = builder.status;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.latestInferenceResult = builder.latestInferenceResult;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String inferenceSchedulerName() {
        return this.inferenceSchedulerName;
    }

    public final String inferenceSchedulerArn() {
        return this.inferenceSchedulerArn;
    }

    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Long dataDelayOffsetInMinutes() {
        return this.dataDelayOffsetInMinutes;
    }

    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(this.dataUploadFrequency);
    }

    public final String dataUploadFrequencyAsString() {
        return this.dataUploadFrequency;
    }

    public final LatestInferenceResult latestInferenceResult() {
        return LatestInferenceResult.fromValue(this.latestInferenceResult);
    }

    public final String latestInferenceResultAsString() {
        return this.latestInferenceResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestInferenceResultAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceSchedulerSummary)) {
            return false;
        }
        InferenceSchedulerSummary other = (InferenceSchedulerSummary)obj;
        return Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.inferenceSchedulerName(), other.inferenceSchedulerName()) && Objects.equals(this.inferenceSchedulerArn(), other.inferenceSchedulerArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes()) && Objects.equals(this.dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString()) && Objects.equals(this.latestInferenceResultAsString(), other.latestInferenceResultAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceSchedulerSummary").add("ModelName", (Object)this.modelName()).add("ModelArn", (Object)this.modelArn()).add("InferenceSchedulerName", (Object)this.inferenceSchedulerName()).add("InferenceSchedulerArn", (Object)this.inferenceSchedulerArn()).add("Status", (Object)this.statusAsString()).add("DataDelayOffsetInMinutes", (Object)this.dataDelayOffsetInMinutes()).add("DataUploadFrequency", (Object)this.dataUploadFrequencyAsString()).add("LatestInferenceResult", (Object)this.latestInferenceResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ModelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "ModelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "InferenceSchedulerName": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerName()));
            }
            case "InferenceSchedulerArn": {
                return Optional.ofNullable(clazz.cast(this.inferenceSchedulerArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "DataDelayOffsetInMinutes": {
                return Optional.ofNullable(clazz.cast(this.dataDelayOffsetInMinutes()));
            }
            case "DataUploadFrequency": {
                return Optional.ofNullable(clazz.cast(this.dataUploadFrequencyAsString()));
            }
            case "LatestInferenceResult": {
                return Optional.ofNullable(clazz.cast(this.latestInferenceResultAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DataDelayOffsetInMinutes", DATA_DELAY_OFFSET_IN_MINUTES_FIELD);
        map.put("DataUploadFrequency", DATA_UPLOAD_FREQUENCY_FIELD);
        map.put("LatestInferenceResult", LATEST_INFERENCE_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceSchedulerSummary, T> g) {
        return obj -> g.apply((InferenceSchedulerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String modelName;
        private String modelArn;
        private String inferenceSchedulerName;
        private String inferenceSchedulerArn;
        private String status;
        private Long dataDelayOffsetInMinutes;
        private String dataUploadFrequency;
        private String latestInferenceResult;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceSchedulerSummary model) {
            this.modelName(model.modelName);
            this.modelArn(model.modelArn);
            this.inferenceSchedulerName(model.inferenceSchedulerName);
            this.inferenceSchedulerArn(model.inferenceSchedulerArn);
            this.status(model.status);
            this.dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            this.dataUploadFrequency(model.dataUploadFrequency);
            this.latestInferenceResult(model.latestInferenceResult);
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return this.inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return this.dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return this.dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final String getLatestInferenceResult() {
            return this.latestInferenceResult;
        }

        public final void setLatestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
        }

        @Override
        public final Builder latestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
            return this;
        }

        @Override
        public final Builder latestInferenceResult(LatestInferenceResult latestInferenceResult) {
            this.latestInferenceResult(latestInferenceResult == null ? null : latestInferenceResult.toString());
            return this;
        }

        public InferenceSchedulerSummary build() {
            return new InferenceSchedulerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceSchedulerSummary> {
        public Builder modelName(String var1);

        public Builder modelArn(String var1);

        public Builder inferenceSchedulerName(String var1);

        public Builder inferenceSchedulerArn(String var1);

        public Builder status(String var1);

        public Builder status(InferenceSchedulerStatus var1);

        public Builder dataDelayOffsetInMinutes(Long var1);

        public Builder dataUploadFrequency(String var1);

        public Builder dataUploadFrequency(DataUploadFrequency var1);

        public Builder latestInferenceResult(String var1);

        public Builder latestInferenceResult(LatestInferenceResult var1);
    }
}

