/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInferenceSchedulerResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<CreateInferenceSchedulerResponse.Builder, CreateInferenceSchedulerResponse> {
    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerArn").getter(getter(CreateInferenceSchedulerResponse::inferenceSchedulerArn))
            .setter(setter(Builder::inferenceSchedulerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build())
            .build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(CreateInferenceSchedulerResponse::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(CreateInferenceSchedulerResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelQuality").getter(getter(CreateInferenceSchedulerResponse::modelQualityAsString))
            .setter(setter(Builder::modelQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_SCHEDULER_ARN_FIELD,
            INFERENCE_SCHEDULER_NAME_FIELD, STATUS_FIELD, MODEL_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String inferenceSchedulerArn;

    private final String inferenceSchedulerName;

    private final String status;

    private final String modelQuality;

    private CreateInferenceSchedulerResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.status = builder.status;
        this.modelQuality = builder.modelQuality;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference scheduler being created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference scheduler being created.
     */
    public final String inferenceSchedulerArn() {
        return inferenceSchedulerArn;
    }

    /**
     * <p>
     * The name of inference scheduler being created.
     * </p>
     * 
     * @return The name of inference scheduler being created.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * Indicates the status of the <code>CreateInferenceScheduler</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the <code>CreateInferenceScheduler</code> operation.
     * @see InferenceSchedulerStatus
     */
    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the <code>CreateInferenceScheduler</code> operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the <code>CreateInferenceScheduler</code> operation.
     * @see InferenceSchedulerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(modelQuality);
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final String modelQualityAsString() {
        return modelQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceSchedulerResponse)) {
            return false;
        }
        CreateInferenceSchedulerResponse other = (CreateInferenceSchedulerResponse) obj;
        return Objects.equals(inferenceSchedulerArn(), other.inferenceSchedulerArn())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(modelQualityAsString(), other.modelQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInferenceSchedulerResponse").add("InferenceSchedulerArn", inferenceSchedulerArn())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("Status", statusAsString())
                .add("ModelQuality", modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InferenceSchedulerArn":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerArn()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceSchedulerResponse, T> g) {
        return obj -> g.apply((CreateInferenceSchedulerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateInferenceSchedulerResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference scheduler being created.
         * </p>
         * 
         * @param inferenceSchedulerArn
         *        The Amazon Resource Name (ARN) of the inference scheduler being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerArn(String inferenceSchedulerArn);

        /**
         * <p>
         * The name of inference scheduler being created.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of inference scheduler being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * Indicates the status of the <code>CreateInferenceScheduler</code> operation.
         * </p>
         * 
         * @param status
         *        Indicates the status of the <code>CreateInferenceScheduler</code> operation.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the <code>CreateInferenceScheduler</code> operation.
         * </p>
         * 
         * @param status
         *        Indicates the status of the <code>CreateInferenceScheduler</code> operation.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(InferenceSchedulerStatus status);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(String modelQuality);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>. </p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(ModelQuality modelQuality);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String inferenceSchedulerArn;

        private String inferenceSchedulerName;

        private String status;

        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceSchedulerResponse model) {
            super(model);
            inferenceSchedulerArn(model.inferenceSchedulerArn);
            inferenceSchedulerName(model.inferenceSchedulerName);
            status(model.status);
            modelQuality(model.modelQuality);
        }

        public final String getInferenceSchedulerArn() {
            return inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getModelQuality() {
            return modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public CreateInferenceSchedulerResponse build() {
            return new CreateInferenceSchedulerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
