/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLabelGroupRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<CreateLabelGroupRequest.Builder, CreateLabelGroupRequest> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(CreateLabelGroupRequest::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<List<String>> FAULT_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FaultCodes")
            .getter(getter(CreateLabelGroupRequest::faultCodes))
            .setter(setter(Builder::faultCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaultCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateLabelGroupRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateLabelGroupRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            FAULT_CODES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String labelGroupName;

    private final List<String> faultCodes;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateLabelGroupRequest(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.faultCodes = builder.faultCodes;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Names a group of labels.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * 
     * @return Names a group of labels.</p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FaultCodes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFaultCodes() {
        return faultCodes != null && !(faultCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used with this
     * label group.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFaultCodes} method.
     * </p>
     * 
     * @return The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used
     *         with this label group.</p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final List<String> faultCodes() {
        return faultCodes;
    }

    /**
     * <p>
     * A unique identifier for the request to create a label group. If you do not set the client request token, Lookout
     * for Equipment generates one.
     * </p>
     * 
     * @return A unique identifier for the request to create a label group. If you do not set the client request token,
     *         Lookout for Equipment generates one.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags that provide metadata about the label group you are creating.
     * </p>
     * <p>
     * Data in this field will be retained for service usage. Follow best practices for the security of your data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags that provide metadata about the label group you are creating. </p>
     *         <p>
     *         Data in this field will be retained for service usage. Follow best practices for the security of your
     *         data.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFaultCodes() ? faultCodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelGroupRequest)) {
            return false;
        }
        CreateLabelGroupRequest other = (CreateLabelGroupRequest) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName()) && hasFaultCodes() == other.hasFaultCodes()
                && Objects.equals(faultCodes(), other.faultCodes()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLabelGroupRequest").add("LabelGroupName", labelGroupName())
                .add("FaultCodes", hasFaultCodes() ? faultCodes() : null).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "FaultCodes":
            return Optional.ofNullable(clazz.cast(faultCodes()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
        map.put("FaultCodes", FAULT_CODES_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelGroupRequest, T> g) {
        return obj -> g.apply((CreateLabelGroupRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLabelGroupRequest> {
        /**
         * <p>
         * Names a group of labels.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param labelGroupName
         *        Names a group of labels.</p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used with
         * this label group.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param faultCodes
         *        The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used
         *        with this label group.</p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCodes(Collection<String> faultCodes);

        /**
         * <p>
         * The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used with
         * this label group.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param faultCodes
         *        The acceptable fault codes (indicating the type of anomaly associated with the label) that can be used
         *        with this label group.</p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faultCodes(String... faultCodes);

        /**
         * <p>
         * A unique identifier for the request to create a label group. If you do not set the client request token,
         * Lookout for Equipment generates one.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request to create a label group. If you do not set the client request
         *        token, Lookout for Equipment generates one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Tags that provide metadata about the label group you are creating.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param tags
         *        Tags that provide metadata about the label group you are creating. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags that provide metadata about the label group you are creating.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * 
         * @param tags
         *        Tags that provide metadata about the label group you are creating. </p>
         *        <p>
         *        Data in this field will be retained for service usage. Follow best practices for the security of your
         *        data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags that provide metadata about the label group you are creating.
         * </p>
         * <p>
         * Data in this field will be retained for service usage. Follow best practices for the security of your data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.lookoutequipment.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder#build()} is called immediately and
         * its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String labelGroupName;

        private List<String> faultCodes = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelGroupRequest model) {
            super(model);
            labelGroupName(model.labelGroupName);
            faultCodes(model.faultCodes);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final Collection<String> getFaultCodes() {
            if (faultCodes instanceof SdkAutoConstructList) {
                return null;
            }
            return faultCodes;
        }

        public final void setFaultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
        }

        @Override
        public final Builder faultCodes(Collection<String> faultCodes) {
            this.faultCodes = FaultCodesCopier.copy(faultCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder faultCodes(String... faultCodes) {
            faultCodes(Arrays.asList(faultCodes));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLabelGroupRequest build() {
            return new CreateLabelGroupRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
