/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLabelGroupResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<CreateLabelGroupResponse.Builder, CreateLabelGroupResponse> {
    private static final SdkField<String> LABEL_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupName").getter(getter(CreateLabelGroupResponse::labelGroupName))
            .setter(setter(Builder::labelGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupName").build()).build();

    private static final SdkField<String> LABEL_GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LabelGroupArn").getter(getter(CreateLabelGroupResponse::labelGroupArn))
            .setter(setter(Builder::labelGroupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelGroupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABEL_GROUP_NAME_FIELD,
            LABEL_GROUP_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String labelGroupName;

    private final String labelGroupArn;

    private CreateLabelGroupResponse(BuilderImpl builder) {
        super(builder);
        this.labelGroupName = builder.labelGroupName;
        this.labelGroupArn = builder.labelGroupArn;
    }

    /**
     * <p>
     * The name of the label group that you have created. Data in this field will be retained for service usage. Follow
     * best practices for the security of your data.
     * </p>
     * 
     * @return The name of the label group that you have created. Data in this field will be retained for service usage.
     *         Follow best practices for the security of your data.
     */
    public final String labelGroupName() {
        return labelGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the label group that you have created.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the label group that you have created.
     */
    public final String labelGroupArn() {
        return labelGroupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(labelGroupArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLabelGroupResponse)) {
            return false;
        }
        CreateLabelGroupResponse other = (CreateLabelGroupResponse) obj;
        return Objects.equals(labelGroupName(), other.labelGroupName()) && Objects.equals(labelGroupArn(), other.labelGroupArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLabelGroupResponse").add("LabelGroupName", labelGroupName())
                .add("LabelGroupArn", labelGroupArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LabelGroupName":
            return Optional.ofNullable(clazz.cast(labelGroupName()));
        case "LabelGroupArn":
            return Optional.ofNullable(clazz.cast(labelGroupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LabelGroupName", LABEL_GROUP_NAME_FIELD);
        map.put("LabelGroupArn", LABEL_GROUP_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLabelGroupResponse, T> g) {
        return obj -> g.apply((CreateLabelGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLabelGroupResponse> {
        /**
         * <p>
         * The name of the label group that you have created. Data in this field will be retained for service usage.
         * Follow best practices for the security of your data.
         * </p>
         * 
         * @param labelGroupName
         *        The name of the label group that you have created. Data in this field will be retained for service
         *        usage. Follow best practices for the security of your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupName(String labelGroupName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the label group that you have created.
         * </p>
         * 
         * @param labelGroupArn
         *        The Amazon Resource Name (ARN) of the label group that you have created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelGroupArn(String labelGroupArn);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String labelGroupName;

        private String labelGroupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLabelGroupResponse model) {
            super(model);
            labelGroupName(model.labelGroupName);
            labelGroupArn(model.labelGroupArn);
        }

        public final String getLabelGroupName() {
            return labelGroupName;
        }

        public final void setLabelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
        }

        @Override
        public final Builder labelGroupName(String labelGroupName) {
            this.labelGroupName = labelGroupName;
            return this;
        }

        public final String getLabelGroupArn() {
            return labelGroupArn;
        }

        public final void setLabelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
        }

        @Override
        public final Builder labelGroupArn(String labelGroupArn) {
            this.labelGroupArn = labelGroupArn;
            return this;
        }

        @Override
        public CreateLabelGroupResponse build() {
            return new CreateLabelGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
