/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * DataQualitySummary gives aggregated statistics over all the sensors about a completed ingestion job. It primarily
 * gives more information about statistics over different incorrect data like MissingCompleteSensorData,
 * MissingSensorData, UnsupportedDateFormats, InsufficientSensorData, DuplicateTimeStamps.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataQualitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DataQualitySummary.Builder, DataQualitySummary> {
    private static final SdkField<InsufficientSensorData> INSUFFICIENT_SENSOR_DATA_FIELD = SdkField
            .<InsufficientSensorData> builder(MarshallingType.SDK_POJO).memberName("InsufficientSensorData")
            .getter(getter(DataQualitySummary::insufficientSensorData)).setter(setter(Builder::insufficientSensorData))
            .constructor(InsufficientSensorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsufficientSensorData").build())
            .build();

    private static final SdkField<MissingSensorData> MISSING_SENSOR_DATA_FIELD = SdkField
            .<MissingSensorData> builder(MarshallingType.SDK_POJO).memberName("MissingSensorData")
            .getter(getter(DataQualitySummary::missingSensorData)).setter(setter(Builder::missingSensorData))
            .constructor(MissingSensorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingSensorData").build()).build();

    private static final SdkField<InvalidSensorData> INVALID_SENSOR_DATA_FIELD = SdkField
            .<InvalidSensorData> builder(MarshallingType.SDK_POJO).memberName("InvalidSensorData")
            .getter(getter(DataQualitySummary::invalidSensorData)).setter(setter(Builder::invalidSensorData))
            .constructor(InvalidSensorData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvalidSensorData").build()).build();

    private static final SdkField<UnsupportedTimestamps> UNSUPPORTED_TIMESTAMPS_FIELD = SdkField
            .<UnsupportedTimestamps> builder(MarshallingType.SDK_POJO).memberName("UnsupportedTimestamps")
            .getter(getter(DataQualitySummary::unsupportedTimestamps)).setter(setter(Builder::unsupportedTimestamps))
            .constructor(UnsupportedTimestamps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnsupportedTimestamps").build())
            .build();

    private static final SdkField<DuplicateTimestamps> DUPLICATE_TIMESTAMPS_FIELD = SdkField
            .<DuplicateTimestamps> builder(MarshallingType.SDK_POJO).memberName("DuplicateTimestamps")
            .getter(getter(DataQualitySummary::duplicateTimestamps)).setter(setter(Builder::duplicateTimestamps))
            .constructor(DuplicateTimestamps::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DuplicateTimestamps").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSUFFICIENT_SENSOR_DATA_FIELD, MISSING_SENSOR_DATA_FIELD, INVALID_SENSOR_DATA_FIELD, UNSUPPORTED_TIMESTAMPS_FIELD,
            DUPLICATE_TIMESTAMPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InsufficientSensorData insufficientSensorData;

    private final MissingSensorData missingSensorData;

    private final InvalidSensorData invalidSensorData;

    private final UnsupportedTimestamps unsupportedTimestamps;

    private final DuplicateTimestamps duplicateTimestamps;

    private DataQualitySummary(BuilderImpl builder) {
        this.insufficientSensorData = builder.insufficientSensorData;
        this.missingSensorData = builder.missingSensorData;
        this.invalidSensorData = builder.invalidSensorData;
        this.unsupportedTimestamps = builder.unsupportedTimestamps;
        this.duplicateTimestamps = builder.duplicateTimestamps;
    }

    /**
     * <p>
     * Parameter that gives information about insufficient data for sensors in the dataset. This includes information
     * about those sensors that have complete data missing and those with a short date range.
     * </p>
     * 
     * @return Parameter that gives information about insufficient data for sensors in the dataset. This includes
     *         information about those sensors that have complete data missing and those with a short date range.
     */
    public final InsufficientSensorData insufficientSensorData() {
        return insufficientSensorData;
    }

    /**
     * <p>
     * Parameter that gives information about data that is missing over all the sensors in the input data.
     * </p>
     * 
     * @return Parameter that gives information about data that is missing over all the sensors in the input data.
     */
    public final MissingSensorData missingSensorData() {
        return missingSensorData;
    }

    /**
     * <p>
     * Parameter that gives information about data that is invalid over all the sensors in the input data.
     * </p>
     * 
     * @return Parameter that gives information about data that is invalid over all the sensors in the input data.
     */
    public final InvalidSensorData invalidSensorData() {
        return invalidSensorData;
    }

    /**
     * <p>
     * Parameter that gives information about unsupported timestamps in the input data.
     * </p>
     * 
     * @return Parameter that gives information about unsupported timestamps in the input data.
     */
    public final UnsupportedTimestamps unsupportedTimestamps() {
        return unsupportedTimestamps;
    }

    /**
     * <p>
     * Parameter that gives information about duplicate timestamps in the input data.
     * </p>
     * 
     * @return Parameter that gives information about duplicate timestamps in the input data.
     */
    public final DuplicateTimestamps duplicateTimestamps() {
        return duplicateTimestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(insufficientSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(missingSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(invalidSensorData());
        hashCode = 31 * hashCode + Objects.hashCode(unsupportedTimestamps());
        hashCode = 31 * hashCode + Objects.hashCode(duplicateTimestamps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualitySummary)) {
            return false;
        }
        DataQualitySummary other = (DataQualitySummary) obj;
        return Objects.equals(insufficientSensorData(), other.insufficientSensorData())
                && Objects.equals(missingSensorData(), other.missingSensorData())
                && Objects.equals(invalidSensorData(), other.invalidSensorData())
                && Objects.equals(unsupportedTimestamps(), other.unsupportedTimestamps())
                && Objects.equals(duplicateTimestamps(), other.duplicateTimestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataQualitySummary").add("InsufficientSensorData", insufficientSensorData())
                .add("MissingSensorData", missingSensorData()).add("InvalidSensorData", invalidSensorData())
                .add("UnsupportedTimestamps", unsupportedTimestamps()).add("DuplicateTimestamps", duplicateTimestamps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InsufficientSensorData":
            return Optional.ofNullable(clazz.cast(insufficientSensorData()));
        case "MissingSensorData":
            return Optional.ofNullable(clazz.cast(missingSensorData()));
        case "InvalidSensorData":
            return Optional.ofNullable(clazz.cast(invalidSensorData()));
        case "UnsupportedTimestamps":
            return Optional.ofNullable(clazz.cast(unsupportedTimestamps()));
        case "DuplicateTimestamps":
            return Optional.ofNullable(clazz.cast(duplicateTimestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InsufficientSensorData", INSUFFICIENT_SENSOR_DATA_FIELD);
        map.put("MissingSensorData", MISSING_SENSOR_DATA_FIELD);
        map.put("InvalidSensorData", INVALID_SENSOR_DATA_FIELD);
        map.put("UnsupportedTimestamps", UNSUPPORTED_TIMESTAMPS_FIELD);
        map.put("DuplicateTimestamps", DUPLICATE_TIMESTAMPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataQualitySummary, T> g) {
        return obj -> g.apply((DataQualitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataQualitySummary> {
        /**
         * <p>
         * Parameter that gives information about insufficient data for sensors in the dataset. This includes
         * information about those sensors that have complete data missing and those with a short date range.
         * </p>
         * 
         * @param insufficientSensorData
         *        Parameter that gives information about insufficient data for sensors in the dataset. This includes
         *        information about those sensors that have complete data missing and those with a short date range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder insufficientSensorData(InsufficientSensorData insufficientSensorData);

        /**
         * <p>
         * Parameter that gives information about insufficient data for sensors in the dataset. This includes
         * information about those sensors that have complete data missing and those with a short date range.
         * </p>
         * This is a convenience method that creates an instance of the {@link InsufficientSensorData.Builder} avoiding
         * the need to create one manually via {@link InsufficientSensorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InsufficientSensorData.Builder#build()} is called immediately and
         * its result is passed to {@link #insufficientSensorData(InsufficientSensorData)}.
         * 
         * @param insufficientSensorData
         *        a consumer that will call methods on {@link InsufficientSensorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #insufficientSensorData(InsufficientSensorData)
         */
        default Builder insufficientSensorData(Consumer<InsufficientSensorData.Builder> insufficientSensorData) {
            return insufficientSensorData(InsufficientSensorData.builder().applyMutation(insufficientSensorData).build());
        }

        /**
         * <p>
         * Parameter that gives information about data that is missing over all the sensors in the input data.
         * </p>
         * 
         * @param missingSensorData
         *        Parameter that gives information about data that is missing over all the sensors in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missingSensorData(MissingSensorData missingSensorData);

        /**
         * <p>
         * Parameter that gives information about data that is missing over all the sensors in the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link MissingSensorData.Builder} avoiding the
         * need to create one manually via {@link MissingSensorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MissingSensorData.Builder#build()} is called immediately and its
         * result is passed to {@link #missingSensorData(MissingSensorData)}.
         * 
         * @param missingSensorData
         *        a consumer that will call methods on {@link MissingSensorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #missingSensorData(MissingSensorData)
         */
        default Builder missingSensorData(Consumer<MissingSensorData.Builder> missingSensorData) {
            return missingSensorData(MissingSensorData.builder().applyMutation(missingSensorData).build());
        }

        /**
         * <p>
         * Parameter that gives information about data that is invalid over all the sensors in the input data.
         * </p>
         * 
         * @param invalidSensorData
         *        Parameter that gives information about data that is invalid over all the sensors in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invalidSensorData(InvalidSensorData invalidSensorData);

        /**
         * <p>
         * Parameter that gives information about data that is invalid over all the sensors in the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link InvalidSensorData.Builder} avoiding the
         * need to create one manually via {@link InvalidSensorData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InvalidSensorData.Builder#build()} is called immediately and its
         * result is passed to {@link #invalidSensorData(InvalidSensorData)}.
         * 
         * @param invalidSensorData
         *        a consumer that will call methods on {@link InvalidSensorData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invalidSensorData(InvalidSensorData)
         */
        default Builder invalidSensorData(Consumer<InvalidSensorData.Builder> invalidSensorData) {
            return invalidSensorData(InvalidSensorData.builder().applyMutation(invalidSensorData).build());
        }

        /**
         * <p>
         * Parameter that gives information about unsupported timestamps in the input data.
         * </p>
         * 
         * @param unsupportedTimestamps
         *        Parameter that gives information about unsupported timestamps in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsupportedTimestamps(UnsupportedTimestamps unsupportedTimestamps);

        /**
         * <p>
         * Parameter that gives information about unsupported timestamps in the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnsupportedTimestamps.Builder} avoiding
         * the need to create one manually via {@link UnsupportedTimestamps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnsupportedTimestamps.Builder#build()} is called immediately and
         * its result is passed to {@link #unsupportedTimestamps(UnsupportedTimestamps)}.
         * 
         * @param unsupportedTimestamps
         *        a consumer that will call methods on {@link UnsupportedTimestamps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unsupportedTimestamps(UnsupportedTimestamps)
         */
        default Builder unsupportedTimestamps(Consumer<UnsupportedTimestamps.Builder> unsupportedTimestamps) {
            return unsupportedTimestamps(UnsupportedTimestamps.builder().applyMutation(unsupportedTimestamps).build());
        }

        /**
         * <p>
         * Parameter that gives information about duplicate timestamps in the input data.
         * </p>
         * 
         * @param duplicateTimestamps
         *        Parameter that gives information about duplicate timestamps in the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duplicateTimestamps(DuplicateTimestamps duplicateTimestamps);

        /**
         * <p>
         * Parameter that gives information about duplicate timestamps in the input data.
         * </p>
         * This is a convenience method that creates an instance of the {@link DuplicateTimestamps.Builder} avoiding the
         * need to create one manually via {@link DuplicateTimestamps#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DuplicateTimestamps.Builder#build()} is called immediately and
         * its result is passed to {@link #duplicateTimestamps(DuplicateTimestamps)}.
         * 
         * @param duplicateTimestamps
         *        a consumer that will call methods on {@link DuplicateTimestamps.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #duplicateTimestamps(DuplicateTimestamps)
         */
        default Builder duplicateTimestamps(Consumer<DuplicateTimestamps.Builder> duplicateTimestamps) {
            return duplicateTimestamps(DuplicateTimestamps.builder().applyMutation(duplicateTimestamps).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InsufficientSensorData insufficientSensorData;

        private MissingSensorData missingSensorData;

        private InvalidSensorData invalidSensorData;

        private UnsupportedTimestamps unsupportedTimestamps;

        private DuplicateTimestamps duplicateTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualitySummary model) {
            insufficientSensorData(model.insufficientSensorData);
            missingSensorData(model.missingSensorData);
            invalidSensorData(model.invalidSensorData);
            unsupportedTimestamps(model.unsupportedTimestamps);
            duplicateTimestamps(model.duplicateTimestamps);
        }

        public final InsufficientSensorData.Builder getInsufficientSensorData() {
            return insufficientSensorData != null ? insufficientSensorData.toBuilder() : null;
        }

        public final void setInsufficientSensorData(InsufficientSensorData.BuilderImpl insufficientSensorData) {
            this.insufficientSensorData = insufficientSensorData != null ? insufficientSensorData.build() : null;
        }

        @Override
        public final Builder insufficientSensorData(InsufficientSensorData insufficientSensorData) {
            this.insufficientSensorData = insufficientSensorData;
            return this;
        }

        public final MissingSensorData.Builder getMissingSensorData() {
            return missingSensorData != null ? missingSensorData.toBuilder() : null;
        }

        public final void setMissingSensorData(MissingSensorData.BuilderImpl missingSensorData) {
            this.missingSensorData = missingSensorData != null ? missingSensorData.build() : null;
        }

        @Override
        public final Builder missingSensorData(MissingSensorData missingSensorData) {
            this.missingSensorData = missingSensorData;
            return this;
        }

        public final InvalidSensorData.Builder getInvalidSensorData() {
            return invalidSensorData != null ? invalidSensorData.toBuilder() : null;
        }

        public final void setInvalidSensorData(InvalidSensorData.BuilderImpl invalidSensorData) {
            this.invalidSensorData = invalidSensorData != null ? invalidSensorData.build() : null;
        }

        @Override
        public final Builder invalidSensorData(InvalidSensorData invalidSensorData) {
            this.invalidSensorData = invalidSensorData;
            return this;
        }

        public final UnsupportedTimestamps.Builder getUnsupportedTimestamps() {
            return unsupportedTimestamps != null ? unsupportedTimestamps.toBuilder() : null;
        }

        public final void setUnsupportedTimestamps(UnsupportedTimestamps.BuilderImpl unsupportedTimestamps) {
            this.unsupportedTimestamps = unsupportedTimestamps != null ? unsupportedTimestamps.build() : null;
        }

        @Override
        public final Builder unsupportedTimestamps(UnsupportedTimestamps unsupportedTimestamps) {
            this.unsupportedTimestamps = unsupportedTimestamps;
            return this;
        }

        public final DuplicateTimestamps.Builder getDuplicateTimestamps() {
            return duplicateTimestamps != null ? duplicateTimestamps.toBuilder() : null;
        }

        public final void setDuplicateTimestamps(DuplicateTimestamps.BuilderImpl duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps != null ? duplicateTimestamps.build() : null;
        }

        @Override
        public final Builder duplicateTimestamps(DuplicateTimestamps duplicateTimestamps) {
            this.duplicateTimestamps = duplicateTimestamps;
            return this;
        }

        @Override
        public DataQualitySummary build() {
            return new DataQualitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
