/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeModelResponse.Builder, DescribeModelResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeModelResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(DescribeModelResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeModelResponse::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeModelResponse::datasetArn)).setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Schema")
            .getter(getter(DescribeModelResponse::schema))
            .setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration")
            .getter(getter(DescribeModelResponse::labelsInputConfiguration)).setter(setter(Builder::labelsInputConfiguration))
            .constructor(LabelsInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build())
            .build();

    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataStartTime").getter(getter(DescribeModelResponse::trainingDataStartTime))
            .setter(setter(Builder::trainingDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build())
            .build();

    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataEndTime").getter(getter(DescribeModelResponse::trainingDataEndTime))
            .setter(setter(Builder::trainingDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataStartTime").getter(getter(DescribeModelResponse::evaluationDataStartTime))
            .setter(setter(Builder::evaluationDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataEndTime").getter(getter(DescribeModelResponse::evaluationDataEndTime))
            .setter(setter(Builder::evaluationDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeModelResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<DataPreProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DataPreProcessingConfiguration")
            .getter(getter(DescribeModelResponse::dataPreProcessingConfiguration))
            .setter(setter(Builder::dataPreProcessingConfiguration))
            .constructor(DataPreProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration")
                    .build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeModelResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> TRAINING_EXECUTION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingExecutionStartTime")
            .getter(getter(DescribeModelResponse::trainingExecutionStartTime))
            .setter(setter(Builder::trainingExecutionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionStartTime").build())
            .build();

    private static final SdkField<Instant> TRAINING_EXECUTION_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("TrainingExecutionEndTime")
            .getter(getter(DescribeModelResponse::trainingExecutionEndTime)).setter(setter(Builder::trainingExecutionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionEndTime").build())
            .build();

    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedReason").getter(getter(DescribeModelResponse::failedReason)).setter(setter(Builder::failedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()).build();

    private static final SdkField<String> MODEL_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ModelMetrics")
            .getter(getter(DescribeModelResponse::modelMetrics))
            .setter(setter(Builder::modelMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeModelResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeModelResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(DescribeModelResponse::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<String> OFF_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OffCondition").getter(getter(DescribeModelResponse::offCondition)).setter(setter(Builder::offCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffCondition").build()).build();

    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceModelVersionArn").getter(getter(DescribeModelResponse::sourceModelVersionArn))
            .setter(setter(Builder::sourceModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build())
            .build();

    private static final SdkField<Instant> IMPORT_JOB_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImportJobStartTime").getter(getter(DescribeModelResponse::importJobStartTime))
            .setter(setter(Builder::importJobStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobStartTime").build())
            .build();

    private static final SdkField<Instant> IMPORT_JOB_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImportJobEndTime").getter(getter(DescribeModelResponse::importJobEndTime))
            .setter(setter(Builder::importJobEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobEndTime").build()).build();

    private static final SdkField<Long> ACTIVE_MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ActiveModelVersion").getter(getter(DescribeModelResponse::activeModelVersion))
            .setter(setter(Builder::activeModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersion").build())
            .build();

    private static final SdkField<String> ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveModelVersionArn").getter(getter(DescribeModelResponse::activeModelVersionArn))
            .setter(setter(Builder::activeModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveModelVersionArn").build())
            .build();

    private static final SdkField<Instant> MODEL_VERSION_ACTIVATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ModelVersionActivatedAt").getter(getter(DescribeModelResponse::modelVersionActivatedAt))
            .setter(setter(Builder::modelVersionActivatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionActivatedAt").build())
            .build();

    private static final SdkField<Long> PREVIOUS_ACTIVE_MODEL_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("PreviousActiveModelVersion")
            .getter(getter(DescribeModelResponse::previousActiveModelVersion))
            .setter(setter(Builder::previousActiveModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveModelVersion").build())
            .build();

    private static final SdkField<String> PREVIOUS_ACTIVE_MODEL_VERSION_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreviousActiveModelVersionArn")
            .getter(getter(DescribeModelResponse::previousActiveModelVersionArn))
            .setter(setter(Builder::previousActiveModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveModelVersionArn")
                    .build()).build();

    private static final SdkField<Instant> PREVIOUS_MODEL_VERSION_ACTIVATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("PreviousModelVersionActivatedAt")
            .getter(getter(DescribeModelResponse::previousModelVersionActivatedAt))
            .setter(setter(Builder::previousModelVersionActivatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousModelVersionActivatedAt")
                    .build()).build();

    private static final SdkField<String> PRIOR_MODEL_METRICS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PriorModelMetrics")
            .getter(getter(DescribeModelResponse::priorModelMetrics))
            .setter(setter(Builder::priorModelMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorModelMetrics").build(),
                    JsonValueTrait.create()).build();

    private static final SdkField<String> LATEST_SCHEDULED_RETRAINING_FAILED_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestScheduledRetrainingFailedReason")
            .getter(getter(DescribeModelResponse::latestScheduledRetrainingFailedReason))
            .setter(setter(Builder::latestScheduledRetrainingFailedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestScheduledRetrainingFailedReason").build()).build();

    private static final SdkField<String> LATEST_SCHEDULED_RETRAINING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestScheduledRetrainingStatus")
            .getter(getter(DescribeModelResponse::latestScheduledRetrainingStatusAsString))
            .setter(setter(Builder::latestScheduledRetrainingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStatus")
                    .build()).build();

    private static final SdkField<Long> LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("LatestScheduledRetrainingModelVersion")
            .getter(getter(DescribeModelResponse::latestScheduledRetrainingModelVersion))
            .setter(setter(Builder::latestScheduledRetrainingModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestScheduledRetrainingModelVersion").build()).build();

    private static final SdkField<Instant> LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestScheduledRetrainingStartTime")
            .getter(getter(DescribeModelResponse::latestScheduledRetrainingStartTime))
            .setter(setter(Builder::latestScheduledRetrainingStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestScheduledRetrainingStartTime")
                    .build()).build();

    private static final SdkField<Integer> LATEST_SCHEDULED_RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("LatestScheduledRetrainingAvailableDataInDays")
            .getter(getter(DescribeModelResponse::latestScheduledRetrainingAvailableDataInDays))
            .setter(setter(Builder::latestScheduledRetrainingAvailableDataInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("LatestScheduledRetrainingAvailableDataInDays").build()).build();

    private static final SdkField<Instant> NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("NextScheduledRetrainingStartDate")
            .getter(getter(DescribeModelResponse::nextScheduledRetrainingStartDate))
            .setter(setter(Builder::nextScheduledRetrainingStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextScheduledRetrainingStartDate")
                    .build()).build();

    private static final SdkField<Instant> ACCUMULATED_INFERENCE_DATA_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AccumulatedInferenceDataStartTime")
            .getter(getter(DescribeModelResponse::accumulatedInferenceDataStartTime))
            .setter(setter(Builder::accumulatedInferenceDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccumulatedInferenceDataStartTime")
                    .build()).build();

    private static final SdkField<Instant> ACCUMULATED_INFERENCE_DATA_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("AccumulatedInferenceDataEndTime")
            .getter(getter(DescribeModelResponse::accumulatedInferenceDataEndTime))
            .setter(setter(Builder::accumulatedInferenceDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccumulatedInferenceDataEndTime")
                    .build()).build();

    private static final SdkField<String> RETRAINING_SCHEDULER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrainingSchedulerStatus").getter(getter(DescribeModelResponse::retrainingSchedulerStatusAsString))
            .setter(setter(Builder::retrainingSchedulerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingSchedulerStatus").build())
            .build();

    private static final SdkField<ModelDiagnosticsOutputConfiguration> MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ModelDiagnosticsOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ModelDiagnosticsOutputConfiguration")
            .getter(getter(DescribeModelResponse::modelDiagnosticsOutputConfiguration))
            .setter(setter(Builder::modelDiagnosticsOutputConfiguration))
            .constructor(ModelDiagnosticsOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ModelDiagnosticsOutputConfiguration").build()).build();

    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelQuality").getter(getter(DescribeModelResponse::modelQualityAsString))
            .setter(setter(Builder::modelQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, DATASET_NAME_FIELD, DATASET_ARN_FIELD, SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD,
            TRAINING_DATA_START_TIME_FIELD, TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD,
            EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD, DATA_PRE_PROCESSING_CONFIGURATION_FIELD, STATUS_FIELD,
            TRAINING_EXECUTION_START_TIME_FIELD, TRAINING_EXECUTION_END_TIME_FIELD, FAILED_REASON_FIELD, MODEL_METRICS_FIELD,
            LAST_UPDATED_TIME_FIELD, CREATED_AT_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD, OFF_CONDITION_FIELD,
            SOURCE_MODEL_VERSION_ARN_FIELD, IMPORT_JOB_START_TIME_FIELD, IMPORT_JOB_END_TIME_FIELD, ACTIVE_MODEL_VERSION_FIELD,
            ACTIVE_MODEL_VERSION_ARN_FIELD, MODEL_VERSION_ACTIVATED_AT_FIELD, PREVIOUS_ACTIVE_MODEL_VERSION_FIELD,
            PREVIOUS_ACTIVE_MODEL_VERSION_ARN_FIELD, PREVIOUS_MODEL_VERSION_ACTIVATED_AT_FIELD, PRIOR_MODEL_METRICS_FIELD,
            LATEST_SCHEDULED_RETRAINING_FAILED_REASON_FIELD, LATEST_SCHEDULED_RETRAINING_STATUS_FIELD,
            LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD, LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD,
            LATEST_SCHEDULED_RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD, NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD,
            ACCUMULATED_INFERENCE_DATA_START_TIME_FIELD, ACCUMULATED_INFERENCE_DATA_END_TIME_FIELD,
            RETRAINING_SCHEDULER_STATUS_FIELD, MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD, MODEL_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelName;

    private final String modelArn;

    private final String datasetName;

    private final String datasetArn;

    private final String schema;

    private final LabelsInputConfiguration labelsInputConfiguration;

    private final Instant trainingDataStartTime;

    private final Instant trainingDataEndTime;

    private final Instant evaluationDataStartTime;

    private final Instant evaluationDataEndTime;

    private final String roleArn;

    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;

    private final String status;

    private final Instant trainingExecutionStartTime;

    private final Instant trainingExecutionEndTime;

    private final String failedReason;

    private final String modelMetrics;

    private final Instant lastUpdatedTime;

    private final Instant createdAt;

    private final String serverSideKmsKeyId;

    private final String offCondition;

    private final String sourceModelVersionArn;

    private final Instant importJobStartTime;

    private final Instant importJobEndTime;

    private final Long activeModelVersion;

    private final String activeModelVersionArn;

    private final Instant modelVersionActivatedAt;

    private final Long previousActiveModelVersion;

    private final String previousActiveModelVersionArn;

    private final Instant previousModelVersionActivatedAt;

    private final String priorModelMetrics;

    private final String latestScheduledRetrainingFailedReason;

    private final String latestScheduledRetrainingStatus;

    private final Long latestScheduledRetrainingModelVersion;

    private final Instant latestScheduledRetrainingStartTime;

    private final Integer latestScheduledRetrainingAvailableDataInDays;

    private final Instant nextScheduledRetrainingStartDate;

    private final Instant accumulatedInferenceDataStartTime;

    private final Instant accumulatedInferenceDataEndTime;

    private final String retrainingSchedulerStatus;

    private final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

    private final String modelQuality;

    private DescribeModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.schema = builder.schema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.status = builder.status;
        this.trainingExecutionStartTime = builder.trainingExecutionStartTime;
        this.trainingExecutionEndTime = builder.trainingExecutionEndTime;
        this.failedReason = builder.failedReason;
        this.modelMetrics = builder.modelMetrics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdAt = builder.createdAt;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.offCondition = builder.offCondition;
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.importJobStartTime = builder.importJobStartTime;
        this.importJobEndTime = builder.importJobEndTime;
        this.activeModelVersion = builder.activeModelVersion;
        this.activeModelVersionArn = builder.activeModelVersionArn;
        this.modelVersionActivatedAt = builder.modelVersionActivatedAt;
        this.previousActiveModelVersion = builder.previousActiveModelVersion;
        this.previousActiveModelVersionArn = builder.previousActiveModelVersionArn;
        this.previousModelVersionActivatedAt = builder.previousModelVersionActivatedAt;
        this.priorModelMetrics = builder.priorModelMetrics;
        this.latestScheduledRetrainingFailedReason = builder.latestScheduledRetrainingFailedReason;
        this.latestScheduledRetrainingStatus = builder.latestScheduledRetrainingStatus;
        this.latestScheduledRetrainingModelVersion = builder.latestScheduledRetrainingModelVersion;
        this.latestScheduledRetrainingStartTime = builder.latestScheduledRetrainingStartTime;
        this.latestScheduledRetrainingAvailableDataInDays = builder.latestScheduledRetrainingAvailableDataInDays;
        this.nextScheduledRetrainingStartDate = builder.nextScheduledRetrainingStartDate;
        this.accumulatedInferenceDataStartTime = builder.accumulatedInferenceDataStartTime;
        this.accumulatedInferenceDataEndTime = builder.accumulatedInferenceDataEndTime;
        this.retrainingSchedulerStatus = builder.retrainingSchedulerStatus;
        this.modelDiagnosticsOutputConfiguration = builder.modelDiagnosticsOutputConfiguration;
        this.modelQuality = builder.modelQuality;
    }

    /**
     * <p>
     * The name of the machine learning model being described.
     * </p>
     * 
     * @return The name of the machine learning model being described.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model being described.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the dataset being used by the machine learning being described.
     * </p>
     * 
     * @return The name of the dataset being used by the machine learning being described.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resouce Name (ARN) of the dataset used to create the machine learning model being described.
     * </p>
     * 
     * @return The Amazon Resouce Name (ARN) of the dataset used to create the machine learning model being described.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * A JSON description of the data that is in each time series dataset, including names, column names, and data
     * types.
     * </p>
     * 
     * @return A JSON description of the data that is in each time series dataset, including names, column names, and
     *         data types.
     */
    public final String schema() {
        return schema;
    }

    /**
     * <p>
     * Specifies configuration information about the labels input, including its S3 location.
     * </p>
     * 
     * @return Specifies configuration information about the labels input, including its S3 location.
     */
    public final LabelsInputConfiguration labelsInputConfiguration() {
        return labelsInputConfiguration;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that was used to begin the subset of training data for the machine
     * learning model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that was used to begin the subset of training data for the
     *         machine learning model.
     */
    public final Instant trainingDataStartTime() {
        return trainingDataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that was used to end the subset of training data for the machine
     * learning model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that was used to end the subset of training data for the
     *         machine learning model.
     */
    public final Instant trainingDataEndTime() {
        return trainingDataEndTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that was used to begin the subset of evaluation data for the machine
     * learning model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that was used to begin the subset of evaluation data for the
     *         machine learning model.
     */
    public final Instant evaluationDataStartTime() {
        return evaluationDataStartTime;
    }

    /**
     * <p>
     * Indicates the time reference in the dataset that was used to end the subset of evaluation data for the machine
     * learning model.
     * </p>
     * 
     * @return Indicates the time reference in the dataset that was used to end the subset of evaluation data for the
     *         machine learning model.
     */
    public final Instant evaluationDataEndTime() {
        return evaluationDataEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a role with permission to access the data source for the machine learning model
     * being described.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a role with permission to access the data source for the machine
     *         learning model being described.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
     * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
     * second level and you want the system to resample the data at a 1 minute rate before training, the
     * <code>TargetSamplingRate</code> is 1 minute.
     * </p>
     * <p>
     * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate you
     * want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is <i>PT15M</i>, and
     * the value for a 1 hour rate is <i>PT1H</i>
     * </p>
     * 
     * @return The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after
     *         post processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected
     *         at a 1 second level and you want the system to resample the data at a 1 minute rate before training, the
     *         <code>TargetSamplingRate</code> is 1 minute.</p>
     *         <p>
     *         When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
     *         rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
     *         <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
     */
    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return dataPreProcessingConfiguration;
    }

    /**
     * <p>
     * Specifies the current status of the model being described. Status describes the status of the most recent action
     * of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the current status of the model being described. Status describes the status of the most recent
     *         action of the model.
     * @see ModelStatus
     */
    public final ModelStatus status() {
        return ModelStatus.fromValue(status);
    }

    /**
     * <p>
     * Specifies the current status of the model being described. Status describes the status of the most recent action
     * of the model.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Specifies the current status of the model being described. Status describes the status of the most recent
     *         action of the model.
     * @see ModelStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates the time at which the training of the machine learning model began.
     * </p>
     * 
     * @return Indicates the time at which the training of the machine learning model began.
     */
    public final Instant trainingExecutionStartTime() {
        return trainingExecutionStartTime;
    }

    /**
     * <p>
     * Indicates the time at which the training of the machine learning model was completed.
     * </p>
     * 
     * @return Indicates the time at which the training of the machine learning model was completed.
     */
    public final Instant trainingExecutionEndTime() {
        return trainingExecutionEndTime;
    }

    /**
     * <p>
     * If the training of the machine learning model failed, this indicates the reason for that failure.
     * </p>
     * 
     * @return If the training of the machine learning model failed, this indicates the reason for that failure.
     */
    public final String failedReason() {
        return failedReason;
    }

    /**
     * <p>
     * The Model Metrics show an aggregated summary of the model's performance within the evaluation time range. This is
     * the JSON content of the metrics created when evaluating the model.
     * </p>
     * 
     * @return The Model Metrics show an aggregated summary of the model's performance within the evaluation time range.
     *         This is the JSON content of the metrics created when evaluating the model.
     */
    public final String modelMetrics() {
        return modelMetrics;
    }

    /**
     * <p>
     * Indicates the last time the machine learning model was updated. The type of update is not specified.
     * </p>
     * 
     * @return Indicates the last time the machine learning model was updated. The type of update is not specified.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Indicates the time and date at which the machine learning model was created.
     * </p>
     * 
     * @return Indicates the time and date at which the machine learning model was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout
     * for Equipment will not use data from this asset for training, evaluation, or inference.
     * </p>
     * 
     * @return Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
     *         Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
     */
    public final String offCondition() {
        return offCondition;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source model version. This field appears if the active model version was
     * imported.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source model version. This field appears if the active model
     *         version was imported.
     */
    public final String sourceModelVersionArn() {
        return sourceModelVersionArn;
    }

    /**
     * <p>
     * The date and time when the import job was started. This field appears if the active model version was imported.
     * </p>
     * 
     * @return The date and time when the import job was started. This field appears if the active model version was
     *         imported.
     */
    public final Instant importJobStartTime() {
        return importJobStartTime;
    }

    /**
     * <p>
     * The date and time when the import job was completed. This field appears if the active model version was imported.
     * </p>
     * 
     * @return The date and time when the import job was completed. This field appears if the active model version was
     *         imported.
     */
    public final Instant importJobEndTime() {
        return importJobEndTime;
    }

    /**
     * <p>
     * The name of the model version used by the inference schedular when running a scheduled inference execution.
     * </p>
     * 
     * @return The name of the model version used by the inference schedular when running a scheduled inference
     *         execution.
     */
    public final Long activeModelVersion() {
        return activeModelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version used by the inference scheduler when running a scheduled
     * inference execution.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version used by the inference scheduler when running a
     *         scheduled inference execution.
     */
    public final String activeModelVersionArn() {
        return activeModelVersionArn;
    }

    /**
     * <p>
     * The date the active model version was activated.
     * </p>
     * 
     * @return The date the active model version was activated.
     */
    public final Instant modelVersionActivatedAt() {
        return modelVersionActivatedAt;
    }

    /**
     * <p>
     * The model version that was set as the active model version prior to the current active model version.
     * </p>
     * 
     * @return The model version that was set as the active model version prior to the current active model version.
     */
    public final Long previousActiveModelVersion() {
        return previousActiveModelVersion;
    }

    /**
     * <p>
     * The ARN of the model version that was set as the active model version prior to the current active model version.
     * </p>
     * 
     * @return The ARN of the model version that was set as the active model version prior to the current active model
     *         version.
     */
    public final String previousActiveModelVersionArn() {
        return previousActiveModelVersionArn;
    }

    /**
     * <p>
     * The date and time when the previous active model version was activated.
     * </p>
     * 
     * @return The date and time when the previous active model version was activated.
     */
    public final Instant previousModelVersionActivatedAt() {
        return previousModelVersionActivatedAt;
    }

    /**
     * <p>
     * If the model version was retrained, this field shows a summary of the performance of the prior model on the new
     * training range. You can use the information in this JSON-formatted object to compare the new model version and
     * the prior model version.
     * </p>
     * 
     * @return If the model version was retrained, this field shows a summary of the performance of the prior model on
     *         the new training range. You can use the information in this JSON-formatted object to compare the new
     *         model version and the prior model version.
     */
    public final String priorModelMetrics() {
        return priorModelMetrics;
    }

    /**
     * <p>
     * If the model version was generated by retraining and the training failed, this indicates the reason for that
     * failure.
     * </p>
     * 
     * @return If the model version was generated by retraining and the training failed, this indicates the reason for
     *         that failure.
     */
    public final String latestScheduledRetrainingFailedReason() {
        return latestScheduledRetrainingFailedReason;
    }

    /**
     * <p>
     * Indicates the status of the most recent scheduled retraining run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestScheduledRetrainingStatus} will return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestScheduledRetrainingStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the most recent scheduled retraining run.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus latestScheduledRetrainingStatus() {
        return ModelVersionStatus.fromValue(latestScheduledRetrainingStatus);
    }

    /**
     * <p>
     * Indicates the status of the most recent scheduled retraining run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestScheduledRetrainingStatus} will return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestScheduledRetrainingStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the most recent scheduled retraining run.
     * @see ModelVersionStatus
     */
    public final String latestScheduledRetrainingStatusAsString() {
        return latestScheduledRetrainingStatus;
    }

    /**
     * <p>
     * Indicates the most recent model version that was generated by retraining.
     * </p>
     * 
     * @return Indicates the most recent model version that was generated by retraining.
     */
    public final Long latestScheduledRetrainingModelVersion() {
        return latestScheduledRetrainingModelVersion;
    }

    /**
     * <p>
     * Indicates the start time of the most recent scheduled retraining run.
     * </p>
     * 
     * @return Indicates the start time of the most recent scheduled retraining run.
     */
    public final Instant latestScheduledRetrainingStartTime() {
        return latestScheduledRetrainingStartTime;
    }

    /**
     * <p>
     * Indicates the number of days of data used in the most recent scheduled retraining run.
     * </p>
     * 
     * @return Indicates the number of days of data used in the most recent scheduled retraining run.
     */
    public final Integer latestScheduledRetrainingAvailableDataInDays() {
        return latestScheduledRetrainingAvailableDataInDays;
    }

    /**
     * <p>
     * Indicates the date and time that the next scheduled retraining run will start on. Lookout for Equipment truncates
     * the time you provide to the nearest UTC day.
     * </p>
     * 
     * @return Indicates the date and time that the next scheduled retraining run will start on. Lookout for Equipment
     *         truncates the time you provide to the nearest UTC day.
     */
    public final Instant nextScheduledRetrainingStartDate() {
        return nextScheduledRetrainingStartDate;
    }

    /**
     * <p>
     * Indicates the start time of the inference data that has been accumulated.
     * </p>
     * 
     * @return Indicates the start time of the inference data that has been accumulated.
     */
    public final Instant accumulatedInferenceDataStartTime() {
        return accumulatedInferenceDataStartTime;
    }

    /**
     * <p>
     * Indicates the end time of the inference data that has been accumulated.
     * </p>
     * 
     * @return Indicates the end time of the inference data that has been accumulated.
     */
    public final Instant accumulatedInferenceDataEndTime() {
        return accumulatedInferenceDataEndTime;
    }

    /**
     * <p>
     * Indicates the status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retrainingSchedulerStatus} will return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #retrainingSchedulerStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final RetrainingSchedulerStatus retrainingSchedulerStatus() {
        return RetrainingSchedulerStatus.fromValue(retrainingSchedulerStatus);
    }

    /**
     * <p>
     * Indicates the status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #retrainingSchedulerStatus} will return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #retrainingSchedulerStatusAsString}.
     * </p>
     * 
     * @return Indicates the status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final String retrainingSchedulerStatusAsString() {
        return retrainingSchedulerStatus;
    }

    /**
     * <p>
     * Configuration information for the model's pointwise model diagnostics.
     * </p>
     * 
     * @return Configuration information for the model's pointwise model diagnostics.
     */
    public final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration() {
        return modelDiagnosticsOutputConfiguration;
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(modelQuality);
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final String modelQualityAsString() {
        return modelQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trainingExecutionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingExecutionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(offCondition());
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(importJobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(importJobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activeModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionActivatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(previousActiveModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(previousActiveModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(previousModelVersionActivatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(priorModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingFailedReason());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestScheduledRetrainingAvailableDataInDays());
        hashCode = 31 * hashCode + Objects.hashCode(nextScheduledRetrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(accumulatedInferenceDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(accumulatedInferenceDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingSchedulerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelDiagnosticsOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelResponse)) {
            return false;
        }
        DescribeModelResponse other = (DescribeModelResponse) obj;
        return Objects.equals(modelName(), other.modelName())
                && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(schema(), other.schema())
                && Objects.equals(labelsInputConfiguration(), other.labelsInputConfiguration())
                && Objects.equals(trainingDataStartTime(), other.trainingDataStartTime())
                && Objects.equals(trainingDataEndTime(), other.trainingDataEndTime())
                && Objects.equals(evaluationDataStartTime(), other.evaluationDataStartTime())
                && Objects.equals(evaluationDataEndTime(), other.evaluationDataEndTime())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(trainingExecutionStartTime(), other.trainingExecutionStartTime())
                && Objects.equals(trainingExecutionEndTime(), other.trainingExecutionEndTime())
                && Objects.equals(failedReason(), other.failedReason())
                && Objects.equals(modelMetrics(), other.modelMetrics())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(offCondition(), other.offCondition())
                && Objects.equals(sourceModelVersionArn(), other.sourceModelVersionArn())
                && Objects.equals(importJobStartTime(), other.importJobStartTime())
                && Objects.equals(importJobEndTime(), other.importJobEndTime())
                && Objects.equals(activeModelVersion(), other.activeModelVersion())
                && Objects.equals(activeModelVersionArn(), other.activeModelVersionArn())
                && Objects.equals(modelVersionActivatedAt(), other.modelVersionActivatedAt())
                && Objects.equals(previousActiveModelVersion(), other.previousActiveModelVersion())
                && Objects.equals(previousActiveModelVersionArn(), other.previousActiveModelVersionArn())
                && Objects.equals(previousModelVersionActivatedAt(), other.previousModelVersionActivatedAt())
                && Objects.equals(priorModelMetrics(), other.priorModelMetrics())
                && Objects.equals(latestScheduledRetrainingFailedReason(), other.latestScheduledRetrainingFailedReason())
                && Objects.equals(latestScheduledRetrainingStatusAsString(), other.latestScheduledRetrainingStatusAsString())
                && Objects.equals(latestScheduledRetrainingModelVersion(), other.latestScheduledRetrainingModelVersion())
                && Objects.equals(latestScheduledRetrainingStartTime(), other.latestScheduledRetrainingStartTime())
                && Objects.equals(latestScheduledRetrainingAvailableDataInDays(),
                        other.latestScheduledRetrainingAvailableDataInDays())
                && Objects.equals(nextScheduledRetrainingStartDate(), other.nextScheduledRetrainingStartDate())
                && Objects.equals(accumulatedInferenceDataStartTime(), other.accumulatedInferenceDataStartTime())
                && Objects.equals(accumulatedInferenceDataEndTime(), other.accumulatedInferenceDataEndTime())
                && Objects.equals(retrainingSchedulerStatusAsString(), other.retrainingSchedulerStatusAsString())
                && Objects.equals(modelDiagnosticsOutputConfiguration(), other.modelDiagnosticsOutputConfiguration())
                && Objects.equals(modelQualityAsString(), other.modelQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelResponse").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("DatasetName", datasetName()).add("DatasetArn", datasetArn()).add("Schema", schema())
                .add("LabelsInputConfiguration", labelsInputConfiguration())
                .add("TrainingDataStartTime", trainingDataStartTime()).add("TrainingDataEndTime", trainingDataEndTime())
                .add("EvaluationDataStartTime", evaluationDataStartTime()).add("EvaluationDataEndTime", evaluationDataEndTime())
                .add("RoleArn", roleArn()).add("DataPreProcessingConfiguration", dataPreProcessingConfiguration())
                .add("Status", statusAsString()).add("TrainingExecutionStartTime", trainingExecutionStartTime())
                .add("TrainingExecutionEndTime", trainingExecutionEndTime()).add("FailedReason", failedReason())
                .add("ModelMetrics", modelMetrics()).add("LastUpdatedTime", lastUpdatedTime()).add("CreatedAt", createdAt())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("OffCondition", offCondition())
                .add("SourceModelVersionArn", sourceModelVersionArn()).add("ImportJobStartTime", importJobStartTime())
                .add("ImportJobEndTime", importJobEndTime()).add("ActiveModelVersion", activeModelVersion())
                .add("ActiveModelVersionArn", activeModelVersionArn()).add("ModelVersionActivatedAt", modelVersionActivatedAt())
                .add("PreviousActiveModelVersion", previousActiveModelVersion())
                .add("PreviousActiveModelVersionArn", previousActiveModelVersionArn())
                .add("PreviousModelVersionActivatedAt", previousModelVersionActivatedAt())
                .add("PriorModelMetrics", priorModelMetrics())
                .add("LatestScheduledRetrainingFailedReason", latestScheduledRetrainingFailedReason())
                .add("LatestScheduledRetrainingStatus", latestScheduledRetrainingStatusAsString())
                .add("LatestScheduledRetrainingModelVersion", latestScheduledRetrainingModelVersion())
                .add("LatestScheduledRetrainingStartTime", latestScheduledRetrainingStartTime())
                .add("LatestScheduledRetrainingAvailableDataInDays", latestScheduledRetrainingAvailableDataInDays())
                .add("NextScheduledRetrainingStartDate", nextScheduledRetrainingStartDate())
                .add("AccumulatedInferenceDataStartTime", accumulatedInferenceDataStartTime())
                .add("AccumulatedInferenceDataEndTime", accumulatedInferenceDataEndTime())
                .add("RetrainingSchedulerStatus", retrainingSchedulerStatusAsString())
                .add("ModelDiagnosticsOutputConfiguration", modelDiagnosticsOutputConfiguration())
                .add("ModelQuality", modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "LabelsInputConfiguration":
            return Optional.ofNullable(clazz.cast(labelsInputConfiguration()));
        case "TrainingDataStartTime":
            return Optional.ofNullable(clazz.cast(trainingDataStartTime()));
        case "TrainingDataEndTime":
            return Optional.ofNullable(clazz.cast(trainingDataEndTime()));
        case "EvaluationDataStartTime":
            return Optional.ofNullable(clazz.cast(evaluationDataStartTime()));
        case "EvaluationDataEndTime":
            return Optional.ofNullable(clazz.cast(evaluationDataEndTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DataPreProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(dataPreProcessingConfiguration()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TrainingExecutionStartTime":
            return Optional.ofNullable(clazz.cast(trainingExecutionStartTime()));
        case "TrainingExecutionEndTime":
            return Optional.ofNullable(clazz.cast(trainingExecutionEndTime()));
        case "FailedReason":
            return Optional.ofNullable(clazz.cast(failedReason()));
        case "ModelMetrics":
            return Optional.ofNullable(clazz.cast(modelMetrics()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "OffCondition":
            return Optional.ofNullable(clazz.cast(offCondition()));
        case "SourceModelVersionArn":
            return Optional.ofNullable(clazz.cast(sourceModelVersionArn()));
        case "ImportJobStartTime":
            return Optional.ofNullable(clazz.cast(importJobStartTime()));
        case "ImportJobEndTime":
            return Optional.ofNullable(clazz.cast(importJobEndTime()));
        case "ActiveModelVersion":
            return Optional.ofNullable(clazz.cast(activeModelVersion()));
        case "ActiveModelVersionArn":
            return Optional.ofNullable(clazz.cast(activeModelVersionArn()));
        case "ModelVersionActivatedAt":
            return Optional.ofNullable(clazz.cast(modelVersionActivatedAt()));
        case "PreviousActiveModelVersion":
            return Optional.ofNullable(clazz.cast(previousActiveModelVersion()));
        case "PreviousActiveModelVersionArn":
            return Optional.ofNullable(clazz.cast(previousActiveModelVersionArn()));
        case "PreviousModelVersionActivatedAt":
            return Optional.ofNullable(clazz.cast(previousModelVersionActivatedAt()));
        case "PriorModelMetrics":
            return Optional.ofNullable(clazz.cast(priorModelMetrics()));
        case "LatestScheduledRetrainingFailedReason":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingFailedReason()));
        case "LatestScheduledRetrainingStatus":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingStatusAsString()));
        case "LatestScheduledRetrainingModelVersion":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingModelVersion()));
        case "LatestScheduledRetrainingStartTime":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingStartTime()));
        case "LatestScheduledRetrainingAvailableDataInDays":
            return Optional.ofNullable(clazz.cast(latestScheduledRetrainingAvailableDataInDays()));
        case "NextScheduledRetrainingStartDate":
            return Optional.ofNullable(clazz.cast(nextScheduledRetrainingStartDate()));
        case "AccumulatedInferenceDataStartTime":
            return Optional.ofNullable(clazz.cast(accumulatedInferenceDataStartTime()));
        case "AccumulatedInferenceDataEndTime":
            return Optional.ofNullable(clazz.cast(accumulatedInferenceDataEndTime()));
        case "RetrainingSchedulerStatus":
            return Optional.ofNullable(clazz.cast(retrainingSchedulerStatusAsString()));
        case "ModelDiagnosticsOutputConfiguration":
            return Optional.ofNullable(clazz.cast(modelDiagnosticsOutputConfiguration()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("LabelsInputConfiguration", LABELS_INPUT_CONFIGURATION_FIELD);
        map.put("TrainingDataStartTime", TRAINING_DATA_START_TIME_FIELD);
        map.put("TrainingDataEndTime", TRAINING_DATA_END_TIME_FIELD);
        map.put("EvaluationDataStartTime", EVALUATION_DATA_START_TIME_FIELD);
        map.put("EvaluationDataEndTime", EVALUATION_DATA_END_TIME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DataPreProcessingConfiguration", DATA_PRE_PROCESSING_CONFIGURATION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("TrainingExecutionStartTime", TRAINING_EXECUTION_START_TIME_FIELD);
        map.put("TrainingExecutionEndTime", TRAINING_EXECUTION_END_TIME_FIELD);
        map.put("FailedReason", FAILED_REASON_FIELD);
        map.put("ModelMetrics", MODEL_METRICS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
        map.put("OffCondition", OFF_CONDITION_FIELD);
        map.put("SourceModelVersionArn", SOURCE_MODEL_VERSION_ARN_FIELD);
        map.put("ImportJobStartTime", IMPORT_JOB_START_TIME_FIELD);
        map.put("ImportJobEndTime", IMPORT_JOB_END_TIME_FIELD);
        map.put("ActiveModelVersion", ACTIVE_MODEL_VERSION_FIELD);
        map.put("ActiveModelVersionArn", ACTIVE_MODEL_VERSION_ARN_FIELD);
        map.put("ModelVersionActivatedAt", MODEL_VERSION_ACTIVATED_AT_FIELD);
        map.put("PreviousActiveModelVersion", PREVIOUS_ACTIVE_MODEL_VERSION_FIELD);
        map.put("PreviousActiveModelVersionArn", PREVIOUS_ACTIVE_MODEL_VERSION_ARN_FIELD);
        map.put("PreviousModelVersionActivatedAt", PREVIOUS_MODEL_VERSION_ACTIVATED_AT_FIELD);
        map.put("PriorModelMetrics", PRIOR_MODEL_METRICS_FIELD);
        map.put("LatestScheduledRetrainingFailedReason", LATEST_SCHEDULED_RETRAINING_FAILED_REASON_FIELD);
        map.put("LatestScheduledRetrainingStatus", LATEST_SCHEDULED_RETRAINING_STATUS_FIELD);
        map.put("LatestScheduledRetrainingModelVersion", LATEST_SCHEDULED_RETRAINING_MODEL_VERSION_FIELD);
        map.put("LatestScheduledRetrainingStartTime", LATEST_SCHEDULED_RETRAINING_START_TIME_FIELD);
        map.put("LatestScheduledRetrainingAvailableDataInDays", LATEST_SCHEDULED_RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD);
        map.put("NextScheduledRetrainingStartDate", NEXT_SCHEDULED_RETRAINING_START_DATE_FIELD);
        map.put("AccumulatedInferenceDataStartTime", ACCUMULATED_INFERENCE_DATA_START_TIME_FIELD);
        map.put("AccumulatedInferenceDataEndTime", ACCUMULATED_INFERENCE_DATA_END_TIME_FIELD);
        map.put("RetrainingSchedulerStatus", RETRAINING_SCHEDULER_STATUS_FIELD);
        map.put("ModelDiagnosticsOutputConfiguration", MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelResponse, T> g) {
        return obj -> g.apply((DescribeModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeModelResponse> {
        /**
         * <p>
         * The name of the machine learning model being described.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model being described.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the machine learning model being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the dataset being used by the machine learning being described.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset being used by the machine learning being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resouce Name (ARN) of the dataset used to create the machine learning model being described.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resouce Name (ARN) of the dataset used to create the machine learning model being
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * A JSON description of the data that is in each time series dataset, including names, column names, and data
         * types.
         * </p>
         * 
         * @param schema
         *        A JSON description of the data that is in each time series dataset, including names, column names, and
         *        data types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * <p>
         * Specifies configuration information about the labels input, including its S3 location.
         * </p>
         * 
         * @param labelsInputConfiguration
         *        Specifies configuration information about the labels input, including its S3 location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration);

        /**
         * <p>
         * Specifies configuration information about the labels input, including its S3 location.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelsInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link LabelsInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelsInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #labelsInputConfiguration(LabelsInputConfiguration)}.
         * 
         * @param labelsInputConfiguration
         *        a consumer that will call methods on {@link LabelsInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelsInputConfiguration(LabelsInputConfiguration)
         */
        default Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return labelsInputConfiguration(LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration).build());
        }

        /**
         * <p>
         * Indicates the time reference in the dataset that was used to begin the subset of training data for the
         * machine learning model.
         * </p>
         * 
         * @param trainingDataStartTime
         *        Indicates the time reference in the dataset that was used to begin the subset of training data for the
         *        machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataStartTime(Instant trainingDataStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that was used to end the subset of training data for the machine
         * learning model.
         * </p>
         * 
         * @param trainingDataEndTime
         *        Indicates the time reference in the dataset that was used to end the subset of training data for the
         *        machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataEndTime(Instant trainingDataEndTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that was used to begin the subset of evaluation data for the
         * machine learning model.
         * </p>
         * 
         * @param evaluationDataStartTime
         *        Indicates the time reference in the dataset that was used to begin the subset of evaluation data for
         *        the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataStartTime(Instant evaluationDataStartTime);

        /**
         * <p>
         * Indicates the time reference in the dataset that was used to end the subset of evaluation data for the
         * machine learning model.
         * </p>
         * 
         * @param evaluationDataEndTime
         *        Indicates the time reference in the dataset that was used to end the subset of evaluation data for the
         *        machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataEndTime(Instant evaluationDataEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a role with permission to access the data source for the machine learning
         * model being described.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of a role with permission to access the data source for the machine
         *        learning model being described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
         * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
         * second level and you want the system to resample the data at a 1 minute rate before training, the
         * <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * 
         * @param dataPreProcessingConfiguration
         *        The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after
         *        post processing by Amazon Lookout for Equipment. For example, if you provide data that has been
         *        collected at a 1 second level and you want the system to resample the data at a 1 minute rate before
         *        training, the <code>TargetSamplingRate</code> is 1 minute.</p>
         *        <p>
         *        When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the
         *        rate you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate
         *        is <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration);

        /**
         * <p>
         * The configuration is the <code>TargetSamplingRate</code>, which is the sampling rate of the data after post
         * processing by Amazon Lookout for Equipment. For example, if you provide data that has been collected at a 1
         * second level and you want the system to resample the data at a 1 minute rate before training, the
         * <code>TargetSamplingRate</code> is 1 minute.
         * </p>
         * <p>
         * When providing a value for the <code>TargetSamplingRate</code>, you must attach the prefix "PT" to the rate
         * you want. The value for a 1 second rate is therefore <i>PT1S</i>, the value for a 15 minute rate is
         * <i>PT15M</i>, and the value for a 1 hour rate is <i>PT1H</i>
         * </p>
         * This is a convenience method that creates an instance of the {@link DataPreProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataPreProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPreProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataPreProcessingConfiguration(DataPreProcessingConfiguration)}.
         * 
         * @param dataPreProcessingConfiguration
         *        a consumer that will call methods on {@link DataPreProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPreProcessingConfiguration(DataPreProcessingConfiguration)
         */
        default Builder dataPreProcessingConfiguration(
                Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return dataPreProcessingConfiguration(DataPreProcessingConfiguration.builder()
                    .applyMutation(dataPreProcessingConfiguration).build());
        }

        /**
         * <p>
         * Specifies the current status of the model being described. Status describes the status of the most recent
         * action of the model.
         * </p>
         * 
         * @param status
         *        Specifies the current status of the model being described. Status describes the status of the most
         *        recent action of the model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Specifies the current status of the model being described. Status describes the status of the most recent
         * action of the model.
         * </p>
         * 
         * @param status
         *        Specifies the current status of the model being described. Status describes the status of the most
         *        recent action of the model.
         * @see ModelStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelStatus
         */
        Builder status(ModelStatus status);

        /**
         * <p>
         * Indicates the time at which the training of the machine learning model began.
         * </p>
         * 
         * @param trainingExecutionStartTime
         *        Indicates the time at which the training of the machine learning model began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingExecutionStartTime(Instant trainingExecutionStartTime);

        /**
         * <p>
         * Indicates the time at which the training of the machine learning model was completed.
         * </p>
         * 
         * @param trainingExecutionEndTime
         *        Indicates the time at which the training of the machine learning model was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingExecutionEndTime(Instant trainingExecutionEndTime);

        /**
         * <p>
         * If the training of the machine learning model failed, this indicates the reason for that failure.
         * </p>
         * 
         * @param failedReason
         *        If the training of the machine learning model failed, this indicates the reason for that failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedReason(String failedReason);

        /**
         * <p>
         * The Model Metrics show an aggregated summary of the model's performance within the evaluation time range.
         * This is the JSON content of the metrics created when evaluating the model.
         * </p>
         * 
         * @param modelMetrics
         *        The Model Metrics show an aggregated summary of the model's performance within the evaluation time
         *        range. This is the JSON content of the metrics created when evaluating the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetrics(String modelMetrics);

        /**
         * <p>
         * Indicates the last time the machine learning model was updated. The type of update is not specified.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Indicates the last time the machine learning model was updated. The type of update is not specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Indicates the time and date at which the machine learning model was created.
         * </p>
         * 
         * @param createdAt
         *        Indicates the time and date at which the machine learning model was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        Provides the identifier of the KMS key used to encrypt model data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
         * Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * </p>
         * 
         * @param offCondition
         *        Indicates that the asset associated with this sensor has been shut off. As long as this condition is
         *        met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offCondition(String offCondition);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source model version. This field appears if the active model version
         * was imported.
         * </p>
         * 
         * @param sourceModelVersionArn
         *        The Amazon Resource Name (ARN) of the source model version. This field appears if the active model
         *        version was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelVersionArn(String sourceModelVersionArn);

        /**
         * <p>
         * The date and time when the import job was started. This field appears if the active model version was
         * imported.
         * </p>
         * 
         * @param importJobStartTime
         *        The date and time when the import job was started. This field appears if the active model version was
         *        imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobStartTime(Instant importJobStartTime);

        /**
         * <p>
         * The date and time when the import job was completed. This field appears if the active model version was
         * imported.
         * </p>
         * 
         * @param importJobEndTime
         *        The date and time when the import job was completed. This field appears if the active model version
         *        was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobEndTime(Instant importJobEndTime);

        /**
         * <p>
         * The name of the model version used by the inference schedular when running a scheduled inference execution.
         * </p>
         * 
         * @param activeModelVersion
         *        The name of the model version used by the inference schedular when running a scheduled inference
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelVersion(Long activeModelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version used by the inference scheduler when running a scheduled
         * inference execution.
         * </p>
         * 
         * @param activeModelVersionArn
         *        The Amazon Resource Name (ARN) of the model version used by the inference scheduler when running a
         *        scheduled inference execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeModelVersionArn(String activeModelVersionArn);

        /**
         * <p>
         * The date the active model version was activated.
         * </p>
         * 
         * @param modelVersionActivatedAt
         *        The date the active model version was activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionActivatedAt(Instant modelVersionActivatedAt);

        /**
         * <p>
         * The model version that was set as the active model version prior to the current active model version.
         * </p>
         * 
         * @param previousActiveModelVersion
         *        The model version that was set as the active model version prior to the current active model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousActiveModelVersion(Long previousActiveModelVersion);

        /**
         * <p>
         * The ARN of the model version that was set as the active model version prior to the current active model
         * version.
         * </p>
         * 
         * @param previousActiveModelVersionArn
         *        The ARN of the model version that was set as the active model version prior to the current active
         *        model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousActiveModelVersionArn(String previousActiveModelVersionArn);

        /**
         * <p>
         * The date and time when the previous active model version was activated.
         * </p>
         * 
         * @param previousModelVersionActivatedAt
         *        The date and time when the previous active model version was activated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousModelVersionActivatedAt(Instant previousModelVersionActivatedAt);

        /**
         * <p>
         * If the model version was retrained, this field shows a summary of the performance of the prior model on the
         * new training range. You can use the information in this JSON-formatted object to compare the new model
         * version and the prior model version.
         * </p>
         * 
         * @param priorModelMetrics
         *        If the model version was retrained, this field shows a summary of the performance of the prior model
         *        on the new training range. You can use the information in this JSON-formatted object to compare the
         *        new model version and the prior model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorModelMetrics(String priorModelMetrics);

        /**
         * <p>
         * If the model version was generated by retraining and the training failed, this indicates the reason for that
         * failure.
         * </p>
         * 
         * @param latestScheduledRetrainingFailedReason
         *        If the model version was generated by retraining and the training failed, this indicates the reason
         *        for that failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingFailedReason(String latestScheduledRetrainingFailedReason);

        /**
         * <p>
         * Indicates the status of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStatus
         *        Indicates the status of the most recent scheduled retraining run.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder latestScheduledRetrainingStatus(String latestScheduledRetrainingStatus);

        /**
         * <p>
         * Indicates the status of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStatus
         *        Indicates the status of the most recent scheduled retraining run.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder latestScheduledRetrainingStatus(ModelVersionStatus latestScheduledRetrainingStatus);

        /**
         * <p>
         * Indicates the most recent model version that was generated by retraining.
         * </p>
         * 
         * @param latestScheduledRetrainingModelVersion
         *        Indicates the most recent model version that was generated by retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion);

        /**
         * <p>
         * Indicates the start time of the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingStartTime
         *        Indicates the start time of the most recent scheduled retraining run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime);

        /**
         * <p>
         * Indicates the number of days of data used in the most recent scheduled retraining run.
         * </p>
         * 
         * @param latestScheduledRetrainingAvailableDataInDays
         *        Indicates the number of days of data used in the most recent scheduled retraining run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestScheduledRetrainingAvailableDataInDays(Integer latestScheduledRetrainingAvailableDataInDays);

        /**
         * <p>
         * Indicates the date and time that the next scheduled retraining run will start on. Lookout for Equipment
         * truncates the time you provide to the nearest UTC day.
         * </p>
         * 
         * @param nextScheduledRetrainingStartDate
         *        Indicates the date and time that the next scheduled retraining run will start on. Lookout for
         *        Equipment truncates the time you provide to the nearest UTC day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate);

        /**
         * <p>
         * Indicates the start time of the inference data that has been accumulated.
         * </p>
         * 
         * @param accumulatedInferenceDataStartTime
         *        Indicates the start time of the inference data that has been accumulated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accumulatedInferenceDataStartTime(Instant accumulatedInferenceDataStartTime);

        /**
         * <p>
         * Indicates the end time of the inference data that has been accumulated.
         * </p>
         * 
         * @param accumulatedInferenceDataEndTime
         *        Indicates the end time of the inference data that has been accumulated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accumulatedInferenceDataEndTime(Instant accumulatedInferenceDataEndTime);

        /**
         * <p>
         * Indicates the status of the retraining scheduler.
         * </p>
         * 
         * @param retrainingSchedulerStatus
         *        Indicates the status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder retrainingSchedulerStatus(String retrainingSchedulerStatus);

        /**
         * <p>
         * Indicates the status of the retraining scheduler.
         * </p>
         * 
         * @param retrainingSchedulerStatus
         *        Indicates the status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder retrainingSchedulerStatus(RetrainingSchedulerStatus retrainingSchedulerStatus);

        /**
         * <p>
         * Configuration information for the model's pointwise model diagnostics.
         * </p>
         * 
         * @param modelDiagnosticsOutputConfiguration
         *        Configuration information for the model's pointwise model diagnostics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration);

        /**
         * <p>
         * Configuration information for the model's pointwise model diagnostics.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelDiagnosticsOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link ModelDiagnosticsOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDiagnosticsOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)}.
         * 
         * @param modelDiagnosticsOutputConfiguration
         *        a consumer that will call methods on {@link ModelDiagnosticsOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)
         */
        default Builder modelDiagnosticsOutputConfiguration(
                Consumer<ModelDiagnosticsOutputConfiguration.Builder> modelDiagnosticsOutputConfiguration) {
            return modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration.builder()
                    .applyMutation(modelDiagnosticsOutputConfiguration).build());
        }

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(String modelQuality);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(ModelQuality modelQuality);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String datasetName;

        private String datasetArn;

        private String schema;

        private LabelsInputConfiguration labelsInputConfiguration;

        private Instant trainingDataStartTime;

        private Instant trainingDataEndTime;

        private Instant evaluationDataStartTime;

        private Instant evaluationDataEndTime;

        private String roleArn;

        private DataPreProcessingConfiguration dataPreProcessingConfiguration;

        private String status;

        private Instant trainingExecutionStartTime;

        private Instant trainingExecutionEndTime;

        private String failedReason;

        private String modelMetrics;

        private Instant lastUpdatedTime;

        private Instant createdAt;

        private String serverSideKmsKeyId;

        private String offCondition;

        private String sourceModelVersionArn;

        private Instant importJobStartTime;

        private Instant importJobEndTime;

        private Long activeModelVersion;

        private String activeModelVersionArn;

        private Instant modelVersionActivatedAt;

        private Long previousActiveModelVersion;

        private String previousActiveModelVersionArn;

        private Instant previousModelVersionActivatedAt;

        private String priorModelMetrics;

        private String latestScheduledRetrainingFailedReason;

        private String latestScheduledRetrainingStatus;

        private Long latestScheduledRetrainingModelVersion;

        private Instant latestScheduledRetrainingStartTime;

        private Integer latestScheduledRetrainingAvailableDataInDays;

        private Instant nextScheduledRetrainingStartDate;

        private Instant accumulatedInferenceDataStartTime;

        private Instant accumulatedInferenceDataEndTime;

        private String retrainingSchedulerStatus;

        private ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelResponse model) {
            super(model);
            modelName(model.modelName);
            modelArn(model.modelArn);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            schema(model.schema);
            labelsInputConfiguration(model.labelsInputConfiguration);
            trainingDataStartTime(model.trainingDataStartTime);
            trainingDataEndTime(model.trainingDataEndTime);
            evaluationDataStartTime(model.evaluationDataStartTime);
            evaluationDataEndTime(model.evaluationDataEndTime);
            roleArn(model.roleArn);
            dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            status(model.status);
            trainingExecutionStartTime(model.trainingExecutionStartTime);
            trainingExecutionEndTime(model.trainingExecutionEndTime);
            failedReason(model.failedReason);
            modelMetrics(model.modelMetrics);
            lastUpdatedTime(model.lastUpdatedTime);
            createdAt(model.createdAt);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            offCondition(model.offCondition);
            sourceModelVersionArn(model.sourceModelVersionArn);
            importJobStartTime(model.importJobStartTime);
            importJobEndTime(model.importJobEndTime);
            activeModelVersion(model.activeModelVersion);
            activeModelVersionArn(model.activeModelVersionArn);
            modelVersionActivatedAt(model.modelVersionActivatedAt);
            previousActiveModelVersion(model.previousActiveModelVersion);
            previousActiveModelVersionArn(model.previousActiveModelVersionArn);
            previousModelVersionActivatedAt(model.previousModelVersionActivatedAt);
            priorModelMetrics(model.priorModelMetrics);
            latestScheduledRetrainingFailedReason(model.latestScheduledRetrainingFailedReason);
            latestScheduledRetrainingStatus(model.latestScheduledRetrainingStatus);
            latestScheduledRetrainingModelVersion(model.latestScheduledRetrainingModelVersion);
            latestScheduledRetrainingStartTime(model.latestScheduledRetrainingStartTime);
            latestScheduledRetrainingAvailableDataInDays(model.latestScheduledRetrainingAvailableDataInDays);
            nextScheduledRetrainingStartDate(model.nextScheduledRetrainingStartDate);
            accumulatedInferenceDataStartTime(model.accumulatedInferenceDataStartTime);
            accumulatedInferenceDataEndTime(model.accumulatedInferenceDataEndTime);
            retrainingSchedulerStatus(model.retrainingSchedulerStatus);
            modelDiagnosticsOutputConfiguration(model.modelDiagnosticsOutputConfiguration);
            modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return labelsInputConfiguration != null ? labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(
                DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getTrainingExecutionStartTime() {
            return trainingExecutionStartTime;
        }

        public final void setTrainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
        }

        @Override
        public final Builder trainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
            return this;
        }

        public final Instant getTrainingExecutionEndTime() {
            return trainingExecutionEndTime;
        }

        public final void setTrainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
        }

        @Override
        public final Builder trainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
            return this;
        }

        public final String getFailedReason() {
            return failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final String getModelMetrics() {
            return modelMetrics;
        }

        public final void setModelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
        }

        @Override
        public final Builder modelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getOffCondition() {
            return offCondition;
        }

        public final void setOffCondition(String offCondition) {
            this.offCondition = offCondition;
        }

        @Override
        public final Builder offCondition(String offCondition) {
            this.offCondition = offCondition;
            return this;
        }

        public final String getSourceModelVersionArn() {
            return sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final Instant getImportJobStartTime() {
            return importJobStartTime;
        }

        public final void setImportJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
        }

        @Override
        public final Builder importJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
            return this;
        }

        public final Instant getImportJobEndTime() {
            return importJobEndTime;
        }

        public final void setImportJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
        }

        @Override
        public final Builder importJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
            return this;
        }

        public final Long getActiveModelVersion() {
            return activeModelVersion;
        }

        public final void setActiveModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
        }

        @Override
        public final Builder activeModelVersion(Long activeModelVersion) {
            this.activeModelVersion = activeModelVersion;
            return this;
        }

        public final String getActiveModelVersionArn() {
            return activeModelVersionArn;
        }

        public final void setActiveModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
        }

        @Override
        public final Builder activeModelVersionArn(String activeModelVersionArn) {
            this.activeModelVersionArn = activeModelVersionArn;
            return this;
        }

        public final Instant getModelVersionActivatedAt() {
            return modelVersionActivatedAt;
        }

        public final void setModelVersionActivatedAt(Instant modelVersionActivatedAt) {
            this.modelVersionActivatedAt = modelVersionActivatedAt;
        }

        @Override
        public final Builder modelVersionActivatedAt(Instant modelVersionActivatedAt) {
            this.modelVersionActivatedAt = modelVersionActivatedAt;
            return this;
        }

        public final Long getPreviousActiveModelVersion() {
            return previousActiveModelVersion;
        }

        public final void setPreviousActiveModelVersion(Long previousActiveModelVersion) {
            this.previousActiveModelVersion = previousActiveModelVersion;
        }

        @Override
        public final Builder previousActiveModelVersion(Long previousActiveModelVersion) {
            this.previousActiveModelVersion = previousActiveModelVersion;
            return this;
        }

        public final String getPreviousActiveModelVersionArn() {
            return previousActiveModelVersionArn;
        }

        public final void setPreviousActiveModelVersionArn(String previousActiveModelVersionArn) {
            this.previousActiveModelVersionArn = previousActiveModelVersionArn;
        }

        @Override
        public final Builder previousActiveModelVersionArn(String previousActiveModelVersionArn) {
            this.previousActiveModelVersionArn = previousActiveModelVersionArn;
            return this;
        }

        public final Instant getPreviousModelVersionActivatedAt() {
            return previousModelVersionActivatedAt;
        }

        public final void setPreviousModelVersionActivatedAt(Instant previousModelVersionActivatedAt) {
            this.previousModelVersionActivatedAt = previousModelVersionActivatedAt;
        }

        @Override
        public final Builder previousModelVersionActivatedAt(Instant previousModelVersionActivatedAt) {
            this.previousModelVersionActivatedAt = previousModelVersionActivatedAt;
            return this;
        }

        public final String getPriorModelMetrics() {
            return priorModelMetrics;
        }

        public final void setPriorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
        }

        @Override
        public final Builder priorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
            return this;
        }

        public final String getLatestScheduledRetrainingFailedReason() {
            return latestScheduledRetrainingFailedReason;
        }

        public final void setLatestScheduledRetrainingFailedReason(String latestScheduledRetrainingFailedReason) {
            this.latestScheduledRetrainingFailedReason = latestScheduledRetrainingFailedReason;
        }

        @Override
        public final Builder latestScheduledRetrainingFailedReason(String latestScheduledRetrainingFailedReason) {
            this.latestScheduledRetrainingFailedReason = latestScheduledRetrainingFailedReason;
            return this;
        }

        public final String getLatestScheduledRetrainingStatus() {
            return latestScheduledRetrainingStatus;
        }

        public final void setLatestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(String latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus = latestScheduledRetrainingStatus;
            return this;
        }

        @Override
        public final Builder latestScheduledRetrainingStatus(ModelVersionStatus latestScheduledRetrainingStatus) {
            this.latestScheduledRetrainingStatus(latestScheduledRetrainingStatus == null ? null : latestScheduledRetrainingStatus
                    .toString());
            return this;
        }

        public final Long getLatestScheduledRetrainingModelVersion() {
            return latestScheduledRetrainingModelVersion;
        }

        public final void setLatestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
        }

        @Override
        public final Builder latestScheduledRetrainingModelVersion(Long latestScheduledRetrainingModelVersion) {
            this.latestScheduledRetrainingModelVersion = latestScheduledRetrainingModelVersion;
            return this;
        }

        public final Instant getLatestScheduledRetrainingStartTime() {
            return latestScheduledRetrainingStartTime;
        }

        public final void setLatestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
        }

        @Override
        public final Builder latestScheduledRetrainingStartTime(Instant latestScheduledRetrainingStartTime) {
            this.latestScheduledRetrainingStartTime = latestScheduledRetrainingStartTime;
            return this;
        }

        public final Integer getLatestScheduledRetrainingAvailableDataInDays() {
            return latestScheduledRetrainingAvailableDataInDays;
        }

        public final void setLatestScheduledRetrainingAvailableDataInDays(Integer latestScheduledRetrainingAvailableDataInDays) {
            this.latestScheduledRetrainingAvailableDataInDays = latestScheduledRetrainingAvailableDataInDays;
        }

        @Override
        public final Builder latestScheduledRetrainingAvailableDataInDays(Integer latestScheduledRetrainingAvailableDataInDays) {
            this.latestScheduledRetrainingAvailableDataInDays = latestScheduledRetrainingAvailableDataInDays;
            return this;
        }

        public final Instant getNextScheduledRetrainingStartDate() {
            return nextScheduledRetrainingStartDate;
        }

        public final void setNextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
        }

        @Override
        public final Builder nextScheduledRetrainingStartDate(Instant nextScheduledRetrainingStartDate) {
            this.nextScheduledRetrainingStartDate = nextScheduledRetrainingStartDate;
            return this;
        }

        public final Instant getAccumulatedInferenceDataStartTime() {
            return accumulatedInferenceDataStartTime;
        }

        public final void setAccumulatedInferenceDataStartTime(Instant accumulatedInferenceDataStartTime) {
            this.accumulatedInferenceDataStartTime = accumulatedInferenceDataStartTime;
        }

        @Override
        public final Builder accumulatedInferenceDataStartTime(Instant accumulatedInferenceDataStartTime) {
            this.accumulatedInferenceDataStartTime = accumulatedInferenceDataStartTime;
            return this;
        }

        public final Instant getAccumulatedInferenceDataEndTime() {
            return accumulatedInferenceDataEndTime;
        }

        public final void setAccumulatedInferenceDataEndTime(Instant accumulatedInferenceDataEndTime) {
            this.accumulatedInferenceDataEndTime = accumulatedInferenceDataEndTime;
        }

        @Override
        public final Builder accumulatedInferenceDataEndTime(Instant accumulatedInferenceDataEndTime) {
            this.accumulatedInferenceDataEndTime = accumulatedInferenceDataEndTime;
            return this;
        }

        public final String getRetrainingSchedulerStatus() {
            return retrainingSchedulerStatus;
        }

        public final void setRetrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
        }

        @Override
        public final Builder retrainingSchedulerStatus(String retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus = retrainingSchedulerStatus;
            return this;
        }

        @Override
        public final Builder retrainingSchedulerStatus(RetrainingSchedulerStatus retrainingSchedulerStatus) {
            this.retrainingSchedulerStatus(retrainingSchedulerStatus == null ? null : retrainingSchedulerStatus.toString());
            return this;
        }

        public final ModelDiagnosticsOutputConfiguration.Builder getModelDiagnosticsOutputConfiguration() {
            return modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration.toBuilder() : null;
        }

        public final void setModelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration.BuilderImpl modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration
                    .build() : null;
        }

        @Override
        public final Builder modelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration;
            return this;
        }

        public final String getModelQuality() {
            return modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public DescribeModelResponse build() {
            return new DescribeModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
