/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelVersionResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeModelVersionResponse.Builder, DescribeModelVersionResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(DescribeModelVersionResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(DescribeModelVersionResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Long> MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ModelVersion").getter(getter(DescribeModelVersionResponse::modelVersion))
            .setter(setter(Builder::modelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersion").build()).build();

    private static final SdkField<String> MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelVersionArn").getter(getter(DescribeModelVersionResponse::modelVersionArn))
            .setter(setter(Builder::modelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelVersionArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeModelVersionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(DescribeModelVersionResponse::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetName").getter(getter(DescribeModelVersionResponse::datasetName))
            .setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetName").build()).build();

    private static final SdkField<String> DATASET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatasetArn").getter(getter(DescribeModelVersionResponse::datasetArn))
            .setter(setter(Builder::datasetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatasetArn").build()).build();

    private static final SdkField<String> SCHEMA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Schema")
            .getter(getter(DescribeModelVersionResponse::schema)).setter(setter(Builder::schema))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schema").build()).build();

    private static final SdkField<LabelsInputConfiguration> LABELS_INPUT_CONFIGURATION_FIELD = SdkField
            .<LabelsInputConfiguration> builder(MarshallingType.SDK_POJO).memberName("LabelsInputConfiguration")
            .getter(getter(DescribeModelVersionResponse::labelsInputConfiguration))
            .setter(setter(Builder::labelsInputConfiguration)).constructor(LabelsInputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelsInputConfiguration").build())
            .build();

    private static final SdkField<Instant> TRAINING_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataStartTime").getter(getter(DescribeModelVersionResponse::trainingDataStartTime))
            .setter(setter(Builder::trainingDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataStartTime").build())
            .build();

    private static final SdkField<Instant> TRAINING_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingDataEndTime").getter(getter(DescribeModelVersionResponse::trainingDataEndTime))
            .setter(setter(Builder::trainingDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingDataEndTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataStartTime").getter(getter(DescribeModelVersionResponse::evaluationDataStartTime))
            .setter(setter(Builder::evaluationDataStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataStartTime").build())
            .build();

    private static final SdkField<Instant> EVALUATION_DATA_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EvaluationDataEndTime").getter(getter(DescribeModelVersionResponse::evaluationDataEndTime))
            .setter(setter(Builder::evaluationDataEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationDataEndTime").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(DescribeModelVersionResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<DataPreProcessingConfiguration> DATA_PRE_PROCESSING_CONFIGURATION_FIELD = SdkField
            .<DataPreProcessingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("DataPreProcessingConfiguration")
            .getter(getter(DescribeModelVersionResponse::dataPreProcessingConfiguration))
            .setter(setter(Builder::dataPreProcessingConfiguration))
            .constructor(DataPreProcessingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPreProcessingConfiguration")
                    .build()).build();

    private static final SdkField<Instant> TRAINING_EXECUTION_START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("TrainingExecutionStartTime")
            .getter(getter(DescribeModelVersionResponse::trainingExecutionStartTime))
            .setter(setter(Builder::trainingExecutionStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionStartTime").build())
            .build();

    private static final SdkField<Instant> TRAINING_EXECUTION_END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("TrainingExecutionEndTime")
            .getter(getter(DescribeModelVersionResponse::trainingExecutionEndTime))
            .setter(setter(Builder::trainingExecutionEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingExecutionEndTime").build())
            .build();

    private static final SdkField<String> FAILED_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedReason").getter(getter(DescribeModelVersionResponse::failedReason))
            .setter(setter(Builder::failedReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedReason").build()).build();

    private static final SdkField<String> MODEL_METRICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelMetrics").getter(getter(DescribeModelVersionResponse::modelMetrics))
            .setter(setter(Builder::modelMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetrics").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(DescribeModelVersionResponse::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(DescribeModelVersionResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> SERVER_SIDE_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerSideKmsKeyId").getter(getter(DescribeModelVersionResponse::serverSideKmsKeyId))
            .setter(setter(Builder::serverSideKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerSideKmsKeyId").build())
            .build();

    private static final SdkField<String> OFF_CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OffCondition").getter(getter(DescribeModelVersionResponse::offCondition))
            .setter(setter(Builder::offCondition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OffCondition").build()).build();

    private static final SdkField<String> SOURCE_MODEL_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceModelVersionArn").getter(getter(DescribeModelVersionResponse::sourceModelVersionArn))
            .setter(setter(Builder::sourceModelVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceModelVersionArn").build())
            .build();

    private static final SdkField<Instant> IMPORT_JOB_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImportJobStartTime").getter(getter(DescribeModelVersionResponse::importJobStartTime))
            .setter(setter(Builder::importJobStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobStartTime").build())
            .build();

    private static final SdkField<Instant> IMPORT_JOB_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ImportJobEndTime").getter(getter(DescribeModelVersionResponse::importJobEndTime))
            .setter(setter(Builder::importJobEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportJobEndTime").build()).build();

    private static final SdkField<Long> IMPORTED_DATA_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ImportedDataSizeInBytes").getter(getter(DescribeModelVersionResponse::importedDataSizeInBytes))
            .setter(setter(Builder::importedDataSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportedDataSizeInBytes").build())
            .build();

    private static final SdkField<String> PRIOR_MODEL_METRICS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PriorModelMetrics").getter(getter(DescribeModelVersionResponse::priorModelMetrics))
            .setter(setter(Builder::priorModelMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PriorModelMetrics").build()).build();

    private static final SdkField<Integer> RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetrainingAvailableDataInDays")
            .getter(getter(DescribeModelVersionResponse::retrainingAvailableDataInDays))
            .setter(setter(Builder::retrainingAvailableDataInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingAvailableDataInDays")
                    .build()).build();

    private static final SdkField<String> AUTO_PROMOTION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoPromotionResult").getter(getter(DescribeModelVersionResponse::autoPromotionResultAsString))
            .setter(setter(Builder::autoPromotionResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPromotionResult").build())
            .build();

    private static final SdkField<String> AUTO_PROMOTION_RESULT_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoPromotionResultReason").getter(getter(DescribeModelVersionResponse::autoPromotionResultReason))
            .setter(setter(Builder::autoPromotionResultReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoPromotionResultReason").build())
            .build();

    private static final SdkField<ModelDiagnosticsOutputConfiguration> MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD = SdkField
            .<ModelDiagnosticsOutputConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ModelDiagnosticsOutputConfiguration")
            .getter(getter(DescribeModelVersionResponse::modelDiagnosticsOutputConfiguration))
            .setter(setter(Builder::modelDiagnosticsOutputConfiguration))
            .constructor(ModelDiagnosticsOutputConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ModelDiagnosticsOutputConfiguration").build()).build();

    private static final SdkField<S3Object> MODEL_DIAGNOSTICS_RESULTS_OBJECT_FIELD = SdkField
            .<S3Object> builder(MarshallingType.SDK_POJO)
            .memberName("ModelDiagnosticsResultsObject")
            .getter(getter(DescribeModelVersionResponse::modelDiagnosticsResultsObject))
            .setter(setter(Builder::modelDiagnosticsResultsObject))
            .constructor(S3Object::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDiagnosticsResultsObject")
                    .build()).build();

    private static final SdkField<String> MODEL_QUALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelQuality").getter(getter(DescribeModelVersionResponse::modelQualityAsString))
            .setter(setter(Builder::modelQuality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, MODEL_VERSION_FIELD, MODEL_VERSION_ARN_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD, DATASET_NAME_FIELD,
            DATASET_ARN_FIELD, SCHEMA_FIELD, LABELS_INPUT_CONFIGURATION_FIELD, TRAINING_DATA_START_TIME_FIELD,
            TRAINING_DATA_END_TIME_FIELD, EVALUATION_DATA_START_TIME_FIELD, EVALUATION_DATA_END_TIME_FIELD, ROLE_ARN_FIELD,
            DATA_PRE_PROCESSING_CONFIGURATION_FIELD, TRAINING_EXECUTION_START_TIME_FIELD, TRAINING_EXECUTION_END_TIME_FIELD,
            FAILED_REASON_FIELD, MODEL_METRICS_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_AT_FIELD, SERVER_SIDE_KMS_KEY_ID_FIELD,
            OFF_CONDITION_FIELD, SOURCE_MODEL_VERSION_ARN_FIELD, IMPORT_JOB_START_TIME_FIELD, IMPORT_JOB_END_TIME_FIELD,
            IMPORTED_DATA_SIZE_IN_BYTES_FIELD, PRIOR_MODEL_METRICS_FIELD, RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD,
            AUTO_PROMOTION_RESULT_FIELD, AUTO_PROMOTION_RESULT_REASON_FIELD, MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD,
            MODEL_DIAGNOSTICS_RESULTS_OBJECT_FIELD, MODEL_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelName;

    private final String modelArn;

    private final Long modelVersion;

    private final String modelVersionArn;

    private final String status;

    private final String sourceType;

    private final String datasetName;

    private final String datasetArn;

    private final String schema;

    private final LabelsInputConfiguration labelsInputConfiguration;

    private final Instant trainingDataStartTime;

    private final Instant trainingDataEndTime;

    private final Instant evaluationDataStartTime;

    private final Instant evaluationDataEndTime;

    private final String roleArn;

    private final DataPreProcessingConfiguration dataPreProcessingConfiguration;

    private final Instant trainingExecutionStartTime;

    private final Instant trainingExecutionEndTime;

    private final String failedReason;

    private final String modelMetrics;

    private final Instant lastUpdatedTime;

    private final Instant createdAt;

    private final String serverSideKmsKeyId;

    private final String offCondition;

    private final String sourceModelVersionArn;

    private final Instant importJobStartTime;

    private final Instant importJobEndTime;

    private final Long importedDataSizeInBytes;

    private final String priorModelMetrics;

    private final Integer retrainingAvailableDataInDays;

    private final String autoPromotionResult;

    private final String autoPromotionResultReason;

    private final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

    private final S3Object modelDiagnosticsResultsObject;

    private final String modelQuality;

    private DescribeModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.modelVersion = builder.modelVersion;
        this.modelVersionArn = builder.modelVersionArn;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.datasetName = builder.datasetName;
        this.datasetArn = builder.datasetArn;
        this.schema = builder.schema;
        this.labelsInputConfiguration = builder.labelsInputConfiguration;
        this.trainingDataStartTime = builder.trainingDataStartTime;
        this.trainingDataEndTime = builder.trainingDataEndTime;
        this.evaluationDataStartTime = builder.evaluationDataStartTime;
        this.evaluationDataEndTime = builder.evaluationDataEndTime;
        this.roleArn = builder.roleArn;
        this.dataPreProcessingConfiguration = builder.dataPreProcessingConfiguration;
        this.trainingExecutionStartTime = builder.trainingExecutionStartTime;
        this.trainingExecutionEndTime = builder.trainingExecutionEndTime;
        this.failedReason = builder.failedReason;
        this.modelMetrics = builder.modelMetrics;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdAt = builder.createdAt;
        this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
        this.offCondition = builder.offCondition;
        this.sourceModelVersionArn = builder.sourceModelVersionArn;
        this.importJobStartTime = builder.importJobStartTime;
        this.importJobEndTime = builder.importJobEndTime;
        this.importedDataSizeInBytes = builder.importedDataSizeInBytes;
        this.priorModelMetrics = builder.priorModelMetrics;
        this.retrainingAvailableDataInDays = builder.retrainingAvailableDataInDays;
        this.autoPromotionResult = builder.autoPromotionResult;
        this.autoPromotionResultReason = builder.autoPromotionResultReason;
        this.modelDiagnosticsOutputConfiguration = builder.modelDiagnosticsOutputConfiguration;
        this.modelDiagnosticsResultsObject = builder.modelDiagnosticsResultsObject;
        this.modelQuality = builder.modelQuality;
    }

    /**
     * <p>
     * The name of the machine learning model that this version belongs to.
     * </p>
     * 
     * @return The name of the machine learning model that this version belongs to.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the parent machine learning model that this version belong to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the parent machine learning model that this version belong to.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The version of the machine learning model.
     * </p>
     * 
     * @return The version of the machine learning model.
     */
    public final Long modelVersion() {
        return modelVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model version.
     */
    public final String modelVersionArn() {
        return modelVersionArn;
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the model version.
     * @see ModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates whether this model version was created by training or by importing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this model version was created by training or by importing.
     * @see ModelVersionSourceType
     */
    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Indicates whether this model version was created by training or by importing.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Indicates whether this model version was created by training or by importing.
     * @see ModelVersionSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * The name of the dataset used to train the model version.
     * </p>
     * 
     * @return The name of the dataset used to train the model version.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset used to train the model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset used to train the model version.
     */
    public final String datasetArn() {
        return datasetArn;
    }

    /**
     * <p>
     * The schema of the data used to train the model version.
     * </p>
     * 
     * @return The schema of the data used to train the model version.
     */
    public final String schema() {
        return schema;
    }

    /**
     * Returns the value of the LabelsInputConfiguration property for this object.
     * 
     * @return The value of the LabelsInputConfiguration property for this object.
     */
    public final LabelsInputConfiguration labelsInputConfiguration() {
        return labelsInputConfiguration;
    }

    /**
     * <p>
     * The date on which the training data began being gathered. If you imported the version, this is the date that the
     * training data in the source version began being gathered.
     * </p>
     * 
     * @return The date on which the training data began being gathered. If you imported the version, this is the date
     *         that the training data in the source version began being gathered.
     */
    public final Instant trainingDataStartTime() {
        return trainingDataStartTime;
    }

    /**
     * <p>
     * The date on which the training data finished being gathered. If you imported the version, this is the date that
     * the training data in the source version finished being gathered.
     * </p>
     * 
     * @return The date on which the training data finished being gathered. If you imported the version, this is the
     *         date that the training data in the source version finished being gathered.
     */
    public final Instant trainingDataEndTime() {
        return trainingDataEndTime;
    }

    /**
     * <p>
     * The date on which the data in the evaluation set began being gathered. If you imported the version, this is the
     * date that the evaluation set data in the source version began being gathered.
     * </p>
     * 
     * @return The date on which the data in the evaluation set began being gathered. If you imported the version, this
     *         is the date that the evaluation set data in the source version began being gathered.
     */
    public final Instant evaluationDataStartTime() {
        return evaluationDataStartTime;
    }

    /**
     * <p>
     * The date on which the data in the evaluation set began being gathered. If you imported the version, this is the
     * date that the evaluation set data in the source version finished being gathered.
     * </p>
     * 
     * @return The date on which the data in the evaluation set began being gathered. If you imported the version, this
     *         is the date that the evaluation set data in the source version finished being gathered.
     */
    public final Instant evaluationDataEndTime() {
        return evaluationDataEndTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role that was used to train the model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role that was used to train the model version.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * Returns the value of the DataPreProcessingConfiguration property for this object.
     * 
     * @return The value of the DataPreProcessingConfiguration property for this object.
     */
    public final DataPreProcessingConfiguration dataPreProcessingConfiguration() {
        return dataPreProcessingConfiguration;
    }

    /**
     * <p>
     * The time when the training of the version began.
     * </p>
     * 
     * @return The time when the training of the version began.
     */
    public final Instant trainingExecutionStartTime() {
        return trainingExecutionStartTime;
    }

    /**
     * <p>
     * The time when the training of the version completed.
     * </p>
     * 
     * @return The time when the training of the version completed.
     */
    public final Instant trainingExecutionEndTime() {
        return trainingExecutionEndTime;
    }

    /**
     * <p>
     * The failure message if the training of the model version failed.
     * </p>
     * 
     * @return The failure message if the training of the model version failed.
     */
    public final String failedReason() {
        return failedReason;
    }

    /**
     * <p>
     * Shows an aggregated summary, in JSON format, of the model's performance within the evaluation time range. These
     * metrics are created when evaluating the model.
     * </p>
     * 
     * @return Shows an aggregated summary, in JSON format, of the model's performance within the evaluation time range.
     *         These metrics are created when evaluating the model.
     */
    public final String modelMetrics() {
        return modelMetrics;
    }

    /**
     * <p>
     * Indicates the last time the machine learning model version was updated.
     * </p>
     * 
     * @return Indicates the last time the machine learning model version was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Indicates the time and date at which the machine learning model version was created.
     * </p>
     * 
     * @return Indicates the time and date at which the machine learning model version was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The identifier of the KMS key key used to encrypt model version data by Amazon Lookout for Equipment.
     * </p>
     * 
     * @return The identifier of the KMS key key used to encrypt model version data by Amazon Lookout for Equipment.
     */
    public final String serverSideKmsKeyId() {
        return serverSideKmsKeyId;
    }

    /**
     * <p>
     * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met, Lookout
     * for Equipment will not use data from this asset for training, evaluation, or inference.
     * </p>
     * 
     * @return Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
     *         Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
     */
    public final String offCondition() {
        return offCondition;
    }

    /**
     * <p>
     * If model version was imported, then this field is the arn of the source model version.
     * </p>
     * 
     * @return If model version was imported, then this field is the arn of the source model version.
     */
    public final String sourceModelVersionArn() {
        return sourceModelVersionArn;
    }

    /**
     * <p>
     * The date and time when the import job began. This field appears if the model version was imported.
     * </p>
     * 
     * @return The date and time when the import job began. This field appears if the model version was imported.
     */
    public final Instant importJobStartTime() {
        return importJobStartTime;
    }

    /**
     * <p>
     * The date and time when the import job completed. This field appears if the model version was imported.
     * </p>
     * 
     * @return The date and time when the import job completed. This field appears if the model version was imported.
     */
    public final Instant importJobEndTime() {
        return importJobEndTime;
    }

    /**
     * <p>
     * The size in bytes of the imported data. This field appears if the model version was imported.
     * </p>
     * 
     * @return The size in bytes of the imported data. This field appears if the model version was imported.
     */
    public final Long importedDataSizeInBytes() {
        return importedDataSizeInBytes;
    }

    /**
     * <p>
     * If the model version was retrained, this field shows a summary of the performance of the prior model on the new
     * training range. You can use the information in this JSON-formatted object to compare the new model version and
     * the prior model version.
     * </p>
     * 
     * @return If the model version was retrained, this field shows a summary of the performance of the prior model on
     *         the new training range. You can use the information in this JSON-formatted object to compare the new
     *         model version and the prior model version.
     */
    public final String priorModelMetrics() {
        return priorModelMetrics;
    }

    /**
     * <p>
     * Indicates the number of days of data used in the most recent scheduled retraining run.
     * </p>
     * 
     * @return Indicates the number of days of data used in the most recent scheduled retraining run.
     */
    public final Integer retrainingAvailableDataInDays() {
        return retrainingAvailableDataInDays;
    }

    /**
     * <p>
     * Indicates whether the model version was promoted to be the active version after retraining or if there was an
     * error with or cancellation of the retraining.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoPromotionResult} will return {@link AutoPromotionResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoPromotionResultAsString}.
     * </p>
     * 
     * @return Indicates whether the model version was promoted to be the active version after retraining or if there
     *         was an error with or cancellation of the retraining.
     * @see AutoPromotionResult
     */
    public final AutoPromotionResult autoPromotionResult() {
        return AutoPromotionResult.fromValue(autoPromotionResult);
    }

    /**
     * <p>
     * Indicates whether the model version was promoted to be the active version after retraining or if there was an
     * error with or cancellation of the retraining.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoPromotionResult} will return {@link AutoPromotionResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoPromotionResultAsString}.
     * </p>
     * 
     * @return Indicates whether the model version was promoted to be the active version after retraining or if there
     *         was an error with or cancellation of the retraining.
     * @see AutoPromotionResult
     */
    public final String autoPromotionResultAsString() {
        return autoPromotionResult;
    }

    /**
     * <p>
     * Indicates the reason for the <code>AutoPromotionResult</code>. For example, a model might not be promoted if its
     * performance was worse than the active version, if there was an error during training, or if the retraining
     * scheduler was using <code>MANUAL</code> promote mode. The model will be promoted in <code>MANAGED</code> promote
     * mode if the performance is better than the previous model.
     * </p>
     * 
     * @return Indicates the reason for the <code>AutoPromotionResult</code>. For example, a model might not be promoted
     *         if its performance was worse than the active version, if there was an error during training, or if the
     *         retraining scheduler was using <code>MANUAL</code> promote mode. The model will be promoted in
     *         <code>MANAGED</code> promote mode if the performance is better than the previous model.
     */
    public final String autoPromotionResultReason() {
        return autoPromotionResultReason;
    }

    /**
     * <p>
     * The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for the model
     * version.
     * </p>
     * 
     * @return The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for the
     *         model version.
     */
    public final ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration() {
        return modelDiagnosticsOutputConfiguration;
    }

    /**
     * <p>
     * The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for the model
     * version.
     * </p>
     * 
     * @return The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for the
     *         model version.
     */
    public final S3Object modelDiagnosticsResultsObject() {
        return modelDiagnosticsResultsObject;
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final ModelQuality modelQuality() {
        return ModelQuality.fromValue(modelQuality);
    }

    /**
     * <p>
     * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the model
     * quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise, the value
     * is <code>QUALITY_THRESHOLD_MET</code>.
     * </p>
     * <p>
     * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
     * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding labels
     * to the input dataset and retraining the model.
     * </p>
     * <p>
     * For information about using labels with your models, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
     * labeling</a>.
     * </p>
     * <p>
     * For information about improving the quality of a model, see <a
     * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with Amazon
     * Lookout for Equipment</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelQuality} will
     * return {@link ModelQuality#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modelQualityAsString}.
     * </p>
     * 
     * @return Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
     *         model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
     *         Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
     *         <p>
     *         If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code>
     *         is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by
     *         adding labels to the input dataset and retraining the model.
     *         </p>
     *         <p>
     *         For information about using labels with your models, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
     *         >Understanding labeling</a>.
     *         </p>
     *         <p>
     *         For information about improving the quality of a model, see <a
     *         href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
     *         with Amazon Lookout for Equipment</a>.
     * @see ModelQuality
     */
    public final String modelQualityAsString() {
        return modelQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(modelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetArn());
        hashCode = 31 * hashCode + Objects.hashCode(schema());
        hashCode = 31 * hashCode + Objects.hashCode(labelsInputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(evaluationDataEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataPreProcessingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(trainingExecutionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(trainingExecutionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(failedReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(serverSideKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(offCondition());
        hashCode = 31 * hashCode + Objects.hashCode(sourceModelVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(importJobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(importJobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(importedDataSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(priorModelMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingAvailableDataInDays());
        hashCode = 31 * hashCode + Objects.hashCode(autoPromotionResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(autoPromotionResultReason());
        hashCode = 31 * hashCode + Objects.hashCode(modelDiagnosticsOutputConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(modelDiagnosticsResultsObject());
        hashCode = 31 * hashCode + Objects.hashCode(modelQualityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelVersionResponse)) {
            return false;
        }
        DescribeModelVersionResponse other = (DescribeModelVersionResponse) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(modelVersion(), other.modelVersion())
                && Objects.equals(modelVersionArn(), other.modelVersionArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(datasetName(), other.datasetName()) && Objects.equals(datasetArn(), other.datasetArn())
                && Objects.equals(schema(), other.schema())
                && Objects.equals(labelsInputConfiguration(), other.labelsInputConfiguration())
                && Objects.equals(trainingDataStartTime(), other.trainingDataStartTime())
                && Objects.equals(trainingDataEndTime(), other.trainingDataEndTime())
                && Objects.equals(evaluationDataStartTime(), other.evaluationDataStartTime())
                && Objects.equals(evaluationDataEndTime(), other.evaluationDataEndTime())
                && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(dataPreProcessingConfiguration(), other.dataPreProcessingConfiguration())
                && Objects.equals(trainingExecutionStartTime(), other.trainingExecutionStartTime())
                && Objects.equals(trainingExecutionEndTime(), other.trainingExecutionEndTime())
                && Objects.equals(failedReason(), other.failedReason()) && Objects.equals(modelMetrics(), other.modelMetrics())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(serverSideKmsKeyId(), other.serverSideKmsKeyId())
                && Objects.equals(offCondition(), other.offCondition())
                && Objects.equals(sourceModelVersionArn(), other.sourceModelVersionArn())
                && Objects.equals(importJobStartTime(), other.importJobStartTime())
                && Objects.equals(importJobEndTime(), other.importJobEndTime())
                && Objects.equals(importedDataSizeInBytes(), other.importedDataSizeInBytes())
                && Objects.equals(priorModelMetrics(), other.priorModelMetrics())
                && Objects.equals(retrainingAvailableDataInDays(), other.retrainingAvailableDataInDays())
                && Objects.equals(autoPromotionResultAsString(), other.autoPromotionResultAsString())
                && Objects.equals(autoPromotionResultReason(), other.autoPromotionResultReason())
                && Objects.equals(modelDiagnosticsOutputConfiguration(), other.modelDiagnosticsOutputConfiguration())
                && Objects.equals(modelDiagnosticsResultsObject(), other.modelDiagnosticsResultsObject())
                && Objects.equals(modelQualityAsString(), other.modelQualityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelVersionResponse").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("ModelVersion", modelVersion()).add("ModelVersionArn", modelVersionArn()).add("Status", statusAsString())
                .add("SourceType", sourceTypeAsString()).add("DatasetName", datasetName()).add("DatasetArn", datasetArn())
                .add("Schema", schema()).add("LabelsInputConfiguration", labelsInputConfiguration())
                .add("TrainingDataStartTime", trainingDataStartTime()).add("TrainingDataEndTime", trainingDataEndTime())
                .add("EvaluationDataStartTime", evaluationDataStartTime()).add("EvaluationDataEndTime", evaluationDataEndTime())
                .add("RoleArn", roleArn()).add("DataPreProcessingConfiguration", dataPreProcessingConfiguration())
                .add("TrainingExecutionStartTime", trainingExecutionStartTime())
                .add("TrainingExecutionEndTime", trainingExecutionEndTime()).add("FailedReason", failedReason())
                .add("ModelMetrics", modelMetrics()).add("LastUpdatedTime", lastUpdatedTime()).add("CreatedAt", createdAt())
                .add("ServerSideKmsKeyId", serverSideKmsKeyId()).add("OffCondition", offCondition())
                .add("SourceModelVersionArn", sourceModelVersionArn()).add("ImportJobStartTime", importJobStartTime())
                .add("ImportJobEndTime", importJobEndTime()).add("ImportedDataSizeInBytes", importedDataSizeInBytes())
                .add("PriorModelMetrics", priorModelMetrics())
                .add("RetrainingAvailableDataInDays", retrainingAvailableDataInDays())
                .add("AutoPromotionResult", autoPromotionResultAsString())
                .add("AutoPromotionResultReason", autoPromotionResultReason())
                .add("ModelDiagnosticsOutputConfiguration", modelDiagnosticsOutputConfiguration())
                .add("ModelDiagnosticsResultsObject", modelDiagnosticsResultsObject())
                .add("ModelQuality", modelQualityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "ModelVersion":
            return Optional.ofNullable(clazz.cast(modelVersion()));
        case "ModelVersionArn":
            return Optional.ofNullable(clazz.cast(modelVersionArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "DatasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "DatasetArn":
            return Optional.ofNullable(clazz.cast(datasetArn()));
        case "Schema":
            return Optional.ofNullable(clazz.cast(schema()));
        case "LabelsInputConfiguration":
            return Optional.ofNullable(clazz.cast(labelsInputConfiguration()));
        case "TrainingDataStartTime":
            return Optional.ofNullable(clazz.cast(trainingDataStartTime()));
        case "TrainingDataEndTime":
            return Optional.ofNullable(clazz.cast(trainingDataEndTime()));
        case "EvaluationDataStartTime":
            return Optional.ofNullable(clazz.cast(evaluationDataStartTime()));
        case "EvaluationDataEndTime":
            return Optional.ofNullable(clazz.cast(evaluationDataEndTime()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "DataPreProcessingConfiguration":
            return Optional.ofNullable(clazz.cast(dataPreProcessingConfiguration()));
        case "TrainingExecutionStartTime":
            return Optional.ofNullable(clazz.cast(trainingExecutionStartTime()));
        case "TrainingExecutionEndTime":
            return Optional.ofNullable(clazz.cast(trainingExecutionEndTime()));
        case "FailedReason":
            return Optional.ofNullable(clazz.cast(failedReason()));
        case "ModelMetrics":
            return Optional.ofNullable(clazz.cast(modelMetrics()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "ServerSideKmsKeyId":
            return Optional.ofNullable(clazz.cast(serverSideKmsKeyId()));
        case "OffCondition":
            return Optional.ofNullable(clazz.cast(offCondition()));
        case "SourceModelVersionArn":
            return Optional.ofNullable(clazz.cast(sourceModelVersionArn()));
        case "ImportJobStartTime":
            return Optional.ofNullable(clazz.cast(importJobStartTime()));
        case "ImportJobEndTime":
            return Optional.ofNullable(clazz.cast(importJobEndTime()));
        case "ImportedDataSizeInBytes":
            return Optional.ofNullable(clazz.cast(importedDataSizeInBytes()));
        case "PriorModelMetrics":
            return Optional.ofNullable(clazz.cast(priorModelMetrics()));
        case "RetrainingAvailableDataInDays":
            return Optional.ofNullable(clazz.cast(retrainingAvailableDataInDays()));
        case "AutoPromotionResult":
            return Optional.ofNullable(clazz.cast(autoPromotionResultAsString()));
        case "AutoPromotionResultReason":
            return Optional.ofNullable(clazz.cast(autoPromotionResultReason()));
        case "ModelDiagnosticsOutputConfiguration":
            return Optional.ofNullable(clazz.cast(modelDiagnosticsOutputConfiguration()));
        case "ModelDiagnosticsResultsObject":
            return Optional.ofNullable(clazz.cast(modelDiagnosticsResultsObject()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQualityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("ModelVersion", MODEL_VERSION_FIELD);
        map.put("ModelVersionArn", MODEL_VERSION_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("DatasetName", DATASET_NAME_FIELD);
        map.put("DatasetArn", DATASET_ARN_FIELD);
        map.put("Schema", SCHEMA_FIELD);
        map.put("LabelsInputConfiguration", LABELS_INPUT_CONFIGURATION_FIELD);
        map.put("TrainingDataStartTime", TRAINING_DATA_START_TIME_FIELD);
        map.put("TrainingDataEndTime", TRAINING_DATA_END_TIME_FIELD);
        map.put("EvaluationDataStartTime", EVALUATION_DATA_START_TIME_FIELD);
        map.put("EvaluationDataEndTime", EVALUATION_DATA_END_TIME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("DataPreProcessingConfiguration", DATA_PRE_PROCESSING_CONFIGURATION_FIELD);
        map.put("TrainingExecutionStartTime", TRAINING_EXECUTION_START_TIME_FIELD);
        map.put("TrainingExecutionEndTime", TRAINING_EXECUTION_END_TIME_FIELD);
        map.put("FailedReason", FAILED_REASON_FIELD);
        map.put("ModelMetrics", MODEL_METRICS_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("ServerSideKmsKeyId", SERVER_SIDE_KMS_KEY_ID_FIELD);
        map.put("OffCondition", OFF_CONDITION_FIELD);
        map.put("SourceModelVersionArn", SOURCE_MODEL_VERSION_ARN_FIELD);
        map.put("ImportJobStartTime", IMPORT_JOB_START_TIME_FIELD);
        map.put("ImportJobEndTime", IMPORT_JOB_END_TIME_FIELD);
        map.put("ImportedDataSizeInBytes", IMPORTED_DATA_SIZE_IN_BYTES_FIELD);
        map.put("PriorModelMetrics", PRIOR_MODEL_METRICS_FIELD);
        map.put("RetrainingAvailableDataInDays", RETRAINING_AVAILABLE_DATA_IN_DAYS_FIELD);
        map.put("AutoPromotionResult", AUTO_PROMOTION_RESULT_FIELD);
        map.put("AutoPromotionResultReason", AUTO_PROMOTION_RESULT_REASON_FIELD);
        map.put("ModelDiagnosticsOutputConfiguration", MODEL_DIAGNOSTICS_OUTPUT_CONFIGURATION_FIELD);
        map.put("ModelDiagnosticsResultsObject", MODEL_DIAGNOSTICS_RESULTS_OBJECT_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelVersionResponse, T> g) {
        return obj -> g.apply((DescribeModelVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeModelVersionResponse> {
        /**
         * <p>
         * The name of the machine learning model that this version belongs to.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model that this version belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the parent machine learning model that this version belong to.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the parent machine learning model that this version belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The version of the machine learning model.
         * </p>
         * 
         * @param modelVersion
         *        The version of the machine learning model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersion(Long modelVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model version.
         * </p>
         * 
         * @param modelVersionArn
         *        The Amazon Resource Name (ARN) of the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelVersionArn(String modelVersionArn);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the model version.
         * </p>
         * 
         * @param status
         *        The current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(ModelVersionStatus status);

        /**
         * <p>
         * Indicates whether this model version was created by training or by importing.
         * </p>
         * 
         * @param sourceType
         *        Indicates whether this model version was created by training or by importing.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Indicates whether this model version was created by training or by importing.
         * </p>
         * 
         * @param sourceType
         *        Indicates whether this model version was created by training or by importing.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(ModelVersionSourceType sourceType);

        /**
         * <p>
         * The name of the dataset used to train the model version.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset used to train the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset used to train the model version.
         * </p>
         * 
         * @param datasetArn
         *        The Amazon Resource Name (ARN) of the dataset used to train the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetArn(String datasetArn);

        /**
         * <p>
         * The schema of the data used to train the model version.
         * </p>
         * 
         * @param schema
         *        The schema of the data used to train the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schema(String schema);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * @param labelsInputConfiguration
         *        The new value for the LabelsInputConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration);

        /**
         * Sets the value of the LabelsInputConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link LabelsInputConfiguration.Builder}
         * avoiding the need to create one manually via {@link LabelsInputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelsInputConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #labelsInputConfiguration(LabelsInputConfiguration)}.
         * 
         * @param labelsInputConfiguration
         *        a consumer that will call methods on {@link LabelsInputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #labelsInputConfiguration(LabelsInputConfiguration)
         */
        default Builder labelsInputConfiguration(Consumer<LabelsInputConfiguration.Builder> labelsInputConfiguration) {
            return labelsInputConfiguration(LabelsInputConfiguration.builder().applyMutation(labelsInputConfiguration).build());
        }

        /**
         * <p>
         * The date on which the training data began being gathered. If you imported the version, this is the date that
         * the training data in the source version began being gathered.
         * </p>
         * 
         * @param trainingDataStartTime
         *        The date on which the training data began being gathered. If you imported the version, this is the
         *        date that the training data in the source version began being gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataStartTime(Instant trainingDataStartTime);

        /**
         * <p>
         * The date on which the training data finished being gathered. If you imported the version, this is the date
         * that the training data in the source version finished being gathered.
         * </p>
         * 
         * @param trainingDataEndTime
         *        The date on which the training data finished being gathered. If you imported the version, this is the
         *        date that the training data in the source version finished being gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataEndTime(Instant trainingDataEndTime);

        /**
         * <p>
         * The date on which the data in the evaluation set began being gathered. If you imported the version, this is
         * the date that the evaluation set data in the source version began being gathered.
         * </p>
         * 
         * @param evaluationDataStartTime
         *        The date on which the data in the evaluation set began being gathered. If you imported the version,
         *        this is the date that the evaluation set data in the source version began being gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataStartTime(Instant evaluationDataStartTime);

        /**
         * <p>
         * The date on which the data in the evaluation set began being gathered. If you imported the version, this is
         * the date that the evaluation set data in the source version finished being gathered.
         * </p>
         * 
         * @param evaluationDataEndTime
         *        The date on which the data in the evaluation set began being gathered. If you imported the version,
         *        this is the date that the evaluation set data in the source version finished being gathered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationDataEndTime(Instant evaluationDataEndTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role that was used to train the model version.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role that was used to train the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * Sets the value of the DataPreProcessingConfiguration property for this object.
         *
         * @param dataPreProcessingConfiguration
         *        The new value for the DataPreProcessingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration);

        /**
         * Sets the value of the DataPreProcessingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DataPreProcessingConfiguration.Builder}
         * avoiding the need to create one manually via {@link DataPreProcessingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataPreProcessingConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #dataPreProcessingConfiguration(DataPreProcessingConfiguration)}.
         * 
         * @param dataPreProcessingConfiguration
         *        a consumer that will call methods on {@link DataPreProcessingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPreProcessingConfiguration(DataPreProcessingConfiguration)
         */
        default Builder dataPreProcessingConfiguration(
                Consumer<DataPreProcessingConfiguration.Builder> dataPreProcessingConfiguration) {
            return dataPreProcessingConfiguration(DataPreProcessingConfiguration.builder()
                    .applyMutation(dataPreProcessingConfiguration).build());
        }

        /**
         * <p>
         * The time when the training of the version began.
         * </p>
         * 
         * @param trainingExecutionStartTime
         *        The time when the training of the version began.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingExecutionStartTime(Instant trainingExecutionStartTime);

        /**
         * <p>
         * The time when the training of the version completed.
         * </p>
         * 
         * @param trainingExecutionEndTime
         *        The time when the training of the version completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingExecutionEndTime(Instant trainingExecutionEndTime);

        /**
         * <p>
         * The failure message if the training of the model version failed.
         * </p>
         * 
         * @param failedReason
         *        The failure message if the training of the model version failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedReason(String failedReason);

        /**
         * <p>
         * Shows an aggregated summary, in JSON format, of the model's performance within the evaluation time range.
         * These metrics are created when evaluating the model.
         * </p>
         * 
         * @param modelMetrics
         *        Shows an aggregated summary, in JSON format, of the model's performance within the evaluation time
         *        range. These metrics are created when evaluating the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetrics(String modelMetrics);

        /**
         * <p>
         * Indicates the last time the machine learning model version was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Indicates the last time the machine learning model version was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Indicates the time and date at which the machine learning model version was created.
         * </p>
         * 
         * @param createdAt
         *        Indicates the time and date at which the machine learning model version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The identifier of the KMS key key used to encrypt model version data by Amazon Lookout for Equipment.
         * </p>
         * 
         * @param serverSideKmsKeyId
         *        The identifier of the KMS key key used to encrypt model version data by Amazon Lookout for Equipment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverSideKmsKeyId(String serverSideKmsKeyId);

        /**
         * <p>
         * Indicates that the asset associated with this sensor has been shut off. As long as this condition is met,
         * Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * </p>
         * 
         * @param offCondition
         *        Indicates that the asset associated with this sensor has been shut off. As long as this condition is
         *        met, Lookout for Equipment will not use data from this asset for training, evaluation, or inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offCondition(String offCondition);

        /**
         * <p>
         * If model version was imported, then this field is the arn of the source model version.
         * </p>
         * 
         * @param sourceModelVersionArn
         *        If model version was imported, then this field is the arn of the source model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceModelVersionArn(String sourceModelVersionArn);

        /**
         * <p>
         * The date and time when the import job began. This field appears if the model version was imported.
         * </p>
         * 
         * @param importJobStartTime
         *        The date and time when the import job began. This field appears if the model version was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobStartTime(Instant importJobStartTime);

        /**
         * <p>
         * The date and time when the import job completed. This field appears if the model version was imported.
         * </p>
         * 
         * @param importJobEndTime
         *        The date and time when the import job completed. This field appears if the model version was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importJobEndTime(Instant importJobEndTime);

        /**
         * <p>
         * The size in bytes of the imported data. This field appears if the model version was imported.
         * </p>
         * 
         * @param importedDataSizeInBytes
         *        The size in bytes of the imported data. This field appears if the model version was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importedDataSizeInBytes(Long importedDataSizeInBytes);

        /**
         * <p>
         * If the model version was retrained, this field shows a summary of the performance of the prior model on the
         * new training range. You can use the information in this JSON-formatted object to compare the new model
         * version and the prior model version.
         * </p>
         * 
         * @param priorModelMetrics
         *        If the model version was retrained, this field shows a summary of the performance of the prior model
         *        on the new training range. You can use the information in this JSON-formatted object to compare the
         *        new model version and the prior model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priorModelMetrics(String priorModelMetrics);

        /**
         * <p>
         * Indicates the number of days of data used in the most recent scheduled retraining run.
         * </p>
         * 
         * @param retrainingAvailableDataInDays
         *        Indicates the number of days of data used in the most recent scheduled retraining run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingAvailableDataInDays(Integer retrainingAvailableDataInDays);

        /**
         * <p>
         * Indicates whether the model version was promoted to be the active version after retraining or if there was an
         * error with or cancellation of the retraining.
         * </p>
         * 
         * @param autoPromotionResult
         *        Indicates whether the model version was promoted to be the active version after retraining or if there
         *        was an error with or cancellation of the retraining.
         * @see AutoPromotionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPromotionResult
         */
        Builder autoPromotionResult(String autoPromotionResult);

        /**
         * <p>
         * Indicates whether the model version was promoted to be the active version after retraining or if there was an
         * error with or cancellation of the retraining.
         * </p>
         * 
         * @param autoPromotionResult
         *        Indicates whether the model version was promoted to be the active version after retraining or if there
         *        was an error with or cancellation of the retraining.
         * @see AutoPromotionResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoPromotionResult
         */
        Builder autoPromotionResult(AutoPromotionResult autoPromotionResult);

        /**
         * <p>
         * Indicates the reason for the <code>AutoPromotionResult</code>. For example, a model might not be promoted if
         * its performance was worse than the active version, if there was an error during training, or if the
         * retraining scheduler was using <code>MANUAL</code> promote mode. The model will be promoted in
         * <code>MANAGED</code> promote mode if the performance is better than the previous model.
         * </p>
         * 
         * @param autoPromotionResultReason
         *        Indicates the reason for the <code>AutoPromotionResult</code>. For example, a model might not be
         *        promoted if its performance was worse than the active version, if there was an error during training,
         *        or if the retraining scheduler was using <code>MANUAL</code> promote mode. The model will be promoted
         *        in <code>MANAGED</code> promote mode if the performance is better than the previous model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoPromotionResultReason(String autoPromotionResultReason);

        /**
         * <p>
         * The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for the model
         * version.
         * </p>
         * 
         * @param modelDiagnosticsOutputConfiguration
         *        The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for
         *        the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration);

        /**
         * <p>
         * The Amazon S3 location where Amazon Lookout for Equipment saves the pointwise model diagnostics for the model
         * version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ModelDiagnosticsOutputConfiguration.Builder} avoiding the need to create one manually via
         * {@link ModelDiagnosticsOutputConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelDiagnosticsOutputConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)}.
         * 
         * @param modelDiagnosticsOutputConfiguration
         *        a consumer that will call methods on {@link ModelDiagnosticsOutputConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration)
         */
        default Builder modelDiagnosticsOutputConfiguration(
                Consumer<ModelDiagnosticsOutputConfiguration.Builder> modelDiagnosticsOutputConfiguration) {
            return modelDiagnosticsOutputConfiguration(ModelDiagnosticsOutputConfiguration.builder()
                    .applyMutation(modelDiagnosticsOutputConfiguration).build());
        }

        /**
         * <p>
         * The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for the
         * model version.
         * </p>
         * 
         * @param modelDiagnosticsResultsObject
         *        The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for
         *        the model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDiagnosticsResultsObject(S3Object modelDiagnosticsResultsObject);

        /**
         * <p>
         * The Amazon S3 output prefix for where Lookout for Equipment saves the pointwise model diagnostics for the
         * model version.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Object.Builder} avoiding the need to
         * create one manually via {@link S3Object#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Object.Builder#build()} is called immediately and its result is
         * passed to {@link #modelDiagnosticsResultsObject(S3Object)}.
         * 
         * @param modelDiagnosticsResultsObject
         *        a consumer that will call methods on {@link S3Object.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDiagnosticsResultsObject(S3Object)
         */
        default Builder modelDiagnosticsResultsObject(Consumer<S3Object.Builder> modelDiagnosticsResultsObject) {
            return modelDiagnosticsResultsObject(S3Object.builder().applyMutation(modelDiagnosticsResultsObject).build());
        }

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(String modelQuality);

        /**
         * <p>
         * Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that the
         * model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>. Otherwise,
         * the value is <code>QUALITY_THRESHOLD_MET</code>.
         * </p>
         * <p>
         * If the model is unlabeled, the model quality can't be assessed and the value of <code>ModelQuality</code> is
         * <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a model quality assessment by adding
         * labels to the input dataset and retraining the model.
         * </p>
         * <p>
         * For information about using labels with your models, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html">Understanding
         * labeling</a>.
         * </p>
         * <p>
         * For information about improving the quality of a model, see <a
         * href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices with
         * Amazon Lookout for Equipment</a>.
         * </p>
         * 
         * @param modelQuality
         *        Provides a quality assessment for a model that uses labels. If Lookout for Equipment determines that
         *        the model quality is poor based on training metrics, the value is <code>POOR_QUALITY_DETECTED</code>.
         *        Otherwise, the value is <code>QUALITY_THRESHOLD_MET</code>.</p>
         *        <p>
         *        If the model is unlabeled, the model quality can't be assessed and the value of
         *        <code>ModelQuality</code> is <code>CANNOT_DETERMINE_QUALITY</code>. In this situation, you can get a
         *        model quality assessment by adding labels to the input dataset and retraining the model.
         *        </p>
         *        <p>
         *        For information about using labels with your models, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/understanding-labeling.html"
         *        >Understanding labeling</a>.
         *        </p>
         *        <p>
         *        For information about improving the quality of a model, see <a
         *        href="https://docs.aws.amazon.com/lookout-for-equipment/latest/ug/best-practices.html">Best practices
         *        with Amazon Lookout for Equipment</a>.
         * @see ModelQuality
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelQuality
         */
        Builder modelQuality(ModelQuality modelQuality);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private Long modelVersion;

        private String modelVersionArn;

        private String status;

        private String sourceType;

        private String datasetName;

        private String datasetArn;

        private String schema;

        private LabelsInputConfiguration labelsInputConfiguration;

        private Instant trainingDataStartTime;

        private Instant trainingDataEndTime;

        private Instant evaluationDataStartTime;

        private Instant evaluationDataEndTime;

        private String roleArn;

        private DataPreProcessingConfiguration dataPreProcessingConfiguration;

        private Instant trainingExecutionStartTime;

        private Instant trainingExecutionEndTime;

        private String failedReason;

        private String modelMetrics;

        private Instant lastUpdatedTime;

        private Instant createdAt;

        private String serverSideKmsKeyId;

        private String offCondition;

        private String sourceModelVersionArn;

        private Instant importJobStartTime;

        private Instant importJobEndTime;

        private Long importedDataSizeInBytes;

        private String priorModelMetrics;

        private Integer retrainingAvailableDataInDays;

        private String autoPromotionResult;

        private String autoPromotionResultReason;

        private ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration;

        private S3Object modelDiagnosticsResultsObject;

        private String modelQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelVersionResponse model) {
            super(model);
            modelName(model.modelName);
            modelArn(model.modelArn);
            modelVersion(model.modelVersion);
            modelVersionArn(model.modelVersionArn);
            status(model.status);
            sourceType(model.sourceType);
            datasetName(model.datasetName);
            datasetArn(model.datasetArn);
            schema(model.schema);
            labelsInputConfiguration(model.labelsInputConfiguration);
            trainingDataStartTime(model.trainingDataStartTime);
            trainingDataEndTime(model.trainingDataEndTime);
            evaluationDataStartTime(model.evaluationDataStartTime);
            evaluationDataEndTime(model.evaluationDataEndTime);
            roleArn(model.roleArn);
            dataPreProcessingConfiguration(model.dataPreProcessingConfiguration);
            trainingExecutionStartTime(model.trainingExecutionStartTime);
            trainingExecutionEndTime(model.trainingExecutionEndTime);
            failedReason(model.failedReason);
            modelMetrics(model.modelMetrics);
            lastUpdatedTime(model.lastUpdatedTime);
            createdAt(model.createdAt);
            serverSideKmsKeyId(model.serverSideKmsKeyId);
            offCondition(model.offCondition);
            sourceModelVersionArn(model.sourceModelVersionArn);
            importJobStartTime(model.importJobStartTime);
            importJobEndTime(model.importJobEndTime);
            importedDataSizeInBytes(model.importedDataSizeInBytes);
            priorModelMetrics(model.priorModelMetrics);
            retrainingAvailableDataInDays(model.retrainingAvailableDataInDays);
            autoPromotionResult(model.autoPromotionResult);
            autoPromotionResultReason(model.autoPromotionResultReason);
            modelDiagnosticsOutputConfiguration(model.modelDiagnosticsOutputConfiguration);
            modelDiagnosticsResultsObject(model.modelDiagnosticsResultsObject);
            modelQuality(model.modelQuality);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Long getModelVersion() {
            return modelVersion;
        }

        public final void setModelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
        }

        @Override
        public final Builder modelVersion(Long modelVersion) {
            this.modelVersion = modelVersion;
            return this;
        }

        public final String getModelVersionArn() {
            return modelVersionArn;
        }

        public final void setModelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
        }

        @Override
        public final Builder modelVersionArn(String modelVersionArn) {
            this.modelVersionArn = modelVersionArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetArn() {
            return datasetArn;
        }

        public final void setDatasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
        }

        @Override
        public final Builder datasetArn(String datasetArn) {
            this.datasetArn = datasetArn;
            return this;
        }

        public final String getSchema() {
            return schema;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final LabelsInputConfiguration.Builder getLabelsInputConfiguration() {
            return labelsInputConfiguration != null ? labelsInputConfiguration.toBuilder() : null;
        }

        public final void setLabelsInputConfiguration(LabelsInputConfiguration.BuilderImpl labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration != null ? labelsInputConfiguration.build() : null;
        }

        @Override
        public final Builder labelsInputConfiguration(LabelsInputConfiguration labelsInputConfiguration) {
            this.labelsInputConfiguration = labelsInputConfiguration;
            return this;
        }

        public final Instant getTrainingDataStartTime() {
            return trainingDataStartTime;
        }

        public final void setTrainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
        }

        @Override
        public final Builder trainingDataStartTime(Instant trainingDataStartTime) {
            this.trainingDataStartTime = trainingDataStartTime;
            return this;
        }

        public final Instant getTrainingDataEndTime() {
            return trainingDataEndTime;
        }

        public final void setTrainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
        }

        @Override
        public final Builder trainingDataEndTime(Instant trainingDataEndTime) {
            this.trainingDataEndTime = trainingDataEndTime;
            return this;
        }

        public final Instant getEvaluationDataStartTime() {
            return evaluationDataStartTime;
        }

        public final void setEvaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
        }

        @Override
        public final Builder evaluationDataStartTime(Instant evaluationDataStartTime) {
            this.evaluationDataStartTime = evaluationDataStartTime;
            return this;
        }

        public final Instant getEvaluationDataEndTime() {
            return evaluationDataEndTime;
        }

        public final void setEvaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
        }

        @Override
        public final Builder evaluationDataEndTime(Instant evaluationDataEndTime) {
            this.evaluationDataEndTime = evaluationDataEndTime;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final DataPreProcessingConfiguration.Builder getDataPreProcessingConfiguration() {
            return dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.toBuilder() : null;
        }

        public final void setDataPreProcessingConfiguration(
                DataPreProcessingConfiguration.BuilderImpl dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration != null ? dataPreProcessingConfiguration.build()
                    : null;
        }

        @Override
        public final Builder dataPreProcessingConfiguration(DataPreProcessingConfiguration dataPreProcessingConfiguration) {
            this.dataPreProcessingConfiguration = dataPreProcessingConfiguration;
            return this;
        }

        public final Instant getTrainingExecutionStartTime() {
            return trainingExecutionStartTime;
        }

        public final void setTrainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
        }

        @Override
        public final Builder trainingExecutionStartTime(Instant trainingExecutionStartTime) {
            this.trainingExecutionStartTime = trainingExecutionStartTime;
            return this;
        }

        public final Instant getTrainingExecutionEndTime() {
            return trainingExecutionEndTime;
        }

        public final void setTrainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
        }

        @Override
        public final Builder trainingExecutionEndTime(Instant trainingExecutionEndTime) {
            this.trainingExecutionEndTime = trainingExecutionEndTime;
            return this;
        }

        public final String getFailedReason() {
            return failedReason;
        }

        public final void setFailedReason(String failedReason) {
            this.failedReason = failedReason;
        }

        @Override
        public final Builder failedReason(String failedReason) {
            this.failedReason = failedReason;
            return this;
        }

        public final String getModelMetrics() {
            return modelMetrics;
        }

        public final void setModelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
        }

        @Override
        public final Builder modelMetrics(String modelMetrics) {
            this.modelMetrics = modelMetrics;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getServerSideKmsKeyId() {
            return serverSideKmsKeyId;
        }

        public final void setServerSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
        }

        @Override
        public final Builder serverSideKmsKeyId(String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        public final String getOffCondition() {
            return offCondition;
        }

        public final void setOffCondition(String offCondition) {
            this.offCondition = offCondition;
        }

        @Override
        public final Builder offCondition(String offCondition) {
            this.offCondition = offCondition;
            return this;
        }

        public final String getSourceModelVersionArn() {
            return sourceModelVersionArn;
        }

        public final void setSourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
        }

        @Override
        public final Builder sourceModelVersionArn(String sourceModelVersionArn) {
            this.sourceModelVersionArn = sourceModelVersionArn;
            return this;
        }

        public final Instant getImportJobStartTime() {
            return importJobStartTime;
        }

        public final void setImportJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
        }

        @Override
        public final Builder importJobStartTime(Instant importJobStartTime) {
            this.importJobStartTime = importJobStartTime;
            return this;
        }

        public final Instant getImportJobEndTime() {
            return importJobEndTime;
        }

        public final void setImportJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
        }

        @Override
        public final Builder importJobEndTime(Instant importJobEndTime) {
            this.importJobEndTime = importJobEndTime;
            return this;
        }

        public final Long getImportedDataSizeInBytes() {
            return importedDataSizeInBytes;
        }

        public final void setImportedDataSizeInBytes(Long importedDataSizeInBytes) {
            this.importedDataSizeInBytes = importedDataSizeInBytes;
        }

        @Override
        public final Builder importedDataSizeInBytes(Long importedDataSizeInBytes) {
            this.importedDataSizeInBytes = importedDataSizeInBytes;
            return this;
        }

        public final String getPriorModelMetrics() {
            return priorModelMetrics;
        }

        public final void setPriorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
        }

        @Override
        public final Builder priorModelMetrics(String priorModelMetrics) {
            this.priorModelMetrics = priorModelMetrics;
            return this;
        }

        public final Integer getRetrainingAvailableDataInDays() {
            return retrainingAvailableDataInDays;
        }

        public final void setRetrainingAvailableDataInDays(Integer retrainingAvailableDataInDays) {
            this.retrainingAvailableDataInDays = retrainingAvailableDataInDays;
        }

        @Override
        public final Builder retrainingAvailableDataInDays(Integer retrainingAvailableDataInDays) {
            this.retrainingAvailableDataInDays = retrainingAvailableDataInDays;
            return this;
        }

        public final String getAutoPromotionResult() {
            return autoPromotionResult;
        }

        public final void setAutoPromotionResult(String autoPromotionResult) {
            this.autoPromotionResult = autoPromotionResult;
        }

        @Override
        public final Builder autoPromotionResult(String autoPromotionResult) {
            this.autoPromotionResult = autoPromotionResult;
            return this;
        }

        @Override
        public final Builder autoPromotionResult(AutoPromotionResult autoPromotionResult) {
            this.autoPromotionResult(autoPromotionResult == null ? null : autoPromotionResult.toString());
            return this;
        }

        public final String getAutoPromotionResultReason() {
            return autoPromotionResultReason;
        }

        public final void setAutoPromotionResultReason(String autoPromotionResultReason) {
            this.autoPromotionResultReason = autoPromotionResultReason;
        }

        @Override
        public final Builder autoPromotionResultReason(String autoPromotionResultReason) {
            this.autoPromotionResultReason = autoPromotionResultReason;
            return this;
        }

        public final ModelDiagnosticsOutputConfiguration.Builder getModelDiagnosticsOutputConfiguration() {
            return modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration.toBuilder() : null;
        }

        public final void setModelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration.BuilderImpl modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration != null ? modelDiagnosticsOutputConfiguration
                    .build() : null;
        }

        @Override
        public final Builder modelDiagnosticsOutputConfiguration(
                ModelDiagnosticsOutputConfiguration modelDiagnosticsOutputConfiguration) {
            this.modelDiagnosticsOutputConfiguration = modelDiagnosticsOutputConfiguration;
            return this;
        }

        public final S3Object.Builder getModelDiagnosticsResultsObject() {
            return modelDiagnosticsResultsObject != null ? modelDiagnosticsResultsObject.toBuilder() : null;
        }

        public final void setModelDiagnosticsResultsObject(S3Object.BuilderImpl modelDiagnosticsResultsObject) {
            this.modelDiagnosticsResultsObject = modelDiagnosticsResultsObject != null ? modelDiagnosticsResultsObject.build()
                    : null;
        }

        @Override
        public final Builder modelDiagnosticsResultsObject(S3Object modelDiagnosticsResultsObject) {
            this.modelDiagnosticsResultsObject = modelDiagnosticsResultsObject;
            return this;
        }

        public final String getModelQuality() {
            return modelQuality;
        }

        public final void setModelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
        }

        @Override
        public final Builder modelQuality(String modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        @Override
        public final Builder modelQuality(ModelQuality modelQuality) {
            this.modelQuality(modelQuality == null ? null : modelQuality.toString());
            return this;
        }

        @Override
        public DescribeModelVersionResponse build() {
            return new DescribeModelVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
