/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourcePolicyResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<DescribeResourcePolicyResponse.Builder, DescribeResourcePolicyResponse> {
    private static final SdkField<String> POLICY_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyRevisionId").getter(getter(DescribeResourcePolicyResponse::policyRevisionId))
            .setter(setter(Builder::policyRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyRevisionId").build()).build();

    private static final SdkField<String> RESOURCE_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourcePolicy").getter(getter(DescribeResourcePolicyResponse::resourcePolicy))
            .setter(setter(Builder::resourcePolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourcePolicy").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeResourcePolicyResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeResourcePolicyResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_REVISION_ID_FIELD,
            RESOURCE_POLICY_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyRevisionId;

    private final String resourcePolicy;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private DescribeResourcePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyRevisionId = builder.policyRevisionId;
        this.resourcePolicy = builder.resourcePolicy;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * A unique identifier for a revision of the resource policy.
     * </p>
     * 
     * @return A unique identifier for a revision of the resource policy.
     */
    public final String policyRevisionId() {
        return policyRevisionId;
    }

    /**
     * <p>
     * The resource policy in a JSON-formatted string.
     * </p>
     * 
     * @return The resource policy in a JSON-formatted string.
     */
    public final String resourcePolicy() {
        return resourcePolicy;
    }

    /**
     * <p>
     * The time when the resource policy was created.
     * </p>
     * 
     * @return The time when the resource policy was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the resource policy was last modified.
     * </p>
     * 
     * @return The time when the resource policy was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyRevisionId());
        hashCode = 31 * hashCode + Objects.hashCode(resourcePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourcePolicyResponse)) {
            return false;
        }
        DescribeResourcePolicyResponse other = (DescribeResourcePolicyResponse) obj;
        return Objects.equals(policyRevisionId(), other.policyRevisionId())
                && Objects.equals(resourcePolicy(), other.resourcePolicy())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeResourcePolicyResponse").add("PolicyRevisionId", policyRevisionId())
                .add("ResourcePolicy", resourcePolicy()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyRevisionId":
            return Optional.ofNullable(clazz.cast(policyRevisionId()));
        case "ResourcePolicy":
            return Optional.ofNullable(clazz.cast(resourcePolicy()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PolicyRevisionId", POLICY_REVISION_ID_FIELD);
        map.put("ResourcePolicy", RESOURCE_POLICY_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourcePolicyResponse, T> g) {
        return obj -> g.apply((DescribeResourcePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeResourcePolicyResponse> {
        /**
         * <p>
         * A unique identifier for a revision of the resource policy.
         * </p>
         * 
         * @param policyRevisionId
         *        A unique identifier for a revision of the resource policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyRevisionId(String policyRevisionId);

        /**
         * <p>
         * The resource policy in a JSON-formatted string.
         * </p>
         * 
         * @param resourcePolicy
         *        The resource policy in a JSON-formatted string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourcePolicy(String resourcePolicy);

        /**
         * <p>
         * The time when the resource policy was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the resource policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the resource policy was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the resource policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String policyRevisionId;

        private String resourcePolicy;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourcePolicyResponse model) {
            super(model);
            policyRevisionId(model.policyRevisionId);
            resourcePolicy(model.resourcePolicy);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getPolicyRevisionId() {
            return policyRevisionId;
        }

        public final void setPolicyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
        }

        @Override
        public final Builder policyRevisionId(String policyRevisionId) {
            this.policyRevisionId = policyRevisionId;
            return this;
        }

        public final String getResourcePolicy() {
            return resourcePolicy;
        }

        public final void setResourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
        }

        @Override
        public final Builder resourcePolicy(String resourcePolicy) {
            this.resourcePolicy = resourcePolicy;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeResourcePolicyResponse build() {
            return new DescribeResourcePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
