/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises information abount duplicate timestamps in the dataset.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DuplicateTimestamps implements SdkPojo, Serializable,
        ToCopyableBuilder<DuplicateTimestamps.Builder, DuplicateTimestamps> {
    private static final SdkField<Integer> TOTAL_NUMBER_OF_DUPLICATE_TIMESTAMPS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfDuplicateTimestamps")
            .getter(getter(DuplicateTimestamps::totalNumberOfDuplicateTimestamps))
            .setter(setter(Builder::totalNumberOfDuplicateTimestamps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfDuplicateTimestamps")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TOTAL_NUMBER_OF_DUPLICATE_TIMESTAMPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer totalNumberOfDuplicateTimestamps;

    private DuplicateTimestamps(BuilderImpl builder) {
        this.totalNumberOfDuplicateTimestamps = builder.totalNumberOfDuplicateTimestamps;
    }

    /**
     * <p>
     * Indicates the total number of duplicate timestamps.
     * </p>
     * 
     * @return Indicates the total number of duplicate timestamps.
     */
    public final Integer totalNumberOfDuplicateTimestamps() {
        return totalNumberOfDuplicateTimestamps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfDuplicateTimestamps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DuplicateTimestamps)) {
            return false;
        }
        DuplicateTimestamps other = (DuplicateTimestamps) obj;
        return Objects.equals(totalNumberOfDuplicateTimestamps(), other.totalNumberOfDuplicateTimestamps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DuplicateTimestamps")
                .add("TotalNumberOfDuplicateTimestamps", totalNumberOfDuplicateTimestamps()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalNumberOfDuplicateTimestamps":
            return Optional.ofNullable(clazz.cast(totalNumberOfDuplicateTimestamps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TotalNumberOfDuplicateTimestamps", TOTAL_NUMBER_OF_DUPLICATE_TIMESTAMPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DuplicateTimestamps, T> g) {
        return obj -> g.apply((DuplicateTimestamps) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DuplicateTimestamps> {
        /**
         * <p>
         * Indicates the total number of duplicate timestamps.
         * </p>
         * 
         * @param totalNumberOfDuplicateTimestamps
         *        Indicates the total number of duplicate timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfDuplicateTimestamps(Integer totalNumberOfDuplicateTimestamps);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalNumberOfDuplicateTimestamps;

        private BuilderImpl() {
        }

        private BuilderImpl(DuplicateTimestamps model) {
            totalNumberOfDuplicateTimestamps(model.totalNumberOfDuplicateTimestamps);
        }

        public final Integer getTotalNumberOfDuplicateTimestamps() {
            return totalNumberOfDuplicateTimestamps;
        }

        public final void setTotalNumberOfDuplicateTimestamps(Integer totalNumberOfDuplicateTimestamps) {
            this.totalNumberOfDuplicateTimestamps = totalNumberOfDuplicateTimestamps;
        }

        @Override
        public final Builder totalNumberOfDuplicateTimestamps(Integer totalNumberOfDuplicateTimestamps) {
            this.totalNumberOfDuplicateTimestamps = totalNumberOfDuplicateTimestamps;
            return this;
        }

        @Override
        public DuplicateTimestamps build() {
            return new DuplicateTimestamps(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
