/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies configuration information for the input data for the inference, including timestamp format and delimiter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceInputNameConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceInputNameConfiguration.Builder, InferenceInputNameConfiguration> {
    private static final SdkField<String> TIMESTAMP_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimestampFormat").getter(getter(InferenceInputNameConfiguration::timestampFormat))
            .setter(setter(Builder::timestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampFormat").build()).build();

    private static final SdkField<String> COMPONENT_TIMESTAMP_DELIMITER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ComponentTimestampDelimiter")
            .getter(getter(InferenceInputNameConfiguration::componentTimestampDelimiter))
            .setter(setter(Builder::componentTimestampDelimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComponentTimestampDelimiter")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FORMAT_FIELD,
            COMPONENT_TIMESTAMP_DELIMITER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timestampFormat;

    private final String componentTimestampDelimiter;

    private InferenceInputNameConfiguration(BuilderImpl builder) {
        this.timestampFormat = builder.timestampFormat;
        this.componentTimestampDelimiter = builder.componentTimestampDelimiter;
    }

    /**
     * <p>
     * The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
     * </p>
     * 
     * @return The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
     */
    public final String timestampFormat() {
        return timestampFormat;
    }

    /**
     * <p>
     * Indicates the delimiter character used between items in the data.
     * </p>
     * 
     * @return Indicates the delimiter character used between items in the data.
     */
    public final String componentTimestampDelimiter() {
        return componentTimestampDelimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(componentTimestampDelimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceInputNameConfiguration)) {
            return false;
        }
        InferenceInputNameConfiguration other = (InferenceInputNameConfiguration) obj;
        return Objects.equals(timestampFormat(), other.timestampFormat())
                && Objects.equals(componentTimestampDelimiter(), other.componentTimestampDelimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceInputNameConfiguration").add("TimestampFormat", timestampFormat())
                .add("ComponentTimestampDelimiter", componentTimestampDelimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimestampFormat":
            return Optional.ofNullable(clazz.cast(timestampFormat()));
        case "ComponentTimestampDelimiter":
            return Optional.ofNullable(clazz.cast(componentTimestampDelimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TimestampFormat", TIMESTAMP_FORMAT_FIELD);
        map.put("ComponentTimestampDelimiter", COMPONENT_TIMESTAMP_DELIMITER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceInputNameConfiguration, T> g) {
        return obj -> g.apply((InferenceInputNameConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceInputNameConfiguration> {
        /**
         * <p>
         * The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
         * </p>
         * 
         * @param timestampFormat
         *        The format of the timestamp, whether Epoch time, or standard, with or without hyphens (-).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampFormat(String timestampFormat);

        /**
         * <p>
         * Indicates the delimiter character used between items in the data.
         * </p>
         * 
         * @param componentTimestampDelimiter
         *        Indicates the delimiter character used between items in the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder componentTimestampDelimiter(String componentTimestampDelimiter);
    }

    static final class BuilderImpl implements Builder {
        private String timestampFormat;

        private String componentTimestampDelimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceInputNameConfiguration model) {
            timestampFormat(model.timestampFormat);
            componentTimestampDelimiter(model.componentTimestampDelimiter);
        }

        public final String getTimestampFormat() {
            return timestampFormat;
        }

        public final void setTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
        }

        @Override
        public final Builder timestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public final String getComponentTimestampDelimiter() {
            return componentTimestampDelimiter;
        }

        public final void setComponentTimestampDelimiter(String componentTimestampDelimiter) {
            this.componentTimestampDelimiter = componentTimestampDelimiter;
        }

        @Override
        public final Builder componentTimestampDelimiter(String componentTimestampDelimiter) {
            this.componentTimestampDelimiter = componentTimestampDelimiter;
            return this;
        }

        @Override
        public InferenceInputNameConfiguration build() {
            return new InferenceInputNameConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
