/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the specific inference scheduler, including data delay offset, model name and ARN, status,
 * and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceSchedulerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceSchedulerSummary.Builder, InferenceSchedulerSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(InferenceSchedulerSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(InferenceSchedulerSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> INFERENCE_SCHEDULER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerName").getter(getter(InferenceSchedulerSummary::inferenceSchedulerName))
            .setter(setter(Builder::inferenceSchedulerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerName").build())
            .build();

    private static final SdkField<String> INFERENCE_SCHEDULER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InferenceSchedulerArn").getter(getter(InferenceSchedulerSummary::inferenceSchedulerArn))
            .setter(setter(Builder::inferenceSchedulerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InferenceSchedulerArn").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(InferenceSchedulerSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Long> DATA_DELAY_OFFSET_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataDelayOffsetInMinutes").getter(getter(InferenceSchedulerSummary::dataDelayOffsetInMinutes))
            .setter(setter(Builder::dataDelayOffsetInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataDelayOffsetInMinutes").build())
            .build();

    private static final SdkField<String> DATA_UPLOAD_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataUploadFrequency").getter(getter(InferenceSchedulerSummary::dataUploadFrequencyAsString))
            .setter(setter(Builder::dataUploadFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataUploadFrequency").build())
            .build();

    private static final SdkField<String> LATEST_INFERENCE_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestInferenceResult").getter(getter(InferenceSchedulerSummary::latestInferenceResultAsString))
            .setter(setter(Builder::latestInferenceResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestInferenceResult").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, INFERENCE_SCHEDULER_NAME_FIELD, INFERENCE_SCHEDULER_ARN_FIELD, STATUS_FIELD,
            DATA_DELAY_OFFSET_IN_MINUTES_FIELD, DATA_UPLOAD_FREQUENCY_FIELD, LATEST_INFERENCE_RESULT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final String inferenceSchedulerName;

    private final String inferenceSchedulerArn;

    private final String status;

    private final Long dataDelayOffsetInMinutes;

    private final String dataUploadFrequency;

    private final String latestInferenceResult;

    private InferenceSchedulerSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.inferenceSchedulerName = builder.inferenceSchedulerName;
        this.inferenceSchedulerArn = builder.inferenceSchedulerArn;
        this.status = builder.status;
        this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
        this.dataUploadFrequency = builder.dataUploadFrequency;
        this.latestInferenceResult = builder.latestInferenceResult;
    }

    /**
     * <p>
     * The name of the machine learning model used for the inference scheduler.
     * </p>
     * 
     * @return The name of the machine learning model used for the inference scheduler.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The name of the inference scheduler.
     * </p>
     * 
     * @return The name of the inference scheduler.
     */
    public final String inferenceSchedulerName() {
        return inferenceSchedulerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the inference scheduler.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the inference scheduler.
     */
    public final String inferenceSchedulerArn() {
        return inferenceSchedulerArn;
    }

    /**
     * <p>
     * Indicates the status of the inference scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference scheduler.
     * @see InferenceSchedulerStatus
     */
    public final InferenceSchedulerStatus status() {
        return InferenceSchedulerStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates the status of the inference scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link InferenceSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates the status of the inference scheduler.
     * @see InferenceSchedulerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance, if
     * an offset delay time of five minutes was selected, inference will not begin on the data until the first data
     * measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will
     * wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket.
     * The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when
     * uploading new data.
     * </p>
     * 
     * @return A period of time (in minutes) by which inference on the data is delayed after the data starts. For
     *         instance, if an offset delay time of five minutes was selected, inference will not begin on the data
     *         until the first data measurement after the five minute mark. For example, if five minutes is selected,
     *         the inference scheduler will wake up at the configured frequency with the additional five minute delay
     *         time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't
     *         need to stop and restart the scheduler when uploading new data.
     */
    public final Long dataDelayOffsetInMinutes() {
        return dataDelayOffsetInMinutes;
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. This value is the length of time between
     * data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data
     * to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment
     * starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. This value is the length of time
     *         between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     *         real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
     *         Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
     *         minutes.
     * @see DataUploadFrequency
     */
    public final DataUploadFrequency dataUploadFrequency() {
        return DataUploadFrequency.fromValue(dataUploadFrequency);
    }

    /**
     * <p>
     * How often data is uploaded to the source S3 bucket for the input data. This value is the length of time between
     * data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data
     * to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment
     * starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #dataUploadFrequency} will return {@link DataUploadFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #dataUploadFrequencyAsString}.
     * </p>
     * 
     * @return How often data is uploaded to the source S3 bucket for the input data. This value is the length of time
     *         between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
     *         real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
     *         Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
     *         minutes.
     * @see DataUploadFrequency
     */
    public final String dataUploadFrequencyAsString() {
        return dataUploadFrequency;
    }

    /**
     * <p>
     * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
     * Normal (no anomalous events found).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestInferenceResult} will return {@link LatestInferenceResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestInferenceResultAsString}.
     * </p>
     * 
     * @return Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found)
     *         or Normal (no anomalous events found).
     * @see LatestInferenceResult
     */
    public final LatestInferenceResult latestInferenceResult() {
        return LatestInferenceResult.fromValue(latestInferenceResult);
    }

    /**
     * <p>
     * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
     * Normal (no anomalous events found).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestInferenceResult} will return {@link LatestInferenceResult#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestInferenceResultAsString}.
     * </p>
     * 
     * @return Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found)
     *         or Normal (no anomalous events found).
     * @see LatestInferenceResult
     */
    public final String latestInferenceResultAsString() {
        return latestInferenceResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerName());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceSchedulerArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataDelayOffsetInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(dataUploadFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestInferenceResultAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceSchedulerSummary)) {
            return false;
        }
        InferenceSchedulerSummary other = (InferenceSchedulerSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(inferenceSchedulerName(), other.inferenceSchedulerName())
                && Objects.equals(inferenceSchedulerArn(), other.inferenceSchedulerArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(dataDelayOffsetInMinutes(), other.dataDelayOffsetInMinutes())
                && Objects.equals(dataUploadFrequencyAsString(), other.dataUploadFrequencyAsString())
                && Objects.equals(latestInferenceResultAsString(), other.latestInferenceResultAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceSchedulerSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("InferenceSchedulerName", inferenceSchedulerName()).add("InferenceSchedulerArn", inferenceSchedulerArn())
                .add("Status", statusAsString()).add("DataDelayOffsetInMinutes", dataDelayOffsetInMinutes())
                .add("DataUploadFrequency", dataUploadFrequencyAsString())
                .add("LatestInferenceResult", latestInferenceResultAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "InferenceSchedulerName":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerName()));
        case "InferenceSchedulerArn":
            return Optional.ofNullable(clazz.cast(inferenceSchedulerArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "DataDelayOffsetInMinutes":
            return Optional.ofNullable(clazz.cast(dataDelayOffsetInMinutes()));
        case "DataUploadFrequency":
            return Optional.ofNullable(clazz.cast(dataUploadFrequencyAsString()));
        case "LatestInferenceResult":
            return Optional.ofNullable(clazz.cast(latestInferenceResultAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("InferenceSchedulerName", INFERENCE_SCHEDULER_NAME_FIELD);
        map.put("InferenceSchedulerArn", INFERENCE_SCHEDULER_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("DataDelayOffsetInMinutes", DATA_DELAY_OFFSET_IN_MINUTES_FIELD);
        map.put("DataUploadFrequency", DATA_UPLOAD_FREQUENCY_FIELD);
        map.put("LatestInferenceResult", LATEST_INFERENCE_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceSchedulerSummary, T> g) {
        return obj -> g.apply((InferenceSchedulerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceSchedulerSummary> {
        /**
         * <p>
         * The name of the machine learning model used for the inference scheduler.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model used for the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the machine learning model used by the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The name of the inference scheduler.
         * </p>
         * 
         * @param inferenceSchedulerName
         *        The name of the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerName(String inferenceSchedulerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the inference scheduler.
         * </p>
         * 
         * @param inferenceSchedulerArn
         *        The Amazon Resource Name (ARN) of the inference scheduler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceSchedulerArn(String inferenceSchedulerArn);

        /**
         * <p>
         * Indicates the status of the inference scheduler.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference scheduler.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates the status of the inference scheduler.
         * </p>
         * 
         * @param status
         *        Indicates the status of the inference scheduler.
         * @see InferenceSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InferenceSchedulerStatus
         */
        Builder status(InferenceSchedulerStatus status);

        /**
         * <p>
         * A period of time (in minutes) by which inference on the data is delayed after the data starts. For instance,
         * if an offset delay time of five minutes was selected, inference will not begin on the data until the first
         * data measurement after the five minute mark. For example, if five minutes is selected, the inference
         * scheduler will wake up at the configured frequency with the additional five minute delay time to check the
         * customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and
         * restart the scheduler when uploading new data.
         * </p>
         * 
         * @param dataDelayOffsetInMinutes
         *        A period of time (in minutes) by which inference on the data is delayed after the data starts. For
         *        instance, if an offset delay time of five minutes was selected, inference will not begin on the data
         *        until the first data measurement after the five minute mark. For example, if five minutes is selected,
         *        the inference scheduler will wake up at the configured frequency with the additional five minute delay
         *        time to check the customer S3 bucket. The customer can upload data at the same frequency and they
         *        don't need to stop and restart the scheduler when uploading new data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. This value is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. This value is the length of
         *        time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(String dataUploadFrequency);

        /**
         * <p>
         * How often data is uploaded to the source S3 bucket for the input data. This value is the length of time
         * between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the
         * real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon
         * Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5
         * minutes.
         * </p>
         * 
         * @param dataUploadFrequency
         *        How often data is uploaded to the source S3 bucket for the input data. This value is the length of
         *        time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will
         *        upload the real-time data to the source bucket once every 5 minutes. This frequency also determines
         *        how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it
         *        starts once every 5 minutes.
         * @see DataUploadFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataUploadFrequency
         */
        Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency);

        /**
         * <p>
         * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
         * Normal (no anomalous events found).
         * </p>
         * 
         * @param latestInferenceResult
         *        Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events
         *        found) or Normal (no anomalous events found).
         * @see LatestInferenceResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LatestInferenceResult
         */
        Builder latestInferenceResult(String latestInferenceResult);

        /**
         * <p>
         * Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events found) or
         * Normal (no anomalous events found).
         * </p>
         * 
         * @param latestInferenceResult
         *        Indicates whether the latest execution for the inference scheduler was Anomalous (anomalous events
         *        found) or Normal (no anomalous events found).
         * @see LatestInferenceResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LatestInferenceResult
         */
        Builder latestInferenceResult(LatestInferenceResult latestInferenceResult);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String inferenceSchedulerName;

        private String inferenceSchedulerArn;

        private String status;

        private Long dataDelayOffsetInMinutes;

        private String dataUploadFrequency;

        private String latestInferenceResult;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceSchedulerSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            inferenceSchedulerName(model.inferenceSchedulerName);
            inferenceSchedulerArn(model.inferenceSchedulerArn);
            status(model.status);
            dataDelayOffsetInMinutes(model.dataDelayOffsetInMinutes);
            dataUploadFrequency(model.dataUploadFrequency);
            latestInferenceResult(model.latestInferenceResult);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getInferenceSchedulerName() {
            return inferenceSchedulerName;
        }

        public final void setInferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
        }

        @Override
        public final Builder inferenceSchedulerName(String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        public final String getInferenceSchedulerArn() {
            return inferenceSchedulerArn;
        }

        public final void setInferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
        }

        @Override
        public final Builder inferenceSchedulerArn(String inferenceSchedulerArn) {
            this.inferenceSchedulerArn = inferenceSchedulerArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(InferenceSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Long getDataDelayOffsetInMinutes() {
            return dataDelayOffsetInMinutes;
        }

        public final void setDataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
        }

        @Override
        public final Builder dataDelayOffsetInMinutes(Long dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        public final String getDataUploadFrequency() {
            return dataUploadFrequency;
        }

        public final void setDataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
        }

        @Override
        public final Builder dataUploadFrequency(String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        @Override
        public final Builder dataUploadFrequency(DataUploadFrequency dataUploadFrequency) {
            this.dataUploadFrequency(dataUploadFrequency == null ? null : dataUploadFrequency.toString());
            return this;
        }

        public final String getLatestInferenceResult() {
            return latestInferenceResult;
        }

        public final void setLatestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
        }

        @Override
        public final Builder latestInferenceResult(String latestInferenceResult) {
            this.latestInferenceResult = latestInferenceResult;
            return this;
        }

        @Override
        public final Builder latestInferenceResult(LatestInferenceResult latestInferenceResult) {
            this.latestInferenceResult(latestInferenceResult == null ? null : latestInferenceResult.toString());
            return this;
        }

        @Override
        public InferenceSchedulerSummary build() {
            return new InferenceSchedulerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
