/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies S3 configuration information for the input data for the data ingestion job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestionS3InputConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IngestionS3InputConfiguration.Builder, IngestionS3InputConfiguration> {
    private static final SdkField<String> BUCKET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Bucket")
            .getter(getter(IngestionS3InputConfiguration::bucket)).setter(setter(Builder::bucket))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bucket").build()).build();

    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(IngestionS3InputConfiguration::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> KEY_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyPattern").getter(getter(IngestionS3InputConfiguration::keyPattern))
            .setter(setter(Builder::keyPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyPattern").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUCKET_FIELD, PREFIX_FIELD,
            KEY_PATTERN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String bucket;

    private final String prefix;

    private final String keyPattern;

    private IngestionS3InputConfiguration(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.prefix = builder.prefix;
        this.keyPattern = builder.keyPattern;
    }

    /**
     * <p>
     * The name of the S3 bucket used for the input data for the data ingestion.
     * </p>
     * 
     * @return The name of the S3 bucket used for the input data for the data ingestion.
     */
    public final String bucket() {
        return bucket;
    }

    /**
     * <p>
     * The prefix for the S3 location being used for the input data for the data ingestion.
     * </p>
     * 
     * @return The prefix for the S3 location being used for the input data for the data ingestion.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * The pattern for matching the Amazon S3 files that will be used for ingestion. If the schema was created
     * previously without any KeyPattern, then the default KeyPattern {prefix}/{component_name}/* is used to download
     * files from Amazon S3 according to the schema. This field is required when ingestion is being done for the first
     * time.
     * </p>
     * <p>
     * Valid Values: {prefix}/{component_name}_* | {prefix}/{component_name}/* | {prefix}/{component_name}[DELIMITER]*
     * (Allowed delimiters : space, dot, underscore, hyphen)
     * </p>
     * 
     * @return The pattern for matching the Amazon S3 files that will be used for ingestion. If the schema was created
     *         previously without any KeyPattern, then the default KeyPattern {prefix}/{component_name}/* is used to
     *         download files from Amazon S3 according to the schema. This field is required when ingestion is being
     *         done for the first time.</p>
     *         <p>
     *         Valid Values: {prefix}/{component_name}_* | {prefix}/{component_name}/* |
     *         {prefix}/{component_name}[DELIMITER]* (Allowed delimiters : space, dot, underscore, hyphen)
     */
    public final String keyPattern() {
        return keyPattern;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bucket());
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(keyPattern());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionS3InputConfiguration)) {
            return false;
        }
        IngestionS3InputConfiguration other = (IngestionS3InputConfiguration) obj;
        return Objects.equals(bucket(), other.bucket()) && Objects.equals(prefix(), other.prefix())
                && Objects.equals(keyPattern(), other.keyPattern());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestionS3InputConfiguration").add("Bucket", bucket()).add("Prefix", prefix())
                .add("KeyPattern", keyPattern()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bucket":
            return Optional.ofNullable(clazz.cast(bucket()));
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "KeyPattern":
            return Optional.ofNullable(clazz.cast(keyPattern()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bucket", BUCKET_FIELD);
        map.put("Prefix", PREFIX_FIELD);
        map.put("KeyPattern", KEY_PATTERN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestionS3InputConfiguration, T> g) {
        return obj -> g.apply((IngestionS3InputConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IngestionS3InputConfiguration> {
        /**
         * <p>
         * The name of the S3 bucket used for the input data for the data ingestion.
         * </p>
         * 
         * @param bucket
         *        The name of the S3 bucket used for the input data for the data ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucket(String bucket);

        /**
         * <p>
         * The prefix for the S3 location being used for the input data for the data ingestion.
         * </p>
         * 
         * @param prefix
         *        The prefix for the S3 location being used for the input data for the data ingestion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * The pattern for matching the Amazon S3 files that will be used for ingestion. If the schema was created
         * previously without any KeyPattern, then the default KeyPattern {prefix}/{component_name}/* is used to
         * download files from Amazon S3 according to the schema. This field is required when ingestion is being done
         * for the first time.
         * </p>
         * <p>
         * Valid Values: {prefix}/{component_name}_* | {prefix}/{component_name}/* |
         * {prefix}/{component_name}[DELIMITER]* (Allowed delimiters : space, dot, underscore, hyphen)
         * </p>
         * 
         * @param keyPattern
         *        The pattern for matching the Amazon S3 files that will be used for ingestion. If the schema was
         *        created previously without any KeyPattern, then the default KeyPattern {prefix}/{component_name}/* is
         *        used to download files from Amazon S3 according to the schema. This field is required when ingestion
         *        is being done for the first time.</p>
         *        <p>
         *        Valid Values: {prefix}/{component_name}_* | {prefix}/{component_name}/* |
         *        {prefix}/{component_name}[DELIMITER]* (Allowed delimiters : space, dot, underscore, hyphen)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyPattern(String keyPattern);
    }

    static final class BuilderImpl implements Builder {
        private String bucket;

        private String prefix;

        private String keyPattern;

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionS3InputConfiguration model) {
            bucket(model.bucket);
            prefix(model.prefix);
            keyPattern(model.keyPattern);
        }

        public final String getBucket() {
            return bucket;
        }

        public final void setBucket(String bucket) {
            this.bucket = bucket;
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getKeyPattern() {
            return keyPattern;
        }

        public final void setKeyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
        }

        @Override
        public final Builder keyPattern(String keyPattern) {
            this.keyPattern = keyPattern;
            return this;
        }

        @Override
        public IngestionS3InputConfiguration build() {
            return new IngestionS3InputConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
