/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDataIngestionJobsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListDataIngestionJobsResponse.Builder, ListDataIngestionJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListDataIngestionJobsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<DataIngestionJobSummary>> DATA_INGESTION_JOB_SUMMARIES_FIELD = SdkField
            .<List<DataIngestionJobSummary>> builder(MarshallingType.LIST)
            .memberName("DataIngestionJobSummaries")
            .getter(getter(ListDataIngestionJobsResponse::dataIngestionJobSummaries))
            .setter(setter(Builder::dataIngestionJobSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataIngestionJobSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataIngestionJobSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataIngestionJobSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            DATA_INGESTION_JOB_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<DataIngestionJobSummary> dataIngestionJobSummaries;

    private ListDataIngestionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dataIngestionJobSummaries = builder.dataIngestionJobSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of data ingestion jobs.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of data ingestion jobs.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataIngestionJobSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDataIngestionJobSummaries() {
        return dataIngestionJobSummaries != null && !(dataIngestionJobSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies information about the specific data ingestion job, including dataset name and status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataIngestionJobSummaries} method.
     * </p>
     * 
     * @return Specifies information about the specific data ingestion job, including dataset name and status.
     */
    public final List<DataIngestionJobSummary> dataIngestionJobSummaries() {
        return dataIngestionJobSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataIngestionJobSummaries() ? dataIngestionJobSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataIngestionJobsResponse)) {
            return false;
        }
        ListDataIngestionJobsResponse other = (ListDataIngestionJobsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasDataIngestionJobSummaries() == other.hasDataIngestionJobSummaries()
                && Objects.equals(dataIngestionJobSummaries(), other.dataIngestionJobSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListDataIngestionJobsResponse").add("NextToken", nextToken())
                .add("DataIngestionJobSummaries", hasDataIngestionJobSummaries() ? dataIngestionJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "DataIngestionJobSummaries":
            return Optional.ofNullable(clazz.cast(dataIngestionJobSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("DataIngestionJobSummaries", DATA_INGESTION_JOB_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataIngestionJobsResponse, T> g) {
        return obj -> g.apply((ListDataIngestionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListDataIngestionJobsResponse> {
        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of data ingestion jobs.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of data ingestion jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies information about the specific data ingestion job, including dataset name and status.
         * </p>
         * 
         * @param dataIngestionJobSummaries
         *        Specifies information about the specific data ingestion job, including dataset name and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIngestionJobSummaries(Collection<DataIngestionJobSummary> dataIngestionJobSummaries);

        /**
         * <p>
         * Specifies information about the specific data ingestion job, including dataset name and status.
         * </p>
         * 
         * @param dataIngestionJobSummaries
         *        Specifies information about the specific data ingestion job, including dataset name and status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataIngestionJobSummaries(DataIngestionJobSummary... dataIngestionJobSummaries);

        /**
         * <p>
         * Specifies information about the specific data ingestion job, including dataset name and status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #dataIngestionJobSummaries(List<DataIngestionJobSummary>)}.
         * 
         * @param dataIngestionJobSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.DataIngestionJobSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataIngestionJobSummaries(java.util.Collection<DataIngestionJobSummary>)
         */
        Builder dataIngestionJobSummaries(Consumer<DataIngestionJobSummary.Builder>... dataIngestionJobSummaries);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<DataIngestionJobSummary> dataIngestionJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataIngestionJobsResponse model) {
            super(model);
            nextToken(model.nextToken);
            dataIngestionJobSummaries(model.dataIngestionJobSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DataIngestionJobSummary.Builder> getDataIngestionJobSummaries() {
            List<DataIngestionJobSummary.Builder> result = DataIngestionJobSummariesCopier
                    .copyToBuilder(this.dataIngestionJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataIngestionJobSummaries(Collection<DataIngestionJobSummary.BuilderImpl> dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries = DataIngestionJobSummariesCopier.copyFromBuilder(dataIngestionJobSummaries);
        }

        @Override
        public final Builder dataIngestionJobSummaries(Collection<DataIngestionJobSummary> dataIngestionJobSummaries) {
            this.dataIngestionJobSummaries = DataIngestionJobSummariesCopier.copy(dataIngestionJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataIngestionJobSummaries(DataIngestionJobSummary... dataIngestionJobSummaries) {
            dataIngestionJobSummaries(Arrays.asList(dataIngestionJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataIngestionJobSummaries(Consumer<DataIngestionJobSummary.Builder>... dataIngestionJobSummaries) {
            dataIngestionJobSummaries(Stream.of(dataIngestionJobSummaries)
                    .map(c -> DataIngestionJobSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDataIngestionJobsResponse build() {
            return new ListDataIngestionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
