/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelVersionsRequest extends LookoutEquipmentRequest implements
        ToCopyableBuilder<ListModelVersionsRequest.Builder, ListModelVersionsRequest> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(ListModelVersionsRequest::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelVersionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListModelVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListModelVersionsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceType").getter(getter(ListModelVersionsRequest::sourceTypeAsString))
            .setter(setter(Builder::sourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceType").build()).build();

    private static final SdkField<Instant> CREATED_AT_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAtEndTime").getter(getter(ListModelVersionsRequest::createdAtEndTime))
            .setter(setter(Builder::createdAtEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAtEndTime").build()).build();

    private static final SdkField<Instant> CREATED_AT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAtStartTime").getter(getter(ListModelVersionsRequest::createdAtStartTime))
            .setter(setter(Builder::createdAtStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAtStartTime").build())
            .build();

    private static final SdkField<Long> MAX_MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MaxModelVersion").getter(getter(ListModelVersionsRequest::maxModelVersion))
            .setter(setter(Builder::maxModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxModelVersion").build()).build();

    private static final SdkField<Long> MIN_MODEL_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MinModelVersion").getter(getter(ListModelVersionsRequest::minModelVersion))
            .setter(setter(Builder::minModelVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinModelVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD, SOURCE_TYPE_FIELD, CREATED_AT_END_TIME_FIELD,
            CREATED_AT_START_TIME_FIELD, MAX_MODEL_VERSION_FIELD, MIN_MODEL_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelName;

    private final String nextToken;

    private final Integer maxResults;

    private final String status;

    private final String sourceType;

    private final Instant createdAtEndTime;

    private final Instant createdAtStartTime;

    private final Long maxModelVersion;

    private final Long minModelVersion;

    private ListModelVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
        this.sourceType = builder.sourceType;
        this.createdAtEndTime = builder.createdAtEndTime;
        this.createdAtStartTime = builder.createdAtStartTime;
        this.maxModelVersion = builder.maxModelVersion;
        this.minModelVersion = builder.minModelVersion;
    }

    /**
     * <p>
     * Then name of the machine learning model for which the model versions are to be listed.
     * </p>
     * 
     * @return Then name of the machine learning model for which the model versions are to be listed.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * If the total number of results exceeds the limit that the response can display, the response returns an opaque
     * pagination token indicating where to continue the listing of machine learning model versions. Use this token in
     * the <code>NextToken</code> field in the request to list the next page of results.
     * </p>
     * 
     * @return If the total number of results exceeds the limit that the response can display, the response returns an
     *         opaque pagination token indicating where to continue the listing of machine learning model versions. Use
     *         this token in the <code>NextToken</code> field in the request to list the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the maximum number of machine learning model versions to list.
     * </p>
     * 
     * @return Specifies the maximum number of machine learning model versions to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filter the results based on the current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Filter the results based on the current status of the model version.
     * @see ModelVersionStatus
     */
    public final ModelVersionStatus status() {
        return ModelVersionStatus.fromValue(status);
    }

    /**
     * <p>
     * Filter the results based on the current status of the model version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelVersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return Filter the results based on the current status of the model version.
     * @see ModelVersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filter the results based on the way the model version was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Filter the results based on the way the model version was generated.
     * @see ModelVersionSourceType
     */
    public final ModelVersionSourceType sourceType() {
        return ModelVersionSourceType.fromValue(sourceType);
    }

    /**
     * <p>
     * Filter the results based on the way the model version was generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceType} will
     * return {@link ModelVersionSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #sourceTypeAsString}.
     * </p>
     * 
     * @return Filter the results based on the way the model version was generated.
     * @see ModelVersionSourceType
     */
    public final String sourceTypeAsString() {
        return sourceType;
    }

    /**
     * <p>
     * Filter results to return all the model versions created before this time.
     * </p>
     * 
     * @return Filter results to return all the model versions created before this time.
     */
    public final Instant createdAtEndTime() {
        return createdAtEndTime;
    }

    /**
     * <p>
     * Filter results to return all the model versions created after this time.
     * </p>
     * 
     * @return Filter results to return all the model versions created after this time.
     */
    public final Instant createdAtStartTime() {
        return createdAtStartTime;
    }

    /**
     * <p>
     * Specifies the highest version of the model to return in the list.
     * </p>
     * 
     * @return Specifies the highest version of the model to return in the list.
     */
    public final Long maxModelVersion() {
        return maxModelVersion;
    }

    /**
     * <p>
     * Specifies the lowest version of the model to return in the list.
     * </p>
     * 
     * @return Specifies the lowest version of the model to return in the list.
     */
    public final Long minModelVersion() {
        return minModelVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAtEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdAtStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(minModelVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelVersionsRequest)) {
            return false;
        }
        ListModelVersionsRequest other = (ListModelVersionsRequest) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sourceTypeAsString(), other.sourceTypeAsString())
                && Objects.equals(createdAtEndTime(), other.createdAtEndTime())
                && Objects.equals(createdAtStartTime(), other.createdAtStartTime())
                && Objects.equals(maxModelVersion(), other.maxModelVersion())
                && Objects.equals(minModelVersion(), other.minModelVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelVersionsRequest").add("ModelName", modelName()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("Status", statusAsString()).add("SourceType", sourceTypeAsString())
                .add("CreatedAtEndTime", createdAtEndTime()).add("CreatedAtStartTime", createdAtStartTime())
                .add("MaxModelVersion", maxModelVersion()).add("MinModelVersion", minModelVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SourceType":
            return Optional.ofNullable(clazz.cast(sourceTypeAsString()));
        case "CreatedAtEndTime":
            return Optional.ofNullable(clazz.cast(createdAtEndTime()));
        case "CreatedAtStartTime":
            return Optional.ofNullable(clazz.cast(createdAtStartTime()));
        case "MaxModelVersion":
            return Optional.ofNullable(clazz.cast(maxModelVersion()));
        case "MinModelVersion":
            return Optional.ofNullable(clazz.cast(minModelVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SourceType", SOURCE_TYPE_FIELD);
        map.put("CreatedAtEndTime", CREATED_AT_END_TIME_FIELD);
        map.put("CreatedAtStartTime", CREATED_AT_START_TIME_FIELD);
        map.put("MaxModelVersion", MAX_MODEL_VERSION_FIELD);
        map.put("MinModelVersion", MIN_MODEL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelVersionsRequest, T> g) {
        return obj -> g.apply((ListModelVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListModelVersionsRequest> {
        /**
         * <p>
         * Then name of the machine learning model for which the model versions are to be listed.
         * </p>
         * 
         * @param modelName
         *        Then name of the machine learning model for which the model versions are to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * If the total number of results exceeds the limit that the response can display, the response returns an
         * opaque pagination token indicating where to continue the listing of machine learning model versions. Use this
         * token in the <code>NextToken</code> field in the request to list the next page of results.
         * </p>
         * 
         * @param nextToken
         *        If the total number of results exceeds the limit that the response can display, the response returns
         *        an opaque pagination token indicating where to continue the listing of machine learning model
         *        versions. Use this token in the <code>NextToken</code> field in the request to list the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the maximum number of machine learning model versions to list.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of machine learning model versions to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filter the results based on the current status of the model version.
         * </p>
         * 
         * @param status
         *        Filter the results based on the current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filter the results based on the current status of the model version.
         * </p>
         * 
         * @param status
         *        Filter the results based on the current status of the model version.
         * @see ModelVersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionStatus
         */
        Builder status(ModelVersionStatus status);

        /**
         * <p>
         * Filter the results based on the way the model version was generated.
         * </p>
         * 
         * @param sourceType
         *        Filter the results based on the way the model version was generated.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(String sourceType);

        /**
         * <p>
         * Filter the results based on the way the model version was generated.
         * </p>
         * 
         * @param sourceType
         *        Filter the results based on the way the model version was generated.
         * @see ModelVersionSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelVersionSourceType
         */
        Builder sourceType(ModelVersionSourceType sourceType);

        /**
         * <p>
         * Filter results to return all the model versions created before this time.
         * </p>
         * 
         * @param createdAtEndTime
         *        Filter results to return all the model versions created before this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAtEndTime(Instant createdAtEndTime);

        /**
         * <p>
         * Filter results to return all the model versions created after this time.
         * </p>
         * 
         * @param createdAtStartTime
         *        Filter results to return all the model versions created after this time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAtStartTime(Instant createdAtStartTime);

        /**
         * <p>
         * Specifies the highest version of the model to return in the list.
         * </p>
         * 
         * @param maxModelVersion
         *        Specifies the highest version of the model to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxModelVersion(Long maxModelVersion);

        /**
         * <p>
         * Specifies the lowest version of the model to return in the list.
         * </p>
         * 
         * @param minModelVersion
         *        Specifies the lowest version of the model to return in the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minModelVersion(Long minModelVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutEquipmentRequest.BuilderImpl implements Builder {
        private String modelName;

        private String nextToken;

        private Integer maxResults;

        private String status;

        private String sourceType;

        private Instant createdAtEndTime;

        private Instant createdAtStartTime;

        private Long maxModelVersion;

        private Long minModelVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelVersionsRequest model) {
            super(model);
            modelName(model.modelName);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            status(model.status);
            sourceType(model.sourceType);
            createdAtEndTime(model.createdAtEndTime);
            createdAtStartTime(model.createdAtStartTime);
            maxModelVersion(model.maxModelVersion);
            minModelVersion(model.minModelVersion);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelVersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSourceType() {
            return sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ModelVersionSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public final Instant getCreatedAtEndTime() {
            return createdAtEndTime;
        }

        public final void setCreatedAtEndTime(Instant createdAtEndTime) {
            this.createdAtEndTime = createdAtEndTime;
        }

        @Override
        public final Builder createdAtEndTime(Instant createdAtEndTime) {
            this.createdAtEndTime = createdAtEndTime;
            return this;
        }

        public final Instant getCreatedAtStartTime() {
            return createdAtStartTime;
        }

        public final void setCreatedAtStartTime(Instant createdAtStartTime) {
            this.createdAtStartTime = createdAtStartTime;
        }

        @Override
        public final Builder createdAtStartTime(Instant createdAtStartTime) {
            this.createdAtStartTime = createdAtStartTime;
            return this;
        }

        public final Long getMaxModelVersion() {
            return maxModelVersion;
        }

        public final void setMaxModelVersion(Long maxModelVersion) {
            this.maxModelVersion = maxModelVersion;
        }

        @Override
        public final Builder maxModelVersion(Long maxModelVersion) {
            this.maxModelVersion = maxModelVersion;
            return this;
        }

        public final Long getMinModelVersion() {
            return minModelVersion;
        }

        public final void setMinModelVersion(Long minModelVersion) {
            this.minModelVersion = minModelVersion;
        }

        @Override
        public final Builder minModelVersion(Long minModelVersion) {
            this.minModelVersion = minModelVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListModelVersionsRequest build() {
            return new ListModelVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
