/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSensorStatisticsResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<ListSensorStatisticsResponse.Builder, ListSensorStatisticsResponse> {
    private static final SdkField<List<SensorStatisticsSummary>> SENSOR_STATISTICS_SUMMARIES_FIELD = SdkField
            .<List<SensorStatisticsSummary>> builder(MarshallingType.LIST)
            .memberName("SensorStatisticsSummaries")
            .getter(getter(ListSensorStatisticsResponse::sensorStatisticsSummaries))
            .setter(setter(Builder::sensorStatisticsSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SensorStatisticsSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SensorStatisticsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SensorStatisticsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSensorStatisticsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SENSOR_STATISTICS_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<SensorStatisticsSummary> sensorStatisticsSummaries;

    private final String nextToken;

    private ListSensorStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.sensorStatisticsSummaries = builder.sensorStatisticsSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SensorStatisticsSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSensorStatisticsSummaries() {
        return sensorStatisticsSummaries != null && !(sensorStatisticsSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides ingestion-based statistics regarding the specified sensor with respect to various validation types, such
     * as whether data exists, the number and percentage of missing values, and the number and percentage of duplicate
     * timestamps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSensorStatisticsSummaries} method.
     * </p>
     * 
     * @return Provides ingestion-based statistics regarding the specified sensor with respect to various validation
     *         types, such as whether data exists, the number and percentage of missing values, and the number and
     *         percentage of duplicate timestamps.
     */
    public final List<SensorStatisticsSummary> sensorStatisticsSummaries() {
        return sensorStatisticsSummaries;
    }

    /**
     * <p>
     * An opaque pagination token indicating where to continue the listing of sensor statistics.
     * </p>
     * 
     * @return An opaque pagination token indicating where to continue the listing of sensor statistics.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSensorStatisticsSummaries() ? sensorStatisticsSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSensorStatisticsResponse)) {
            return false;
        }
        ListSensorStatisticsResponse other = (ListSensorStatisticsResponse) obj;
        return hasSensorStatisticsSummaries() == other.hasSensorStatisticsSummaries()
                && Objects.equals(sensorStatisticsSummaries(), other.sensorStatisticsSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSensorStatisticsResponse")
                .add("SensorStatisticsSummaries", hasSensorStatisticsSummaries() ? sensorStatisticsSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SensorStatisticsSummaries":
            return Optional.ofNullable(clazz.cast(sensorStatisticsSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SensorStatisticsSummaries", SENSOR_STATISTICS_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSensorStatisticsResponse, T> g) {
        return obj -> g.apply((ListSensorStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSensorStatisticsResponse> {
        /**
         * <p>
         * Provides ingestion-based statistics regarding the specified sensor with respect to various validation types,
         * such as whether data exists, the number and percentage of missing values, and the number and percentage of
         * duplicate timestamps.
         * </p>
         * 
         * @param sensorStatisticsSummaries
         *        Provides ingestion-based statistics regarding the specified sensor with respect to various validation
         *        types, such as whether data exists, the number and percentage of missing values, and the number and
         *        percentage of duplicate timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensorStatisticsSummaries(Collection<SensorStatisticsSummary> sensorStatisticsSummaries);

        /**
         * <p>
         * Provides ingestion-based statistics regarding the specified sensor with respect to various validation types,
         * such as whether data exists, the number and percentage of missing values, and the number and percentage of
         * duplicate timestamps.
         * </p>
         * 
         * @param sensorStatisticsSummaries
         *        Provides ingestion-based statistics regarding the specified sensor with respect to various validation
         *        types, such as whether data exists, the number and percentage of missing values, and the number and
         *        percentage of duplicate timestamps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sensorStatisticsSummaries(SensorStatisticsSummary... sensorStatisticsSummaries);

        /**
         * <p>
         * Provides ingestion-based statistics regarding the specified sensor with respect to various validation types,
         * such as whether data exists, the number and percentage of missing values, and the number and percentage of
         * duplicate timestamps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #sensorStatisticsSummaries(List<SensorStatisticsSummary>)}.
         * 
         * @param sensorStatisticsSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lookoutequipment.model.SensorStatisticsSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sensorStatisticsSummaries(java.util.Collection<SensorStatisticsSummary>)
         */
        Builder sensorStatisticsSummaries(Consumer<SensorStatisticsSummary.Builder>... sensorStatisticsSummaries);

        /**
         * <p>
         * An opaque pagination token indicating where to continue the listing of sensor statistics.
         * </p>
         * 
         * @param nextToken
         *        An opaque pagination token indicating where to continue the listing of sensor statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private List<SensorStatisticsSummary> sensorStatisticsSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSensorStatisticsResponse model) {
            super(model);
            sensorStatisticsSummaries(model.sensorStatisticsSummaries);
            nextToken(model.nextToken);
        }

        public final List<SensorStatisticsSummary.Builder> getSensorStatisticsSummaries() {
            List<SensorStatisticsSummary.Builder> result = SensorStatisticsSummariesCopier
                    .copyToBuilder(this.sensorStatisticsSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSensorStatisticsSummaries(Collection<SensorStatisticsSummary.BuilderImpl> sensorStatisticsSummaries) {
            this.sensorStatisticsSummaries = SensorStatisticsSummariesCopier.copyFromBuilder(sensorStatisticsSummaries);
        }

        @Override
        public final Builder sensorStatisticsSummaries(Collection<SensorStatisticsSummary> sensorStatisticsSummaries) {
            this.sensorStatisticsSummaries = SensorStatisticsSummariesCopier.copy(sensorStatisticsSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensorStatisticsSummaries(SensorStatisticsSummary... sensorStatisticsSummaries) {
            sensorStatisticsSummaries(Arrays.asList(sensorStatisticsSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sensorStatisticsSummaries(Consumer<SensorStatisticsSummary.Builder>... sensorStatisticsSummaries) {
            sensorStatisticsSummaries(Stream.of(sensorStatisticsSummaries)
                    .map(c -> SensorStatisticsSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSensorStatisticsResponse build() {
            return new ListSensorStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
