/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises information on sensors that have sensor data completely missing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MissingCompleteSensorData implements SdkPojo, Serializable,
        ToCopyableBuilder<MissingCompleteSensorData.Builder, MissingCompleteSensorData> {
    private static final SdkField<Integer> AFFECTED_SENSOR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AffectedSensorCount").getter(getter(MissingCompleteSensorData::affectedSensorCount))
            .setter(setter(Builder::affectedSensorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AffectedSensorCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AFFECTED_SENSOR_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer affectedSensorCount;

    private MissingCompleteSensorData(BuilderImpl builder) {
        this.affectedSensorCount = builder.affectedSensorCount;
    }

    /**
     * <p>
     * Indicates the number of sensors that have data missing completely.
     * </p>
     * 
     * @return Indicates the number of sensors that have data missing completely.
     */
    public final Integer affectedSensorCount() {
        return affectedSensorCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(affectedSensorCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MissingCompleteSensorData)) {
            return false;
        }
        MissingCompleteSensorData other = (MissingCompleteSensorData) obj;
        return Objects.equals(affectedSensorCount(), other.affectedSensorCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MissingCompleteSensorData").add("AffectedSensorCount", affectedSensorCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AffectedSensorCount":
            return Optional.ofNullable(clazz.cast(affectedSensorCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AffectedSensorCount", AFFECTED_SENSOR_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MissingCompleteSensorData, T> g) {
        return obj -> g.apply((MissingCompleteSensorData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MissingCompleteSensorData> {
        /**
         * <p>
         * Indicates the number of sensors that have data missing completely.
         * </p>
         * 
         * @param affectedSensorCount
         *        Indicates the number of sensors that have data missing completely.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder affectedSensorCount(Integer affectedSensorCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer affectedSensorCount;

        private BuilderImpl() {
        }

        private BuilderImpl(MissingCompleteSensorData model) {
            affectedSensorCount(model.affectedSensorCount);
        }

        public final Integer getAffectedSensorCount() {
            return affectedSensorCount;
        }

        public final void setAffectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
        }

        @Override
        public final Builder affectedSensorCount(Integer affectedSensorCount) {
            this.affectedSensorCount = affectedSensorCount;
            return this;
        }

        @Override
        public MissingCompleteSensorData build() {
            return new MissingCompleteSensorData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
