/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Entity that comprises information on monotonic values in the data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MonotonicValues implements SdkPojo, Serializable, ToCopyableBuilder<MonotonicValues.Builder, MonotonicValues> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MonotonicValues::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MONOTONICITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Monotonicity").getter(getter(MonotonicValues::monotonicityAsString))
            .setter(setter(Builder::monotonicity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monotonicity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            MONOTONICITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String status;

    private final String monotonicity;

    private MonotonicValues(BuilderImpl builder) {
        this.status = builder.status;
        this.monotonicity = builder.monotonicity;
    }

    /**
     * <p>
     * Indicates whether there is a potential data issue related to having monotonic values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatisticalIssueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether there is a potential data issue related to having monotonic values.
     * @see StatisticalIssueStatus
     */
    public final StatisticalIssueStatus status() {
        return StatisticalIssueStatus.fromValue(status);
    }

    /**
     * <p>
     * Indicates whether there is a potential data issue related to having monotonic values.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatisticalIssueStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Indicates whether there is a potential data issue related to having monotonic values.
     * @see StatisticalIssueStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monotonicity} will
     * return {@link Monotonicity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monotonicityAsString}.
     * </p>
     * 
     * @return Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
     * @see Monotonicity
     */
    public final Monotonicity monotonicity() {
        return Monotonicity.fromValue(monotonicity);
    }

    /**
     * <p>
     * Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #monotonicity} will
     * return {@link Monotonicity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #monotonicityAsString}.
     * </p>
     * 
     * @return Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
     * @see Monotonicity
     */
    public final String monotonicityAsString() {
        return monotonicity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(monotonicityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonotonicValues)) {
            return false;
        }
        MonotonicValues other = (MonotonicValues) obj;
        return Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(monotonicityAsString(), other.monotonicityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MonotonicValues").add("Status", statusAsString()).add("Monotonicity", monotonicityAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Monotonicity":
            return Optional.ofNullable(clazz.cast(monotonicityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Status", STATUS_FIELD);
        map.put("Monotonicity", MONOTONICITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MonotonicValues, T> g) {
        return obj -> g.apply((MonotonicValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MonotonicValues> {
        /**
         * <p>
         * Indicates whether there is a potential data issue related to having monotonic values.
         * </p>
         * 
         * @param status
         *        Indicates whether there is a potential data issue related to having monotonic values.
         * @see StatisticalIssueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticalIssueStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Indicates whether there is a potential data issue related to having monotonic values.
         * </p>
         * 
         * @param status
         *        Indicates whether there is a potential data issue related to having monotonic values.
         * @see StatisticalIssueStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatisticalIssueStatus
         */
        Builder status(StatisticalIssueStatus status);

        /**
         * <p>
         * Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
         * </p>
         * 
         * @param monotonicity
         *        Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
         * @see Monotonicity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Monotonicity
         */
        Builder monotonicity(String monotonicity);

        /**
         * <p>
         * Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
         * </p>
         * 
         * @param monotonicity
         *        Indicates the monotonicity of values. Can be INCREASING, DECREASING, or STATIC.
         * @see Monotonicity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Monotonicity
         */
        Builder monotonicity(Monotonicity monotonicity);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private String monotonicity;

        private BuilderImpl() {
        }

        private BuilderImpl(MonotonicValues model) {
            status(model.status);
            monotonicity(model.monotonicity);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatisticalIssueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMonotonicity() {
            return monotonicity;
        }

        public final void setMonotonicity(String monotonicity) {
            this.monotonicity = monotonicity;
        }

        @Override
        public final Builder monotonicity(String monotonicity) {
            this.monotonicity = monotonicity;
            return this;
        }

        @Override
        public final Builder monotonicity(Monotonicity monotonicity) {
            this.monotonicity(monotonicity == null ? null : monotonicity.toString());
            return this;
        }

        @Override
        public MonotonicValues build() {
            return new MonotonicValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
