/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the specified retraining scheduler, including model name, status, start date, frequency,
 * and lookback window.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RetrainingSchedulerSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RetrainingSchedulerSummary.Builder, RetrainingSchedulerSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(RetrainingSchedulerSummary::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(RetrainingSchedulerSummary::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RetrainingSchedulerSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> RETRAINING_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("RetrainingStartDate").getter(getter(RetrainingSchedulerSummary::retrainingStartDate))
            .setter(setter(Builder::retrainingStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingStartDate").build())
            .build();

    private static final SdkField<String> RETRAINING_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RetrainingFrequency").getter(getter(RetrainingSchedulerSummary::retrainingFrequency))
            .setter(setter(Builder::retrainingFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetrainingFrequency").build())
            .build();

    private static final SdkField<String> LOOKBACK_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LookbackWindow").getter(getter(RetrainingSchedulerSummary::lookbackWindow))
            .setter(setter(Builder::lookbackWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackWindow").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, STATUS_FIELD, RETRAINING_START_DATE_FIELD, RETRAINING_FREQUENCY_FIELD, LOOKBACK_WINDOW_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final String modelArn;

    private final String status;

    private final Instant retrainingStartDate;

    private final String retrainingFrequency;

    private final String lookbackWindow;

    private RetrainingSchedulerSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.status = builder.status;
        this.retrainingStartDate = builder.retrainingStartDate;
        this.retrainingFrequency = builder.retrainingFrequency;
        this.lookbackWindow = builder.lookbackWindow;
    }

    /**
     * <p>
     * The name of the model that the retraining scheduler is attached to.
     * </p>
     * 
     * @return The name of the model that the retraining scheduler is attached to.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The ARN of the model that the retraining scheduler is attached to.
     * </p>
     * 
     * @return The ARN of the model that the retraining scheduler is attached to.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final RetrainingSchedulerStatus status() {
        return RetrainingSchedulerStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the retraining scheduler.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RetrainingSchedulerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the retraining scheduler.
     * @see RetrainingSchedulerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the nearest
     * UTC day.
     * </p>
     * 
     * @return The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
     *         nearest UTC day.
     */
    public final Instant retrainingStartDate() {
        return retrainingStartDate;
    }

    /**
     * <p>
     * The frequency at which the model retraining is set. This follows the <a
     * href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
     * </p>
     * 
     * @return The frequency at which the model retraining is set. This follows the <a
     *         href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
     */
    public final String retrainingFrequency() {
        return retrainingFrequency;
    }

    /**
     * <p>
     * The number of past days of data used for retraining.
     * </p>
     * 
     * @return The number of past days of data used for retraining.
     */
    public final String lookbackWindow() {
        return lookbackWindow;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(retrainingFrequency());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackWindow());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrainingSchedulerSummary)) {
            return false;
        }
        RetrainingSchedulerSummary other = (RetrainingSchedulerSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(retrainingStartDate(), other.retrainingStartDate())
                && Objects.equals(retrainingFrequency(), other.retrainingFrequency())
                && Objects.equals(lookbackWindow(), other.lookbackWindow());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RetrainingSchedulerSummary").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("Status", statusAsString()).add("RetrainingStartDate", retrainingStartDate())
                .add("RetrainingFrequency", retrainingFrequency()).add("LookbackWindow", lookbackWindow()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "RetrainingStartDate":
            return Optional.ofNullable(clazz.cast(retrainingStartDate()));
        case "RetrainingFrequency":
            return Optional.ofNullable(clazz.cast(retrainingFrequency()));
        case "LookbackWindow":
            return Optional.ofNullable(clazz.cast(lookbackWindow()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("RetrainingStartDate", RETRAINING_START_DATE_FIELD);
        map.put("RetrainingFrequency", RETRAINING_FREQUENCY_FIELD);
        map.put("LookbackWindow", LOOKBACK_WINDOW_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrainingSchedulerSummary, T> g) {
        return obj -> g.apply((RetrainingSchedulerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RetrainingSchedulerSummary> {
        /**
         * <p>
         * The name of the model that the retraining scheduler is attached to.
         * </p>
         * 
         * @param modelName
         *        The name of the model that the retraining scheduler is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The ARN of the model that the retraining scheduler is attached to.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the model that the retraining scheduler is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The status of the retraining scheduler.
         * </p>
         * 
         * @param status
         *        The status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the retraining scheduler.
         * </p>
         * 
         * @param status
         *        The status of the retraining scheduler.
         * @see RetrainingSchedulerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RetrainingSchedulerStatus
         */
        Builder status(RetrainingSchedulerStatus status);

        /**
         * <p>
         * The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to the
         * nearest UTC day.
         * </p>
         * 
         * @param retrainingStartDate
         *        The start date for the retraining scheduler. Lookout for Equipment truncates the time you provide to
         *        the nearest UTC day.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingStartDate(Instant retrainingStartDate);

        /**
         * <p>
         * The frequency at which the model retraining is set. This follows the <a
         * href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
         * </p>
         * 
         * @param retrainingFrequency
         *        The frequency at which the model retraining is set. This follows the <a
         *        href="https://en.wikipedia.org/wiki/ISO_8601#Durations">ISO 8601</a> guidelines.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrainingFrequency(String retrainingFrequency);

        /**
         * <p>
         * The number of past days of data used for retraining.
         * </p>
         * 
         * @param lookbackWindow
         *        The number of past days of data used for retraining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lookbackWindow(String lookbackWindow);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private String status;

        private Instant retrainingStartDate;

        private String retrainingFrequency;

        private String lookbackWindow;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrainingSchedulerSummary model) {
            modelName(model.modelName);
            modelArn(model.modelArn);
            status(model.status);
            retrainingStartDate(model.retrainingStartDate);
            retrainingFrequency(model.retrainingFrequency);
            lookbackWindow(model.lookbackWindow);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RetrainingSchedulerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getRetrainingStartDate() {
            return retrainingStartDate;
        }

        public final void setRetrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
        }

        @Override
        public final Builder retrainingStartDate(Instant retrainingStartDate) {
            this.retrainingStartDate = retrainingStartDate;
            return this;
        }

        public final String getRetrainingFrequency() {
            return retrainingFrequency;
        }

        public final void setRetrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
        }

        @Override
        public final Builder retrainingFrequency(String retrainingFrequency) {
            this.retrainingFrequency = retrainingFrequency;
            return this;
        }

        public final String getLookbackWindow() {
            return lookbackWindow;
        }

        public final void setLookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
        }

        @Override
        public final Builder lookbackWindow(String lookbackWindow) {
            this.lookbackWindow = lookbackWindow;
            return this;
        }

        @Override
        public RetrainingSchedulerSummary build() {
            return new RetrainingSchedulerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
