/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutequipment.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateActiveModelVersionResponse extends LookoutEquipmentResponse implements
        ToCopyableBuilder<UpdateActiveModelVersionResponse.Builder, UpdateActiveModelVersionResponse> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(UpdateActiveModelVersionResponse::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelArn").getter(getter(UpdateActiveModelVersionResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelArn").build()).build();

    private static final SdkField<Long> CURRENT_ACTIVE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CurrentActiveVersion").getter(getter(UpdateActiveModelVersionResponse::currentActiveVersion))
            .setter(setter(Builder::currentActiveVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentActiveVersion").build())
            .build();

    private static final SdkField<Long> PREVIOUS_ACTIVE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("PreviousActiveVersion").getter(getter(UpdateActiveModelVersionResponse::previousActiveVersion))
            .setter(setter(Builder::previousActiveVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveVersion").build())
            .build();

    private static final SdkField<String> CURRENT_ACTIVE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentActiveVersionArn").getter(getter(UpdateActiveModelVersionResponse::currentActiveVersionArn))
            .setter(setter(Builder::currentActiveVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentActiveVersionArn").build())
            .build();

    private static final SdkField<String> PREVIOUS_ACTIVE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreviousActiveVersionArn").getter(getter(UpdateActiveModelVersionResponse::previousActiveVersionArn))
            .setter(setter(Builder::previousActiveVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreviousActiveVersionArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            MODEL_ARN_FIELD, CURRENT_ACTIVE_VERSION_FIELD, PREVIOUS_ACTIVE_VERSION_FIELD, CURRENT_ACTIVE_VERSION_ARN_FIELD,
            PREVIOUS_ACTIVE_VERSION_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelName;

    private final String modelArn;

    private final Long currentActiveVersion;

    private final Long previousActiveVersion;

    private final String currentActiveVersionArn;

    private final String previousActiveVersionArn;

    private UpdateActiveModelVersionResponse(BuilderImpl builder) {
        super(builder);
        this.modelName = builder.modelName;
        this.modelArn = builder.modelArn;
        this.currentActiveVersion = builder.currentActiveVersion;
        this.previousActiveVersion = builder.previousActiveVersion;
        this.currentActiveVersionArn = builder.currentActiveVersionArn;
        this.previousActiveVersionArn = builder.previousActiveVersionArn;
    }

    /**
     * <p>
     * The name of the machine learning model for which the active model version was set.
     * </p>
     * 
     * @return The name of the machine learning model for which the active model version was set.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model for which the active model version was set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model for which the active model version was set.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The version that is currently active of the machine learning model for which the active model version was set.
     * </p>
     * 
     * @return The version that is currently active of the machine learning model for which the active model version was
     *         set.
     */
    public final Long currentActiveVersion() {
        return currentActiveVersion;
    }

    /**
     * <p>
     * The previous version that was active of the machine learning model for which the active model version was set.
     * </p>
     * 
     * @return The previous version that was active of the machine learning model for which the active model version was
     *         set.
     */
    public final Long previousActiveVersion() {
        return previousActiveVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model version that is the current active model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model version that is the current active model
     *         version.
     */
    public final String currentActiveVersionArn() {
        return currentActiveVersionArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the machine learning model version that was the previous active model version.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the machine learning model version that was the previous active model
     *         version.
     */
    public final String previousActiveVersionArn() {
        return previousActiveVersionArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(currentActiveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(previousActiveVersion());
        hashCode = 31 * hashCode + Objects.hashCode(currentActiveVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(previousActiveVersionArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateActiveModelVersionResponse)) {
            return false;
        }
        UpdateActiveModelVersionResponse other = (UpdateActiveModelVersionResponse) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(currentActiveVersion(), other.currentActiveVersion())
                && Objects.equals(previousActiveVersion(), other.previousActiveVersion())
                && Objects.equals(currentActiveVersionArn(), other.currentActiveVersionArn())
                && Objects.equals(previousActiveVersionArn(), other.previousActiveVersionArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateActiveModelVersionResponse").add("ModelName", modelName()).add("ModelArn", modelArn())
                .add("CurrentActiveVersion", currentActiveVersion()).add("PreviousActiveVersion", previousActiveVersion())
                .add("CurrentActiveVersionArn", currentActiveVersionArn())
                .add("PreviousActiveVersionArn", previousActiveVersionArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "ModelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "CurrentActiveVersion":
            return Optional.ofNullable(clazz.cast(currentActiveVersion()));
        case "PreviousActiveVersion":
            return Optional.ofNullable(clazz.cast(previousActiveVersion()));
        case "CurrentActiveVersionArn":
            return Optional.ofNullable(clazz.cast(currentActiveVersionArn()));
        case "PreviousActiveVersionArn":
            return Optional.ofNullable(clazz.cast(previousActiveVersionArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("ModelArn", MODEL_ARN_FIELD);
        map.put("CurrentActiveVersion", CURRENT_ACTIVE_VERSION_FIELD);
        map.put("PreviousActiveVersion", PREVIOUS_ACTIVE_VERSION_FIELD);
        map.put("CurrentActiveVersionArn", CURRENT_ACTIVE_VERSION_ARN_FIELD);
        map.put("PreviousActiveVersionArn", PREVIOUS_ACTIVE_VERSION_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateActiveModelVersionResponse, T> g) {
        return obj -> g.apply((UpdateActiveModelVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends LookoutEquipmentResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateActiveModelVersionResponse> {
        /**
         * <p>
         * The name of the machine learning model for which the active model version was set.
         * </p>
         * 
         * @param modelName
         *        The name of the machine learning model for which the active model version was set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model for which the active model version was set.
         * </p>
         * 
         * @param modelArn
         *        The Amazon Resource Name (ARN) of the machine learning model for which the active model version was
         *        set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The version that is currently active of the machine learning model for which the active model version was
         * set.
         * </p>
         * 
         * @param currentActiveVersion
         *        The version that is currently active of the machine learning model for which the active model version
         *        was set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentActiveVersion(Long currentActiveVersion);

        /**
         * <p>
         * The previous version that was active of the machine learning model for which the active model version was
         * set.
         * </p>
         * 
         * @param previousActiveVersion
         *        The previous version that was active of the machine learning model for which the active model version
         *        was set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousActiveVersion(Long previousActiveVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model version that is the current active model
         * version.
         * </p>
         * 
         * @param currentActiveVersionArn
         *        The Amazon Resource Name (ARN) of the machine learning model version that is the current active model
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentActiveVersionArn(String currentActiveVersionArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the machine learning model version that was the previous active model
         * version.
         * </p>
         * 
         * @param previousActiveVersionArn
         *        The Amazon Resource Name (ARN) of the machine learning model version that was the previous active
         *        model version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousActiveVersionArn(String previousActiveVersionArn);
    }

    static final class BuilderImpl extends LookoutEquipmentResponse.BuilderImpl implements Builder {
        private String modelName;

        private String modelArn;

        private Long currentActiveVersion;

        private Long previousActiveVersion;

        private String currentActiveVersionArn;

        private String previousActiveVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateActiveModelVersionResponse model) {
            super(model);
            modelName(model.modelName);
            modelArn(model.modelArn);
            currentActiveVersion(model.currentActiveVersion);
            previousActiveVersion(model.previousActiveVersion);
            currentActiveVersionArn(model.currentActiveVersionArn);
            previousActiveVersionArn(model.previousActiveVersionArn);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Long getCurrentActiveVersion() {
            return currentActiveVersion;
        }

        public final void setCurrentActiveVersion(Long currentActiveVersion) {
            this.currentActiveVersion = currentActiveVersion;
        }

        @Override
        public final Builder currentActiveVersion(Long currentActiveVersion) {
            this.currentActiveVersion = currentActiveVersion;
            return this;
        }

        public final Long getPreviousActiveVersion() {
            return previousActiveVersion;
        }

        public final void setPreviousActiveVersion(Long previousActiveVersion) {
            this.previousActiveVersion = previousActiveVersion;
        }

        @Override
        public final Builder previousActiveVersion(Long previousActiveVersion) {
            this.previousActiveVersion = previousActiveVersion;
            return this;
        }

        public final String getCurrentActiveVersionArn() {
            return currentActiveVersionArn;
        }

        public final void setCurrentActiveVersionArn(String currentActiveVersionArn) {
            this.currentActiveVersionArn = currentActiveVersionArn;
        }

        @Override
        public final Builder currentActiveVersionArn(String currentActiveVersionArn) {
            this.currentActiveVersionArn = currentActiveVersionArn;
            return this;
        }

        public final String getPreviousActiveVersionArn() {
            return previousActiveVersionArn;
        }

        public final void setPreviousActiveVersionArn(String previousActiveVersionArn) {
            this.previousActiveVersionArn = previousActiveVersionArn;
        }

        @Override
        public final Builder previousActiveVersionArn(String previousActiveVersionArn) {
            this.previousActiveVersionArn = previousActiveVersionArn;
            return this;
        }

        @Override
        public UpdateActiveModelVersionResponse build() {
            return new UpdateActiveModelVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
