/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of anomalous metrics
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyGroup implements SdkPojo, Serializable, ToCopyableBuilder<AnomalyGroup.Builder, AnomalyGroup> {
    private static final SdkField<String> START_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartTime").getter(getter(AnomalyGroup::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> END_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndTime").getter(getter(AnomalyGroup::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(AnomalyGroup::anomalyGroupId)).setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<Double> ANOMALY_GROUP_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("AnomalyGroupScore").getter(getter(AnomalyGroup::anomalyGroupScore))
            .setter(setter(Builder::anomalyGroupScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupScore").build()).build();

    private static final SdkField<String> PRIMARY_METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryMetricName").getter(getter(AnomalyGroup::primaryMetricName))
            .setter(setter(Builder::primaryMetricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryMetricName").build()).build();

    private static final SdkField<List<MetricLevelImpact>> METRIC_LEVEL_IMPACT_LIST_FIELD = SdkField
            .<List<MetricLevelImpact>> builder(MarshallingType.LIST)
            .memberName("MetricLevelImpactList")
            .getter(getter(AnomalyGroup::metricLevelImpactList))
            .setter(setter(Builder::metricLevelImpactList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricLevelImpactList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricLevelImpact> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricLevelImpact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            END_TIME_FIELD, ANOMALY_GROUP_ID_FIELD, ANOMALY_GROUP_SCORE_FIELD, PRIMARY_METRIC_NAME_FIELD,
            METRIC_LEVEL_IMPACT_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String startTime;

    private final String endTime;

    private final String anomalyGroupId;

    private final Double anomalyGroupScore;

    private final String primaryMetricName;

    private final List<MetricLevelImpact> metricLevelImpactList;

    private AnomalyGroup(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.anomalyGroupScore = builder.anomalyGroupScore;
        this.primaryMetricName = builder.primaryMetricName;
        this.metricLevelImpactList = builder.metricLevelImpactList;
    }

    /**
     * <p>
     * The start time for the group.
     * </p>
     * 
     * @return The start time for the group.
     */
    public final String startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time for the group.
     * </p>
     * 
     * @return The end time for the group.
     */
    public final String endTime() {
        return endTime;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * The severity score of the group.
     * </p>
     * 
     * @return The severity score of the group.
     */
    public final Double anomalyGroupScore() {
        return anomalyGroupScore;
    }

    /**
     * <p>
     * The name of the primary affected measure for the group.
     * </p>
     * 
     * @return The name of the primary affected measure for the group.
     */
    public final String primaryMetricName() {
        return primaryMetricName;
    }

    /**
     * Returns true if the MetricLevelImpactList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMetricLevelImpactList() {
        return metricLevelImpactList != null && !(metricLevelImpactList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of measures affected by the anomaly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricLevelImpactList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of measures affected by the anomaly.
     */
    public final List<MetricLevelImpact> metricLevelImpactList() {
        return metricLevelImpactList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupScore());
        hashCode = 31 * hashCode + Objects.hashCode(primaryMetricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricLevelImpactList() ? metricLevelImpactList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroup)) {
            return false;
        }
        AnomalyGroup other = (AnomalyGroup) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(anomalyGroupId(), other.anomalyGroupId())
                && Objects.equals(anomalyGroupScore(), other.anomalyGroupScore())
                && Objects.equals(primaryMetricName(), other.primaryMetricName())
                && hasMetricLevelImpactList() == other.hasMetricLevelImpactList()
                && Objects.equals(metricLevelImpactList(), other.metricLevelImpactList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyGroup").add("StartTime", startTime()).add("EndTime", endTime())
                .add("AnomalyGroupId", anomalyGroupId()).add("AnomalyGroupScore", anomalyGroupScore())
                .add("PrimaryMetricName", primaryMetricName())
                .add("MetricLevelImpactList", hasMetricLevelImpactList() ? metricLevelImpactList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "AnomalyGroupScore":
            return Optional.ofNullable(clazz.cast(anomalyGroupScore()));
        case "PrimaryMetricName":
            return Optional.ofNullable(clazz.cast(primaryMetricName()));
        case "MetricLevelImpactList":
            return Optional.ofNullable(clazz.cast(metricLevelImpactList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroup, T> g) {
        return obj -> g.apply((AnomalyGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyGroup> {
        /**
         * <p>
         * The start time for the group.
         * </p>
         * 
         * @param startTime
         *        The start time for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(String startTime);

        /**
         * <p>
         * The end time for the group.
         * </p>
         * 
         * @param endTime
         *        The end time for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(String endTime);

        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * The severity score of the group.
         * </p>
         * 
         * @param anomalyGroupScore
         *        The severity score of the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupScore(Double anomalyGroupScore);

        /**
         * <p>
         * The name of the primary affected measure for the group.
         * </p>
         * 
         * @param primaryMetricName
         *        The name of the primary affected measure for the group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryMetricName(String primaryMetricName);

        /**
         * <p>
         * A list of measures affected by the anomaly.
         * </p>
         * 
         * @param metricLevelImpactList
         *        A list of measures affected by the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricLevelImpactList(Collection<MetricLevelImpact> metricLevelImpactList);

        /**
         * <p>
         * A list of measures affected by the anomaly.
         * </p>
         * 
         * @param metricLevelImpactList
         *        A list of measures affected by the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricLevelImpactList(MetricLevelImpact... metricLevelImpactList);

        /**
         * <p>
         * A list of measures affected by the anomaly.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricLevelImpact>.Builder} avoiding the
         * need to create one manually via {@link List<MetricLevelImpact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricLevelImpact>.Builder#build()} is called immediately
         * and its result is passed to {@link #metricLevelImpactList(List<MetricLevelImpact>)}.
         * 
         * @param metricLevelImpactList
         *        a consumer that will call methods on {@link List<MetricLevelImpact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricLevelImpactList(List<MetricLevelImpact>)
         */
        Builder metricLevelImpactList(Consumer<MetricLevelImpact.Builder>... metricLevelImpactList);
    }

    static final class BuilderImpl implements Builder {
        private String startTime;

        private String endTime;

        private String anomalyGroupId;

        private Double anomalyGroupScore;

        private String primaryMetricName;

        private List<MetricLevelImpact> metricLevelImpactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroup model) {
            startTime(model.startTime);
            endTime(model.endTime);
            anomalyGroupId(model.anomalyGroupId);
            anomalyGroupScore(model.anomalyGroupScore);
            primaryMetricName(model.primaryMetricName);
            metricLevelImpactList(model.metricLevelImpactList);
        }

        public final String getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public final String getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        public final Double getAnomalyGroupScore() {
            return anomalyGroupScore;
        }

        @Override
        public final Builder anomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
            return this;
        }

        public final void setAnomalyGroupScore(Double anomalyGroupScore) {
            this.anomalyGroupScore = anomalyGroupScore;
        }

        public final String getPrimaryMetricName() {
            return primaryMetricName;
        }

        @Override
        public final Builder primaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
            return this;
        }

        public final void setPrimaryMetricName(String primaryMetricName) {
            this.primaryMetricName = primaryMetricName;
        }

        public final List<MetricLevelImpact.Builder> getMetricLevelImpactList() {
            List<MetricLevelImpact.Builder> result = MetricLevelImpactListCopier.copyToBuilder(this.metricLevelImpactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricLevelImpactList(Collection<MetricLevelImpact> metricLevelImpactList) {
            this.metricLevelImpactList = MetricLevelImpactListCopier.copy(metricLevelImpactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricLevelImpactList(MetricLevelImpact... metricLevelImpactList) {
            metricLevelImpactList(Arrays.asList(metricLevelImpactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricLevelImpactList(Consumer<MetricLevelImpact.Builder>... metricLevelImpactList) {
            metricLevelImpactList(Stream.of(metricLevelImpactList).map(c -> MetricLevelImpact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricLevelImpactList(Collection<MetricLevelImpact.BuilderImpl> metricLevelImpactList) {
            this.metricLevelImpactList = MetricLevelImpactListCopier.copyFromBuilder(metricLevelImpactList);
        }

        @Override
        public AnomalyGroup build() {
            return new AnomalyGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
