/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Feedback for an anomalous metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnomalyGroupTimeSeriesFeedback implements SdkPojo, Serializable,
        ToCopyableBuilder<AnomalyGroupTimeSeriesFeedback.Builder, AnomalyGroupTimeSeriesFeedback> {
    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(AnomalyGroupTimeSeriesFeedback::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeSeriesId").getter(getter(AnomalyGroupTimeSeriesFeedback::timeSeriesId))
            .setter(setter(Builder::timeSeriesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesId").build()).build();

    private static final SdkField<Boolean> IS_ANOMALY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsAnomaly").getter(getter(AnomalyGroupTimeSeriesFeedback::isAnomaly)).setter(setter(Builder::isAnomaly))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsAnomaly").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_GROUP_ID_FIELD,
            TIME_SERIES_ID_FIELD, IS_ANOMALY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String anomalyGroupId;

    private final String timeSeriesId;

    private final Boolean isAnomaly;

    private AnomalyGroupTimeSeriesFeedback(BuilderImpl builder) {
        this.anomalyGroupId = builder.anomalyGroupId;
        this.timeSeriesId = builder.timeSeriesId;
        this.isAnomaly = builder.isAnomaly;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @return The ID of the metric.
     */
    public final String timeSeriesId() {
        return timeSeriesId;
    }

    /**
     * <p>
     * Feedback on whether the metric is a legitimate anomaly.
     * </p>
     * 
     * @return Feedback on whether the metric is a legitimate anomaly.
     */
    public final Boolean isAnomaly() {
        return isAnomaly;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesId());
        hashCode = 31 * hashCode + Objects.hashCode(isAnomaly());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnomalyGroupTimeSeriesFeedback)) {
            return false;
        }
        AnomalyGroupTimeSeriesFeedback other = (AnomalyGroupTimeSeriesFeedback) obj;
        return Objects.equals(anomalyGroupId(), other.anomalyGroupId()) && Objects.equals(timeSeriesId(), other.timeSeriesId())
                && Objects.equals(isAnomaly(), other.isAnomaly());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnomalyGroupTimeSeriesFeedback").add("AnomalyGroupId", anomalyGroupId())
                .add("TimeSeriesId", timeSeriesId()).add("IsAnomaly", isAnomaly()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "TimeSeriesId":
            return Optional.ofNullable(clazz.cast(timeSeriesId()));
        case "IsAnomaly":
            return Optional.ofNullable(clazz.cast(isAnomaly()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnomalyGroupTimeSeriesFeedback, T> g) {
        return obj -> g.apply((AnomalyGroupTimeSeriesFeedback) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnomalyGroupTimeSeriesFeedback> {
        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * The ID of the metric.
         * </p>
         * 
         * @param timeSeriesId
         *        The ID of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesId(String timeSeriesId);

        /**
         * <p>
         * Feedback on whether the metric is a legitimate anomaly.
         * </p>
         * 
         * @param isAnomaly
         *        Feedback on whether the metric is a legitimate anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAnomaly(Boolean isAnomaly);
    }

    static final class BuilderImpl implements Builder {
        private String anomalyGroupId;

        private String timeSeriesId;

        private Boolean isAnomaly;

        private BuilderImpl() {
        }

        private BuilderImpl(AnomalyGroupTimeSeriesFeedback model) {
            anomalyGroupId(model.anomalyGroupId);
            timeSeriesId(model.timeSeriesId);
            isAnomaly(model.isAnomaly);
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        @Override
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        public final String getTimeSeriesId() {
            return timeSeriesId;
        }

        @Override
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        public final Boolean getIsAnomaly() {
            return isAnomaly;
        }

        @Override
        public final Builder isAnomaly(Boolean isAnomaly) {
            this.isAnomaly = isAnomaly;
            return this;
        }

        public final void setIsAnomaly(Boolean isAnomaly) {
            this.isAnomaly = isAnomaly;
        }

        @Override
        public AnomalyGroupTimeSeriesFeedback build() {
            return new AnomalyGroupTimeSeriesFeedback(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
