/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAlertRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<CreateAlertRequest.Builder, CreateAlertRequest> {
    private static final SdkField<String> ALERT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertName").getter(getter(CreateAlertRequest::alertName)).setter(setter(Builder::alertName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertName").build()).build();

    private static final SdkField<Integer> ALERT_SENSITIVITY_THRESHOLD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("AlertSensitivityThreshold")
            .getter(getter(CreateAlertRequest::alertSensitivityThreshold)).setter(setter(Builder::alertSensitivityThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertSensitivityThreshold").build())
            .build();

    private static final SdkField<String> ALERT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AlertDescription").getter(getter(CreateAlertRequest::alertDescription))
            .setter(setter(Builder::alertDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlertDescription").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(CreateAlertRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<Action> ACTION_FIELD = SdkField.<Action> builder(MarshallingType.SDK_POJO).memberName("Action")
            .getter(getter(CreateAlertRequest::action)).setter(setter(Builder::action)).constructor(Action::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAlertRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALERT_NAME_FIELD,
            ALERT_SENSITIVITY_THRESHOLD_FIELD, ALERT_DESCRIPTION_FIELD, ANOMALY_DETECTOR_ARN_FIELD, ACTION_FIELD, TAGS_FIELD));

    private final String alertName;

    private final Integer alertSensitivityThreshold;

    private final String alertDescription;

    private final String anomalyDetectorArn;

    private final Action action;

    private final Map<String, String> tags;

    private CreateAlertRequest(BuilderImpl builder) {
        super(builder);
        this.alertName = builder.alertName;
        this.alertSensitivityThreshold = builder.alertSensitivityThreshold;
        this.alertDescription = builder.alertDescription;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.action = builder.action;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the alert.
     * </p>
     * 
     * @return The name of the alert.
     */
    public final String alertName() {
        return alertName;
    }

    /**
     * <p>
     * An integer from 0 to 100 specifying the alert sensitivity threshold.
     * </p>
     * 
     * @return An integer from 0 to 100 specifying the alert sensitivity threshold.
     */
    public final Integer alertSensitivityThreshold() {
        return alertSensitivityThreshold;
    }

    /**
     * <p>
     * A description of the alert.
     * </p>
     * 
     * @return A description of the alert.
     */
    public final String alertDescription() {
        return alertDescription;
    }

    /**
     * <p>
     * The ARN of the detector to which the alert is attached.
     * </p>
     * 
     * @return The ARN of the detector to which the alert is attached.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * Action that will be triggered when there is an alert.
     * </p>
     * 
     * @return Action that will be triggered when there is an alert.
     */
    public final Action action() {
        return action;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply
     * to the alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
     *         apply to the alert.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(alertName());
        hashCode = 31 * hashCode + Objects.hashCode(alertSensitivityThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(alertDescription());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(action());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAlertRequest)) {
            return false;
        }
        CreateAlertRequest other = (CreateAlertRequest) obj;
        return Objects.equals(alertName(), other.alertName())
                && Objects.equals(alertSensitivityThreshold(), other.alertSensitivityThreshold())
                && Objects.equals(alertDescription(), other.alertDescription())
                && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(action(), other.action())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAlertRequest").add("AlertName", alertName())
                .add("AlertSensitivityThreshold", alertSensitivityThreshold()).add("AlertDescription", alertDescription())
                .add("AnomalyDetectorArn", anomalyDetectorArn()).add("Action", action()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AlertName":
            return Optional.ofNullable(clazz.cast(alertName()));
        case "AlertSensitivityThreshold":
            return Optional.ofNullable(clazz.cast(alertSensitivityThreshold()));
        case "AlertDescription":
            return Optional.ofNullable(clazz.cast(alertDescription()));
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "Action":
            return Optional.ofNullable(clazz.cast(action()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAlertRequest, T> g) {
        return obj -> g.apply((CreateAlertRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAlertRequest> {
        /**
         * <p>
         * The name of the alert.
         * </p>
         * 
         * @param alertName
         *        The name of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertName(String alertName);

        /**
         * <p>
         * An integer from 0 to 100 specifying the alert sensitivity threshold.
         * </p>
         * 
         * @param alertSensitivityThreshold
         *        An integer from 0 to 100 specifying the alert sensitivity threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertSensitivityThreshold(Integer alertSensitivityThreshold);

        /**
         * <p>
         * A description of the alert.
         * </p>
         * 
         * @param alertDescription
         *        A description of the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alertDescription(String alertDescription);

        /**
         * <p>
         * The ARN of the detector to which the alert is attached.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector to which the alert is attached.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * 
         * @param action
         *        Action that will be triggered when there is an alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Action action);

        /**
         * <p>
         * Action that will be triggered when there is an alert.
         * </p>
         * This is a convenience that creates an instance of the {@link Action.Builder} avoiding the need to create one
         * manually via {@link Action#builder()}.
         *
         * When the {@link Consumer} completes, {@link Action.Builder#build()} is called immediately and its result is
         * passed to {@link #action(Action)}.
         * 
         * @param action
         *        a consumer that will call methods on {@link Action.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #action(Action)
         */
        default Builder action(Consumer<Action.Builder> action) {
            return action(Action.builder().applyMutation(action).build());
        }

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
         * apply to the alert.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>
         *        to apply to the alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String alertName;

        private Integer alertSensitivityThreshold;

        private String alertDescription;

        private String anomalyDetectorArn;

        private Action action;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAlertRequest model) {
            super(model);
            alertName(model.alertName);
            alertSensitivityThreshold(model.alertSensitivityThreshold);
            alertDescription(model.alertDescription);
            anomalyDetectorArn(model.anomalyDetectorArn);
            action(model.action);
            tags(model.tags);
        }

        public final String getAlertName() {
            return alertName;
        }

        @Override
        public final Builder alertName(String alertName) {
            this.alertName = alertName;
            return this;
        }

        public final void setAlertName(String alertName) {
            this.alertName = alertName;
        }

        public final Integer getAlertSensitivityThreshold() {
            return alertSensitivityThreshold;
        }

        @Override
        public final Builder alertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
            return this;
        }

        public final void setAlertSensitivityThreshold(Integer alertSensitivityThreshold) {
            this.alertSensitivityThreshold = alertSensitivityThreshold;
        }

        public final String getAlertDescription() {
            return alertDescription;
        }

        @Override
        public final Builder alertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
            return this;
        }

        public final void setAlertDescription(String alertDescription) {
            this.alertDescription = alertDescription;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        public final Action.Builder getAction() {
            return action != null ? action.toBuilder() : null;
        }

        @Override
        public final Builder action(Action action) {
            this.action = action;
            return this;
        }

        public final void setAction(Action.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAlertRequest build() {
            return new CreateAlertRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
