/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalyDetectorRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<CreateAnomalyDetectorRequest.Builder, CreateAnomalyDetectorRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorName").getter(getter(CreateAnomalyDetectorRequest::anomalyDetectorName))
            .setter(setter(Builder::anomalyDetectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorName").build())
            .build();

    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorDescription")
            .getter(getter(CreateAnomalyDetectorRequest::anomalyDetectorDescription))
            .setter(setter(Builder::anomalyDetectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build())
            .build();

    private static final SdkField<AnomalyDetectorConfig> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField
            .<AnomalyDetectorConfig> builder(MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig")
            .getter(getter(CreateAnomalyDetectorRequest::anomalyDetectorConfig)).setter(setter(Builder::anomalyDetectorConfig))
            .constructor(AnomalyDetectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build())
            .build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(CreateAnomalyDetectorRequest::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(CreateAnomalyDetectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_NAME_FIELD,
            ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD));

    private final String anomalyDetectorName;

    private final String anomalyDetectorDescription;

    private final AnomalyDetectorConfig anomalyDetectorConfig;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private CreateAnomalyDetectorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorName = builder.anomalyDetectorName;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the detector.
     * </p>
     * 
     * @return The name of the detector.
     */
    public final String anomalyDetectorName() {
        return anomalyDetectorName;
    }

    /**
     * <p>
     * A description of the detector.
     * </p>
     * 
     * @return A description of the detector.
     */
    public final String anomalyDetectorDescription() {
        return anomalyDetectorDescription;
    }

    /**
     * <p>
     * Contains information about the configuration of the anomaly detector.
     * </p>
     * 
     * @return Contains information about the configuration of the anomaly detector.
     */
    public final AnomalyDetectorConfig anomalyDetectorConfig() {
        return anomalyDetectorConfig;
    }

    /**
     * <p>
     * The ARN of the KMS key to use to encrypt your data.
     * </p>
     * 
     * @return The ARN of the KMS key to use to encrypt your data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to apply
     * to the anomaly detector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
     *         apply to the anomaly detector.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorName());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyDetectorRequest)) {
            return false;
        }
        CreateAnomalyDetectorRequest other = (CreateAnomalyDetectorRequest) obj;
        return Objects.equals(anomalyDetectorName(), other.anomalyDetectorName())
                && Objects.equals(anomalyDetectorDescription(), other.anomalyDetectorDescription())
                && Objects.equals(anomalyDetectorConfig(), other.anomalyDetectorConfig())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalyDetectorRequest").add("AnomalyDetectorName", anomalyDetectorName())
                .add("AnomalyDetectorDescription", anomalyDetectorDescription())
                .add("AnomalyDetectorConfig", anomalyDetectorConfig()).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorName":
            return Optional.ofNullable(clazz.cast(anomalyDetectorName()));
        case "AnomalyDetectorDescription":
            return Optional.ofNullable(clazz.cast(anomalyDetectorDescription()));
        case "AnomalyDetectorConfig":
            return Optional.ofNullable(clazz.cast(anomalyDetectorConfig()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyDetectorRequest, T> g) {
        return obj -> g.apply((CreateAnomalyDetectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnomalyDetectorRequest> {
        /**
         * <p>
         * The name of the detector.
         * </p>
         * 
         * @param anomalyDetectorName
         *        The name of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorName(String anomalyDetectorName);

        /**
         * <p>
         * A description of the detector.
         * </p>
         * 
         * @param anomalyDetectorDescription
         *        A description of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorDescription(String anomalyDetectorDescription);

        /**
         * <p>
         * Contains information about the configuration of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorConfig
         *        Contains information about the configuration of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig);

        /**
         * <p>
         * Contains information about the configuration of the anomaly detector.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalyDetectorConfig.Builder} avoiding the need
         * to create one manually via {@link AnomalyDetectorConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyDetectorConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalyDetectorConfig(AnomalyDetectorConfig)}.
         * 
         * @param anomalyDetectorConfig
         *        a consumer that will call methods on {@link AnomalyDetectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetectorConfig(AnomalyDetectorConfig)
         */
        default Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfig.Builder> anomalyDetectorConfig) {
            return anomalyDetectorConfig(AnomalyDetectorConfig.builder().applyMutation(anomalyDetectorConfig).build());
        }

        /**
         * <p>
         * The ARN of the KMS key to use to encrypt your data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key to use to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a> to
         * apply to the anomaly detector.
         * </p>
         * 
         * @param tags
         *        A list of <a href="https://docs.aws.amazon.com/lookoutmetrics/latest/dev/detectors-tags.html">tags</a>
         *        to apply to the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorName;

        private String anomalyDetectorDescription;

        private AnomalyDetectorConfig anomalyDetectorConfig;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyDetectorRequest model) {
            super(model);
            anomalyDetectorName(model.anomalyDetectorName);
            anomalyDetectorDescription(model.anomalyDetectorDescription);
            anomalyDetectorConfig(model.anomalyDetectorConfig);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
        }

        public final String getAnomalyDetectorName() {
            return anomalyDetectorName;
        }

        @Override
        public final Builder anomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
            return this;
        }

        public final void setAnomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
        }

        public final String getAnomalyDetectorDescription() {
            return anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        public final AnomalyDetectorConfig.Builder getAnomalyDetectorConfig() {
            return anomalyDetectorConfig != null ? anomalyDetectorConfig.toBuilder() : null;
        }

        @Override
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfig anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfig.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalyDetectorRequest build() {
            return new CreateAnomalyDetectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
