/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about how a source CSV data file should be analyzed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CsvFormatDescriptor implements SdkPojo, Serializable,
        ToCopyableBuilder<CsvFormatDescriptor.Builder, CsvFormatDescriptor> {
    private static final SdkField<String> FILE_COMPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FileCompression").getter(getter(CsvFormatDescriptor::fileCompressionAsString))
            .setter(setter(Builder::fileCompression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileCompression").build()).build();

    private static final SdkField<String> CHARSET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Charset")
            .getter(getter(CsvFormatDescriptor::charset)).setter(setter(Builder::charset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()).build();

    private static final SdkField<Boolean> CONTAINS_HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ContainsHeader").getter(getter(CsvFormatDescriptor::containsHeader))
            .setter(setter(Builder::containsHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()).build();

    private static final SdkField<String> DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Delimiter").getter(getter(CsvFormatDescriptor::delimiter)).setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()).build();

    private static final SdkField<List<String>> HEADER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HeaderList")
            .getter(getter(CsvFormatDescriptor::headerList))
            .setter(setter(Builder::headerList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> QUOTE_SYMBOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuoteSymbol").getter(getter(CsvFormatDescriptor::quoteSymbol)).setter(setter(Builder::quoteSymbol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuoteSymbol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_COMPRESSION_FIELD,
            CHARSET_FIELD, CONTAINS_HEADER_FIELD, DELIMITER_FIELD, HEADER_LIST_FIELD, QUOTE_SYMBOL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileCompression;

    private final String charset;

    private final Boolean containsHeader;

    private final String delimiter;

    private final List<String> headerList;

    private final String quoteSymbol;

    private CsvFormatDescriptor(BuilderImpl builder) {
        this.fileCompression = builder.fileCompression;
        this.charset = builder.charset;
        this.containsHeader = builder.containsHeader;
        this.delimiter = builder.delimiter;
        this.headerList = builder.headerList;
        this.quoteSymbol = builder.quoteSymbol;
    }

    /**
     * <p>
     * The level of compression of the source CSV file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCompression}
     * will return {@link CSVFileCompression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileCompressionAsString}.
     * </p>
     * 
     * @return The level of compression of the source CSV file.
     * @see CSVFileCompression
     */
    public final CSVFileCompression fileCompression() {
        return CSVFileCompression.fromValue(fileCompression);
    }

    /**
     * <p>
     * The level of compression of the source CSV file.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileCompression}
     * will return {@link CSVFileCompression#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #fileCompressionAsString}.
     * </p>
     * 
     * @return The level of compression of the source CSV file.
     * @see CSVFileCompression
     */
    public final String fileCompressionAsString() {
        return fileCompression;
    }

    /**
     * <p>
     * The character set in which the source CSV file is written.
     * </p>
     * 
     * @return The character set in which the source CSV file is written.
     */
    public final String charset() {
        return charset;
    }

    /**
     * <p>
     * Whether or not the source CSV file contains a header.
     * </p>
     * 
     * @return Whether or not the source CSV file contains a header.
     */
    public final Boolean containsHeader() {
        return containsHeader;
    }

    /**
     * <p>
     * The character used to delimit the source CSV file.
     * </p>
     * 
     * @return The character used to delimit the source CSV file.
     */
    public final String delimiter() {
        return delimiter;
    }

    /**
     * Returns true if the HeaderList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasHeaderList() {
        return headerList != null && !(headerList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the source CSV file's headers, if any.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHeaderList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the source CSV file's headers, if any.
     */
    public final List<String> headerList() {
        return headerList;
    }

    /**
     * <p>
     * The character used as a quote character.
     * </p>
     * 
     * @return The character used as a quote character.
     */
    public final String quoteSymbol() {
        return quoteSymbol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(charset());
        hashCode = 31 * hashCode + Objects.hashCode(containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderList() ? headerList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(quoteSymbol());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CsvFormatDescriptor)) {
            return false;
        }
        CsvFormatDescriptor other = (CsvFormatDescriptor) obj;
        return Objects.equals(fileCompressionAsString(), other.fileCompressionAsString())
                && Objects.equals(charset(), other.charset()) && Objects.equals(containsHeader(), other.containsHeader())
                && Objects.equals(delimiter(), other.delimiter()) && hasHeaderList() == other.hasHeaderList()
                && Objects.equals(headerList(), other.headerList()) && Objects.equals(quoteSymbol(), other.quoteSymbol());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CsvFormatDescriptor").add("FileCompression", fileCompressionAsString())
                .add("Charset", charset()).add("ContainsHeader", containsHeader()).add("Delimiter", delimiter())
                .add("HeaderList", hasHeaderList() ? headerList() : null).add("QuoteSymbol", quoteSymbol()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FileCompression":
            return Optional.ofNullable(clazz.cast(fileCompressionAsString()));
        case "Charset":
            return Optional.ofNullable(clazz.cast(charset()));
        case "ContainsHeader":
            return Optional.ofNullable(clazz.cast(containsHeader()));
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        case "HeaderList":
            return Optional.ofNullable(clazz.cast(headerList()));
        case "QuoteSymbol":
            return Optional.ofNullable(clazz.cast(quoteSymbol()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CsvFormatDescriptor, T> g) {
        return obj -> g.apply((CsvFormatDescriptor) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CsvFormatDescriptor> {
        /**
         * <p>
         * The level of compression of the source CSV file.
         * </p>
         * 
         * @param fileCompression
         *        The level of compression of the source CSV file.
         * @see CSVFileCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CSVFileCompression
         */
        Builder fileCompression(String fileCompression);

        /**
         * <p>
         * The level of compression of the source CSV file.
         * </p>
         * 
         * @param fileCompression
         *        The level of compression of the source CSV file.
         * @see CSVFileCompression
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CSVFileCompression
         */
        Builder fileCompression(CSVFileCompression fileCompression);

        /**
         * <p>
         * The character set in which the source CSV file is written.
         * </p>
         * 
         * @param charset
         *        The character set in which the source CSV file is written.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder charset(String charset);

        /**
         * <p>
         * Whether or not the source CSV file contains a header.
         * </p>
         * 
         * @param containsHeader
         *        Whether or not the source CSV file contains a header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsHeader(Boolean containsHeader);

        /**
         * <p>
         * The character used to delimit the source CSV file.
         * </p>
         * 
         * @param delimiter
         *        The character used to delimit the source CSV file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);

        /**
         * <p>
         * A list of the source CSV file's headers, if any.
         * </p>
         * 
         * @param headerList
         *        A list of the source CSV file's headers, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerList(Collection<String> headerList);

        /**
         * <p>
         * A list of the source CSV file's headers, if any.
         * </p>
         * 
         * @param headerList
         *        A list of the source CSV file's headers, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerList(String... headerList);

        /**
         * <p>
         * The character used as a quote character.
         * </p>
         * 
         * @param quoteSymbol
         *        The character used as a quote character.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quoteSymbol(String quoteSymbol);
    }

    static final class BuilderImpl implements Builder {
        private String fileCompression;

        private String charset;

        private Boolean containsHeader;

        private String delimiter;

        private List<String> headerList = DefaultSdkAutoConstructList.getInstance();

        private String quoteSymbol;

        private BuilderImpl() {
        }

        private BuilderImpl(CsvFormatDescriptor model) {
            fileCompression(model.fileCompression);
            charset(model.charset);
            containsHeader(model.containsHeader);
            delimiter(model.delimiter);
            headerList(model.headerList);
            quoteSymbol(model.quoteSymbol);
        }

        public final String getFileCompression() {
            return fileCompression;
        }

        @Override
        public final Builder fileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
            return this;
        }

        @Override
        public final Builder fileCompression(CSVFileCompression fileCompression) {
            this.fileCompression(fileCompression == null ? null : fileCompression.toString());
            return this;
        }

        public final void setFileCompression(String fileCompression) {
            this.fileCompression = fileCompression;
        }

        public final String getCharset() {
            return charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        public final Boolean getContainsHeader() {
            return containsHeader;
        }

        @Override
        public final Builder containsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final void setContainsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        public final Collection<String> getHeaderList() {
            if (headerList instanceof SdkAutoConstructList) {
                return null;
            }
            return headerList;
        }

        @Override
        public final Builder headerList(Collection<String> headerList) {
            this.headerList = HeaderListCopier.copy(headerList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerList(String... headerList) {
            headerList(Arrays.asList(headerList));
            return this;
        }

        public final void setHeaderList(Collection<String> headerList) {
            this.headerList = HeaderListCopier.copy(headerList);
        }

        public final String getQuoteSymbol() {
            return quoteSymbol;
        }

        @Override
        public final Builder quoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
            return this;
        }

        public final void setQuoteSymbol(String quoteSymbol) {
            this.quoteSymbol = quoteSymbol;
        }

        @Override
        public CsvFormatDescriptor build() {
            return new CsvFormatDescriptor(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
