/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyDetectionExecutionsRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<DescribeAnomalyDetectionExecutionsRequest.Builder, DescribeAnomalyDetectionExecutionsRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(DescribeAnomalyDetectionExecutionsRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timestamp").getter(getter(DescribeAnomalyDetectionExecutionsRequest::timestamp))
            .setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeAnomalyDetectionExecutionsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAnomalyDetectionExecutionsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            TIMESTAMP_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String anomalyDetectorArn;

    private final String timestamp;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeAnomalyDetectionExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.timestamp = builder.timestamp;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The timestamp of the anomaly detection job.
     * </p>
     * 
     * @return The timestamp of the anomaly detection job.
     */
    public final String timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The number of items to return in the response.
     * </p>
     * 
     * @return The number of items to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectionExecutionsRequest)) {
            return false;
        }
        DescribeAnomalyDetectionExecutionsRequest other = (DescribeAnomalyDetectionExecutionsRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn()) && Objects.equals(timestamp(), other.timestamp())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyDetectionExecutionsRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("Timestamp", timestamp()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "Timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectionExecutionsRequest, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectionExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnomalyDetectionExecutionsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The Amazon Resource Name (ARN) of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The timestamp of the anomaly detection job.
         * </p>
         * 
         * @param timestamp
         *        The timestamp of the anomaly detection job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(String timestamp);

        /**
         * <p>
         * The number of items to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The number of items to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token that's returned by a previous request to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String timestamp;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectionExecutionsRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            timestamp(model.timestamp);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        public final String getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAnomalyDetectionExecutionsRequest build() {
            return new DescribeAnomalyDetectionExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
