/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnomalyDetectorResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<DescribeAnomalyDetectorResponse.Builder, DescribeAnomalyDetectorResponse> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(DescribeAnomalyDetectorResponse::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> ANOMALY_DETECTOR_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorName").getter(getter(DescribeAnomalyDetectorResponse::anomalyDetectorName))
            .setter(setter(Builder::anomalyDetectorName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorName").build())
            .build();

    private static final SdkField<String> ANOMALY_DETECTOR_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorDescription")
            .getter(getter(DescribeAnomalyDetectorResponse::anomalyDetectorDescription))
            .setter(setter(Builder::anomalyDetectorDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorDescription").build())
            .build();

    private static final SdkField<AnomalyDetectorConfigSummary> ANOMALY_DETECTOR_CONFIG_FIELD = SdkField
            .<AnomalyDetectorConfigSummary> builder(MarshallingType.SDK_POJO).memberName("AnomalyDetectorConfig")
            .getter(getter(DescribeAnomalyDetectorResponse::anomalyDetectorConfig))
            .setter(setter(Builder::anomalyDetectorConfig)).constructor(AnomalyDetectorConfigSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorConfig").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeAnomalyDetectorResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeAnomalyDetectorResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DescribeAnomalyDetectorResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeAnomalyDetectorResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(DescribeAnomalyDetectorResponse::kmsKeyArn))
            .setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            ANOMALY_DETECTOR_NAME_FIELD, ANOMALY_DETECTOR_DESCRIPTION_FIELD, ANOMALY_DETECTOR_CONFIG_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, KMS_KEY_ARN_FIELD));

    private final String anomalyDetectorArn;

    private final String anomalyDetectorName;

    private final String anomalyDetectorDescription;

    private final AnomalyDetectorConfigSummary anomalyDetectorConfig;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final String status;

    private final String failureReason;

    private final String kmsKeyArn;

    private DescribeAnomalyDetectorResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyDetectorName = builder.anomalyDetectorName;
        this.anomalyDetectorDescription = builder.anomalyDetectorDescription;
        this.anomalyDetectorConfig = builder.anomalyDetectorConfig;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The ARN of the detector.
     * </p>
     * 
     * @return The ARN of the detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The name of the detector.
     * </p>
     * 
     * @return The name of the detector.
     */
    public final String anomalyDetectorName() {
        return anomalyDetectorName;
    }

    /**
     * <p>
     * A description of the detector.
     * </p>
     * 
     * @return A description of the detector.
     */
    public final String anomalyDetectorDescription() {
        return anomalyDetectorDescription;
    }

    /**
     * <p>
     * Contains information about the detector's configuration.
     * </p>
     * 
     * @return Contains information about the detector's configuration.
     */
    public final AnomalyDetectorConfigSummary anomalyDetectorConfig() {
        return anomalyDetectorConfig;
    }

    /**
     * <p>
     * The time at which the detector was created.
     * </p>
     * 
     * @return The time at which the detector was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the detector was last modified.
     * </p>
     * 
     * @return The time at which the detector was last modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The status of the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyDetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector.
     * @see AnomalyDetectorStatus
     */
    public final AnomalyDetectorStatus status() {
        return AnomalyDetectorStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the detector.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link AnomalyDetectorStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the detector.
     * @see AnomalyDetectorStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason that the detector failed, if any.
     * </p>
     * 
     * @return The reason that the detector failed, if any.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The ARN of the KMS key to use to encrypt your data.
     * </p>
     * 
     * @return The ARN of the KMS key to use to encrypt your data.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorName());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorDescription());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnomalyDetectorResponse)) {
            return false;
        }
        DescribeAnomalyDetectorResponse other = (DescribeAnomalyDetectorResponse) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(anomalyDetectorName(), other.anomalyDetectorName())
                && Objects.equals(anomalyDetectorDescription(), other.anomalyDetectorDescription())
                && Objects.equals(anomalyDetectorConfig(), other.anomalyDetectorConfig())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnomalyDetectorResponse").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("AnomalyDetectorName", anomalyDetectorName())
                .add("AnomalyDetectorDescription", anomalyDetectorDescription())
                .add("AnomalyDetectorConfig", anomalyDetectorConfig()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("Status", statusAsString())
                .add("FailureReason", failureReason()).add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "AnomalyDetectorName":
            return Optional.ofNullable(clazz.cast(anomalyDetectorName()));
        case "AnomalyDetectorDescription":
            return Optional.ofNullable(clazz.cast(anomalyDetectorDescription()));
        case "AnomalyDetectorConfig":
            return Optional.ofNullable(clazz.cast(anomalyDetectorConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnomalyDetectorResponse, T> g) {
        return obj -> g.apply((DescribeAnomalyDetectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnomalyDetectorResponse> {
        /**
         * <p>
         * The ARN of the detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The name of the detector.
         * </p>
         * 
         * @param anomalyDetectorName
         *        The name of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorName(String anomalyDetectorName);

        /**
         * <p>
         * A description of the detector.
         * </p>
         * 
         * @param anomalyDetectorDescription
         *        A description of the detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorDescription(String anomalyDetectorDescription);

        /**
         * <p>
         * Contains information about the detector's configuration.
         * </p>
         * 
         * @param anomalyDetectorConfig
         *        Contains information about the detector's configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorConfig(AnomalyDetectorConfigSummary anomalyDetectorConfig);

        /**
         * <p>
         * Contains information about the detector's configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalyDetectorConfigSummary.Builder} avoiding
         * the need to create one manually via {@link AnomalyDetectorConfigSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyDetectorConfigSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #anomalyDetectorConfig(AnomalyDetectorConfigSummary)}.
         * 
         * @param anomalyDetectorConfig
         *        a consumer that will call methods on {@link AnomalyDetectorConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyDetectorConfig(AnomalyDetectorConfigSummary)
         */
        default Builder anomalyDetectorConfig(Consumer<AnomalyDetectorConfigSummary.Builder> anomalyDetectorConfig) {
            return anomalyDetectorConfig(AnomalyDetectorConfigSummary.builder().applyMutation(anomalyDetectorConfig).build());
        }

        /**
         * <p>
         * The time at which the detector was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the detector was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the detector was last modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The time at which the detector was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The status of the detector.
         * </p>
         * 
         * @param status
         *        The status of the detector.
         * @see AnomalyDetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyDetectorStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the detector.
         * </p>
         * 
         * @param status
         *        The status of the detector.
         * @see AnomalyDetectorStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnomalyDetectorStatus
         */
        Builder status(AnomalyDetectorStatus status);

        /**
         * <p>
         * The reason that the detector failed, if any.
         * </p>
         * 
         * @param failureReason
         *        The reason that the detector failed, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The ARN of the KMS key to use to encrypt your data.
         * </p>
         * 
         * @param kmsKeyArn
         *        The ARN of the KMS key to use to encrypt your data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String anomalyDetectorName;

        private String anomalyDetectorDescription;

        private AnomalyDetectorConfigSummary anomalyDetectorConfig;

        private Instant creationTime;

        private Instant lastModificationTime;

        private String status;

        private String failureReason;

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnomalyDetectorResponse model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            anomalyDetectorName(model.anomalyDetectorName);
            anomalyDetectorDescription(model.anomalyDetectorDescription);
            anomalyDetectorConfig(model.anomalyDetectorConfig);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            status(model.status);
            failureReason(model.failureReason);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        @Override
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        public final String getAnomalyDetectorName() {
            return anomalyDetectorName;
        }

        @Override
        public final Builder anomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
            return this;
        }

        public final void setAnomalyDetectorName(String anomalyDetectorName) {
            this.anomalyDetectorName = anomalyDetectorName;
        }

        public final String getAnomalyDetectorDescription() {
            return anomalyDetectorDescription;
        }

        @Override
        public final Builder anomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
            return this;
        }

        public final void setAnomalyDetectorDescription(String anomalyDetectorDescription) {
            this.anomalyDetectorDescription = anomalyDetectorDescription;
        }

        public final AnomalyDetectorConfigSummary.Builder getAnomalyDetectorConfig() {
            return anomalyDetectorConfig != null ? anomalyDetectorConfig.toBuilder() : null;
        }

        @Override
        public final Builder anomalyDetectorConfig(AnomalyDetectorConfigSummary anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig;
            return this;
        }

        public final void setAnomalyDetectorConfig(AnomalyDetectorConfigSummary.BuilderImpl anomalyDetectorConfig) {
            this.anomalyDetectorConfig = anomalyDetectorConfig != null ? anomalyDetectorConfig.build() : null;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        @Override
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnomalyDetectorStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public DescribeAnomalyDetectorResponse build() {
            return new DescribeAnomalyDetectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
