/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The severity of a value of a dimension that contributed to an anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionValueContribution implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionValueContribution.Builder, DimensionValueContribution> {
    private static final SdkField<String> DIMENSION_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionValue").getter(getter(DimensionValueContribution::dimensionValue))
            .setter(setter(Builder::dimensionValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValue").build()).build();

    private static final SdkField<Double> CONTRIBUTION_SCORE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ContributionScore").getter(getter(DimensionValueContribution::contributionScore))
            .setter(setter(Builder::contributionScore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionScore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_VALUE_FIELD,
            CONTRIBUTION_SCORE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionValue;

    private final Double contributionScore;

    private DimensionValueContribution(BuilderImpl builder) {
        this.dimensionValue = builder.dimensionValue;
        this.contributionScore = builder.contributionScore;
    }

    /**
     * <p>
     * The value of the dimension.
     * </p>
     * 
     * @return The value of the dimension.
     */
    public final String dimensionValue() {
        return dimensionValue;
    }

    /**
     * <p>
     * The severity score of the value.
     * </p>
     * 
     * @return The severity score of the value.
     */
    public final Double contributionScore() {
        return contributionScore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionValue());
        hashCode = 31 * hashCode + Objects.hashCode(contributionScore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionValueContribution)) {
            return false;
        }
        DimensionValueContribution other = (DimensionValueContribution) obj;
        return Objects.equals(dimensionValue(), other.dimensionValue())
                && Objects.equals(contributionScore(), other.contributionScore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DimensionValueContribution").add("DimensionValue", dimensionValue())
                .add("ContributionScore", contributionScore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionValue":
            return Optional.ofNullable(clazz.cast(dimensionValue()));
        case "ContributionScore":
            return Optional.ofNullable(clazz.cast(contributionScore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionValueContribution, T> g) {
        return obj -> g.apply((DimensionValueContribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionValueContribution> {
        /**
         * <p>
         * The value of the dimension.
         * </p>
         * 
         * @param dimensionValue
         *        The value of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValue(String dimensionValue);

        /**
         * <p>
         * The severity score of the value.
         * </p>
         * 
         * @param contributionScore
         *        The severity score of the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionScore(Double contributionScore);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionValue;

        private Double contributionScore;

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionValueContribution model) {
            dimensionValue(model.dimensionValue);
            contributionScore(model.contributionScore);
        }

        public final String getDimensionValue() {
            return dimensionValue;
        }

        @Override
        public final Builder dimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
            return this;
        }

        public final void setDimensionValue(String dimensionValue) {
            this.dimensionValue = dimensionValue;
        }

        public final Double getContributionScore() {
            return contributionScore;
        }

        @Override
        public final Builder contributionScore(Double contributionScore) {
            this.contributionScore = contributionScore;
            return this;
        }

        public final void setContributionScore(Double contributionScore) {
            this.contributionScore = contributionScore;
        }

        @Override
        public DimensionValueContribution build() {
            return new DimensionValueContribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
