/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFeedbackResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<GetFeedbackResponse.Builder, GetFeedbackResponse> {
    private static final SdkField<List<TimeSeriesFeedback>> ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD = SdkField
            .<List<TimeSeriesFeedback>> builder(MarshallingType.LIST)
            .memberName("AnomalyGroupTimeSeriesFeedback")
            .getter(getter(GetFeedbackResponse::anomalyGroupTimeSeriesFeedback))
            .setter(setter(Builder::anomalyGroupTimeSeriesFeedback))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupTimeSeriesFeedback")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TimeSeriesFeedback> builder(MarshallingType.SDK_POJO)
                                            .constructor(TimeSeriesFeedback::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetFeedbackResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ANOMALY_GROUP_TIME_SERIES_FEEDBACK_FIELD, NEXT_TOKEN_FIELD));

    private final List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback;

    private final String nextToken;

    private GetFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyGroupTimeSeriesFeedback = builder.anomalyGroupTimeSeriesFeedback;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the AnomalyGroupTimeSeriesFeedback property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasAnomalyGroupTimeSeriesFeedback() {
        return anomalyGroupTimeSeriesFeedback != null && !(anomalyGroupTimeSeriesFeedback instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Feedback for an anomalous metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnomalyGroupTimeSeriesFeedback()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Feedback for an anomalous metric.
     */
    public final List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback() {
        return anomalyGroupTimeSeriesFeedback;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAnomalyGroupTimeSeriesFeedback() ? anomalyGroupTimeSeriesFeedback() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFeedbackResponse)) {
            return false;
        }
        GetFeedbackResponse other = (GetFeedbackResponse) obj;
        return hasAnomalyGroupTimeSeriesFeedback() == other.hasAnomalyGroupTimeSeriesFeedback()
                && Objects.equals(anomalyGroupTimeSeriesFeedback(), other.anomalyGroupTimeSeriesFeedback())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GetFeedbackResponse")
                .add("AnomalyGroupTimeSeriesFeedback",
                        hasAnomalyGroupTimeSeriesFeedback() ? anomalyGroupTimeSeriesFeedback() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyGroupTimeSeriesFeedback":
            return Optional.ofNullable(clazz.cast(anomalyGroupTimeSeriesFeedback()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFeedbackResponse, T> g) {
        return obj -> g.apply((GetFeedbackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFeedbackResponse> {
        /**
         * <p>
         * Feedback for an anomalous metric.
         * </p>
         * 
         * @param anomalyGroupTimeSeriesFeedback
         *        Feedback for an anomalous metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupTimeSeriesFeedback(Collection<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback);

        /**
         * <p>
         * Feedback for an anomalous metric.
         * </p>
         * 
         * @param anomalyGroupTimeSeriesFeedback
         *        Feedback for an anomalous metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupTimeSeriesFeedback(TimeSeriesFeedback... anomalyGroupTimeSeriesFeedback);

        /**
         * <p>
         * Feedback for an anomalous metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TimeSeriesFeedback>.Builder} avoiding the
         * need to create one manually via {@link List<TimeSeriesFeedback>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TimeSeriesFeedback>.Builder#build()} is called immediately
         * and its result is passed to {@link #anomalyGroupTimeSeriesFeedback(List<TimeSeriesFeedback>)}.
         * 
         * @param anomalyGroupTimeSeriesFeedback
         *        a consumer that will call methods on {@link List<TimeSeriesFeedback>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyGroupTimeSeriesFeedback(List<TimeSeriesFeedback>)
         */
        Builder anomalyGroupTimeSeriesFeedback(Consumer<TimeSeriesFeedback.Builder>... anomalyGroupTimeSeriesFeedback);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFeedbackResponse model) {
            super(model);
            anomalyGroupTimeSeriesFeedback(model.anomalyGroupTimeSeriesFeedback);
            nextToken(model.nextToken);
        }

        public final List<TimeSeriesFeedback.Builder> getAnomalyGroupTimeSeriesFeedback() {
            List<TimeSeriesFeedback.Builder> result = TimeSeriesFeedbackListCopier
                    .copyToBuilder(this.anomalyGroupTimeSeriesFeedback);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder anomalyGroupTimeSeriesFeedback(Collection<TimeSeriesFeedback> anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = TimeSeriesFeedbackListCopier.copy(anomalyGroupTimeSeriesFeedback);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupTimeSeriesFeedback(TimeSeriesFeedback... anomalyGroupTimeSeriesFeedback) {
            anomalyGroupTimeSeriesFeedback(Arrays.asList(anomalyGroupTimeSeriesFeedback));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyGroupTimeSeriesFeedback(
                Consumer<TimeSeriesFeedback.Builder>... anomalyGroupTimeSeriesFeedback) {
            anomalyGroupTimeSeriesFeedback(Stream.of(anomalyGroupTimeSeriesFeedback)
                    .map(c -> TimeSeriesFeedback.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalyGroupTimeSeriesFeedback(
                Collection<TimeSeriesFeedback.BuilderImpl> anomalyGroupTimeSeriesFeedback) {
            this.anomalyGroupTimeSeriesFeedback = TimeSeriesFeedbackListCopier.copyFromBuilder(anomalyGroupTimeSeriesFeedback);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetFeedbackResponse build() {
            return new GetFeedbackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
