/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated statistics about a measure affected by an anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ItemizedMetricStats implements SdkPojo, Serializable,
        ToCopyableBuilder<ItemizedMetricStats.Builder, ItemizedMetricStats> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(ItemizedMetricStats::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Integer> OCCURRENCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("OccurrenceCount").getter(getter(ItemizedMetricStats::occurrenceCount))
            .setter(setter(Builder::occurrenceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OccurrenceCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            OCCURRENCE_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final Integer occurrenceCount;

    private ItemizedMetricStats(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.occurrenceCount = builder.occurrenceCount;
    }

    /**
     * <p>
     * The name of the measure.
     * </p>
     * 
     * @return The name of the measure.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The number of times that the measure appears.
     * </p>
     * 
     * @return The number of times that the measure appears.
     */
    public final Integer occurrenceCount() {
        return occurrenceCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(occurrenceCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemizedMetricStats)) {
            return false;
        }
        ItemizedMetricStats other = (ItemizedMetricStats) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(occurrenceCount(), other.occurrenceCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ItemizedMetricStats").add("MetricName", metricName()).add("OccurrenceCount", occurrenceCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "OccurrenceCount":
            return Optional.ofNullable(clazz.cast(occurrenceCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ItemizedMetricStats, T> g) {
        return obj -> g.apply((ItemizedMetricStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ItemizedMetricStats> {
        /**
         * <p>
         * The name of the measure.
         * </p>
         * 
         * @param metricName
         *        The name of the measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The number of times that the measure appears.
         * </p>
         * 
         * @param occurrenceCount
         *        The number of times that the measure appears.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder occurrenceCount(Integer occurrenceCount);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private Integer occurrenceCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ItemizedMetricStats model) {
            metricName(model.metricName);
            occurrenceCount(model.occurrenceCount);
        }

        public final String getMetricName() {
            return metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Integer getOccurrenceCount() {
            return occurrenceCount;
        }

        @Override
        public final Builder occurrenceCount(Integer occurrenceCount) {
            this.occurrenceCount = occurrenceCount;
            return this;
        }

        public final void setOccurrenceCount(Integer occurrenceCount) {
            this.occurrenceCount = occurrenceCount;
        }

        @Override
        public ItemizedMetricStats build() {
            return new ItemizedMetricStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
