/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMetricSetsResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListMetricSetsResponse.Builder, ListMetricSetsResponse> {
    private static final SdkField<List<MetricSetSummary>> METRIC_SET_SUMMARY_LIST_FIELD = SdkField
            .<List<MetricSetSummary>> builder(MarshallingType.LIST)
            .memberName("MetricSetSummaryList")
            .getter(getter(ListMetricSetsResponse::metricSetSummaryList))
            .setter(setter(Builder::metricSetSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMetricSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MetricSetSummary> metricSetSummaryList;

    private final String nextToken;

    private ListMetricSetsResponse(BuilderImpl builder) {
        super(builder);
        this.metricSetSummaryList = builder.metricSetSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the MetricSetSummaryList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMetricSetSummaryList() {
        return metricSetSummaryList != null && !(metricSetSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the datasets in the AWS Region, with configuration details for each.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricSetSummaryList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the datasets in the AWS Region, with configuration details for each.
     */
    public final List<MetricSetSummary> metricSetSummaryList() {
        return metricSetSummaryList;
    }

    /**
     * <p>
     * If the response is truncated, the list call returns this token. To retrieve the next set of results, use the
     * token in the next list request.
     * </p>
     * 
     * @return If the response is truncated, the list call returns this token. To retrieve the next set of results, use
     *         the token in the next list request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricSetSummaryList() ? metricSetSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricSetsResponse)) {
            return false;
        }
        ListMetricSetsResponse other = (ListMetricSetsResponse) obj;
        return hasMetricSetSummaryList() == other.hasMetricSetSummaryList()
                && Objects.equals(metricSetSummaryList(), other.metricSetSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMetricSetsResponse")
                .add("MetricSetSummaryList", hasMetricSetSummaryList() ? metricSetSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSetSummaryList":
            return Optional.ofNullable(clazz.cast(metricSetSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricSetsResponse, T> g) {
        return obj -> g.apply((ListMetricSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMetricSetsResponse> {
        /**
         * <p>
         * A list of the datasets in the AWS Region, with configuration details for each.
         * </p>
         * 
         * @param metricSetSummaryList
         *        A list of the datasets in the AWS Region, with configuration details for each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetSummaryList(Collection<MetricSetSummary> metricSetSummaryList);

        /**
         * <p>
         * A list of the datasets in the AWS Region, with configuration details for each.
         * </p>
         * 
         * @param metricSetSummaryList
         *        A list of the datasets in the AWS Region, with configuration details for each.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetSummaryList(MetricSetSummary... metricSetSummaryList);

        /**
         * <p>
         * A list of the datasets in the AWS Region, with configuration details for each.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MetricSetSummary>.Builder} avoiding the
         * need to create one manually via {@link List<MetricSetSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MetricSetSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #metricSetSummaryList(List<MetricSetSummary>)}.
         * 
         * @param metricSetSummaryList
         *        a consumer that will call methods on {@link List<MetricSetSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSetSummaryList(List<MetricSetSummary>)
         */
        Builder metricSetSummaryList(Consumer<MetricSetSummary.Builder>... metricSetSummaryList);

        /**
         * <p>
         * If the response is truncated, the list call returns this token. To retrieve the next set of results, use the
         * token in the next list request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, the list call returns this token. To retrieve the next set of results,
         *        use the token in the next list request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<MetricSetSummary> metricSetSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricSetsResponse model) {
            super(model);
            metricSetSummaryList(model.metricSetSummaryList);
            nextToken(model.nextToken);
        }

        public final List<MetricSetSummary.Builder> getMetricSetSummaryList() {
            List<MetricSetSummary.Builder> result = MetricSetSummaryListCopier.copyToBuilder(this.metricSetSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricSetSummaryList(Collection<MetricSetSummary> metricSetSummaryList) {
            this.metricSetSummaryList = MetricSetSummaryListCopier.copy(metricSetSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetSummaryList(MetricSetSummary... metricSetSummaryList) {
            metricSetSummaryList(Arrays.asList(metricSetSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricSetSummaryList(Consumer<MetricSetSummary.Builder>... metricSetSummaryList) {
            metricSetSummaryList(Stream.of(metricSetSummaryList).map(c -> MetricSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMetricSetSummaryList(Collection<MetricSetSummary.BuilderImpl> metricSetSummaryList) {
            this.metricSetSummaryList = MetricSetSummaryListCopier.copyFromBuilder(metricSetSummaryList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMetricSetsResponse build() {
            return new ListMetricSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
