/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMetricSetRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<UpdateMetricSetRequest.Builder, UpdateMetricSetRequest> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetArn").getter(getter(UpdateMetricSetRequest::metricSetArn))
            .setter(setter(Builder::metricSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()).build();

    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetDescription").getter(getter(UpdateMetricSetRequest::metricSetDescription))
            .setter(setter(Builder::metricSetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build())
            .build();

    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField
            .<List<Metric>> builder(MarshallingType.LIST)
            .memberName("MetricList")
            .getter(getter(UpdateMetricSetRequest::metricList))
            .setter(setter(Builder::metricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metric> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(UpdateMetricSetRequest::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField
            .<TimestampColumn> builder(MarshallingType.SDK_POJO).memberName("TimestampColumn")
            .getter(getter(UpdateMetricSetRequest::timestampColumn)).setter(setter(Builder::timestampColumn))
            .constructor(TimestampColumn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()).build();

    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DimensionList")
            .getter(getter(UpdateMetricSetRequest::dimensionList))
            .setter(setter(Builder::dimensionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetFrequency").getter(getter(UpdateMetricSetRequest::metricSetFrequencyAsString))
            .setter(setter(Builder::metricSetFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build())
            .build();

    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.<MetricSource> builder(MarshallingType.SDK_POJO)
            .memberName("MetricSource").getter(getter(UpdateMetricSetRequest::metricSource))
            .setter(setter(Builder::metricSource)).constructor(MetricSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD,
            METRIC_SET_DESCRIPTION_FIELD, METRIC_LIST_FIELD, OFFSET_FIELD, TIMESTAMP_COLUMN_FIELD, DIMENSION_LIST_FIELD,
            METRIC_SET_FREQUENCY_FIELD, METRIC_SOURCE_FIELD));

    private final String metricSetArn;

    private final String metricSetDescription;

    private final List<Metric> metricList;

    private final Integer offset;

    private final TimestampColumn timestampColumn;

    private final List<String> dimensionList;

    private final String metricSetFrequency;

    private final MetricSource metricSource;

    private UpdateMetricSetRequest(BuilderImpl builder) {
        super(builder);
        this.metricSetArn = builder.metricSetArn;
        this.metricSetDescription = builder.metricSetDescription;
        this.metricList = builder.metricList;
        this.offset = builder.offset;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.metricSource = builder.metricSource;
    }

    /**
     * <p>
     * The ARN of the dataset to update.
     * </p>
     * 
     * @return The ARN of the dataset to update.
     */
    public final String metricSetArn() {
        return metricSetArn;
    }

    /**
     * <p>
     * The dataset's description.
     * </p>
     * 
     * @return The dataset's description.
     */
    public final String metricSetDescription() {
        return metricSetDescription;
    }

    /**
     * Returns true if the MetricList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMetricList() {
        return metricList != null && !(metricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metric list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetricList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metric list.
     */
    public final List<Metric> metricList() {
        return metricList;
    }

    /**
     * <p>
     * After an interval ends, the amount of time that the detector waits before importing data.
     * </p>
     * 
     * @return After an interval ends, the amount of time that the detector waits before importing data.
     */
    public final Integer offset() {
        return offset;
    }

    /**
     * <p>
     * The timestamp column.
     * </p>
     * 
     * @return The timestamp column.
     */
    public final TimestampColumn timestampColumn() {
        return timestampColumn;
    }

    /**
     * Returns true if the DimensionList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDimensionList() {
        return dimensionList != null && !(dimensionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimension list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDimensionList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The dimension list.
     */
    public final List<String> dimensionList() {
        return dimensionList;
    }

    /**
     * <p>
     * The dataset's interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The dataset's interval.
     * @see Frequency
     */
    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(metricSetFrequency);
    }

    /**
     * <p>
     * The dataset's interval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The dataset's interval.
     * @see Frequency
     */
    public final String metricSetFrequencyAsString() {
        return metricSetFrequency;
    }

    /**
     * Returns the value of the MetricSource property for this object.
     * 
     * @return The value of the MetricSource property for this object.
     */
    public final MetricSource metricSource() {
        return metricSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricList() ? metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionList() ? dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(metricSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMetricSetRequest)) {
            return false;
        }
        UpdateMetricSetRequest other = (UpdateMetricSetRequest) obj;
        return Objects.equals(metricSetArn(), other.metricSetArn())
                && Objects.equals(metricSetDescription(), other.metricSetDescription())
                && hasMetricList() == other.hasMetricList() && Objects.equals(metricList(), other.metricList())
                && Objects.equals(offset(), other.offset()) && Objects.equals(timestampColumn(), other.timestampColumn())
                && hasDimensionList() == other.hasDimensionList() && Objects.equals(dimensionList(), other.dimensionList())
                && Objects.equals(metricSetFrequencyAsString(), other.metricSetFrequencyAsString())
                && Objects.equals(metricSource(), other.metricSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateMetricSetRequest").add("MetricSetArn", metricSetArn())
                .add("MetricSetDescription", metricSetDescription()).add("MetricList", hasMetricList() ? metricList() : null)
                .add("Offset", offset()).add("TimestampColumn", timestampColumn())
                .add("DimensionList", hasDimensionList() ? dimensionList() : null)
                .add("MetricSetFrequency", metricSetFrequencyAsString()).add("MetricSource", metricSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSetArn":
            return Optional.ofNullable(clazz.cast(metricSetArn()));
        case "MetricSetDescription":
            return Optional.ofNullable(clazz.cast(metricSetDescription()));
        case "MetricList":
            return Optional.ofNullable(clazz.cast(metricList()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "TimestampColumn":
            return Optional.ofNullable(clazz.cast(timestampColumn()));
        case "DimensionList":
            return Optional.ofNullable(clazz.cast(dimensionList()));
        case "MetricSetFrequency":
            return Optional.ofNullable(clazz.cast(metricSetFrequencyAsString()));
        case "MetricSource":
            return Optional.ofNullable(clazz.cast(metricSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMetricSetRequest, T> g) {
        return obj -> g.apply((UpdateMetricSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMetricSetRequest> {
        /**
         * <p>
         * The ARN of the dataset to update.
         * </p>
         * 
         * @param metricSetArn
         *        The ARN of the dataset to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetArn(String metricSetArn);

        /**
         * <p>
         * The dataset's description.
         * </p>
         * 
         * @param metricSetDescription
         *        The dataset's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDescription(String metricSetDescription);

        /**
         * <p>
         * The metric list.
         * </p>
         * 
         * @param metricList
         *        The metric list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Collection<Metric> metricList);

        /**
         * <p>
         * The metric list.
         * </p>
         * 
         * @param metricList
         *        The metric list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Metric... metricList);

        /**
         * <p>
         * The metric list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metric>.Builder} avoiding the need to
         * create one manually via {@link List<Metric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metric>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricList(List<Metric>)}.
         * 
         * @param metricList
         *        a consumer that will call methods on {@link List<Metric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricList(List<Metric>)
         */
        Builder metricList(Consumer<Metric.Builder>... metricList);

        /**
         * <p>
         * After an interval ends, the amount of time that the detector waits before importing data.
         * </p>
         * 
         * @param offset
         *        After an interval ends, the amount of time that the detector waits before importing data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * <p>
         * The timestamp column.
         * </p>
         * 
         * @param timestampColumn
         *        The timestamp column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampColumn(TimestampColumn timestampColumn);

        /**
         * <p>
         * The timestamp column.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampColumn.Builder} avoiding the need to
         * create one manually via {@link TimestampColumn#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampColumn.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampColumn(TimestampColumn)}.
         * 
         * @param timestampColumn
         *        a consumer that will call methods on {@link TimestampColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampColumn(TimestampColumn)
         */
        default Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return timestampColumn(TimestampColumn.builder().applyMutation(timestampColumn).build());
        }

        /**
         * <p>
         * The dimension list.
         * </p>
         * 
         * @param dimensionList
         *        The dimension list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(Collection<String> dimensionList);

        /**
         * <p>
         * The dimension list.
         * </p>
         * 
         * @param dimensionList
         *        The dimension list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(String... dimensionList);

        /**
         * <p>
         * The dataset's interval.
         * </p>
         * 
         * @param metricSetFrequency
         *        The dataset's interval.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(String metricSetFrequency);

        /**
         * <p>
         * The dataset's interval.
         * </p>
         * 
         * @param metricSetFrequency
         *        The dataset's interval.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(Frequency metricSetFrequency);

        /**
         * Sets the value of the MetricSource property for this object.
         *
         * @param metricSource
         *        The new value for the MetricSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSource(MetricSource metricSource);

        /**
         * Sets the value of the MetricSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link MetricSource.Builder} avoiding the need to
         * create one manually via {@link MetricSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricSource.Builder#build()} is called immediately and its
         * result is passed to {@link #metricSource(MetricSource)}.
         * 
         * @param metricSource
         *        a consumer that will call methods on {@link MetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSource(MetricSource)
         */
        default Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return metricSource(MetricSource.builder().applyMutation(metricSource).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String metricSetArn;

        private String metricSetDescription;

        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();

        private Integer offset;

        private TimestampColumn timestampColumn;

        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();

        private String metricSetFrequency;

        private MetricSource metricSource;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMetricSetRequest model) {
            super(model);
            metricSetArn(model.metricSetArn);
            metricSetDescription(model.metricSetDescription);
            metricList(model.metricList);
            offset(model.offset);
            timestampColumn(model.timestampColumn);
            dimensionList(model.dimensionList);
            metricSetFrequency(model.metricSetFrequency);
            metricSource(model.metricSource);
        }

        public final String getMetricSetArn() {
            return metricSetArn;
        }

        @Override
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        public final String getMetricSetDescription() {
            return metricSetDescription;
        }

        @Override
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Metric... metricList) {
            metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder>... metricList) {
            metricList(Stream.of(metricList).map(c -> Metric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        public final Integer getOffset() {
            return offset;
        }

        @Override
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return timestampColumn != null ? timestampColumn.toBuilder() : null;
        }

        @Override
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        public final Collection<String> getDimensionList() {
            if (dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionList;
        }

        @Override
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionList(String... dimensionList) {
            dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        public final String getMetricSetFrequency() {
            return metricSetFrequency;
        }

        @Override
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        public final MetricSource.Builder getMetricSource() {
            return metricSource != null ? metricSource.toBuilder() : null;
        }

        @Override
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMetricSetRequest build() {
            return new UpdateMetricSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
