/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.HeaderValueListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.services.lookoutmetrics.model.SampleRowsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSampleDataResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, GetSampleDataResponse> {
    private static final SdkField<List<String>> HEADER_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HeaderValues").getter(GetSampleDataResponse.getter(GetSampleDataResponse::headerValues)).setter(GetSampleDataResponse.setter(Builder::headerValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<List<String>>> SAMPLE_ROWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SampleRows").getter(GetSampleDataResponse.getter(GetSampleDataResponse::sampleRows)).setter(GetSampleDataResponse.setter(Builder::sampleRows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_VALUES_FIELD, SAMPLE_ROWS_FIELD));
    private final List<String> headerValues;
    private final List<List<String>> sampleRows;

    private GetSampleDataResponse(BuilderImpl builder) {
        super(builder);
        this.headerValues = builder.headerValues;
        this.sampleRows = builder.sampleRows;
    }

    public final boolean hasHeaderValues() {
        return this.headerValues != null && !(this.headerValues instanceof SdkAutoConstructList);
    }

    public final List<String> headerValues() {
        return this.headerValues;
    }

    public final boolean hasSampleRows() {
        return this.sampleRows != null && !(this.sampleRows instanceof SdkAutoConstructList);
    }

    public final List<List<String>> sampleRows() {
        return this.sampleRows;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHeaderValues() ? this.headerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSampleRows() ? this.sampleRows() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampleDataResponse)) {
            return false;
        }
        GetSampleDataResponse other = (GetSampleDataResponse)((Object)obj);
        return this.hasHeaderValues() == other.hasHeaderValues() && Objects.equals(this.headerValues(), other.headerValues()) && this.hasSampleRows() == other.hasSampleRows() && Objects.equals(this.sampleRows(), other.sampleRows());
    }

    public final String toString() {
        return ToString.builder((String)"GetSampleDataResponse").add("HeaderValues", this.hasHeaderValues() ? this.headerValues() : null).add("SampleRows", this.hasSampleRows() ? this.sampleRows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HeaderValues": {
                return Optional.ofNullable(clazz.cast(this.headerValues()));
            }
            case "SampleRows": {
                return Optional.ofNullable(clazz.cast(this.sampleRows()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampleDataResponse, T> g) {
        return obj -> g.apply((GetSampleDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<String> headerValues = DefaultSdkAutoConstructList.getInstance();
        private List<List<String>> sampleRows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampleDataResponse model) {
            super(model);
            this.headerValues(model.headerValues);
            this.sampleRows(model.sampleRows);
        }

        public final Collection<String> getHeaderValues() {
            if (this.headerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.headerValues;
        }

        @Override
        public final Builder headerValues(Collection<String> headerValues) {
            this.headerValues = HeaderValueListCopier.copy(headerValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder headerValues(String ... headerValues) {
            this.headerValues(Arrays.asList(headerValues));
            return this;
        }

        public final void setHeaderValues(Collection<String> headerValues) {
            this.headerValues = HeaderValueListCopier.copy(headerValues);
        }

        public final Collection<? extends Collection<String>> getSampleRows() {
            if (this.sampleRows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sampleRows;
        }

        @Override
        public final Builder sampleRows(Collection<? extends Collection<String>> sampleRows) {
            this.sampleRows = SampleRowsCopier.copy(sampleRows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleRows(Collection<String> ... sampleRows) {
            this.sampleRows((Collection<? extends Collection<String>>)Arrays.asList(sampleRows));
            return this;
        }

        public final void setSampleRows(Collection<? extends Collection<String>> sampleRows) {
            this.sampleRows = SampleRowsCopier.copy(sampleRows);
        }

        @Override
        public GetSampleDataResponse build() {
            return new GetSampleDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSampleDataResponse> {
        public Builder headerValues(Collection<String> var1);

        public Builder headerValues(String ... var1);

        public Builder sampleRows(Collection<? extends Collection<String>> var1);

        public Builder sampleRows(Collection<String> ... var1);
    }
}

