/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lookoutmetrics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorSummary;
import software.amazon.awssdk.services.lookoutmetrics.model.AnomalyDetectorSummaryListCopier;
import software.amazon.awssdk.services.lookoutmetrics.model.LookoutMetricsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnomalyDetectorsResponse
extends LookoutMetricsResponse
implements ToCopyableBuilder<Builder, ListAnomalyDetectorsResponse> {
    private static final SdkField<List<AnomalyDetectorSummary>> ANOMALY_DETECTOR_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyDetectorSummaryList").getter(ListAnomalyDetectorsResponse.getter(ListAnomalyDetectorsResponse::anomalyDetectorSummaryList)).setter(ListAnomalyDetectorsResponse.setter(Builder::anomalyDetectorSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyDetectorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAnomalyDetectorsResponse.getter(ListAnomalyDetectorsResponse::nextToken)).setter(ListAnomalyDetectorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnomalyDetectorSummary> anomalyDetectorSummaryList;
    private final String nextToken;

    private ListAnomalyDetectorsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorSummaryList = builder.anomalyDetectorSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAnomalyDetectorSummaryList() {
        return this.anomalyDetectorSummaryList != null && !(this.anomalyDetectorSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AnomalyDetectorSummary> anomalyDetectorSummaryList() {
        return this.anomalyDetectorSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyDetectorSummaryList() ? this.anomalyDetectorSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyDetectorsResponse)) {
            return false;
        }
        ListAnomalyDetectorsResponse other = (ListAnomalyDetectorsResponse)((Object)obj);
        return this.hasAnomalyDetectorSummaryList() == other.hasAnomalyDetectorSummaryList() && Objects.equals(this.anomalyDetectorSummaryList(), other.anomalyDetectorSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAnomalyDetectorsResponse").add("AnomalyDetectorSummaryList", this.hasAnomalyDetectorSummaryList() ? this.anomalyDetectorSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyDetectorSummaryList": {
                return Optional.ofNullable(clazz.cast(this.anomalyDetectorSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyDetectorsResponse, T> g) {
        return obj -> g.apply((ListAnomalyDetectorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LookoutMetricsResponse.BuilderImpl
    implements Builder {
        private List<AnomalyDetectorSummary> anomalyDetectorSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyDetectorsResponse model) {
            super(model);
            this.anomalyDetectorSummaryList(model.anomalyDetectorSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AnomalyDetectorSummary.Builder> getAnomalyDetectorSummaryList() {
            List<AnomalyDetectorSummary.Builder> result = AnomalyDetectorSummaryListCopier.copyToBuilder(this.anomalyDetectorSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder anomalyDetectorSummaryList(Collection<AnomalyDetectorSummary> anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList = AnomalyDetectorSummaryListCopier.copy(anomalyDetectorSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectorSummaryList(AnomalyDetectorSummary ... anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList(Arrays.asList(anomalyDetectorSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyDetectorSummaryList(Consumer<AnomalyDetectorSummary.Builder> ... anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList(Stream.of(anomalyDetectorSummaryList).map(c -> (AnomalyDetectorSummary)((AnomalyDetectorSummary.Builder)AnomalyDetectorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalyDetectorSummaryList(Collection<AnomalyDetectorSummary.BuilderImpl> anomalyDetectorSummaryList) {
            this.anomalyDetectorSummaryList = AnomalyDetectorSummaryListCopier.copyFromBuilder(anomalyDetectorSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnomalyDetectorsResponse build() {
            return new ListAnomalyDetectorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends LookoutMetricsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnomalyDetectorsResponse> {
        public Builder anomalyDetectorSummaryList(Collection<AnomalyDetectorSummary> var1);

        public Builder anomalyDetectorSummaryList(AnomalyDetectorSummary ... var1);

        public Builder anomalyDetectorSummaryList(Consumer<AnomalyDetectorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

