/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMetricSetResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<DescribeMetricSetResponse.Builder, DescribeMetricSetResponse> {
    private static final SdkField<String> METRIC_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetArn").getter(getter(DescribeMetricSetResponse::metricSetArn))
            .setter(setter(Builder::metricSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetArn").build()).build();

    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(DescribeMetricSetResponse::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> METRIC_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetName").getter(getter(DescribeMetricSetResponse::metricSetName))
            .setter(setter(Builder::metricSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetName").build()).build();

    private static final SdkField<String> METRIC_SET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetDescription").getter(getter(DescribeMetricSetResponse::metricSetDescription))
            .setter(setter(Builder::metricSetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetDescription").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeMetricSetResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFICATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModificationTime").getter(getter(DescribeMetricSetResponse::lastModificationTime))
            .setter(setter(Builder::lastModificationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModificationTime").build())
            .build();

    private static final SdkField<Integer> OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Offset").getter(getter(DescribeMetricSetResponse::offset)).setter(setter(Builder::offset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Offset").build()).build();

    private static final SdkField<List<Metric>> METRIC_LIST_FIELD = SdkField
            .<List<Metric>> builder(MarshallingType.LIST)
            .memberName("MetricList")
            .getter(getter(DescribeMetricSetResponse::metricList))
            .setter(setter(Builder::metricList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Metric> builder(MarshallingType.SDK_POJO)
                                            .constructor(Metric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TimestampColumn> TIMESTAMP_COLUMN_FIELD = SdkField
            .<TimestampColumn> builder(MarshallingType.SDK_POJO).memberName("TimestampColumn")
            .getter(getter(DescribeMetricSetResponse::timestampColumn)).setter(setter(Builder::timestampColumn))
            .constructor(TimestampColumn::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestampColumn").build()).build();

    private static final SdkField<List<String>> DIMENSION_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DimensionList")
            .getter(getter(DescribeMetricSetResponse::dimensionList))
            .setter(setter(Builder::dimensionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> METRIC_SET_FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricSetFrequency").getter(getter(DescribeMetricSetResponse::metricSetFrequencyAsString))
            .setter(setter(Builder::metricSetFrequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSetFrequency").build())
            .build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(DescribeMetricSetResponse::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<MetricSource> METRIC_SOURCE_FIELD = SdkField.<MetricSource> builder(MarshallingType.SDK_POJO)
            .memberName("MetricSource").getter(getter(DescribeMetricSetResponse::metricSource))
            .setter(setter(Builder::metricSource)).constructor(MetricSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricSource").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_SET_ARN_FIELD,
            ANOMALY_DETECTOR_ARN_FIELD, METRIC_SET_NAME_FIELD, METRIC_SET_DESCRIPTION_FIELD, CREATION_TIME_FIELD,
            LAST_MODIFICATION_TIME_FIELD, OFFSET_FIELD, METRIC_LIST_FIELD, TIMESTAMP_COLUMN_FIELD, DIMENSION_LIST_FIELD,
            METRIC_SET_FREQUENCY_FIELD, TIMEZONE_FIELD, METRIC_SOURCE_FIELD));

    private final String metricSetArn;

    private final String anomalyDetectorArn;

    private final String metricSetName;

    private final String metricSetDescription;

    private final Instant creationTime;

    private final Instant lastModificationTime;

    private final Integer offset;

    private final List<Metric> metricList;

    private final TimestampColumn timestampColumn;

    private final List<String> dimensionList;

    private final String metricSetFrequency;

    private final String timezone;

    private final MetricSource metricSource;

    private DescribeMetricSetResponse(BuilderImpl builder) {
        super(builder);
        this.metricSetArn = builder.metricSetArn;
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.metricSetName = builder.metricSetName;
        this.metricSetDescription = builder.metricSetDescription;
        this.creationTime = builder.creationTime;
        this.lastModificationTime = builder.lastModificationTime;
        this.offset = builder.offset;
        this.metricList = builder.metricList;
        this.timestampColumn = builder.timestampColumn;
        this.dimensionList = builder.dimensionList;
        this.metricSetFrequency = builder.metricSetFrequency;
        this.timezone = builder.timezone;
        this.metricSource = builder.metricSource;
    }

    /**
     * <p>
     * The ARN of the dataset.
     * </p>
     * 
     * @return The ARN of the dataset.
     */
    public final String metricSetArn() {
        return metricSetArn;
    }

    /**
     * <p>
     * The ARN of the detector that contains the dataset.
     * </p>
     * 
     * @return The ARN of the detector that contains the dataset.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String metricSetName() {
        return metricSetName;
    }

    /**
     * <p>
     * The dataset's description.
     * </p>
     * 
     * @return The dataset's description.
     */
    public final String metricSetDescription() {
        return metricSetDescription;
    }

    /**
     * <p>
     * The time at which the dataset was created.
     * </p>
     * 
     * @return The time at which the dataset was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time at which the dataset was last modified.
     * </p>
     * 
     * @return The time at which the dataset was last modified.
     */
    public final Instant lastModificationTime() {
        return lastModificationTime;
    }

    /**
     * <p>
     * The offset in seconds. Only supported for S3 and Redshift datasources.
     * </p>
     * 
     * @return The offset in seconds. Only supported for S3 and Redshift datasources.
     */
    public final Integer offset() {
        return offset;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetricList() {
        return metricList != null && !(metricList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the metrics defined by the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricList} method.
     * </p>
     * 
     * @return A list of the metrics defined by the dataset.
     */
    public final List<Metric> metricList() {
        return metricList;
    }

    /**
     * <p>
     * Contains information about the column used for tracking time in your source data.
     * </p>
     * 
     * @return Contains information about the column used for tracking time in your source data.
     */
    public final TimestampColumn timestampColumn() {
        return timestampColumn;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionList() {
        return dimensionList != null && !(dimensionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the dimensions chosen for analysis.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionList} method.
     * </p>
     * 
     * @return A list of the dimensions chosen for analysis.
     */
    public final List<String> dimensionList() {
        return dimensionList;
    }

    /**
     * <p>
     * The interval at which the data will be analyzed for anomalies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The interval at which the data will be analyzed for anomalies.
     * @see Frequency
     */
    public final Frequency metricSetFrequency() {
        return Frequency.fromValue(metricSetFrequency);
    }

    /**
     * <p>
     * The interval at which the data will be analyzed for anomalies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #metricSetFrequency} will return {@link Frequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #metricSetFrequencyAsString}.
     * </p>
     * 
     * @return The interval at which the data will be analyzed for anomalies.
     * @see Frequency
     */
    public final String metricSetFrequencyAsString() {
        return metricSetFrequency;
    }

    /**
     * <p>
     * The time zone in which the dataset's data was recorded.
     * </p>
     * 
     * @return The time zone in which the dataset's data was recorded.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Contains information about the dataset's source data.
     * </p>
     * 
     * @return Contains information about the dataset's source data.
     */
    public final MetricSource metricSource() {
        return metricSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metricSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetName());
        hashCode = 31 * hashCode + Objects.hashCode(metricSetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModificationTime());
        hashCode = 31 * hashCode + Objects.hashCode(offset());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricList() ? metricList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timestampColumn());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionList() ? dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricSetFrequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(metricSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMetricSetResponse)) {
            return false;
        }
        DescribeMetricSetResponse other = (DescribeMetricSetResponse) obj;
        return Objects.equals(metricSetArn(), other.metricSetArn())
                && Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(metricSetName(), other.metricSetName())
                && Objects.equals(metricSetDescription(), other.metricSetDescription())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModificationTime(), other.lastModificationTime())
                && Objects.equals(offset(), other.offset()) && hasMetricList() == other.hasMetricList()
                && Objects.equals(metricList(), other.metricList()) && Objects.equals(timestampColumn(), other.timestampColumn())
                && hasDimensionList() == other.hasDimensionList() && Objects.equals(dimensionList(), other.dimensionList())
                && Objects.equals(metricSetFrequencyAsString(), other.metricSetFrequencyAsString())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(metricSource(), other.metricSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeMetricSetResponse").add("MetricSetArn", metricSetArn())
                .add("AnomalyDetectorArn", anomalyDetectorArn()).add("MetricSetName", metricSetName())
                .add("MetricSetDescription", metricSetDescription()).add("CreationTime", creationTime())
                .add("LastModificationTime", lastModificationTime()).add("Offset", offset())
                .add("MetricList", hasMetricList() ? metricList() : null).add("TimestampColumn", timestampColumn())
                .add("DimensionList", hasDimensionList() ? dimensionList() : null)
                .add("MetricSetFrequency", metricSetFrequencyAsString()).add("Timezone", timezone())
                .add("MetricSource", metricSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricSetArn":
            return Optional.ofNullable(clazz.cast(metricSetArn()));
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "MetricSetName":
            return Optional.ofNullable(clazz.cast(metricSetName()));
        case "MetricSetDescription":
            return Optional.ofNullable(clazz.cast(metricSetDescription()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModificationTime":
            return Optional.ofNullable(clazz.cast(lastModificationTime()));
        case "Offset":
            return Optional.ofNullable(clazz.cast(offset()));
        case "MetricList":
            return Optional.ofNullable(clazz.cast(metricList()));
        case "TimestampColumn":
            return Optional.ofNullable(clazz.cast(timestampColumn()));
        case "DimensionList":
            return Optional.ofNullable(clazz.cast(dimensionList()));
        case "MetricSetFrequency":
            return Optional.ofNullable(clazz.cast(metricSetFrequencyAsString()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "MetricSource":
            return Optional.ofNullable(clazz.cast(metricSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMetricSetResponse, T> g) {
        return obj -> g.apply((DescribeMetricSetResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeMetricSetResponse> {
        /**
         * <p>
         * The ARN of the dataset.
         * </p>
         * 
         * @param metricSetArn
         *        The ARN of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetArn(String metricSetArn);

        /**
         * <p>
         * The ARN of the detector that contains the dataset.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The ARN of the detector that contains the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param metricSetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetName(String metricSetName);

        /**
         * <p>
         * The dataset's description.
         * </p>
         * 
         * @param metricSetDescription
         *        The dataset's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSetDescription(String metricSetDescription);

        /**
         * <p>
         * The time at which the dataset was created.
         * </p>
         * 
         * @param creationTime
         *        The time at which the dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time at which the dataset was last modified.
         * </p>
         * 
         * @param lastModificationTime
         *        The time at which the dataset was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModificationTime(Instant lastModificationTime);

        /**
         * <p>
         * The offset in seconds. Only supported for S3 and Redshift datasources.
         * </p>
         * 
         * @param offset
         *        The offset in seconds. Only supported for S3 and Redshift datasources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offset(Integer offset);

        /**
         * <p>
         * A list of the metrics defined by the dataset.
         * </p>
         * 
         * @param metricList
         *        A list of the metrics defined by the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Collection<Metric> metricList);

        /**
         * <p>
         * A list of the metrics defined by the dataset.
         * </p>
         * 
         * @param metricList
         *        A list of the metrics defined by the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricList(Metric... metricList);

        /**
         * <p>
         * A list of the metrics defined by the dataset.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Metric>.Builder} avoiding the need to
         * create one manually via {@link List<Metric>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Metric>.Builder#build()} is called immediately and its
         * result is passed to {@link #metricList(List<Metric>)}.
         * 
         * @param metricList
         *        a consumer that will call methods on {@link List<Metric>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricList(List<Metric>)
         */
        Builder metricList(Consumer<Metric.Builder>... metricList);

        /**
         * <p>
         * Contains information about the column used for tracking time in your source data.
         * </p>
         * 
         * @param timestampColumn
         *        Contains information about the column used for tracking time in your source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestampColumn(TimestampColumn timestampColumn);

        /**
         * <p>
         * Contains information about the column used for tracking time in your source data.
         * </p>
         * This is a convenience that creates an instance of the {@link TimestampColumn.Builder} avoiding the need to
         * create one manually via {@link TimestampColumn#builder()}.
         *
         * When the {@link Consumer} completes, {@link TimestampColumn.Builder#build()} is called immediately and its
         * result is passed to {@link #timestampColumn(TimestampColumn)}.
         * 
         * @param timestampColumn
         *        a consumer that will call methods on {@link TimestampColumn.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timestampColumn(TimestampColumn)
         */
        default Builder timestampColumn(Consumer<TimestampColumn.Builder> timestampColumn) {
            return timestampColumn(TimestampColumn.builder().applyMutation(timestampColumn).build());
        }

        /**
         * <p>
         * A list of the dimensions chosen for analysis.
         * </p>
         * 
         * @param dimensionList
         *        A list of the dimensions chosen for analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(Collection<String> dimensionList);

        /**
         * <p>
         * A list of the dimensions chosen for analysis.
         * </p>
         * 
         * @param dimensionList
         *        A list of the dimensions chosen for analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(String... dimensionList);

        /**
         * <p>
         * The interval at which the data will be analyzed for anomalies.
         * </p>
         * 
         * @param metricSetFrequency
         *        The interval at which the data will be analyzed for anomalies.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(String metricSetFrequency);

        /**
         * <p>
         * The interval at which the data will be analyzed for anomalies.
         * </p>
         * 
         * @param metricSetFrequency
         *        The interval at which the data will be analyzed for anomalies.
         * @see Frequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Frequency
         */
        Builder metricSetFrequency(Frequency metricSetFrequency);

        /**
         * <p>
         * The time zone in which the dataset's data was recorded.
         * </p>
         * 
         * @param timezone
         *        The time zone in which the dataset's data was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Contains information about the dataset's source data.
         * </p>
         * 
         * @param metricSource
         *        Contains information about the dataset's source data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricSource(MetricSource metricSource);

        /**
         * <p>
         * Contains information about the dataset's source data.
         * </p>
         * This is a convenience that creates an instance of the {@link MetricSource.Builder} avoiding the need to
         * create one manually via {@link MetricSource#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricSource.Builder#build()} is called immediately and its
         * result is passed to {@link #metricSource(MetricSource)}.
         * 
         * @param metricSource
         *        a consumer that will call methods on {@link MetricSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricSource(MetricSource)
         */
        default Builder metricSource(Consumer<MetricSource.Builder> metricSource) {
            return metricSource(MetricSource.builder().applyMutation(metricSource).build());
        }
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private String metricSetArn;

        private String anomalyDetectorArn;

        private String metricSetName;

        private String metricSetDescription;

        private Instant creationTime;

        private Instant lastModificationTime;

        private Integer offset;

        private List<Metric> metricList = DefaultSdkAutoConstructList.getInstance();

        private TimestampColumn timestampColumn;

        private List<String> dimensionList = DefaultSdkAutoConstructList.getInstance();

        private String metricSetFrequency;

        private String timezone;

        private MetricSource metricSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMetricSetResponse model) {
            super(model);
            metricSetArn(model.metricSetArn);
            anomalyDetectorArn(model.anomalyDetectorArn);
            metricSetName(model.metricSetName);
            metricSetDescription(model.metricSetDescription);
            creationTime(model.creationTime);
            lastModificationTime(model.lastModificationTime);
            offset(model.offset);
            metricList(model.metricList);
            timestampColumn(model.timestampColumn);
            dimensionList(model.dimensionList);
            metricSetFrequency(model.metricSetFrequency);
            timezone(model.timezone);
            metricSource(model.metricSource);
        }

        public final String getMetricSetArn() {
            return metricSetArn;
        }

        public final void setMetricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
        }

        @Override
        @Transient
        public final Builder metricSetArn(String metricSetArn) {
            this.metricSetArn = metricSetArn;
            return this;
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getMetricSetName() {
            return metricSetName;
        }

        public final void setMetricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
        }

        @Override
        @Transient
        public final Builder metricSetName(String metricSetName) {
            this.metricSetName = metricSetName;
            return this;
        }

        public final String getMetricSetDescription() {
            return metricSetDescription;
        }

        public final void setMetricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
        }

        @Override
        @Transient
        public final Builder metricSetDescription(String metricSetDescription) {
            this.metricSetDescription = metricSetDescription;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        @Transient
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModificationTime() {
            return lastModificationTime;
        }

        public final void setLastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
        }

        @Override
        @Transient
        public final Builder lastModificationTime(Instant lastModificationTime) {
            this.lastModificationTime = lastModificationTime;
            return this;
        }

        public final Integer getOffset() {
            return offset;
        }

        public final void setOffset(Integer offset) {
            this.offset = offset;
        }

        @Override
        @Transient
        public final Builder offset(Integer offset) {
            this.offset = offset;
            return this;
        }

        public final List<Metric.Builder> getMetricList() {
            List<Metric.Builder> result = MetricListCopier.copyToBuilder(this.metricList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricList(Collection<Metric.BuilderImpl> metricList) {
            this.metricList = MetricListCopier.copyFromBuilder(metricList);
        }

        @Override
        @Transient
        public final Builder metricList(Collection<Metric> metricList) {
            this.metricList = MetricListCopier.copy(metricList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricList(Metric... metricList) {
            metricList(Arrays.asList(metricList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricList(Consumer<Metric.Builder>... metricList) {
            metricList(Stream.of(metricList).map(c -> Metric.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TimestampColumn.Builder getTimestampColumn() {
            return timestampColumn != null ? timestampColumn.toBuilder() : null;
        }

        public final void setTimestampColumn(TimestampColumn.BuilderImpl timestampColumn) {
            this.timestampColumn = timestampColumn != null ? timestampColumn.build() : null;
        }

        @Override
        @Transient
        public final Builder timestampColumn(TimestampColumn timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public final Collection<String> getDimensionList() {
            if (dimensionList instanceof SdkAutoConstructList) {
                return null;
            }
            return dimensionList;
        }

        public final void setDimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
        }

        @Override
        @Transient
        public final Builder dimensionList(Collection<String> dimensionList) {
            this.dimensionList = DimensionListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionList(String... dimensionList) {
            dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        public final String getMetricSetFrequency() {
            return metricSetFrequency;
        }

        public final void setMetricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
        }

        @Override
        @Transient
        public final Builder metricSetFrequency(String metricSetFrequency) {
            this.metricSetFrequency = metricSetFrequency;
            return this;
        }

        @Override
        @Transient
        public final Builder metricSetFrequency(Frequency metricSetFrequency) {
            this.metricSetFrequency(metricSetFrequency == null ? null : metricSetFrequency.toString());
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        @Transient
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final MetricSource.Builder getMetricSource() {
            return metricSource != null ? metricSource.toBuilder() : null;
        }

        public final void setMetricSource(MetricSource.BuilderImpl metricSource) {
            this.metricSource = metricSource != null ? metricSource.build() : null;
        }

        @Override
        @Transient
        public final Builder metricSource(MetricSource metricSource) {
            this.metricSource = metricSource;
            return this;
        }

        @Override
        public DescribeMetricSetResponse build() {
            return new DescribeMetricSetResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
