/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a dimension that contributed to an anomaly.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionContribution implements SdkPojo, Serializable,
        ToCopyableBuilder<DimensionContribution.Builder, DimensionContribution> {
    private static final SdkField<String> DIMENSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DimensionName").getter(getter(DimensionContribution::dimensionName))
            .setter(setter(Builder::dimensionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionName").build()).build();

    private static final SdkField<List<DimensionValueContribution>> DIMENSION_VALUE_CONTRIBUTION_LIST_FIELD = SdkField
            .<List<DimensionValueContribution>> builder(MarshallingType.LIST)
            .memberName("DimensionValueContributionList")
            .getter(getter(DimensionContribution::dimensionValueContributionList))
            .setter(setter(Builder::dimensionValueContributionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionValueContributionList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionValueContribution> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionValueContribution::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_NAME_FIELD,
            DIMENSION_VALUE_CONTRIBUTION_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dimensionName;

    private final List<DimensionValueContribution> dimensionValueContributionList;

    private DimensionContribution(BuilderImpl builder) {
        this.dimensionName = builder.dimensionName;
        this.dimensionValueContributionList = builder.dimensionValueContributionList;
    }

    /**
     * <p>
     * The name of the dimension.
     * </p>
     * 
     * @return The name of the dimension.
     */
    public final String dimensionName() {
        return dimensionName;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionValueContributionList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDimensionValueContributionList() {
        return dimensionValueContributionList != null && !(dimensionValueContributionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of dimension values that contributed to the anomaly.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionValueContributionList} method.
     * </p>
     * 
     * @return A list of dimension values that contributed to the anomaly.
     */
    public final List<DimensionValueContribution> dimensionValueContributionList() {
        return dimensionValueContributionList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensionName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasDimensionValueContributionList() ? dimensionValueContributionList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionContribution)) {
            return false;
        }
        DimensionContribution other = (DimensionContribution) obj;
        return Objects.equals(dimensionName(), other.dimensionName())
                && hasDimensionValueContributionList() == other.hasDimensionValueContributionList()
                && Objects.equals(dimensionValueContributionList(), other.dimensionValueContributionList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DimensionContribution")
                .add("DimensionName", dimensionName())
                .add("DimensionValueContributionList",
                        hasDimensionValueContributionList() ? dimensionValueContributionList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DimensionName":
            return Optional.ofNullable(clazz.cast(dimensionName()));
        case "DimensionValueContributionList":
            return Optional.ofNullable(clazz.cast(dimensionValueContributionList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionContribution, T> g) {
        return obj -> g.apply((DimensionContribution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionContribution> {
        /**
         * <p>
         * The name of the dimension.
         * </p>
         * 
         * @param dimensionName
         *        The name of the dimension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionName(String dimensionName);

        /**
         * <p>
         * A list of dimension values that contributed to the anomaly.
         * </p>
         * 
         * @param dimensionValueContributionList
         *        A list of dimension values that contributed to the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueContributionList(Collection<DimensionValueContribution> dimensionValueContributionList);

        /**
         * <p>
         * A list of dimension values that contributed to the anomaly.
         * </p>
         * 
         * @param dimensionValueContributionList
         *        A list of dimension values that contributed to the anomaly.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionValueContributionList(DimensionValueContribution... dimensionValueContributionList);

        /**
         * <p>
         * A list of dimension values that contributed to the anomaly.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionValueContribution>.Builder}
         * avoiding the need to create one manually via {@link List<DimensionValueContribution>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionValueContribution>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #dimensionValueContributionList(List<DimensionValueContribution>)}.
         * 
         * @param dimensionValueContributionList
         *        a consumer that will call methods on {@link List<DimensionValueContribution>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionValueContributionList(List<DimensionValueContribution>)
         */
        Builder dimensionValueContributionList(Consumer<DimensionValueContribution.Builder>... dimensionValueContributionList);
    }

    static final class BuilderImpl implements Builder {
        private String dimensionName;

        private List<DimensionValueContribution> dimensionValueContributionList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionContribution model) {
            dimensionName(model.dimensionName);
            dimensionValueContributionList(model.dimensionValueContributionList);
        }

        public final String getDimensionName() {
            return dimensionName;
        }

        public final void setDimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
        }

        @Override
        @Transient
        public final Builder dimensionName(String dimensionName) {
            this.dimensionName = dimensionName;
            return this;
        }

        public final List<DimensionValueContribution.Builder> getDimensionValueContributionList() {
            List<DimensionValueContribution.Builder> result = DimensionValueContributionListCopier
                    .copyToBuilder(this.dimensionValueContributionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionValueContributionList(
                Collection<DimensionValueContribution.BuilderImpl> dimensionValueContributionList) {
            this.dimensionValueContributionList = DimensionValueContributionListCopier
                    .copyFromBuilder(dimensionValueContributionList);
        }

        @Override
        @Transient
        public final Builder dimensionValueContributionList(Collection<DimensionValueContribution> dimensionValueContributionList) {
            this.dimensionValueContributionList = DimensionValueContributionListCopier.copy(dimensionValueContributionList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionValueContributionList(DimensionValueContribution... dimensionValueContributionList) {
            dimensionValueContributionList(Arrays.asList(dimensionValueContributionList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionValueContributionList(
                Consumer<DimensionValueContribution.Builder>... dimensionValueContributionList) {
            dimensionValueContributionList(Stream.of(dimensionValueContributionList)
                    .map(c -> DimensionValueContribution.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DimensionContribution build() {
            return new DimensionContribution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
