/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSampleDataResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<GetSampleDataResponse.Builder, GetSampleDataResponse> {
    private static final SdkField<List<String>> HEADER_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HeaderValues")
            .getter(getter(GetSampleDataResponse::headerValues))
            .setter(setter(Builder::headerValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HeaderValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<List<String>>> SAMPLE_ROWS_FIELD = SdkField
            .<List<List<String>>> builder(MarshallingType.LIST)
            .memberName("SampleRows")
            .getter(getter(GetSampleDataResponse::sampleRows))
            .setter(setter(Builder::sampleRows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleRows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEADER_VALUES_FIELD,
            SAMPLE_ROWS_FIELD));

    private final List<String> headerValues;

    private final List<List<String>> sampleRows;

    private GetSampleDataResponse(BuilderImpl builder) {
        super(builder);
        this.headerValues = builder.headerValues;
        this.sampleRows = builder.sampleRows;
    }

    /**
     * For responses, this returns true if the service returned a value for the HeaderValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHeaderValues() {
        return headerValues != null && !(headerValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of header labels for the records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHeaderValues} method.
     * </p>
     * 
     * @return A list of header labels for the records.
     */
    public final List<String> headerValues() {
        return headerValues;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleRows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSampleRows() {
        return sampleRows != null && !(sampleRows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of records.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleRows} method.
     * </p>
     * 
     * @return A list of records.
     */
    public final List<List<String>> sampleRows() {
        return sampleRows;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHeaderValues() ? headerValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleRows() ? sampleRows() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSampleDataResponse)) {
            return false;
        }
        GetSampleDataResponse other = (GetSampleDataResponse) obj;
        return hasHeaderValues() == other.hasHeaderValues() && Objects.equals(headerValues(), other.headerValues())
                && hasSampleRows() == other.hasSampleRows() && Objects.equals(sampleRows(), other.sampleRows());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSampleDataResponse").add("HeaderValues", hasHeaderValues() ? headerValues() : null)
                .add("SampleRows", hasSampleRows() ? sampleRows() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HeaderValues":
            return Optional.ofNullable(clazz.cast(headerValues()));
        case "SampleRows":
            return Optional.ofNullable(clazz.cast(sampleRows()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSampleDataResponse, T> g) {
        return obj -> g.apply((GetSampleDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSampleDataResponse> {
        /**
         * <p>
         * A list of header labels for the records.
         * </p>
         * 
         * @param headerValues
         *        A list of header labels for the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValues(Collection<String> headerValues);

        /**
         * <p>
         * A list of header labels for the records.
         * </p>
         * 
         * @param headerValues
         *        A list of header labels for the records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder headerValues(String... headerValues);

        /**
         * <p>
         * A list of records.
         * </p>
         * 
         * @param sampleRows
         *        A list of records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRows(Collection<? extends Collection<String>> sampleRows);

        /**
         * <p>
         * A list of records.
         * </p>
         * 
         * @param sampleRows
         *        A list of records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleRows(Collection<String>... sampleRows);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<String> headerValues = DefaultSdkAutoConstructList.getInstance();

        private List<List<String>> sampleRows = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetSampleDataResponse model) {
            super(model);
            headerValues(model.headerValues);
            sampleRows(model.sampleRows);
        }

        public final Collection<String> getHeaderValues() {
            if (headerValues instanceof SdkAutoConstructList) {
                return null;
            }
            return headerValues;
        }

        public final void setHeaderValues(Collection<String> headerValues) {
            this.headerValues = HeaderValueListCopier.copy(headerValues);
        }

        @Override
        @Transient
        public final Builder headerValues(Collection<String> headerValues) {
            this.headerValues = HeaderValueListCopier.copy(headerValues);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder headerValues(String... headerValues) {
            headerValues(Arrays.asList(headerValues));
            return this;
        }

        public final Collection<? extends Collection<String>> getSampleRows() {
            if (sampleRows instanceof SdkAutoConstructList) {
                return null;
            }
            return sampleRows;
        }

        public final void setSampleRows(Collection<? extends Collection<String>> sampleRows) {
            this.sampleRows = SampleRowsCopier.copy(sampleRows);
        }

        @Override
        @Transient
        public final Builder sampleRows(Collection<? extends Collection<String>> sampleRows) {
            this.sampleRows = SampleRowsCopier.copy(sampleRows);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sampleRows(Collection<String>... sampleRows) {
            sampleRows(Arrays.asList(sampleRows));
            return this;
        }

        @Override
        public GetSampleDataResponse build() {
            return new GetSampleDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
