/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by the
 * anomaly group.
 * </p>
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InterMetricImpactDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InterMetricImpactDetails.Builder, InterMetricImpactDetails> {
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(InterMetricImpactDetails::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(InterMetricImpactDetails::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<String> RELATIONSHIP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelationshipType").getter(getter(InterMetricImpactDetails::relationshipTypeAsString))
            .setter(setter(Builder::relationshipType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipType").build()).build();

    private static final SdkField<Double> CONTRIBUTION_PERCENTAGE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ContributionPercentage").getter(getter(InterMetricImpactDetails::contributionPercentage))
            .setter(setter(Builder::contributionPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContributionPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAME_FIELD,
            ANOMALY_GROUP_ID_FIELD, RELATIONSHIP_TYPE_FIELD, CONTRIBUTION_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricName;

    private final String anomalyGroupId;

    private final String relationshipType;

    private final Double contributionPercentage;

    private InterMetricImpactDetails(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.relationshipType = builder.relationshipType;
        this.contributionPercentage = builder.contributionPercentage;
    }

    /**
     * <p>
     * The name of the measure.
     * </p>
     * 
     * @return The name of the measure.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or
     * whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>),
     *         or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
     * @see RelationshipType
     */
    public final RelationshipType relationshipType() {
        return RelationshipType.fromValue(relationshipType);
    }

    /**
     * <p>
     * Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or
     * whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #relationshipType}
     * will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #relationshipTypeAsString}.
     * </p>
     * 
     * @return Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>),
     *         or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
     * @see RelationshipType
     */
    public final String relationshipTypeAsString() {
        return relationshipType;
    }

    /**
     * <p>
     * For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has in
     * causing the anomalies.
     * </p>
     * 
     * @return For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure
     *         has in causing the anomalies.
     */
    public final Double contributionPercentage() {
        return contributionPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(contributionPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InterMetricImpactDetails)) {
            return false;
        }
        InterMetricImpactDetails other = (InterMetricImpactDetails) obj;
        return Objects.equals(metricName(), other.metricName()) && Objects.equals(anomalyGroupId(), other.anomalyGroupId())
                && Objects.equals(relationshipTypeAsString(), other.relationshipTypeAsString())
                && Objects.equals(contributionPercentage(), other.contributionPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InterMetricImpactDetails").add("MetricName", metricName())
                .add("AnomalyGroupId", anomalyGroupId()).add("RelationshipType", relationshipTypeAsString())
                .add("ContributionPercentage", contributionPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "RelationshipType":
            return Optional.ofNullable(clazz.cast(relationshipTypeAsString()));
        case "ContributionPercentage":
            return Optional.ofNullable(clazz.cast(contributionPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InterMetricImpactDetails, T> g) {
        return obj -> g.apply((InterMetricImpactDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InterMetricImpactDetails> {
        /**
         * <p>
         * The name of the measure.
         * </p>
         * 
         * @param metricName
         *        The name of the measure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or
         * whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
         * </p>
         * 
         * @param relationshipType
         *        Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>
         *        ), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>
         *        ).
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipType(String relationshipType);

        /**
         * <p>
         * Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), or
         * whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>).
         * </p>
         * 
         * @param relationshipType
         *        Whether a measure is a potential cause of the anomaly group (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>
         *        ), or whether the measure is impacted by the anomaly group (<code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>
         *        ).
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipType(RelationshipType relationshipType);

        /**
         * <p>
         * For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the measure has
         * in causing the anomalies.
         * </p>
         * 
         * @param contributionPercentage
         *        For potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>), the percentage contribution the
         *        measure has in causing the anomalies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contributionPercentage(Double contributionPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String metricName;

        private String anomalyGroupId;

        private String relationshipType;

        private Double contributionPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(InterMetricImpactDetails model) {
            metricName(model.metricName);
            anomalyGroupId(model.anomalyGroupId);
            relationshipType(model.relationshipType);
            contributionPercentage(model.contributionPercentage);
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        @Transient
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        @Transient
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getRelationshipType() {
            return relationshipType;
        }

        public final void setRelationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
        }

        @Override
        @Transient
        public final Builder relationshipType(String relationshipType) {
            this.relationshipType = relationshipType;
            return this;
        }

        @Override
        @Transient
        public final Builder relationshipType(RelationshipType relationshipType) {
            this.relationshipType(relationshipType == null ? null : relationshipType.toString());
            return this;
        }

        public final Double getContributionPercentage() {
            return contributionPercentage;
        }

        public final void setContributionPercentage(Double contributionPercentage) {
            this.contributionPercentage = contributionPercentage;
        }

        @Override
        @Transient
        public final Builder contributionPercentage(Double contributionPercentage) {
            this.contributionPercentage = contributionPercentage;
            return this;
        }

        @Override
        public InterMetricImpactDetails build() {
            return new InterMetricImpactDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
