/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyGroupRelatedMetricsRequest extends LookoutMetricsRequest implements
        ToCopyableBuilder<ListAnomalyGroupRelatedMetricsRequest.Builder, ListAnomalyGroupRelatedMetricsRequest> {
    private static final SdkField<String> ANOMALY_DETECTOR_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyDetectorArn").getter(getter(ListAnomalyGroupRelatedMetricsRequest::anomalyDetectorArn))
            .setter(setter(Builder::anomalyDetectorArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyDetectorArn").build())
            .build();

    private static final SdkField<String> ANOMALY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AnomalyGroupId").getter(getter(ListAnomalyGroupRelatedMetricsRequest::anomalyGroupId))
            .setter(setter(Builder::anomalyGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyGroupId").build()).build();

    private static final SdkField<String> RELATIONSHIP_TYPE_FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RelationshipTypeFilter")
            .getter(getter(ListAnomalyGroupRelatedMetricsRequest::relationshipTypeFilterAsString))
            .setter(setter(Builder::relationshipTypeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelationshipTypeFilter").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListAnomalyGroupRelatedMetricsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyGroupRelatedMetricsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_DETECTOR_ARN_FIELD,
            ANOMALY_GROUP_ID_FIELD, RELATIONSHIP_TYPE_FILTER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String anomalyDetectorArn;

    private final String anomalyGroupId;

    private final String relationshipTypeFilter;

    private final Integer maxResults;

    private final String nextToken;

    private ListAnomalyGroupRelatedMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyDetectorArn = builder.anomalyDetectorArn;
        this.anomalyGroupId = builder.anomalyGroupId;
        this.relationshipTypeFilter = builder.relationshipTypeFilter;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the anomaly detector.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the anomaly detector.
     */
    public final String anomalyDetectorArn() {
        return anomalyDetectorArn;
    }

    /**
     * <p>
     * The ID of the anomaly group.
     * </p>
     * 
     * @return The ID of the anomaly group.
     */
    public final String anomalyGroupId() {
        return anomalyGroupId;
    }

    /**
     * <p>
     * Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
     * <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipTypeFilter} will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #relationshipTypeFilterAsString}.
     * </p>
     * 
     * @return Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
     *         <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
     * @see RelationshipType
     */
    public final RelationshipType relationshipTypeFilter() {
        return RelationshipType.fromValue(relationshipTypeFilter);
    }

    /**
     * <p>
     * Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
     * <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #relationshipTypeFilter} will return {@link RelationshipType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #relationshipTypeFilterAsString}.
     * </p>
     * 
     * @return Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
     *         <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
     * @see RelationshipType
     */
    public final String relationshipTypeFilterAsString() {
        return relationshipTypeFilter;
    }

    /**
     * <p>
     * The maximum number of results to return.
     * </p>
     * 
     * @return The maximum number of results to return.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token that's returned by a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyDetectorArn());
        hashCode = 31 * hashCode + Objects.hashCode(anomalyGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(relationshipTypeFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupRelatedMetricsRequest)) {
            return false;
        }
        ListAnomalyGroupRelatedMetricsRequest other = (ListAnomalyGroupRelatedMetricsRequest) obj;
        return Objects.equals(anomalyDetectorArn(), other.anomalyDetectorArn())
                && Objects.equals(anomalyGroupId(), other.anomalyGroupId())
                && Objects.equals(relationshipTypeFilterAsString(), other.relationshipTypeFilterAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyGroupRelatedMetricsRequest").add("AnomalyDetectorArn", anomalyDetectorArn())
                .add("AnomalyGroupId", anomalyGroupId()).add("RelationshipTypeFilter", relationshipTypeFilterAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyDetectorArn":
            return Optional.ofNullable(clazz.cast(anomalyDetectorArn()));
        case "AnomalyGroupId":
            return Optional.ofNullable(clazz.cast(anomalyGroupId()));
        case "RelationshipTypeFilter":
            return Optional.ofNullable(clazz.cast(relationshipTypeFilterAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupRelatedMetricsRequest, T> g) {
        return obj -> g.apply((ListAnomalyGroupRelatedMetricsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyGroupRelatedMetricsRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the anomaly detector.
         * </p>
         * 
         * @param anomalyDetectorArn
         *        The Amazon Resource Name (ARN) of the anomaly detector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyDetectorArn(String anomalyDetectorArn);

        /**
         * <p>
         * The ID of the anomaly group.
         * </p>
         * 
         * @param anomalyGroupId
         *        The ID of the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyGroupId(String anomalyGroupId);

        /**
         * <p>
         * Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
         * <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
         * </p>
         * 
         * @param relationshipTypeFilter
         *        Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
         *        <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipTypeFilter(String relationshipTypeFilter);

        /**
         * <p>
         * Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
         * <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
         * </p>
         * 
         * @param relationshipTypeFilter
         *        Filter for potential causes (<code>CAUSE_OF_INPUT_ANOMALY_GROUP</code>) or downstream effects (
         *        <code>EFFECT_OF_INPUT_ANOMALY_GROUP</code>) of the anomaly group.
         * @see RelationshipType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RelationshipType
         */
        Builder relationshipTypeFilter(RelationshipType relationshipTypeFilter);

        /**
         * <p>
         * The maximum number of results to return.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specify the pagination token that's returned by a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token that's returned by a previous request to retrieve the next page of
         *        results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LookoutMetricsRequest.BuilderImpl implements Builder {
        private String anomalyDetectorArn;

        private String anomalyGroupId;

        private String relationshipTypeFilter;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupRelatedMetricsRequest model) {
            super(model);
            anomalyDetectorArn(model.anomalyDetectorArn);
            anomalyGroupId(model.anomalyGroupId);
            relationshipTypeFilter(model.relationshipTypeFilter);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAnomalyDetectorArn() {
            return anomalyDetectorArn;
        }

        public final void setAnomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
        }

        @Override
        @Transient
        public final Builder anomalyDetectorArn(String anomalyDetectorArn) {
            this.anomalyDetectorArn = anomalyDetectorArn;
            return this;
        }

        public final String getAnomalyGroupId() {
            return anomalyGroupId;
        }

        public final void setAnomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
        }

        @Override
        @Transient
        public final Builder anomalyGroupId(String anomalyGroupId) {
            this.anomalyGroupId = anomalyGroupId;
            return this;
        }

        public final String getRelationshipTypeFilter() {
            return relationshipTypeFilter;
        }

        public final void setRelationshipTypeFilter(String relationshipTypeFilter) {
            this.relationshipTypeFilter = relationshipTypeFilter;
        }

        @Override
        @Transient
        public final Builder relationshipTypeFilter(String relationshipTypeFilter) {
            this.relationshipTypeFilter = relationshipTypeFilter;
            return this;
        }

        @Override
        @Transient
        public final Builder relationshipTypeFilter(RelationshipType relationshipTypeFilter) {
            this.relationshipTypeFilter(relationshipTypeFilter == null ? null : relationshipTypeFilter.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListAnomalyGroupRelatedMetricsRequest build() {
            return new ListAnomalyGroupRelatedMetricsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
