/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAnomalyGroupRelatedMetricsResponse extends LookoutMetricsResponse implements
        ToCopyableBuilder<ListAnomalyGroupRelatedMetricsResponse.Builder, ListAnomalyGroupRelatedMetricsResponse> {
    private static final SdkField<List<InterMetricImpactDetails>> INTER_METRIC_IMPACT_LIST_FIELD = SdkField
            .<List<InterMetricImpactDetails>> builder(MarshallingType.LIST)
            .memberName("InterMetricImpactList")
            .getter(getter(ListAnomalyGroupRelatedMetricsResponse::interMetricImpactList))
            .setter(setter(Builder::interMetricImpactList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterMetricImpactList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InterMetricImpactDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(InterMetricImpactDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAnomalyGroupRelatedMetricsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INTER_METRIC_IMPACT_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<InterMetricImpactDetails> interMetricImpactList;

    private final String nextToken;

    private ListAnomalyGroupRelatedMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.interMetricImpactList = builder.interMetricImpactList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InterMetricImpactList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInterMetricImpactList() {
        return interMetricImpactList != null && !(interMetricImpactList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Aggregated details about the measures contributing to the anomaly group, and the measures potentially impacted by
     * the anomaly group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInterMetricImpactList} method.
     * </p>
     * 
     * @return Aggregated details about the measures contributing to the anomaly group, and the measures potentially
     *         impacted by the anomaly group.
     */
    public final List<InterMetricImpactDetails> interMetricImpactList() {
        return interMetricImpactList;
    }

    /**
     * <p>
     * The pagination token that's included if more results are available.
     * </p>
     * 
     * @return The pagination token that's included if more results are available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInterMetricImpactList() ? interMetricImpactList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnomalyGroupRelatedMetricsResponse)) {
            return false;
        }
        ListAnomalyGroupRelatedMetricsResponse other = (ListAnomalyGroupRelatedMetricsResponse) obj;
        return hasInterMetricImpactList() == other.hasInterMetricImpactList()
                && Objects.equals(interMetricImpactList(), other.interMetricImpactList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAnomalyGroupRelatedMetricsResponse")
                .add("InterMetricImpactList", hasInterMetricImpactList() ? interMetricImpactList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterMetricImpactList":
            return Optional.ofNullable(clazz.cast(interMetricImpactList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnomalyGroupRelatedMetricsResponse, T> g) {
        return obj -> g.apply((ListAnomalyGroupRelatedMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LookoutMetricsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListAnomalyGroupRelatedMetricsResponse> {
        /**
         * <p>
         * Aggregated details about the measures contributing to the anomaly group, and the measures potentially
         * impacted by the anomaly group.
         * </p>
         * 
         * @param interMetricImpactList
         *        Aggregated details about the measures contributing to the anomaly group, and the measures potentially
         *        impacted by the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interMetricImpactList(Collection<InterMetricImpactDetails> interMetricImpactList);

        /**
         * <p>
         * Aggregated details about the measures contributing to the anomaly group, and the measures potentially
         * impacted by the anomaly group.
         * </p>
         * 
         * @param interMetricImpactList
         *        Aggregated details about the measures contributing to the anomaly group, and the measures potentially
         *        impacted by the anomaly group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interMetricImpactList(InterMetricImpactDetails... interMetricImpactList);

        /**
         * <p>
         * Aggregated details about the measures contributing to the anomaly group, and the measures potentially
         * impacted by the anomaly group.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InterMetricImpactDetails>.Builder} avoiding
         * the need to create one manually via {@link List<InterMetricImpactDetails>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InterMetricImpactDetails>.Builder#build()} is called
         * immediately and its result is passed to {@link #interMetricImpactList(List<InterMetricImpactDetails>)}.
         * 
         * @param interMetricImpactList
         *        a consumer that will call methods on {@link List<InterMetricImpactDetails>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #interMetricImpactList(List<InterMetricImpactDetails>)
         */
        Builder interMetricImpactList(Consumer<InterMetricImpactDetails.Builder>... interMetricImpactList);

        /**
         * <p>
         * The pagination token that's included if more results are available.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that's included if more results are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LookoutMetricsResponse.BuilderImpl implements Builder {
        private List<InterMetricImpactDetails> interMetricImpactList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnomalyGroupRelatedMetricsResponse model) {
            super(model);
            interMetricImpactList(model.interMetricImpactList);
            nextToken(model.nextToken);
        }

        public final List<InterMetricImpactDetails.Builder> getInterMetricImpactList() {
            List<InterMetricImpactDetails.Builder> result = InterMetricImpactListCopier.copyToBuilder(this.interMetricImpactList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInterMetricImpactList(Collection<InterMetricImpactDetails.BuilderImpl> interMetricImpactList) {
            this.interMetricImpactList = InterMetricImpactListCopier.copyFromBuilder(interMetricImpactList);
        }

        @Override
        @Transient
        public final Builder interMetricImpactList(Collection<InterMetricImpactDetails> interMetricImpactList) {
            this.interMetricImpactList = InterMetricImpactListCopier.copy(interMetricImpactList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interMetricImpactList(InterMetricImpactDetails... interMetricImpactList) {
            interMetricImpactList(Arrays.asList(interMetricImpactList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder interMetricImpactList(Consumer<InterMetricImpactDetails.Builder>... interMetricImpactList) {
            interMetricImpactList(Stream.of(interMetricImpactList)
                    .map(c -> InterMetricImpactDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAnomalyGroupRelatedMetricsResponse build() {
            return new ListAnomalyGroupRelatedMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
