/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the Amazon Redshift database configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RedshiftSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<RedshiftSourceConfig.Builder, RedshiftSourceConfig> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterIdentifier").getter(getter(RedshiftSourceConfig::clusterIdentifier))
            .setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<String> DATABASE_HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseHost").getter(getter(RedshiftSourceConfig::databaseHost)).setter(setter(Builder::databaseHost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseHost").build()).build();

    private static final SdkField<Integer> DATABASE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DatabasePort").getter(getter(RedshiftSourceConfig::databasePort)).setter(setter(Builder::databasePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabasePort").build()).build();

    private static final SdkField<String> SECRET_MANAGER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecretManagerArn").getter(getter(RedshiftSourceConfig::secretManagerArn))
            .setter(setter(Builder::secretManagerArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecretManagerArn").build()).build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DatabaseName").getter(getter(RedshiftSourceConfig::databaseName)).setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TableName").getter(getter(RedshiftSourceConfig::tableName)).setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(RedshiftSourceConfig::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("VpcConfiguration")
            .getter(getter(RedshiftSourceConfig::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfiguration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            DATABASE_HOST_FIELD, DATABASE_PORT_FIELD, SECRET_MANAGER_ARN_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD,
            ROLE_ARN_FIELD, VPC_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String clusterIdentifier;

    private final String databaseHost;

    private final Integer databasePort;

    private final String secretManagerArn;

    private final String databaseName;

    private final String tableName;

    private final String roleArn;

    private final VpcConfiguration vpcConfiguration;

    private RedshiftSourceConfig(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.databaseHost = builder.databaseHost;
        this.databasePort = builder.databasePort;
        this.secretManagerArn = builder.secretManagerArn;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.roleArn = builder.roleArn;
        this.vpcConfiguration = builder.vpcConfiguration;
    }

    /**
     * <p>
     * A string identifying the Redshift cluster.
     * </p>
     * 
     * @return A string identifying the Redshift cluster.
     */
    public final String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The name of the database host.
     * </p>
     * 
     * @return The name of the database host.
     */
    public final String databaseHost() {
        return databaseHost;
    }

    /**
     * <p>
     * The port number where the database can be accessed.
     * </p>
     * 
     * @return The port number where the database can be accessed.
     */
    public final Integer databasePort() {
        return databasePort;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
     */
    public final String secretManagerArn() {
        return secretManagerArn;
    }

    /**
     * <p>
     * The Redshift database name.
     * </p>
     * 
     * @return The Redshift database name.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The table name of the Redshift database.
     * </p>
     * 
     * @return The table name of the Redshift database.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the role providing access to the database.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the role providing access to the database.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
     * </p>
     * 
     * @return Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(databaseHost());
        hashCode = 31 * hashCode + Objects.hashCode(databasePort());
        hashCode = 31 * hashCode + Objects.hashCode(secretManagerArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftSourceConfig)) {
            return false;
        }
        RedshiftSourceConfig other = (RedshiftSourceConfig) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier())
                && Objects.equals(databaseHost(), other.databaseHost()) && Objects.equals(databasePort(), other.databasePort())
                && Objects.equals(secretManagerArn(), other.secretManagerArn())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(tableName(), other.tableName())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(vpcConfiguration(), other.vpcConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RedshiftSourceConfig").add("ClusterIdentifier", clusterIdentifier())
                .add("DatabaseHost", databaseHost()).add("DatabasePort", databasePort())
                .add("SecretManagerArn", secretManagerArn()).add("DatabaseName", databaseName()).add("TableName", tableName())
                .add("RoleArn", roleArn()).add("VpcConfiguration", vpcConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "DatabaseHost":
            return Optional.ofNullable(clazz.cast(databaseHost()));
        case "DatabasePort":
            return Optional.ofNullable(clazz.cast(databasePort()));
        case "SecretManagerArn":
            return Optional.ofNullable(clazz.cast(secretManagerArn()));
        case "DatabaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "VpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RedshiftSourceConfig, T> g) {
        return obj -> g.apply((RedshiftSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RedshiftSourceConfig> {
        /**
         * <p>
         * A string identifying the Redshift cluster.
         * </p>
         * 
         * @param clusterIdentifier
         *        A string identifying the Redshift cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The name of the database host.
         * </p>
         * 
         * @param databaseHost
         *        The name of the database host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseHost(String databaseHost);

        /**
         * <p>
         * The port number where the database can be accessed.
         * </p>
         * 
         * @param databasePort
         *        The port number where the database can be accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databasePort(Integer databasePort);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
         * </p>
         * 
         * @param secretManagerArn
         *        The Amazon Resource Name (ARN) of the AWS Secrets Manager role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secretManagerArn(String secretManagerArn);

        /**
         * <p>
         * The Redshift database name.
         * </p>
         * 
         * @param databaseName
         *        The Redshift database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The table name of the Redshift database.
         * </p>
         * 
         * @param tableName
         *        The table name of the Redshift database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the role providing access to the database.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of the role providing access to the database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
         * </p>
         * 
         * @param vpcConfiguration
         *        Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * Contains information about the Amazon Virtual Private Cloud (VPC) configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfiguration.Builder} avoiding the need to
         * create one manually via {@link VpcConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String clusterIdentifier;

        private String databaseHost;

        private Integer databasePort;

        private String secretManagerArn;

        private String databaseName;

        private String tableName;

        private String roleArn;

        private VpcConfiguration vpcConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftSourceConfig model) {
            clusterIdentifier(model.clusterIdentifier);
            databaseHost(model.databaseHost);
            databasePort(model.databasePort);
            secretManagerArn(model.secretManagerArn);
            databaseName(model.databaseName);
            tableName(model.tableName);
            roleArn(model.roleArn);
            vpcConfiguration(model.vpcConfiguration);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getDatabaseHost() {
            return databaseHost;
        }

        public final void setDatabaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
        }

        @Override
        @Transient
        public final Builder databaseHost(String databaseHost) {
            this.databaseHost = databaseHost;
            return this;
        }

        public final Integer getDatabasePort() {
            return databasePort;
        }

        public final void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        @Override
        @Transient
        public final Builder databasePort(Integer databasePort) {
            this.databasePort = databasePort;
            return this;
        }

        public final String getSecretManagerArn() {
            return secretManagerArn;
        }

        public final void setSecretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
        }

        @Override
        @Transient
        public final Builder secretManagerArn(String secretManagerArn) {
            this.secretManagerArn = secretManagerArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        @Transient
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        @Transient
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        @Transient
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        @Override
        public RedshiftSourceConfig build() {
            return new RedshiftSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
