/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lookoutmetrics.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a metric. A metric is an aggregation of the values of a measure for a dimension value, such as
 * <i>availability</i> in the <i>us-east-1</i> Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeSeries implements SdkPojo, Serializable, ToCopyableBuilder<TimeSeries.Builder, TimeSeries> {
    private static final SdkField<String> TIME_SERIES_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TimeSeriesId").getter(getter(TimeSeries::timeSeriesId)).setter(setter(Builder::timeSeriesId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeSeriesId").build()).build();

    private static final SdkField<List<DimensionNameValue>> DIMENSION_LIST_FIELD = SdkField
            .<List<DimensionNameValue>> builder(MarshallingType.LIST)
            .memberName("DimensionList")
            .getter(getter(TimeSeries::dimensionList))
            .setter(setter(Builder::dimensionList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DimensionList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DimensionNameValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DimensionNameValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Double>> METRIC_VALUE_LIST_FIELD = SdkField
            .<List<Double>> builder(MarshallingType.LIST)
            .memberName("MetricValueList")
            .getter(getter(TimeSeries::metricValueList))
            .setter(setter(Builder::metricValueList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricValueList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Double> builder(MarshallingType.DOUBLE)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_SERIES_ID_FIELD,
            DIMENSION_LIST_FIELD, METRIC_VALUE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String timeSeriesId;

    private final List<DimensionNameValue> dimensionList;

    private final List<Double> metricValueList;

    private TimeSeries(BuilderImpl builder) {
        this.timeSeriesId = builder.timeSeriesId;
        this.dimensionList = builder.dimensionList;
        this.metricValueList = builder.metricValueList;
    }

    /**
     * <p>
     * The ID of the metric.
     * </p>
     * 
     * @return The ID of the metric.
     */
    public final String timeSeriesId() {
        return timeSeriesId;
    }

    /**
     * For responses, this returns true if the service returned a value for the DimensionList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDimensionList() {
        return dimensionList != null && !(dimensionList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dimensions of the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDimensionList} method.
     * </p>
     * 
     * @return The dimensions of the metric.
     */
    public final List<DimensionNameValue> dimensionList() {
        return dimensionList;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricValueList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricValueList() {
        return metricValueList != null && !(metricValueList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values for the metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricValueList} method.
     * </p>
     * 
     * @return The values for the metric.
     */
    public final List<Double> metricValueList() {
        return metricValueList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeSeriesId());
        hashCode = 31 * hashCode + Objects.hashCode(hasDimensionList() ? dimensionList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricValueList() ? metricValueList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeries)) {
            return false;
        }
        TimeSeries other = (TimeSeries) obj;
        return Objects.equals(timeSeriesId(), other.timeSeriesId()) && hasDimensionList() == other.hasDimensionList()
                && Objects.equals(dimensionList(), other.dimensionList()) && hasMetricValueList() == other.hasMetricValueList()
                && Objects.equals(metricValueList(), other.metricValueList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeSeries").add("TimeSeriesId", timeSeriesId())
                .add("DimensionList", hasDimensionList() ? dimensionList() : null)
                .add("MetricValueList", hasMetricValueList() ? metricValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TimeSeriesId":
            return Optional.ofNullable(clazz.cast(timeSeriesId()));
        case "DimensionList":
            return Optional.ofNullable(clazz.cast(dimensionList()));
        case "MetricValueList":
            return Optional.ofNullable(clazz.cast(metricValueList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeSeries, T> g) {
        return obj -> g.apply((TimeSeries) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeSeries> {
        /**
         * <p>
         * The ID of the metric.
         * </p>
         * 
         * @param timeSeriesId
         *        The ID of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeSeriesId(String timeSeriesId);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * 
         * @param dimensionList
         *        The dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(Collection<DimensionNameValue> dimensionList);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * 
         * @param dimensionList
         *        The dimensions of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionList(DimensionNameValue... dimensionList);

        /**
         * <p>
         * The dimensions of the metric.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DimensionNameValue>.Builder} avoiding the
         * need to create one manually via {@link List<DimensionNameValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DimensionNameValue>.Builder#build()} is called immediately
         * and its result is passed to {@link #dimensionList(List<DimensionNameValue>)}.
         * 
         * @param dimensionList
         *        a consumer that will call methods on {@link List<DimensionNameValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dimensionList(List<DimensionNameValue>)
         */
        Builder dimensionList(Consumer<DimensionNameValue.Builder>... dimensionList);

        /**
         * <p>
         * The values for the metric.
         * </p>
         * 
         * @param metricValueList
         *        The values for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValueList(Collection<Double> metricValueList);

        /**
         * <p>
         * The values for the metric.
         * </p>
         * 
         * @param metricValueList
         *        The values for the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValueList(Double... metricValueList);
    }

    static final class BuilderImpl implements Builder {
        private String timeSeriesId;

        private List<DimensionNameValue> dimensionList = DefaultSdkAutoConstructList.getInstance();

        private List<Double> metricValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TimeSeries model) {
            timeSeriesId(model.timeSeriesId);
            dimensionList(model.dimensionList);
            metricValueList(model.metricValueList);
        }

        public final String getTimeSeriesId() {
            return timeSeriesId;
        }

        public final void setTimeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
        }

        @Override
        @Transient
        public final Builder timeSeriesId(String timeSeriesId) {
            this.timeSeriesId = timeSeriesId;
            return this;
        }

        public final List<DimensionNameValue.Builder> getDimensionList() {
            List<DimensionNameValue.Builder> result = DimensionNameValueListCopier.copyToBuilder(this.dimensionList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDimensionList(Collection<DimensionNameValue.BuilderImpl> dimensionList) {
            this.dimensionList = DimensionNameValueListCopier.copyFromBuilder(dimensionList);
        }

        @Override
        @Transient
        public final Builder dimensionList(Collection<DimensionNameValue> dimensionList) {
            this.dimensionList = DimensionNameValueListCopier.copy(dimensionList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionList(DimensionNameValue... dimensionList) {
            dimensionList(Arrays.asList(dimensionList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dimensionList(Consumer<DimensionNameValue.Builder>... dimensionList) {
            dimensionList(Stream.of(dimensionList).map(c -> DimensionNameValue.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<Double> getMetricValueList() {
            if (metricValueList instanceof SdkAutoConstructList) {
                return null;
            }
            return metricValueList;
        }

        public final void setMetricValueList(Collection<Double> metricValueList) {
            this.metricValueList = MetricValueListCopier.copy(metricValueList);
        }

        @Override
        @Transient
        public final Builder metricValueList(Collection<Double> metricValueList) {
            this.metricValueList = MetricValueListCopier.copy(metricValueList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder metricValueList(Double... metricValueList) {
            metricValueList(Arrays.asList(metricValueList));
            return this;
        }

        @Override
        public TimeSeries build() {
            return new TimeSeries(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
